---------------------------------------------------------------------------------------
-- Title          : Wishbone slave core for Simple Wishbone UART
---------------------------------------------------------------------------------------
-- File           : simple_uart_pkg.vhd
-- Author         : auto-generated by wbgen2 from simple_uart_wb.wb
-- Created        : Tue Aug 15 10:16:30 2017
-- Standard       : VHDL'87
---------------------------------------------------------------------------------------
-- THIS FILE WAS GENERATED BY wbgen2 FROM SOURCE FILE simple_uart_wb.wb
-- DO NOT HAND-EDIT UNLESS IT'S ABSOLUTELY NECESSARY!
---------------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

package uart_wbgen2_pkg is
  
  
  -- Input registers (user design -> WB slave)
  
  type t_uart_in_registers is record
    sr_tx_busy_i                             : std_logic;
    sr_rx_rdy_i                              : std_logic;
    rdr_rx_data_i                            : std_logic_vector(7 downto 0);
    host_tdr_rdy_i                           : std_logic;
    host_rdr_data_i                          : std_logic_vector(7 downto 0);
    host_rdr_rdy_i                           : std_logic;
    host_rdr_count_i                         : std_logic_vector(15 downto 0);
    end record;
  
  constant c_uart_in_registers_init_value: t_uart_in_registers := (
    sr_tx_busy_i => '0',
    sr_rx_rdy_i => '0',
    rdr_rx_data_i => (others => '0'),
    host_tdr_rdy_i => '0',
    host_rdr_data_i => (others => '0'),
    host_rdr_rdy_i => '0',
    host_rdr_count_i => (others => '0')
    );
    
    -- Output registers (WB slave -> user design)
    
    type t_uart_out_registers is record
      bcr_o                                    : std_logic_vector(31 downto 0);
      bcr_wr_o                                 : std_logic;
      tdr_tx_data_o                            : std_logic_vector(7 downto 0);
      tdr_tx_data_wr_o                         : std_logic;
      host_tdr_data_o                          : std_logic_vector(7 downto 0);
      host_tdr_data_wr_o                       : std_logic;
      end record;
    
    constant c_uart_out_registers_init_value: t_uart_out_registers := (
      bcr_o => (others => '0'),
      bcr_wr_o => '0',
      tdr_tx_data_o => (others => '0'),
      tdr_tx_data_wr_o => '0',
      host_tdr_data_o => (others => '0'),
      host_tdr_data_wr_o => '0'
      );
    function "or" (left, right: t_uart_in_registers) return t_uart_in_registers;
    function f_x_to_zero (x:std_logic) return std_logic;
    function f_x_to_zero (x:std_logic_vector) return std_logic_vector;
end package;

package body uart_wbgen2_pkg is
function f_x_to_zero (x:std_logic) return std_logic is
begin
if x = '1' then
return '1';
else
return '0';
end if;
end function;
function f_x_to_zero (x:std_logic_vector) return std_logic_vector is
variable tmp: std_logic_vector(x'length-1 downto 0);
begin
for i in 0 to x'length-1 loop
if x(i) = '1' then
tmp(i):= '1';
else
tmp(i):= '0';
end if; 
end loop; 
return tmp;
end function;
function "or" (left, right: t_uart_in_registers) return t_uart_in_registers is
variable tmp: t_uart_in_registers;
begin
tmp.sr_tx_busy_i := f_x_to_zero(left.sr_tx_busy_i) or f_x_to_zero(right.sr_tx_busy_i);
tmp.sr_rx_rdy_i := f_x_to_zero(left.sr_rx_rdy_i) or f_x_to_zero(right.sr_rx_rdy_i);
tmp.rdr_rx_data_i := f_x_to_zero(left.rdr_rx_data_i) or f_x_to_zero(right.rdr_rx_data_i);
tmp.host_tdr_rdy_i := f_x_to_zero(left.host_tdr_rdy_i) or f_x_to_zero(right.host_tdr_rdy_i);
tmp.host_rdr_data_i := f_x_to_zero(left.host_rdr_data_i) or f_x_to_zero(right.host_rdr_data_i);
tmp.host_rdr_rdy_i := f_x_to_zero(left.host_rdr_rdy_i) or f_x_to_zero(right.host_rdr_rdy_i);
tmp.host_rdr_count_i := f_x_to_zero(left.host_rdr_count_i) or f_x_to_zero(right.host_rdr_count_i);
return tmp;
end function;
end package body;
