/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.qpid.proton.amqp.transport;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;

import java.util.HashMap;
import java.util.Map;

import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.junit.Test;

public class OpenTest {

    @Test
    public void testCopy() {
        Map<Symbol, Object> properties = new HashMap<>();
        properties.put(Symbol.valueOf("x-opt"), "value");

        Open open = new Open();

        open.setContainerId("test");
        open.setHostname("host");
        open.setMaxFrameSize(UnsignedInteger.valueOf(42));
        open.setChannelMax(UnsignedShort.MAX_VALUE);
        open.setIdleTimeOut(UnsignedInteger.valueOf(111));
        open.setOfferedCapabilities(new Symbol[] { Symbol.valueOf("anonymous-relay") });
        open.setDesiredCapabilities(new Symbol[0]);
        open.setProperties(properties);

        Open copyOf = open.copy();

        assertEquals(open.getContainerId(), copyOf.getContainerId());
        assertEquals(open.getHostname(), copyOf.getHostname());
        assertEquals(open.getMaxFrameSize(), copyOf.getMaxFrameSize());
        assertEquals(open.getChannelMax(), copyOf.getChannelMax());
        assertEquals(open.getIdleTimeOut(), copyOf.getIdleTimeOut());
        assertArrayEquals(open.getDesiredCapabilities(), copyOf.getDesiredCapabilities());
        assertArrayEquals(open.getOfferedCapabilities(), copyOf.getOfferedCapabilities());
        assertEquals(open.getProperties(), copyOf.getProperties());
    }
}
