# OpenRGB Fonts

This folder contains OpenRGB.ttf - a special font that contains all monochrome
icons used in OpenRGB. The icons are assembled into a font in order to simplify
rendering them in accordance with the desired color palette, as well as ensure
the vector scalable format is supported by the platform.

The font is generated by a dedicated CI script located in:
https://gitlab.com/OpenRGBDevelopers/openrgb-icons

Most icons are taken from the open library CSS.GG, and it is preferred that new
icons are chosen from that library instead of making new ones.

In order to add a new icon, please do the following steps:
1) Choose the SVG icon in: https://github.com/astrit/css.gg/tree/main/icons/svg
2) Append the file name to the list in
https://gitlab.com/OpenRGBDevelopers/openrgb-icons/-/blob/main/OpenRGB.json
with a new glyph code. The code must be in the Unicode Private Use Area and it
is recommended to take the first available code after the last icon.
3) After changes were pushed to the `openrgb-icons` repo (or after a merge
request was filed), the CI script will generate a new TTF file that should be
placed in this folder, replacing the existing one
4) Add the new glyph code and it's name to the enumeration in
https://gitlab.com/CalcProgrammer1/OpenRGB/-/blob/master/qt/OpenRGBFont.
5) The icon is now available as a Unicode character, with the code you chose.

In order for the icon to be displayed correctly, the font must be assigned
to the widget, through `OpenRGBFont::GetFont()`.
