/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _STUB_WEBBROWSER_H_
#define _STUB_WEBBROWSER_H_

#include "stub_view.h"

namespace mforms {
namespace stub {

class WebBrowserImpl : public ViewImpl
{
 protected:
  WebBrowserImpl(::mforms::WebBrowser *self)
    : ViewImpl(self)
  {
  }

  static bool __stdcall create(WebBrowser*)
  {
    return true;
  }

  static void __stdcall set_html(WebBrowser*, const std::string&)
  {
  }

  static void __stdcall navigate(WebBrowser*, const std::string&)
  {
  }

  static std::string __stdcall get_document_title(WebBrowser*)
  {
    return "";
  }


public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_webbrowser_impl.create = &WebBrowserImpl::create;
    f->_webbrowser_impl.get_document_title = &WebBrowserImpl::get_document_title;
    f->_webbrowser_impl.navigate = &WebBrowserImpl::navigate;
    f->_webbrowser_impl.set_html = &WebBrowserImpl::set_html;
  }
};

}
}

#endif
