//
// ccsd_2t_right.cc
//
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki.toru@gmail.com>
// Maintainer: TS
//
// This file is part of the SC Toolkit.
//
// The SC Toolkit is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// The SC Toolkit is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the SC Toolkit; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The U.S. Government is granted a limited license as per AL 91-7.
//
  
// This is a C++ code generated by SMITH
  
#include <algorithm>
#include <chemistry/qc/ccr12/ccsd_2t_right.h>
#include <chemistry/qc/ccr12/parenthesis2tnum.h>
using namespace sc;
  
  
CCSD_2T_RIGHT::CCSD_2T_RIGHT(CCR12_Info* info):Parenthesis2tNum(info){};
  
  
  
void CCSD_2T_RIGHT::compute_amp(double* a_i0,const long t_p4b,const long t_p5b,const long t_p6b,const long t_h1b,const long t_h2b,const long t_h3b,const long toggle){
  
in.resize(8);
i1xn.resize(16);
  
if (toggle==1L) {
i1xn.at(0)=new Tensor("ccsd_2t_right_1x0_0",z->mem());
offset_smith_0_1();
smith_0_1_0(); //z->v2()=>in.at(1x0)
in.at(2)=new Tensor("ccsd_2t_right_2_0",z->mem());
offset_smith_1_1();
smith_1_1_0(); //z->f1()=>in.at(2)
smith_2_19(); //z->t1(),z->v2()=>in.at(2)
smith_1_1(); //z->t2(),in.at(2)=>in.at(1x0)
delete in.at(2);
in.at(2)=new Tensor("ccsd_2t_right_2_1",z->mem());
offset_smith_1_4();
smith_1_4_0(); //z->v2()=>in.at(2)
in.at(3)=new Tensor("ccsd_2t_right_3_0",z->mem());
offset_smith_2_8();
smith_2_8_0(); //z->v2()=>in.at(3)
smith_3_16(); //z->t1(),z->v2()=>in.at(3)
smith_2_8(); //z->t1(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_22(); //z->t2(),z->v2()=>in.at(2)
smith_1_4(); //z->t1(),in.at(2)=>in.at(1x0)
delete in.at(2);
in.at(2)=new Tensor("ccsd_2t_right_2_2",z->mem());
offset_smith_1_5();
smith_1_5_0(); //z->v2()=>in.at(2)
smith_2_9(); //z->t1(),z->v2()=>in.at(2)
smith_1_5(); //z->t1(),in.at(2)=>in.at(1x0)
delete in.at(2);
in.at(2)=new Tensor("ccsd_2t_right_2_3",z->mem());
offset_smith_1_13();
smith_1_13_0(); //z->v2()=>in.at(2)
smith_2_21(); //z->t1(),z->v2()=>in.at(2)
smith_1_13(); //z->t2(),in.at(2)=>in.at(1x0)
delete in.at(2);
smith_1_15(); //z->t2(),z->v2()=>in.at(1x0)
}
if (toggle==2L) {
smith_0_1(a_i0,t_p4b,t_p5b,t_p6b,t_h1b,t_h2b,t_h3b);
}
if (toggle==1L) {
i1xn.at(1)=new Tensor("ccsd_2t_right_1x1_1",z->mem());
offset_smith_0_3();
smith_0_3_0(); //z->v2()=>in.at(1x1)
in.at(2)=new Tensor("ccsd_2t_right_2_0",z->mem());
offset_smith_1_6();
smith_1_6_0(); //z->v2()=>in.at(2)
in.at(3)=new Tensor("ccsd_2t_right_3_0",z->mem());
offset_smith_2_10();
smith_2_10_0(); //z->v2()=>in.at(3)
smith_3_17(); //z->t1(),z->v2()=>in.at(3)
smith_2_10(); //z->t1(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_11(); //z->t1(),z->v2()=>in.at(2)
smith_2_20(); //z->t2(),z->v2()=>in.at(2)
smith_1_6(); //z->t1(),in.at(2)=>in.at(1x1)
delete in.at(2);
smith_1_7(); //z->t1(),z->v2()=>in.at(1x1)
in.at(2)=new Tensor("ccsd_2t_right_2_1",z->mem());
offset_smith_1_12();
smith_1_12_0(); //z->v2()=>in.at(2)
smith_2_18(); //z->t1(),z->v2()=>in.at(2)
smith_1_12(); //z->t2(),in.at(2)=>in.at(1x1)
delete in.at(2);
smith_1_14(); //z->t2(),z->v2()=>in.at(1x1)
}
if (toggle==2L) {
smith_0_3(a_i0,t_p4b,t_p5b,t_p6b,t_h1b,t_h2b,t_h3b);
}
if (toggle==3L) {
delete i1xn.at(1);
delete i1xn.at(0);
}
  
}
  
void CCSD_2T_RIGHT::smith_0_1(double* a_i0,const long t_p4b,const long t_p5b,const long t_p6b,const long t_h1b,const long t_h2b,const long t_h3b){ 
      
const long perm[9][6]={0,1,2,3,4,5, 0,1,2,4,3,5, 0,1,2,5,3,4, 0,2,1,3,4,5, 0,2,1,4,3,5, 0,2,1,5,3,4, 1,2,0,3,4,5, 1,2,0,4,3,5, 1,2,0,5,3,4}; 
const long t_b[6]={t_p4b,t_p5b,t_p6b,t_h1b,t_h2b,t_h3b}; 
for (long permutation=0L;permutation<9L;++permutation) { 
 const long p4b=t_b[perm[permutation][0]]; 
 const long p5b=t_b[perm[permutation][1]]; 
 const long p6b=t_b[perm[permutation][2]]; 
 const long h1b=t_b[perm[permutation][3]]; 
 const long h2b=t_b[perm[permutation][4]]; 
 const long h3b=t_b[perm[permutation][5]]; 
 bool skip=false; 
 for (long p_p=0L;p_p<permutation;++p_p) { 
  if(p4b==t_b[perm[p_p][0]] 
  && p5b==t_b[perm[p_p][1]] 
  && p6b==t_b[perm[p_p][2]] 
  && h1b==t_b[perm[p_p][3]] 
  && h2b==t_b[perm[p_p][4]] 
  && h3b==t_b[perm[p_p][5]]) skip=true; 
 } 
 if (skip) continue; 
 if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
  if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
   if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_f()))) { 
    long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
    double* k_c_sort=z->mem()->malloc_local_double(dimc); 
    std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
    for (long h7b=0L;h7b<z->noab();++h7b) { 
     if (z->get_spin(p4b)+z->get_spin(p5b)==z->get_spin(h1b)+z->get_spin(h7b)) { 
      if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(h1b)^z->get_sym(h7b))))==z->irrep_t()) { 
       long p4b_0,p5b_0,h1b_0,h7b_0; 
       z->restricted_4(p4b,p5b,h1b,h7b,p4b_0,p5b_0,h1b_0,h7b_0); 
       long h7b_1,p6b_1,h2b_1,h3b_1; 
       z->restricted_4(h7b,p6b,h2b,h3b,h7b_1,p6b_1,h2b_1,h3b_1); 
       long dim_common=z->get_range(h7b); 
       long dima0_sort=z->get_range(p4b)*z->get_range(p5b)*z->get_range(h1b); 
       long dima0=dim_common*dima0_sort; 
       long dima1_sort=z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
       long dima1=dim_common*dima1_sort; 
       if (dima0>0L && dima1>0L) { 
        double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
        double* k_a0=z->mem()->malloc_local_double(dima0); 
        if (h1b<h7b) { 
         z->t2()->get_block(h7b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h7b),2,1,0,3,+1.0); 
        } 
        else if (h7b<=h1b) { 
         z->t2()->get_block(h1b_0+z->noab()*(h7b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h7b),z->get_range(h1b),3,1,0,2,-1.0); 
        } 
        z->mem()->free_local_double(k_a0); 
        double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
        double* k_a1=z->mem()->malloc_local_double(dima1); 
        i1xn[0]->get_block(h3b_1+z->noab()*(h2b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h7b_1))),k_a1); 
        z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,+1.0); 
        z->mem()->free_local_double(k_a1); 
        double factor=1.0; 
        z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        z->mem()->free_local_double(k_a1_sort); 
        z->mem()->free_local_double(k_a0_sort); 
       } 
      } 
     } 
    } 
    if (p6b>=p5b && h2b>=h1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,4,2,3,1,0,+1.0); 
    } 
    if (p6b>=p5b && h3b>=h1b && h1b>=h2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,4,2,1,3,0,-1.0); 
    } 
    if (p6b>=p5b && h1b>=h3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,4,2,1,0,3,+1.0); 
    } 
    if (p5b>=p6b && p6b>=p4b && h2b>=h1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,2,4,3,1,0,-1.0); 
    } 
    if (p5b>=p6b && p6b>=p4b && h3b>=h1b && h1b>=h2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,2,4,1,3,0,+1.0); 
    } 
    if (p5b>=p6b && p6b>=p4b && h1b>=h3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,2,4,1,0,3,-1.0); 
    } 
    if (p4b>=p6b && h2b>=h1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),2,5,4,3,1,0,+1.0); 
    } 
    if (p4b>=p6b && h3b>=h1b && h1b>=h2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),2,5,4,1,3,0,-1.0); 
    } 
    if (p4b>=p6b && h1b>=h3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),2,5,4,1,0,3,+1.0); 
    } 
    z->mem()->free_local_double(k_c_sort); 
   } 
  } 
 } 
} 
} 
  
void CCSD_2T_RIGHT::smith_0_1_0(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (i1xn[0]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_f())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        long h7b_0,p6b_0,h2b_0,h3b_0; 
        z->restricted_4(h7b,p6b,h2b,h3b,h7b_0,p6b_0,h2b_0,h3b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(h3b_0+(z->nab())*(h2b_0+(z->nab())*(p6b_0+(z->nab())*(h7b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h3b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h3b),0,1,2,3,-1.0); 
         i1xn[0]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::offset_smith_0_1(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_f())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
       i1xn[0]->input_offset(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
i1xn[0]->set_filesize(size); 
i1xn[0]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_0_3(double* a_i0,const long t_p4b,const long t_p5b,const long t_p6b,const long t_h1b,const long t_h2b,const long t_h3b){ 
      
const long perm[9][6]={0,1,2,3,4,5, 0,1,2,3,5,4, 0,1,2,4,5,3, 1,0,2,3,4,5, 1,0,2,3,5,4, 1,0,2,4,5,3, 2,0,1,3,4,5, 2,0,1,3,5,4, 2,0,1,4,5,3}; 
const long t_b[6]={t_p4b,t_p5b,t_p6b,t_h1b,t_h2b,t_h3b}; 
for (long permutation=0L;permutation<9L;++permutation) { 
 const long p4b=t_b[perm[permutation][0]]; 
 const long p5b=t_b[perm[permutation][1]]; 
 const long p6b=t_b[perm[permutation][2]]; 
 const long h1b=t_b[perm[permutation][3]]; 
 const long h2b=t_b[perm[permutation][4]]; 
 const long h3b=t_b[perm[permutation][5]]; 
 bool skip=false; 
 for (long p_p=0L;p_p<permutation;++p_p) { 
  if(p4b==t_b[perm[p_p][0]] 
  && p5b==t_b[perm[p_p][1]] 
  && p6b==t_b[perm[p_p][2]] 
  && h1b==t_b[perm[p_p][3]] 
  && h2b==t_b[perm[p_p][4]] 
  && h3b==t_b[perm[p_p][5]]) skip=true; 
 } 
 if (skip) continue; 
 if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
  if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
   if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
    long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
    double* k_c_sort=z->mem()->malloc_local_double(dimc); 
    std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
    for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
     if (z->get_spin(p4b)+z->get_spin(p7b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
      if ((z->get_sym(p4b)^(z->get_sym(p7b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
       long p4b_0,p7b_0,h1b_0,h2b_0; 
       z->restricted_4(p4b,p7b,h1b,h2b,p4b_0,p7b_0,h1b_0,h2b_0); 
       long p5b_1,p6b_1,h3b_1,p7b_1; 
       z->restricted_4(p5b,p6b,h3b,p7b,p5b_1,p6b_1,h3b_1,p7b_1); 
       long dim_common=z->get_range(p7b); 
       long dima0_sort=z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
       long dima0=dim_common*dima0_sort; 
       long dima1_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b); 
       long dima1=dim_common*dima1_sort; 
       if (dima0>0L && dima1>0L) { 
        double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
        double* k_a0=z->mem()->malloc_local_double(dima0); 
        if (p4b<p7b) { 
         z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
        } 
        else if (p7b<=p4b) { 
         z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
        } 
        z->mem()->free_local_double(k_a0); 
        double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
        double* k_a1=z->mem()->malloc_local_double(dima1); 
        i1xn[1]->get_block(p7b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(p5b_1-z->noab()))),k_a1); 
        z->sort_indices4(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),2,1,0,3,+1.0); 
        z->mem()->free_local_double(k_a1); 
        double factor=1.0; 
        z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        z->mem()->free_local_double(k_a1_sort); 
        z->mem()->free_local_double(k_a0_sort); 
       } 
      } 
     } 
    } 
    if (p5b>=p4b && h3b>=h2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),5,2,1,4,3,0,+1.0); 
    } 
    if (p5b>=p4b && h2b>=h3b && h3b>=h1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),5,2,1,4,0,3,-1.0); 
    } 
    if (p5b>=p4b && h1b>=h3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),5,2,1,0,4,3,+1.0); 
    } 
    if (p6b>=p4b && p4b>=p5b && h3b>=h2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,5,1,4,3,0,-1.0); 
    } 
    if (p6b>=p4b && p4b>=p5b && h2b>=h3b && h3b>=h1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,5,1,4,0,3,+1.0); 
    } 
    if (p6b>=p4b && p4b>=p5b && h1b>=h3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,5,1,0,4,3,-1.0); 
    } 
    if (p4b>=p6b && h3b>=h2b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,1,5,4,3,0,+1.0); 
    } 
    if (p4b>=p6b && h2b>=h3b && h3b>=h1b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,1,5,4,0,3,-1.0); 
    } 
    if (p4b>=p6b && h1b>=h3b) { 
     z->sort_indices_acc6(k_c_sort,a_i0,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,1,5,0,4,3,+1.0); 
    } 
    z->mem()->free_local_double(k_c_sort); 
   } 
  } 
 } 
} 
} 
  
void CCSD_2T_RIGHT::smith_0_3_0(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    if (i1xn[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        long p5b_0,p6b_0,h3b_0,p7b_0; 
        z->restricted_4(p5b,p6b,h3b,p7b,p5b_0,p6b_0,h3b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p7b_0+(z->nab())*(h3b_0+(z->nab())*(p6b_0+(z->nab())*(p5b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,-1.0); 
         i1xn[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::offset_smith_0_3(){ 
 
long size=0L; 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
     if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
       i1xn[1]->input_offset(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),size); 
       size+=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
i1xn[1]->set_filesize(size); 
i1xn[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_1(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (i1xn[0]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_f())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p6b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
          if ((z->get_sym(p6b)^(z->get_sym(p8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_t()) { 
           long p6b_0,p8b_0,h2b_0,h3b_0; 
           z->restricted_4(p6b,p8b,h2b,h3b,p6b_0,p8b_0,h2b_0,h3b_0); 
           long h7b_1,p8b_1; 
           z->restricted_2(h7b,p8b,h7b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p6b<p8b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),3,2,0,1,+1.0); 
            } 
            else if (p8b<=p6b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p6b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h7b_1),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p8b),0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),0,3,2,1,+1.0); 
        i1xn[0]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_12(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    if (i1xn[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h8b=0L;h8b<z->noab();++h8b) { 
         for (long h9b=h8b;h9b<z->noab();++h9b) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h8b)+z->get_spin(h9b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h8b)^z->get_sym(h9b))))==z->irrep_t()) { 
            long p5b_0,p6b_0,h8b_0,h9b_0; 
            z->restricted_4(p5b,p6b,h8b,h9b,p5b_0,p6b_0,h8b_0,h9b_0); 
            long h8b_1,h9b_1,h3b_1,p7b_1; 
            z->restricted_4(h8b,h9b,h3b,p7b,h8b_1,h9b_1,h3b_1,p7b_1); 
            long dim_common=z->get_range(h8b)*z->get_range(h9b); 
            long dima0_sort=z->get_range(p5b)*z->get_range(p6b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(p7b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h9b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h8b),z->get_range(h9b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[2]->get_block(p7b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h9b_1+z->noab()*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (h8b==h9b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),3,2,1,0,+0.5/0.5); 
        i1xn[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_12_0(){ 
      
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        long h8b_0,h9b_0,h3b_0,p7b_0; 
        z->restricted_4(h8b,h9b,h3b,p7b,h8b_0,h9b_0,h3b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p7b_0+(z->nab())*(h3b_0+(z->nab())*(h9b_0+(z->nab())*(h8b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,-1.0); 
         in[2]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::offset_smith_1_12(){ 
 
long size=0L; 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
       in[2]->input_offset(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),size); 
       size+=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_13(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    long tileoffset; 
    if (h2b<h3b) { 
     tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    } 
    else if (h3b<=h2b) { 
     tileoffset=(h2b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    } 
    if (i1xn[0]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h9b=0L;h9b<z->noab();++h9b) { 
         for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(p6b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h9b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(p8b)^(z->get_sym(h2b)^z->get_sym(h9b))))==z->irrep_t()) { 
            long p6b_0,p8b_0,h2b_0,h9b_0; 
            z->restricted_4(p6b,p8b,h2b,h9b,p6b_0,p8b_0,h2b_0,h9b_0); 
            long h7b_1,h9b_1,h3b_1,p8b_1; 
            z->restricted_4(h7b,h9b,h3b,p8b,h7b_1,h9b_1,h3b_1,p8b_1); 
            long dim_common=z->get_range(h9b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(p6b)*z->get_range(h2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h7b)*z->get_range(h3b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (p6b<p8b && h2b<h9b) { 
              z->t2()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p8b),z->get_range(h2b),z->get_range(h9b),2,0,1,3,+1.0); 
             } 
             else if (p6b<p8b && h9b<=h2b) { 
              z->t2()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p8b),z->get_range(h9b),z->get_range(h2b),3,0,1,2,-1.0); 
             } 
             else if (p8b<=p6b && h2b<h9b) { 
              z->t2()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p6b),z->get_range(h2b),z->get_range(h9b),2,1,0,3,-1.0); 
             } 
             else if (p8b<=p6b && h9b<=h2b) { 
              z->t2()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p6b),z->get_range(h9b),z->get_range(h2b),3,1,0,2,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h7b<h9b) { 
              in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h9b_1+z->noab()*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),2,0,3,1,+1.0); 
             } 
             else if (h9b<=h7b) { 
              in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h7b_1+z->noab()*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h7b),z->get_range(h3b),z->get_range(p8b),2,1,3,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h3b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h7b),z->get_range(h2b),z->get_range(p6b),1,3,2,0,+1.0); 
         i1xn[0]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        } 
        if (h2b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h7b),z->get_range(h2b),z->get_range(p6b),1,3,0,2,-1.0); 
         i1xn[0]->add_block(h2b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_13_0(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h9b=h7b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p8b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
        long h7b_0,h9b_0,h3b_0,p8b_0; 
        z->restricted_4(h7b,h9b,h3b,p8b,h7b_0,h9b_0,h3b_0,p8b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p8b_0+(z->nab())*(h3b_0+(z->nab())*(h9b_0+(z->nab())*(h7b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,+1.0); 
         in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::offset_smith_1_13(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h9b=h7b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    if (z->get_spin(h7b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
       in[2]->input_offset(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_14(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    if (p5b<p6b) { 
     tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    } 
    else if (p6b<=p5b) { 
     tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))); 
    } 
    if (i1xn[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h9b=0L;h9b<z->noab();++h9b) { 
         for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(p5b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h9b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h9b))))==z->irrep_t()) { 
            long p5b_0,p8b_0,h3b_0,h9b_0; 
            z->restricted_4(p5b,p8b,h3b,h9b,p5b_0,p8b_0,h3b_0,h9b_0); 
            long h9b_1,p6b_1,p7b_1,p8b_1; 
            z->restricted_4(h9b,p6b,p7b,p8b,h9b_1,p6b_1,p7b_1,p8b_1); 
            long dim_common=z->get_range(h9b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(p5b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(p6b)*z->get_range(p7b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (p5b<p8b && h3b<h9b) { 
              z->t2()->get_block(h9b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(h3b),z->get_range(h9b),2,0,1,3,+1.0); 
             } 
             else if (p5b<p8b && h9b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),3,0,1,2,-1.0); 
             } 
             else if (p8b<=p5b && h3b<h9b) { 
              z->t2()->get_block(h9b_0+z->noab()*(h3b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(h3b),z->get_range(h9b),2,1,0,3,-1.0); 
             } 
             else if (p8b<=p5b && h9b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h9b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(h9b),z->get_range(h3b),3,1,0,2,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (p7b<p8b) { 
              z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),2,1,3,0,+1.0); 
             } 
             else if (p8b<=p7b) { 
              z->v2()->get_block(p7b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p6b),z->get_range(p8b),z->get_range(p7b),3,1,2,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (p6b>=p5b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p5b),3,1,2,0,+1.0); 
         i1xn[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
        } 
        if (p5b>=p6b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p5b),1,3,2,0,-1.0); 
         i1xn[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_15(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (i1xn[0]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         for (long p9b=p8b;p9b<z->noab()+z->nvab();++p9b) { 
          if (z->get_spin(p8b)+z->get_spin(p9b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
           if ((z->get_sym(p8b)^(z->get_sym(p9b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_t()) { 
            long p8b_0,p9b_0,h2b_0,h3b_0; 
            z->restricted_4(p8b,p9b,h2b,h3b,p8b_0,p9b_0,h2b_0,h3b_0); 
            long h7b_1,p6b_1,p8b_1,p9b_1; 
            z->restricted_4(h7b,p6b,p8b,p9b,h7b_1,p6b_1,p8b_1,p9b_1); 
            long dim_common=z->get_range(p8b)*z->get_range(p9b); 
            long dima0_sort=z->get_range(h2b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h7b)*z->get_range(p6b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p8b==p9b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),1,0,3,2,-0.5/0.5); 
        i1xn[0]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_1_0(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  long tileoffset; 
  tileoffset=(p8b-z->noab()+z->nvab()*(h7b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^z->get_sym(p8b))==z->irrep_f()) { 
      long dimc=z->get_range(h7b)*z->get_range(p8b); 
      long h7b_0,p8b_0; 
      z->restricted_2(h7b,p8b,h7b_0,p8b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h7b)*z->get_range(p8b); 
      long dima0=dim_common*dima0_sort; 
      if (dima0>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->f1()->get_block(p8b_0+(z->nab())*(h7b_0),k_a0); 
       z->sort_indices2(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(p8b),0,1,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_c=z->mem()->malloc_local_double(dimc); 
       z->sort_indices2(k_a0_sort,k_c,z->get_range(h7b),z->get_range(p8b),0,1,+1.0); 
       in[2]->add_block(p8b-z->noab()+z->nvab()*(h7b),k_c); 
       z->mem()->free_local_double(k_c); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::offset_smith_1_1(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  if (z->get_spin(h7b)==z->get_spin(p8b)) { 
   if ((z->get_sym(h7b)^z->get_sym(p8b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
     in[2]->input_offset(p8b-z->noab()+z->nvab()*(h7b),size); 
     size+=z->get_range(h7b)*z->get_range(p8b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_4(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (i1xn[0]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h8b=0L;h8b<z->noab();++h8b) { 
         if (z->get_spin(p6b)==z->get_spin(h8b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h8b))==z->irrep_t()) { 
           long p6b_0,h8b_0; 
           z->restricted_2(p6b,h8b,p6b_0,h8b_0); 
           long h7b_1,h8b_1,h2b_1,h3b_1; 
           z->restricted_4(h7b,h8b,h2b,h3b,h7b_1,h8b_1,h2b_1,h3b_1); 
           long dim_common=z->get_range(h8b); 
           long dima0_sort=z->get_range(p6b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h2b)*z->get_range(h3b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h8b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h8b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h7b<h8b) { 
             in[2]->get_block(h3b_1+z->noab()*(h2b_1+z->noab()*(h8b_1+z->noab()*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),3,2,0,1,+1.0); 
            } 
            else if (h8b<=h7b) { 
             in[2]->get_block(h3b_1+z->noab()*(h2b_1+z->noab()*(h7b_1+z->noab()*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h7b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h7b),z->get_range(p6b),2,3,1,0,+1.0); 
        i1xn[0]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_4_0(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        long h7b_0,h8b_0,h2b_0,h3b_0; 
        z->restricted_4(h7b,h8b,h2b,h3b,h7b_0,h8b_0,h2b_0,h3b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(h3b_0+(z->nab())*(h2b_0+(z->nab())*(h8b_0+(z->nab())*(h7b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),0,1,2,3,+1.0); 
         in[2]->add_block(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::offset_smith_1_4(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
       in[2]->input_offset(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_5(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    long tileoffset; 
    if (h2b<h3b) { 
     tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    } 
    else if (h3b<=h2b) { 
     tileoffset=(h2b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    } 
    if (i1xn[0]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p8b_0,h2b_0; 
           z->restricted_2(p8b,h2b,p8b_0,h2b_0); 
           long h7b_1,p6b_1,h3b_1,p8b_1; 
           z->restricted_4(h7b,p6b,h3b,p8b,h7b_1,p6b_1,h3b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h2b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h2b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p8b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h3b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),2,1,3,0,+1.0); 
         i1xn[0]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        } 
        if (h2b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),2,1,0,3,-1.0); 
         i1xn[0]->add_block(h2b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_5_0(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p8b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
        long h7b_0,p6b_0,h3b_0,p8b_0; 
        z->restricted_4(h7b,p6b,h3b,p8b,h7b_0,p6b_0,h3b_0,p8b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p8b_0+(z->nab())*(h3b_0+(z->nab())*(p6b_0+(z->nab())*(h7b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,+1.0); 
         in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::offset_smith_1_5(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
       in[2]->input_offset(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_6(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    if (p5b<p6b) { 
     tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    } 
    else if (p6b<=p5b) { 
     tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))); 
    } 
    if (i1xn[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h8b=0L;h8b<z->noab();++h8b) { 
         if (z->get_spin(p5b)==z->get_spin(h8b)) { 
          if ((z->get_sym(p5b)^z->get_sym(h8b))==z->irrep_t()) { 
           long p5b_0,h8b_0; 
           z->restricted_2(p5b,h8b,p5b_0,h8b_0); 
           long h8b_1,p6b_1,h3b_1,p7b_1; 
           z->restricted_4(h8b,p6b,h3b,p7b,h8b_1,p6b_1,h3b_1,p7b_1); 
           long dim_common=z->get_range(h8b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h8b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h8b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p7b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),3,2,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (p6b>=p5b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),3,2,1,0,+1.0); 
         i1xn[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
        } 
        if (p5b>=p6b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),2,3,1,0,-1.0); 
         i1xn[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_6_0(){ 
      
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(h8b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        long h8b_0,p6b_0,h3b_0,p7b_0; 
        z->restricted_4(h8b,p6b,h3b,p7b,h8b_0,p6b_0,h3b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h8b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p7b_0+(z->nab())*(h3b_0+(z->nab())*(p6b_0+(z->nab())*(h8b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h8b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h8b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,+1.0); 
         in[2]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::offset_smith_1_6(){ 
 
long size=0L; 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
       in[2]->input_offset(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b))),size); 
       size+=z->get_range(h8b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_1_7(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    if (i1xn[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p8b_0,h3b_0; 
           z->restricted_2(p8b,h3b,p8b_0,h3b_0); 
           long p5b_1,p6b_1,p7b_1,p8b_1; 
           z->restricted_4(p5b,p6b,p7b,p8b,p5b_1,p6b_1,p7b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p7b<p8b) { 
             z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(p6b_1+(z->nab())*(p5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(p5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(p7b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),z->get_range(h3b),2,1,3,0,+1.0); 
        i1xn[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_2_10(){ 
      
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h8b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h9b=0L;h9b<z->noab();++h9b) { 
         if (z->get_spin(p6b)==z->get_spin(h9b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h9b))==z->irrep_t()) { 
           long p6b_0,h9b_0; 
           z->restricted_2(p6b,h9b,p6b_0,h9b_0); 
           long h8b_1,h9b_1,h3b_1,p7b_1; 
           z->restricted_4(h8b,h9b,h3b,p7b,h8b_1,h9b_1,h3b_1,p7b_1); 
           long dim_common=z->get_range(h9b); 
           long dima0_sort=z->get_range(p6b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h8b)*z->get_range(h3b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h9b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h9b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h8b<h9b) { 
             in[3]->get_block(p7b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h9b_1+z->noab()*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),3,2,0,1,+1.0); 
            } 
            else if (h9b<=h8b) { 
             in[3]->get_block(p7b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h8b_1+z->noab()*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h8b),z->get_range(h3b),z->get_range(p7b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h3b),z->get_range(h8b),z->get_range(p6b),2,3,1,0,+0.5); 
        in[2]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_2_10_0(){ 
      
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        long h8b_0,h9b_0,h3b_0,p7b_0; 
        z->restricted_4(h8b,h9b,h3b,p7b,h8b_0,h9b_0,h3b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p7b_0+(z->nab())*(h3b_0+(z->nab())*(h9b_0+(z->nab())*(h8b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,-1.0); 
         in[3]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::offset_smith_2_10(){ 
 
long size=0L; 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
       in[3]->input_offset(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),size); 
       size+=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_2_11(){ 
      
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h8b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         if (z->get_spin(p9b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p9b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p9b_0,h3b_0; 
           z->restricted_2(p9b,h3b,p9b_0,h3b_0); 
           long h8b_1,p6b_1,p7b_1,p9b_1; 
           z->restricted_4(h8b,p6b,p7b,p9b,h8b_1,p6b_1,p7b_1,p9b_1); 
           long dim_common=z->get_range(p9b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h8b)*z->get_range(p6b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p7b<p9b) { 
             z->v2()->get_block(p9b_1+(z->nab())*(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),z->get_range(p9b),2,1,0,3,+1.0); 
            } 
            else if (p9b<=p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p9b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(p6b),z->get_range(p9b),z->get_range(p7b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(p6b),z->get_range(h8b),z->get_range(h3b),2,1,3,0,-1.0); 
        in[2]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_2_18(){ 
      
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h8b_1,h9b_1,p7b_1,p10b_1; 
           z->restricted_4(h8b,h9b,p7b,p10b,h8b_1,h9b_1,p7b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h8b)*z->get_range(h9b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p7b<p10b) { 
             z->v2()->get_block(p10b_1+(z->nab())*(p7b_1+(z->nab())*(h9b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(p7b),z->get_range(p10b),2,1,0,3,+1.0); 
            } 
            else if (p10b<=p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(p10b),z->get_range(p7b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h9b),z->get_range(h8b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[2]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_2_19(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  long tileoffset; 
  tileoffset=(p8b-z->noab()+z->nvab()*(h7b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^z->get_sym(p8b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h7b)*z->get_range(p8b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h10b=0L;h10b<z->noab();++h10b) { 
       for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
        if (z->get_spin(p9b)==z->get_spin(h10b)) { 
         if ((z->get_sym(p9b)^z->get_sym(h10b))==z->irrep_t()) { 
          long p9b_0,h10b_0; 
          z->restricted_2(p9b,h10b,p9b_0,h10b_0); 
          long h7b_1,h10b_1,p8b_1,p9b_1; 
          z->restricted_4(h7b,h10b,p8b,p9b,h7b_1,h10b_1,p8b_1,p9b_1); 
          long dim_common=z->get_range(h10b)*z->get_range(p9b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h7b)*z->get_range(p8b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h10b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h10b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h7b<h10b && p8b<p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p8b),z->get_range(p9b),2,0,3,1,+1.0); 
           } 
           else if (h7b<h10b && p9b<=p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p9b),z->get_range(p8b),3,0,2,1,-1.0); 
           } 
           else if (h10b<=h7b && p8b<p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p8b),z->get_range(p9b),2,1,3,0,-1.0); 
           } 
           else if (h10b<=h7b && p9b<=p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p9b),z->get_range(p8b),3,1,2,0,+1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p8b),z->get_range(h7b),1,0,+1.0); 
      in[2]->add_block(p8b-z->noab()+z->nvab()*(h7b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_2_20(){ 
      
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h8b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h10b=0L;h10b<z->noab();++h10b) { 
         for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
          if (z->get_spin(p6b)+z->get_spin(p9b)==z->get_spin(h3b)+z->get_spin(h10b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(p9b)^(z->get_sym(h3b)^z->get_sym(h10b))))==z->irrep_t()) { 
            long p6b_0,p9b_0,h3b_0,h10b_0; 
            z->restricted_4(p6b,p9b,h3b,h10b,p6b_0,p9b_0,h3b_0,h10b_0); 
            long h8b_1,h10b_1,p7b_1,p9b_1; 
            z->restricted_4(h8b,h10b,p7b,p9b,h8b_1,h10b_1,p7b_1,p9b_1); 
            long dim_common=z->get_range(h10b)*z->get_range(p9b); 
            long dima0_sort=z->get_range(p6b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h8b)*z->get_range(p7b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (p6b<p9b && h3b<h10b) { 
              z->t2()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p9b),z->get_range(h3b),z->get_range(h10b),2,0,1,3,+1.0); 
             } 
             else if (p6b<p9b && h10b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p9b),z->get_range(h10b),z->get_range(h3b),3,0,1,2,-1.0); 
             } 
             else if (p9b<=p6b && h3b<h10b) { 
              z->t2()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p6b),z->get_range(h3b),z->get_range(h10b),2,1,0,3,-1.0); 
             } 
             else if (p9b<=p6b && h10b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p6b),z->get_range(h10b),z->get_range(h3b),3,1,0,2,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h8b<h10b && p7b<p9b) { 
              z->v2()->get_block(p9b_1+(z->nab())*(p7b_1+(z->nab())*(h10b_1+(z->nab())*(h8b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h10b),z->get_range(p7b),z->get_range(p9b),2,0,3,1,+1.0); 
             } 
             else if (h8b<h10b && p9b<=p7b) { 
              z->v2()->get_block(p7b_1+(z->nab())*(p9b_1+(z->nab())*(h10b_1+(z->nab())*(h8b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h10b),z->get_range(p9b),z->get_range(p7b),3,0,2,1,-1.0); 
             } 
             else if (h10b<=h8b && p7b<p9b) { 
              z->v2()->get_block(p9b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h10b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h8b),z->get_range(p7b),z->get_range(p9b),2,1,3,0,-1.0); 
             } 
             else if (h10b<=h8b && p9b<=p7b) { 
              z->v2()->get_block(p7b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h10b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h8b),z->get_range(p9b),z->get_range(p7b),3,1,2,0,+1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p6b),1,3,2,0,-1.0); 
        in[2]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_2_21(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h9b=h7b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h7b_1,h9b_1,p8b_1,p10b_1; 
           z->restricted_4(h7b,h9b,p8b,p10b,h7b_1,h9b_1,p8b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h9b)*z->get_range(p8b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p8b<p10b) { 
             z->v2()->get_block(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(p8b),z->get_range(p10b),2,1,0,3,+1.0); 
            } 
            else if (p10b<=p8b) { 
             z->v2()->get_block(p8b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(p10b),z->get_range(p8b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p8b),z->get_range(h9b),z->get_range(h7b),z->get_range(h3b),2,1,3,0,-1.0); 
        in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_2_22(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
          if (z->get_spin(p9b)+z->get_spin(p10b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
           if ((z->get_sym(p9b)^(z->get_sym(p10b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_t()) { 
            long p9b_0,p10b_0,h2b_0,h3b_0; 
            z->restricted_4(p9b,p10b,h2b,h3b,p9b_0,p10b_0,h2b_0,h3b_0); 
            long h7b_1,h8b_1,p9b_1,p10b_1; 
            z->restricted_4(h7b,h8b,p9b,p10b,h7b_1,h8b_1,p9b_1,p10b_1); 
            long dim_common=z->get_range(p9b)*z->get_range(p10b); 
            long dima0_sort=z->get_range(h2b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h7b)*z->get_range(h8b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p10b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p9b),z->get_range(p10b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p9b==p10b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h8b),z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),1,0,3,2,+0.5/0.5); 
        in[2]->add_block(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_2_8(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    long tileoffset; 
    if (h2b<h3b) { 
     tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b)))); 
    } 
    else if (h3b<=h2b) { 
     tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h8b+z->noab()*(h7b)))); 
    } 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         if (z->get_spin(p9b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p9b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p9b_0,h2b_0; 
           z->restricted_2(p9b,h2b,p9b_0,h2b_0); 
           long h7b_1,h8b_1,h3b_1,p9b_1; 
           z->restricted_4(h7b,h8b,h3b,p9b,h7b_1,h8b_1,h3b_1,p9b_1); 
           long dim_common=z->get_range(p9b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h2b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h2b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[3]->get_block(p9b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h8b_1+z->noab()*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h3b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h8b),z->get_range(h7b),z->get_range(h2b),2,1,3,0,+1.0); 
         in[2]->add_block(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
        } 
        if (h2b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h8b),z->get_range(h7b),z->get_range(h2b),2,1,0,3,-1.0); 
         in[2]->add_block(h2b+z->noab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_2_8_0(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        long h7b_0,h8b_0,h3b_0,p9b_0; 
        z->restricted_4(h7b,h8b,h3b,p9b,h7b_0,h8b_0,h3b_0,p9b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p9b_0+(z->nab())*(h3b_0+(z->nab())*(h8b_0+(z->nab())*(h7b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),0,1,2,3,-1.0); 
         in[3]->add_block(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::offset_smith_2_8(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
       in[3]->input_offset(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_2_9(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         if (z->get_spin(p9b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p9b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p9b_0,h3b_0; 
           z->restricted_2(p9b,h3b,p9b_0,h3b_0); 
           long h7b_1,p6b_1,p8b_1,p9b_1; 
           z->restricted_4(h7b,p6b,p8b,p9b,h7b_1,p6b_1,p8b_1,p9b_1); 
           long dim_common=z->get_range(p9b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(p8b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p8b<p9b) { 
             z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),2,1,0,3,+1.0); 
            } 
            else if (p9b<=p8b) { 
             z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(p6b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(p9b),z->get_range(p8b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p8b),z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),2,1,3,0,-0.5); 
        in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_3_16(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h7b_1,h8b_1,p9b_1,p10b_1; 
           z->restricted_4(h7b,h8b,p9b,p10b,h7b_1,h8b_1,p9b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p9b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p9b<p10b) { 
             z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p9b),z->get_range(p10b),2,1,0,3,+1.0); 
            } 
            else if (p10b<=p9b) { 
             z->v2()->get_block(p9b_1+(z->nab())*(p10b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p10b),z->get_range(p9b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(h8b),z->get_range(h7b),z->get_range(h3b),2,1,3,0,+0.5); 
        in[3]->add_block(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2T_RIGHT::smith_3_17(){ 
      
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h8b_1,h9b_1,p7b_1,p10b_1; 
           z->restricted_4(h8b,h9b,p7b,p10b,h8b_1,h9b_1,p7b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h8b)*z->get_range(h9b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p7b<p10b) { 
             z->v2()->get_block(p10b_1+(z->nab())*(p7b_1+(z->nab())*(h9b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(p7b),z->get_range(p10b),2,1,0,3,+1.0); 
            } 
            else if (p10b<=p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(p10b),z->get_range(p7b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h9b),z->get_range(h8b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[3]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
