
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file NoGridPlottingAttributes.h
    \\brief Definition of NoGridPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "NoGridPlottingWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



NoGridPlottingWrapper::NoGridPlottingWrapper(): nogridplotting_(new NoGridPlotting())


{


	

}
NoGridPlottingWrapper::NoGridPlottingWrapper(NoGridPlotting* nogridplotting): nogridplotting_(nogridplotting)
{

	
}

NoGridPlottingWrapper::~NoGridPlottingWrapper()
{

}

void NoGridPlottingWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("MAP_GRID_LATITUDE_REFERENCE") ) {
		double latReference_value = request("MAP_GRID_LATITUDE_REFERENCE");
		nogridplotting_->latReference_ = latReference_value;
		}
	if  (request.countValues("MAP_GRID_LATITUDE_INCREMENT") ) {
		double latIncrement_value = request("MAP_GRID_LATITUDE_INCREMENT");
		nogridplotting_->latIncrement_ = latIncrement_value;
		}
	if  (request.countValues("MAP_GRID_LONGITUDE_REFERENCE") ) {
		double lonReference_value = request("MAP_GRID_LONGITUDE_REFERENCE");
		nogridplotting_->lonReference_ = lonReference_value;
		}
	if  (request.countValues("MAP_GRID_LONGITUDE_INCREMENT") ) {
		double lonIncrement_value = request("MAP_GRID_LONGITUDE_INCREMENT");
		nogridplotting_->lonIncrement_ = lonIncrement_value;
		}
	
	
}

void NoGridPlottingWrapper::print(ostream& out)  const
{
	out << "NoGridPlottingWrapper[]";
}


