{
    Copyright (c) 2002 by Marco van de Voort

    Syscall functions for i386 *BSD.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ****************************************************************************

These functions are the same over all three BSDs, except that some have a
32-bit Errno, and some a 16-bit}

{$ifdef FPC_USE_SYSCALL}

{$ifdef NetBSD}
 {$UNDEF ErrnoWord}
{$endif}
{$ifdef FreeBSD}
 {$DEFINE ErrnoWord}
{$endif}

Procedure fpc_geteipasebx;[external name 'fpc_geteipasebx'];

procedure actualsyscall; assembler; {inline requires a dummy push IIRC}
    asm
         int $0x80
         jb .LErrorcode
         ret
.LErrorcode:
{$ifdef FPC_PIC}
  call  fpc_geteipasebx
  addl  $_GLOBAL_OFFSET_TABLE_,%ebx
  movl  fpc_threadvar_relocate_proc@GOT(%ebx),%ecx
  movl  (%ecx),%ecx
  movl  Errno@GOT(%ebx),%edi
{$else FPC_PIC}
  leal  Errno,%edi
  movl  fpc_threadvar_relocate_proc,%ecx
{$endif FPC_PIC}
  testl %ecx,%ecx
  jne   .LThread
 {$ifdef ErrnoWord}
  movw   %ax,4(%edi)
 {$else}
  movl  %eax,4(%edi)
 {$endif}
  jmp   .LNoThread
.LThread:
  movl  %eax,%ebx
  movl  (%edi),%eax
  call  *%ecx
 {$ifdef ErrnoWord}
  movw   %bx,4(%eax)
 {$else}
  movl  %ebx,4(%eax)
 {$endif}
.LNoThread:
  movl  $-1,%eax
end;

function FpSysCall(sysnr:TSysParam):TSysResult; oldfpccall; assembler; [public,alias:'FPC_DOSYS0'];

asm
  movl  sysnr,%eax
  call  actualsyscall
end;

function FpSysCall(sysnr,param1:TSysParam):TSysResult; oldfpccall; assembler;[public,alias:'FPC_DOSYS1'];

 asm
  movl  sysnr,%eax
  pushl Param1
  call  actualsyscall
  addl  $4,%esp
 end;

function FpSysCall(sysnr,param1:integer):TSysResult; oldfpccall;assembler;[public,alias:'FPC_DOSYS1w'];

 asm
  movswl  sysnr,%eax
  pushw Param1
  call  actualsyscall
  add   $2,%esp
 end;

function FpSysCall(sysnr,param1,param2:TSysParam):TSysResult; oldfpccall;assembler; [public,alias:'FPC_DOSYS2'];

 asm
   movl  sysnr,%eax
   pushl param2
   pushl Param1
   call  actualsyscall
   addl  $8,%esp
 end;

function FpSysCall(sysnr,param1,param2,param3:TSysParam):TSysResult; oldfpccall;assembler;[public,alias:'FPC_DOSYS3'];

 asm
   movl  sysnr,%eax
   pushl param3
   pushl param2
   pushl Param1
   call  actualsyscall
   addl  $12,%esp
end;

function FpSysCall(sysnr,param1,param2,param3,param4:TSysParam):TSysResult;oldfpccall; assembler;[public,alias:'FPC_DOSYS4'];

asm
   movl  sysnr,%eax
   pushl param4
   pushl param3
   pushl param2
   pushl Param1
   call  actualsyscall
   addl  $16,%esp
end;


function FpSysCall(sysnr,param1,param2,param3,param4,param5:TSysParam):TSysResult;oldfpccall;  assembler;[public,alias:'FPC_DOSYS5'];

 asm
   movl  sysnr,%eax
   pushl param5
   pushl param4
   pushl param3
   pushl param2
   pushl Param1
   call  actualsyscall
   addl  $20,%esp
end;

function FpSysCall(sysnr,param1,param2,param3,param4,param5,param6:TSysParam):int64; oldfpccall; assembler;[public,alias:'FPC_DOSYS6'];

asm
   movl  sysnr,%eax
   pushl param6
   pushl param5
   pushl param4
   pushl param3
   pushl param2
   pushl Param1
   call  actualsyscall
   addl  $24,%esp
end;

function FpSysCall(sysnr,param1,param2,param3,param4,param5,param6,param7:TSysParam):int64;oldfpccall;  assembler; [public,alias:'FPC_DOSYS7'];

asm
   movl  sysnr,%eax
   pushl param7
   pushl param6
   pushl param5
   pushl param4
   pushl param3
   pushl param2
   pushl Param1
   call  actualsyscall
   addl  $28,%esp
end;

function FpSysCall(sysnr,param1,param2,param3,param4,param5,param6,param7,param8:TSysParam):int64;oldfpccall;  assembler; [public,alias:'FPC_DOSYS8'];

asm
   movl  sysnr,%eax
   pushl param8
   pushl param7
   pushl param6
   pushl param5
   pushl param4
   pushl param3
   pushl param2
   pushl Param1
   call  actualsyscall
   addl  $32,%esp
end;

{$endif}
