
/* variable.h
 *
 * This file is part of fizmo.
 *
 * Copyright (c) 2009-2015 Christoph Ender.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef variable_h_INCLUDED 
#define variable_h_INCLUDED

#include <inttypes.h>

#ifndef variable_c_INCLUDED 
/*@dependent@*/ extern uint16_t *local_variable_storage_index;
extern uint8_t number_of_locals_active;
#endif /* variable_c_INCLUDED */

void set_variable(uint8_t variable_number, uint16_t data,
    bool keep_stack_index);
uint16_t get_variable(uint8_t variable_number, bool keep_stack_index);
void opcode_pull(void);
void opcode_push(void);
void opcode_push_user_stack(void);
void opcode_loadb(void);
void opcode_loadw(void);
void opcode_storew(void);
void opcode_store(void);
void opcode_inc(void);
void opcode_storeb(void);
void opcode_dec(void);
void opcode_load(void);
void opcode_pop(void);
void opcode_check_arg_count(void);

#endif /* variable_h_INCLUDED */

