/*
          Copyright (C) 1993, 1994, RSNA and Washington University

          The software and supporting documentation for the Radiological
          Society of North America (RSNA) 1993, 1994 Digital Imaging and
          Communications in Medicine (DICOM) Demonstration were developed
          at the
                  Electronic Radiology Laboratory
                  Mallinckrodt Institute of Radiology
                  Washington University School of Medicine
                  510 S. Kingshighway Blvd.
                  St. Louis, MO 63110
          as part of the 1993, 1994 DICOM Central Test Node project for, and
          under contract with, the Radiological Society of North America.

          THIS SOFTWARE IS MADE AVAILABLE, AS IS, AND NEITHER RSNA NOR
          WASHINGTON UNIVERSITY MAKE ANY WARRANTY ABOUT THE SOFTWARE, ITS
          PERFORMANCE, ITS MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR
          USE, FREEDOM FROM ANY COMPUTER DISEASES OR ITS CONFORMITY TO ANY
          SPECIFICATION. THE ENTIRE RISK AS TO QUALITY AND PERFORMANCE OF
          THE SOFTWARE IS WITH THE USER.

          Copyright of the software and supporting documentation is
          jointly owned by RSNA and Washington University, and free access
          is hereby granted as a license to use this software, copy this
          software and prepare derivative works based upon this software.
          However, any distribution of this software source code or
          supporting documentation or derivative works (source code and
          supporting documentation) must include the three paragraphs of
          the copyright notice.
*/
/* Copyright marker.  Copyright will be inserted above.  Do not remove */
/*
** @$=@$=@$=
*/
/*
	header file for Buttons.c,
	contains the structure type of a button.
*/
#ifndef BUTTONS
#define BUTTONS 1

typedef struct {
    Widget
    button;			/* The handle to the button widget */
    String
    label;			/* the label displayed in the button */
    void
        (*callback) ();		/* the callback function called when the
				 * button is */
    char			/* pressed */
       *client_data;		/* the client_data for the callback function */
        Boolean
        sensitive;		/* The default sensitiveness for the button */
}   ButtonList;


 /* Public forward declaration of the functions available */
Widget
CreateButtonTop(Widget parent, Widget top, String label,
		void (*callback) (), XtPointer client_data);
Widget
CreateButtonLeft(Widget parent, Widget left, String label,
		 void (*callback) (), XtPointer client_data);
void SetButtonSensitive(Widget w, Boolean value);
Widget
CreateButtonList(Widget parent, ButtonList list[], int size,
		 String header, Arg formargs[], int formi);
Widget
CreateLabel(Widget parent, Widget top, Widget left, char *string, int vdist);

Widget
CreateSimpleList(Widget parent, Widget top, Widget left, int xsize, int ysize,
		 void (*callback) (), XtPointer client_data, String List[],
		 int listsize, Boolean allowHoriz);
Widget
SimpleListGetBox(Widget list);
#endif
