/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class Aggregate
extends SystemFunction {
    public static final int SUM = 0;
    public static final int AVG = 1;
    public static final int COUNT = 4;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(optimizer, this.argument[0], true);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        switch (this.operation) {
            case 4: {
                return super.getItemType(typeHierarchy);
            }
            case 0: {
                ItemType itemType = Atomizer.getAtomizedItemType(this.argument[0], false, typeHierarchy);
                if (itemType == Type.UNTYPED_ATOMIC_TYPE) {
                    itemType = Type.DOUBLE_TYPE;
                }
                if (Cardinality.allowsZero(this.argument[0].getCardinality())) {
                    if (this.argument.length == 1) {
                        return Type.getCommonSuperType(itemType, Type.INTEGER_TYPE, typeHierarchy);
                    }
                    return Type.getCommonSuperType(itemType, this.argument[1].getItemType(typeHierarchy), typeHierarchy);
                }
                return itemType;
            }
            case 1: {
                ItemType itemType = Atomizer.getAtomizedItemType(this.argument[0], false, typeHierarchy);
                if (itemType == Type.UNTYPED_ATOMIC_TYPE) {
                    return Type.DOUBLE_TYPE;
                }
                if (itemType.getPrimitiveType() == 532) {
                    return Type.DECIMAL_TYPE;
                }
                return itemType;
            }
        }
        throw new AssertionError((Object)"Unknown aggregate operation");
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        switch (this.operation) {
            case 4: {
                SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
                return new IntegerValue(Aggregate.count(sequenceIterator));
            }
            case 0: {
                return this.total(this.argument[0].iterate(xPathContext), xPathContext);
            }
            case 1: {
                return this.average(this.argument[0].iterate(xPathContext), xPathContext);
            }
        }
        throw new UnsupportedOperationException("Unknown aggregate function");
    }

    private AtomicValue total(SequenceIterator sequenceIterator, XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)sequenceIterator.next();
        if (atomicValue == null) {
            if (this.argument.length == 2) {
                return (AtomicValue)this.argument[1].evaluateItem(xPathContext);
            }
            return IntegerValue.ZERO;
        }
        if (!atomicValue.hasBuiltInType()) {
            atomicValue = atomicValue.getPrimitiveValue();
        }
        if (atomicValue instanceof UntypedAtomicValue) {
            try {
                atomicValue = atomicValue.convert(517, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null || xPathException.getLocator().getLineNumber() == -1) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }
        if (atomicValue instanceof NumericValue) {
            AtomicValue atomicValue2;
            do {
                AtomicValue atomicValue3;
                if ((atomicValue3 = (AtomicValue)sequenceIterator.next()) == null) {
                    return atomicValue;
                }
                atomicValue2 = atomicValue3.getPrimitiveValue();
                if (atomicValue2 instanceof UntypedAtomicValue) {
                    atomicValue2 = atomicValue2.convert(517, xPathContext);
                    continue;
                }
                if (atomicValue2 instanceof NumericValue) continue;
                DynamicError dynamicError = new DynamicError("Input to sum() contains a mix of numeric and non-numeric values");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("FORG0006");
                dynamicError.setLocator(this);
                throw dynamicError;
            } while (!((NumericValue)(atomicValue = ((NumericValue)atomicValue).arithmetic(15, (NumericValue)atomicValue2, xPathContext))).isNaN());
            return atomicValue;
        }
        if (atomicValue instanceof DurationValue) {
            while (true) {
                AtomicValue atomicValue4;
                if ((atomicValue4 = (AtomicValue)sequenceIterator.next()) == null) {
                    return atomicValue;
                }
                AtomicValue atomicValue5 = atomicValue4.getPrimitiveValue();
                if (!(atomicValue5 instanceof DurationValue)) {
                    DynamicError dynamicError = new DynamicError("Input to sum() contains a mix of duration and non-duration values");
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setErrorCode("FORG0006");
                    dynamicError.setLocator(this);
                    throw dynamicError;
                }
                atomicValue = ((DurationValue)atomicValue).add((DurationValue)atomicValue5);
            }
        }
        DynamicError dynamicError = new DynamicError("Input to sum() contains a value that is neither numeric, nor a duration");
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode("FORG0006");
        dynamicError.setLocator(this);
        throw dynamicError;
    }

    private AtomicValue average(SequenceIterator sequenceIterator, XPathContext xPathContext) throws XPathException {
        int n = 0;
        AtomicValue atomicValue = (AtomicValue)sequenceIterator.next();
        if (atomicValue == null) {
            return null;
        }
        ++n;
        if (!atomicValue.hasBuiltInType()) {
            atomicValue = atomicValue.getPrimitiveValue();
        }
        if (atomicValue instanceof UntypedAtomicValue) {
            try {
                atomicValue = atomicValue.convert(517, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null || xPathException.getLocator().getLineNumber() == -1) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }
        if (atomicValue instanceof NumericValue) {
            AtomicValue atomicValue2;
            do {
                AtomicValue atomicValue3;
                if ((atomicValue3 = (AtomicValue)sequenceIterator.next()) == null) {
                    return ((NumericValue)atomicValue).arithmetic(18, new IntegerValue(n), xPathContext);
                }
                ++n;
                atomicValue2 = atomicValue3.getPrimitiveValue();
                if (atomicValue2 instanceof UntypedAtomicValue) {
                    try {
                        atomicValue2 = atomicValue2.convert(517, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null || xPathException.getLocator().getLineNumber() == -1) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                } else {
                    if (atomicValue2 instanceof NumericValue) continue;
                    DynamicError dynamicError = new DynamicError("Input to avg() contains a mix of numeric and non-numeric values");
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setErrorCode("FORG0006");
                    dynamicError.setLocator(this);
                    throw dynamicError;
                }
            } while (!((NumericValue)(atomicValue = ((NumericValue)atomicValue).arithmetic(15, (NumericValue)atomicValue2, xPathContext))).isNaN());
            return atomicValue;
        }
        if (atomicValue instanceof DurationValue) {
            while (true) {
                AtomicValue atomicValue4;
                if ((atomicValue4 = (AtomicValue)sequenceIterator.next()) == null) {
                    return ((DurationValue)atomicValue).multiply(1.0 / (double)n);
                }
                ++n;
                AtomicValue atomicValue5 = atomicValue4.getPrimitiveValue();
                if (!(atomicValue5 instanceof DurationValue)) {
                    DynamicError dynamicError = new DynamicError("Input to avg() contains a mix of duration and non-duration values");
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setErrorCode("FORG0006");
                    dynamicError.setLocator(this);
                    throw dynamicError;
                }
                atomicValue = ((DurationValue)atomicValue).add((DurationValue)atomicValue5);
            }
        }
        DynamicError dynamicError = new DynamicError("Input to avg() contains a value that is neither numeric, nor a duration");
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode("FORG0006");
        dynamicError.setLocator(this);
        throw dynamicError;
    }

    public static int count(SequenceIterator sequenceIterator) throws XPathException {
        if ((sequenceIterator.getProperties() & 2) != 0) {
            return ((LastPositionFinder)sequenceIterator).getLastPosition();
        }
        int n = 0;
        while (sequenceIterator.next() != null) {
            ++n;
        }
        return n;
    }

    public static boolean isCountFunction(Expression expression) {
        if (!(expression instanceof Aggregate)) {
            return false;
        }
        Aggregate aggregate = (Aggregate)expression;
        return aggregate.getNumberOfArguments() == 1 && aggregate.operation == 4;
    }
}

