unit ButtonB;

{ Replacement Buttons as original buttons          }
{ do not work in QT5                               }
{ Need to avoid using Bitblt SCRAND & SCRPAINT     }
{  PB Nov-20                                       }
{}

interface uses Classes, Graphics, ButtonBase, LCLExceptionStackTrace;

type
   TButtonB = class(TButtonBase)
      constructor Create (aOwner: TComponent); override;
   private
      FMask: TBitmap;
      procedure SetGlyph;
      procedure SetMask    (Bmp: TBitmap);
      procedure SetGraphic (Bmp: TBitmap);
      procedure SetIndex   (Ind: Integer);
   public
      procedure CheckGlyph;
   published
      property Mask:    TBitmap read FMask      write SetMask;
      property Graphic: TBitmap read FGraphic   write SetGraphic;
      property ButtonIndex: integer read FIndex write SetIndex;
   end;

procedure Register;


implementation

procedure Register;
begin
   RegisterComponents('C-evo', [TButtonB]);
end;

const sz = 25;  { Square button }
      Xg = 169; { Graphic offests }
      Yg = 243;
      Xm = 1;   { Mask offsets }
      Ym = 337;

constructor TButtonB.Create(aOwner: TComponent);
begin
   inherited;
   SetBounds(0, 0, sz, sz);
   Glyph.Width  := sz;
   Glyph.Height := sz;
   Fmask        := nil;
end;


procedure TButtonB.SetGlyph;
var X ,Xpos, Y, Ypos : integer;
   Dest, Src : TRect;
begin
   Xpos := Xm + FIndex mod 12 * (sz+1);
   Ypos := Ym + FIndex div 12 * (sz+1);

   Dest  := Rect (0, 0, sz, sz);
   Src   := Rect (Xg, Yg, Xg+sz, Yg+sz);

   Glyph.BeginUpdate (True);
   Glyph.Canvas.CopyRect(dest, FGraphic.Canvas, src);

   for X := 0 to (sz-1) do
      for Y := 0 to (sz-1) do
         if FMask.Canvas.Pixels [X+Xpos, Y+Ypos] = clBlack then
            Glyph.Canvas.Pixels [X,Y] := clBlack;

   Glyph.EndUpdate;
end;


procedure TButtonB.CheckGlyph;
begin
   if (FIndex >= 0) and (FGraphic <> nil) and (FMask <> nil) then
      SetGlyph;
end;

procedure TButtonB.SetGraphic(Bmp: TBitmap);
begin
   FGraphic := Bmp;
   CheckGlyph;
end;

procedure TButtonB.SetMask(Bmp: TBitmap);

begin
   FMask := Bmp;
   CheckGlyph;
end;

procedure TButtonB.SetIndex (Ind: integer);
begin
   if (FIndex <> Ind) then
   begin
      FIndex := Ind;
      CheckGlyph;
   end;
end;

end.
