/* Simple Plugin API */
/* SPDX-FileCopyrightText: Copyright © 2025 PipeWire authors */
/* SPDX-License-Identifier: MIT */

#ifndef SPA_VIDEO_COLOR_TYPES_H
#define SPA_VIDEO_COLOR_TYPES_H

#include <spa/utils/type.h>
#include <spa/param/video/color.h>

#define SPA_TYPE_INFO_VideColorRange		SPA_TYPE_INFO_ENUM_BASE "VideoColorRange"
#define SPA_TYPE_INFO_VIDEO_COLOR_RANGE_BASE	SPA_TYPE_INFO_VideColorRange ":"

static const struct spa_type_info spa_type_video_color_range[] = {
	{ SPA_VIDEO_COLOR_RANGE_UNKNOWN, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_RANGE_BASE "unknown", NULL },
	{ SPA_VIDEO_COLOR_RANGE_0_255, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_RANGE_BASE "0-255", NULL },
	{ SPA_VIDEO_COLOR_RANGE_16_235, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_RANGE_BASE "16-235", NULL },
	{ 0, 0, NULL, NULL },
};

#define SPA_TYPE_INFO_VideoColorMatrix		SPA_TYPE_INFO_ENUM_BASE "VideoColorMatrix"
#define SPA_TYPE_INFO_VIDEO_COLOR_MATRIX_BASE	SPA_TYPE_INFO_VideoColorMatrix ":"

static const struct spa_type_info spa_type_video_color_matrix[] = {
	{ SPA_VIDEO_COLOR_MATRIX_UNKNOWN, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_MATRIX_BASE "unknown", NULL },
	{ SPA_VIDEO_COLOR_MATRIX_RGB, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_MATRIX_BASE "rgb", NULL },
	{ SPA_VIDEO_COLOR_MATRIX_FCC, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_MATRIX_BASE "fcc", NULL },
	{ SPA_VIDEO_COLOR_MATRIX_BT709, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_MATRIX_BASE "bt709", NULL },
	{ SPA_VIDEO_COLOR_MATRIX_BT601, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_MATRIX_BASE "bt601", NULL },
	{ SPA_VIDEO_COLOR_MATRIX_SMPTE240M, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_MATRIX_BASE "smpte240m", NULL },
	{ SPA_VIDEO_COLOR_MATRIX_BT2020, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_MATRIX_BASE "bt2020", NULL },
	{ 0, 0, NULL, NULL },
};

#define SPA_TYPE_INFO_VideoTransferFunction		SPA_TYPE_INFO_ENUM_BASE "VideoTransferFunction"
#define SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE	SPA_TYPE_INFO_VideoTransferFunction ":"

static const struct spa_type_info spa_type_video_transfer_function[] = {
	{ SPA_VIDEO_TRANSFER_UNKNOWN, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "unknown", NULL },
	{ SPA_VIDEO_TRANSFER_GAMMA10, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "gamma10", NULL },
	{ SPA_VIDEO_TRANSFER_GAMMA18, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "gamma18", NULL },
	{ SPA_VIDEO_TRANSFER_GAMMA20, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "gamma20", NULL },
	{ SPA_VIDEO_TRANSFER_GAMMA22, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "gamma22", NULL },
	{ SPA_VIDEO_TRANSFER_BT709, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "bt709", NULL },
	{ SPA_VIDEO_TRANSFER_SMPTE240M, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "smpte240m", NULL },
	{ SPA_VIDEO_TRANSFER_SRGB, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "srgb", NULL },
	{ SPA_VIDEO_TRANSFER_GAMMA28, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "gamma28", NULL },
	{ SPA_VIDEO_TRANSFER_LOG100, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "log100", NULL },
	{ SPA_VIDEO_TRANSFER_LOG316, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "log316", NULL },
	{ SPA_VIDEO_TRANSFER_BT2020_12, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "bt2020-12", NULL },
	{ SPA_VIDEO_TRANSFER_ADOBERGB, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "adobergb", NULL },
	{ SPA_VIDEO_TRANSFER_BT2020_10, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "bt2020-10", NULL },
	{ SPA_VIDEO_TRANSFER_SMPTE2084, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "smpte2084", NULL },
	{ SPA_VIDEO_TRANSFER_ARIB_STD_B67, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "arib-std-b67", NULL },
	{ SPA_VIDEO_TRANSFER_BT601, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_TRANSFER_FUNCTION_BASE "bt601", NULL },
	{ 0, 0, NULL, NULL },
};

#define SPA_TYPE_INFO_VideoColorPrimaries		SPA_TYPE_INFO_ENUM_BASE "VideoColorPrimaries"
#define SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE	SPA_TYPE_INFO_VideoColorPrimaries ":"

static const struct spa_type_info spa_type_video_color_primaries[] = {
	{ SPA_VIDEO_COLOR_PRIMARIES_UNKNOWN, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "unknown", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_BT709, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "bt709", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_BT470M, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "bt470m", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_BT470BG, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "bt470bg", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_SMPTE170M, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "smpte170m", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_SMPTE240M, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "smpte240m", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_FILM, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "film", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_BT2020, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "bt2020", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_ADOBERGB, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "adobergb", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_SMPTEST428, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "smptest428", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_SMPTERP431, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "smpterp431", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_SMPTEEG432, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "smpteeg432", NULL },
	{ SPA_VIDEO_COLOR_PRIMARIES_EBU3213, SPA_TYPE_Int, SPA_TYPE_INFO_VIDEO_COLOR_PRIMARIES_BASE "ebu3213", NULL },
	{ 0, 0, NULL, NULL },
};

#endif /* SPA_VIDEO_COLOR_TYPES_H */
