21 Oct 2025

> [!warning]
>
> This release includes a breaking change that moves the `kubeletVolumePath` configuration parameter to the installation section of the Helm chart values.yaml.

#### Streamline eBPF data plane installation

You can now easily install Calico with the eBPF data plane on most on-prem clusters (like those created using kubeadm), without manual configuration.
This new automated flow is enabled by setting parameters in the Installation API.

Previously, installing Calico with the eBPF data plane required a series of manual steps to manage kube-proxy and API service endpoints.
Now, the Tigera Operator handles all the necessary networking setup and kube-proxy disabling automatically, ensuring a seamless transition.

This new default behavior simplifies both fresh installations and switching an existing cluster's data plane from iptables to eBPF.
You can still use the manual setup process if needed.

#### nftables data plane GA

The nftables data plane is now generally available.

This enhancement leverages the Service implementation in Kubernetes 1.31 that uses nftables for network filtering, promising better performance and scalability compared to the default iptables implementation.
You can deploy Calico Open Source in nftables mode to provide a robust networking and network policy implementation that is fully compatible with the upstream kube-proxy utilizing nftables.

#### DSCP marking

This release enhances your Quality of Service (QoS) controls by enabling you to set Differentiated Services Code Point (DSCP) markings on your outgoing network traffic.
This capability is important for ensuring network prioritization for applications sensitive to latency or requiring differentiated treatment across a shared network.
You can now assign a DSCP value directly to packets originating from your Kubernetes pods and Calico host endpoints using the new `qos.projectcalico.org/dscp` annotation.
This approach moves the configuration of traffic priority from the network infrastructure layer to the application layer, giving you more reliable and enduring control.

#### Quality of Service (QoS) controls for eBPF data plane

We added support for QoS controls with eBPF.
If your cluster uses Calico's eBPF data plane, you can now use QoS controls for bandwidth limits, packet rate limits, and DSCP marking.

#### Full interface address coverage for auto host endpoints

You can now ensure that host endpoints automatically capture all IPv4 and IPv6 addresses across every network interface on your node.
This capability is essential for a robust and consistent security posture because it ensures that all IP addresses associated with a host are correctly mapped and protected by your network policies.
To manage which interfaces are included, you can use the new `interfacePattern` field in your `HostEndpointTemplate` within the `KubeControllersConfiguration`.

#### Fine-grained BGP control with per-peer local AS number

You can now configure a distinct local AS number for each external BGP peer by using the new `localASNumber` field in the `BGPPeer` resource.

This capability is essential for multi-homed topologies and environments where border nodes must peer with external networks, like government agencies, that require a specific local Autonomous System Number (ASN) different from the cluster's global or node-specific ASN configured in the `BGPConfiguration` resource.
This new field allows you to override the default ASN on a per-peer basis, removing the need to dedicate entire nodes to a single external peer.

If the `localASNumber` field is not set for a peer, Calico will automatically fall back to using the global or node-wide ASN as before, ensuring no change to your existing BGP behavior.

#### eBPF data plane: LRU connection tracking

You can now ensure superior service availability and performance under heavy network load with the introduction of the Least Recently Used (LRU) hash map for connection tracking (conntrack) in the eBPF data plane.

By switching to an LRU hash map, the conntrack system gains an intelligent, automatic eviction policy that removes the oldest, least recently used entries to make room for new connections, preventing network errors and dropped connections.

#### OpenStack: Immediate Neutron QoS policy application

Updates to OpenStack Neutron Quality of Service (QoS) policies are now applied immediately, minimizing configuration delays in large-scale environments.
Previously, policy changes relied on a slow, periodic resync process that could take a long time in large clusters.
With this enhancement, Calico responds to all QoS policy and rule changes on the Neutron API in real-time, enforcing network requirements within seconds and ensuring tenants have a consistent, reliable network experience.

#### Bug fixes

- Fix slow IPAM release performance when releasing IPs from disabled or deleted pools (especially for bulk deletions like those done by IPAM GC). Consider disabled pools as potential IP owners and cache any loaded blocks for fast access. [calico 11094](https://github.com/projectcalico/calico/pull/11094) (@fasaxc)
- Update LivenessProbe of calico-node to point to /bin/birdcl from the existing /usr/bin/birdcl, fixing probe failures on ppc64le and other architectures. [calico 10953](https://github.com/projectcalico/calico/pull/10953) (@kishen-v)
- Fix typo `typa` to collect typha-certs when using calicoctl. [calico 10948](https://github.com/projectcalico/calico/pull/10948) (@tianfeng92)
- Fix race condition that could result in a Wireguard IP not being assigned. [calico 10883](https://github.com/projectcalico/calico/pull/10883) (@caseydavenport)
- Calico waits until networking is fully established before setting the NetworkUnavailable=false condition. [calico 10866](https://github.com/projectcalico/calico/pull/10866) (@caseydavenport)
- Add missing staged policy permissions to apiserver.yaml [calico 11031](https://github.com/projectcalico/calico/pull/11031) (@caseydavenport)
- Fix that whisker wouldn't bind to IPv6 addresses. [calico 10839](https://github.com/projectcalico/calico/pull/10839) (@caseydavenport)
- Fix confd on Windows by skipping watching endpoint status files. [calico 10691](https://github.com/projectcalico/calico/pull/10691) (@song-jiang)
- Fix that IPAM allocation could leak handles when many workloads are scheduled to the same node at the same time, causing timeouts by "thundering herd". [calico 10658](https://github.com/projectcalico/calico/pull/10658) (@fasaxc)
- Fix: In Calico for OpenStack the operation to rebuild a VM could sometimes fail to complete successfully, with the VM getting stuck in ERROR state.  (Completion of #10608) [calico 10656](https://github.com/projectcalico/calico/pull/10656) (@nelljerram)
- Fix: In Calico for OpenStack the operation to rebuild a VM could sometimes fail to complete successfully, with the VM getting stuck in ERROR state. [calico 10608](https://github.com/projectcalico/calico/pull/10608) (@nelljerram)
- Fix that CalicoNodeStatus updates could get blocked by datastore errors [calico 10555](https://github.com/projectcalico/calico/pull/10555) (@theboringstuff)
- Reduce log level for spammy IPv6 RA log when IPv6 is disabled. [calico 10553](https://github.com/projectcalico/calico/pull/10553) (@caseydavenport)
- Fix typo in API json tag for BGP next hop mode [calico 10550](https://github.com/projectcalico/calico/pull/10550) (@song-jiang)
- Helm: fix role binding to use correct serviceaccount name when deployed in an alternative namespace. [calico 10516](https://github.com/projectcalico/calico/pull/10516) (@caseydavenport)
- Fix race condition in Goldmane startup [calico 10512](https://github.com/projectcalico/calico/pull/10512) (@caseydavenport)
- Fix Goldmane race condition when terminating streams [calico 10508](https://github.com/projectcalico/calico/pull/10508) (@caseydavenport)
- windows: fix connections occasionally being reset on periodic updates when HNS rules had not been modified [calico 10437](https://github.com/projectcalico/calico/pull/10437) (@song-jiang)
- Disable WatchList in Calico API server, fixing issue with stuck Namespace termination. [calico 10433](https://github.com/projectcalico/calico/pull/10433) (@caseydavenport)
- Add missing tiers permissions for flannel migration controller [calico 10383](https://github.com/projectcalico/calico/pull/10383) (@caseydavenport)
- Fix flannel migration use of deprecated flag "delete-local-data" [calico 10377](https://github.com/projectcalico/calico/pull/10377) (@caseydavenport)
- Fix a panic in calicoctl when using a wrong WorkloadEndpoint name with a specific format. [calico 10355](https://github.com/projectcalico/calico/pull/10355) (@coutinhop)
- Fix spammy logs when handling endpoint status creation events. [calico 10326](https://github.com/projectcalico/calico/pull/10326) (@song-jiang)
- Fail and retry if mtu file is failed to be written or not found. [calico 10270](https://github.com/projectcalico/calico/pull/10270) (@lubronzhan)
- Fix Operator not installing manifests in the correct order when creating OpenShift HCP clusters [calico 10246](https://github.com/projectcalico/calico/pull/10246) (@coutinhop)
- Fix dangling symlink preventing programs from launching on the s390x architecture. [calico 10205](https://github.com/projectcalico/calico/pull/10205) (@hjiawei)
- Fix potential nil pointer access in confd getNodeMeshPasswordKVPair. [calico 10113](https://github.com/projectcalico/calico/pull/10113) (@fasaxc)
- Fix various spammy warning logs. [calico 10088](https://github.com/projectcalico/calico/pull/10088) (@fasaxc)
- Fix a bug where the Calico APIserver would restart for all updates to the `extension-apiserver-authentication`, regardless of whether the ConfigMap's data actually changed. [calico 9719](https://github.com/projectcalico/calico/pull/9719) (@aaaaaaaalex)

##### nftables

- nftables: fix reprogramming of base chain rules after out-of-band flush. [calico 10936](https://github.com/projectcalico/calico/pull/10936) (@caseydavenport)

##### eBPF

- ebpf: do not blindly redirect back to the same host iface (regression from 3.29) [calico 11154](https://github.com/projectcalico/calico/pull/11154) (@tomastigera)
- ebpf: some old kernels do not verify ipv4 defrag code correctly. We disable the code if the kernel does not have CO-RE or bpf_loop() (~<5.17) [calico 10859](https://github.com/projectcalico/calico/pull/10859) (@tomastigera)
- ebpf: Fix race between loading kubernetes services and conntrack cleanup.  If conntrack cleanup ran before services were loaded, all service entries would look stale and get cleaned up. [calico 10721](https://github.com/projectcalico/calico/pull/10721) (@fasaxc)
- Fix benign "Not a valid CIDR." log when processing headless services in kube proxy. [calico 10698](https://github.com/projectcalico/calico/pull/10698) (@fasaxc)
- ebpf: fixes ICMP response source IP when nodes have multiple IPs assigned [calico 10660](https://github.com/projectcalico/calico/pull/10660) (@tomastigera)
- ebpf: Fix large policy programs in case jit_harden is set, e.g. like in Bottlerocket [calico 10602](https://github.com/projectcalico/calico/pull/10602) (@tomastigera)
- ebpf: Fixed mounting cgroupv2 for connect time load balancing. [calico 10503](https://github.com/projectcalico/calico/pull/10503) (@sridhartigera)
- ebpf: fix forwarding for asymetric routing https://github.com/projectcalico/calico/issues/10469 [calico 10511](https://github.com/projectcalico/calico/pull/10511) (@tomastigera)
- ebpf: handles fragmented IPv4 packets, some limitations apply [calico 10335](https://github.com/projectcalico/calico/pull/10335) (@tomastigera)
- ebpf: Fix configuring arp entries for bpf NAT devices for systemd >= 242 [calico 10216](https://github.com/projectcalico/calico/pull/10216) (@sridhartigera)
- ebpf: Fixed a bug where BPF programs were being re-attached to network interfaces unnecessarily, even when the host IP address had not changed. [calico 10161](https://github.com/projectcalico/calico/pull/10161) (@sridhartigera)
- ebpf: Fix dropping packets from workloads to host interfaces not managed by calico. [calico 10069](https://github.com/projectcalico/calico/pull/10069) (@sridhartigera)
- ebpf: fix cleanup of UDP service entries when a service gets (re)created [calico 10049](https://github.com/projectcalico/calico/pull/10049) (@tomastigera)

#### Other changes

##### Breaking changes

- kubeletVolumePath has been moved to the `installation` section of helm chart values.yaml [calico 10400](https://github.com/projectcalico/calico/pull/10400) (@caseydavenport)

##### General

- Make Calico's backing CRDs optional. Calico will no longer fail to start is a CRD is missing. [calico 11035](https://github.com/projectcalico/calico/pull/11035) (@caseydavenport)
- When the AssumeNeededOnEveryNode performance hint is set on a policy, the iptables dataplane now renders the policy rules to the filter table, even if the chain is not yet referenced; this reduces the work needed when a new workload arrives needing the policy. [calico 10974](https://github.com/projectcalico/calico/pull/10974) (@fasaxc)
- Improve Whisker UI display of enforced and pending policy traces. [calico 10915](https://github.com/projectcalico/calico/pull/10915) (@breff)
- Removed manual Windows Kubernetes service installation scripts. [calico 10893](https://github.com/projectcalico/calico/pull/10893) (@song-jiang)
- Enhanced IP Pool Allocation by introduce namespaceSelector Field [calico 10888](https://github.com/projectcalico/calico/pull/10888) (@PersistentJZH)
- Scale: Kubernetes datastore: speed up IP allocation in clusters that have 1000+ IPAM blocks.  Previously, the IPAM plugin would list all block affinity resources for every request and filter client-side.  Add a label to the block affinity and filter on that instead, for efficient server-side filtering. [calico 10855](https://github.com/projectcalico/calico/pull/10855) (@fasaxc)
- Add calicoctl validate command, which runs local validation against its input without applying changes to the datastore. [calico 10829](https://github.com/projectcalico/calico/pull/10829) (@Copilot)
- Avoid loading wireguard kernel module when Wireguard is disabled. [calico 10821](https://github.com/projectcalico/calico/pull/10821) (@bartekzurawski)
- Updates RBAC for kube-controllers to access services/servicestatus for ETCD manifest installation. [calico 10791](https://github.com/projectcalico/calico/pull/10791) (@MichalFupso)
- Performance: Felix now loads BPF programs in parallel for reduced start-up latency. [calico 10771](https://github.com/projectcalico/calico/pull/10771) (@fasaxc)
- Adds apiservices and webhooks information to the calicoctl diags bundle. [calico 10744](https://github.com/projectcalico/calico/pull/10744) (@rene-dekker)
- You can now configure whether or not to aggregate routes for LoadBalancer services with externalTrafficPolicy=Cluster when advertised over BGP. [calico 10719](https://github.com/projectcalico/calico/pull/10719) (@PersistentJZH)
- Set DSCP for workload's egress traffic leaving cluster [calico 10718](https://github.com/projectcalico/calico/pull/10718) (@mazdakn)
- Cap whisker UI memory consumption [calico 10712](https://github.com/projectcalico/calico/pull/10712) (@ronanc-tigera)
- Added typha configuration to allow server address to be configured [calico 10697](https://github.com/projectcalico/calico/pull/10697) (@Cellebyte)
- Updates the HostEndpoint controller to be aware of all Node interfaces and IPs. Update the HostEndpoint template with interfaceSelector to be able to create automatic HostEndpoints containing interfaceName. Existing HostEndpoints created by the HostEndpoint controller might be updated after the upgrade to contain interfaces newly detected by Calico Node. [calico 10672](https://github.com/projectcalico/calico/pull/10672) (@MichalFupso)
- Calico LoadBalancerController will consider service.spec.LoadBalancerClass in determining if IP should be assigned. When in RequestedServicesOnly mode service will be assigned IP if LoadBalancerClass is set to calico. When running in AllServices and RequestedServicesOnly mode and the LoadBalancerClass is set to other value than calico, service will not be assigned an IP [calico 10627](https://github.com/projectcalico/calico/pull/10627) (@MichalFupso)
- Operator now annotates Guardian pods with cluster version information [calico 10613](https://github.com/projectcalico/calico/pull/10613) (@vara2504)
- Introduce the "localASNumber" field to BGP Peer spec to override the global AS Number defined in the default BGPConfiguration. [calico 10600](https://github.com/projectcalico/calico/pull/10600) (@skoryk-oleksandr)
- Component Migration: To support a minimal footprint and simplify resource management, the calico-apiserver component and its associated resources have been moved from the calico-apiserver namespace to the calico-system namespace. [calico 10574](https://github.com/projectcalico/calico/pull/10574) (@vara2504)
- Match all supported protocols in app policy . [calico 10565](https://github.com/projectcalico/calico/pull/10565) (@mazdakn)
- Add validation to guard against catch-all CIDRs (e.g. 0.0.0.0/0) on negated (notnets) policy rules, as those would effectively disallow all addresses. [calico 10563](https://github.com/projectcalico/calico/pull/10563) (@dzacball)
- Match all supported protocols in app policy . [calico 10546](https://github.com/projectcalico/calico/pull/10546) (@mazdakn)
- Allow Operator to delete ANP/BANP CRDs to set owner refs when assuming control of pre-existing CRDs, for example on OCP. [calico 10543](https://github.com/projectcalico/calico/pull/10543) (@mazdakn)
- Add Goldmane + Whisker CRD specs to helm values.yaml [calico 10501](https://github.com/projectcalico/calico/pull/10501) (@czomo)
- Added support for packet burst configuration to packet rate QoS controls. Fixed upper and lower boundaries of packet rate and number of connections QoS controls to be in-line with kernel limits. [calico 10489](https://github.com/projectcalico/calico/pull/10489) (@coutinhop)
- Enhance Felix to program routes for no encapsulation IP pools instead of BIRD. [calico 10472](https://github.com/projectcalico/calico/pull/10472) (@mazdakn)
- Add NextHopMode field to BGPPeer API. [calico 10471](https://github.com/projectcalico/calico/pull/10471) (@song-jiang)
- Added support for peakrate (and optionally minburst) configuration to bandwidth QoS controls. [calico 10458](https://github.com/projectcalico/calico/pull/10458) (@coutinhop)
- Reduce kube-controllers memory usage by stripping unnecessary Pod fields [calico 10402](https://github.com/projectcalico/calico/pull/10402) (@caseydavenport)
- CSI driver is now disabled by default in helm chart [calico 10400](https://github.com/projectcalico/calico/pull/10400) (@caseydavenport)
- Policies created prior to v3.28.0 have their name retained across upgrade. Policies created in the default tier with version v3.29.[0-3] will have their names changed from `default.name` to `name`. [calico 10399](https://github.com/projectcalico/calico/pull/10399) (@MichalFupso)
- Include all interfaces in CNI result [calico 10382](https://github.com/projectcalico/calico/pull/10382) (@DrAuYueng)
- TLS ciphers are now configurable. This allows greater flexibility for meeting compliance requirements or supporting specific client configurations. If no custom list is provided, a secure default set of PFS ciphers is used. [calico 10380](https://github.com/projectcalico/calico/pull/10380) (@lucastigera)
- Update example Grafana dashboard for monitoring Felix.  Add a lot more detail and process the hard-to-use metrics into something more useful. [calico 10359](https://github.com/projectcalico/calico/pull/10359) (@fasaxc)
- Improve Goldmane flow streaming efficiency [calico 10350](https://github.com/projectcalico/calico/pull/10350) (@caseydavenport)
- Introduces a WatchManager for policies that will close the policy watch when a new tier is added to ensure the consumer is always subscribed to the latest events [calico 10346](https://github.com/projectcalico/calico/pull/10346) (@MichalFupso)
- Improve IPAM garbage collection performance by reducing the number of API calls required to release batches of IP addresses. [calico 10333](https://github.com/projectcalico/calico/pull/10333) (@caseydavenport)
- Scale: Typha clients (such as Felix) now try to reconnect and resync with Typha on connection failure.  This reduces the impact of Typha restart and load rebalancing. [calico 10306](https://github.com/projectcalico/calico/pull/10306) (@fasaxc)
- Enhance Felix to program routes for IPIP encapsulation instead of BIRD. [calico 10291](https://github.com/projectcalico/calico/pull/10291) (@mazdakn)
- The  felix_int_dataplane_apply_time_seconds metric no longer includes the (typically much slower) initial resync. This prevents it from being skewed for a long time on a quiet system.  The new felix_int_dataplane_initial_resync_time_seconds tracks the initial resync time. [calico 10288](https://github.com/projectcalico/calico/pull/10288) (@fasaxc)
- Scale: Felix now deduplicates resource label keys and values, significantly reducing memory usage at high scale. [calico 10272](https://github.com/projectcalico/calico/pull/10272) (@fasaxc)
- Update calico/base image to utilize the minimum glibc runtime from UBI 9. [calico 10207](https://github.com/projectcalico/calico/pull/10207) (@hjiawei)
- Export cluster IPs for all IP families [calico 10183](https://github.com/projectcalico/calico/pull/10183) (@nick-oconnor)
- All Docker images now use standard OCI labels [calico 10181](https://github.com/projectcalico/calico/pull/10181) (@sebhoss)
- Update Operator Helm values to support custom DNS settings [calico 10117](https://github.com/projectcalico/calico/pull/10117) (@jsturtevant)
- Performance: Felix now stores its selector index more efficiently resulting in reduced memory usage in large clusters. [calico 10027](https://github.com/projectcalico/calico/pull/10027) (@fasaxc)
- Updated Calico to use quay.io as the default image registry, replacing docker.io. [calico 10025](https://github.com/projectcalico/calico/pull/10025) (@skoryk-oleksandr)
- Performance: After failures to program IP sets, the dataplane now does a partial resync of only the affected IP sets. This should reduce the overhead of dealing with a transient failure. [calico 9674](https://github.com/projectcalico/calico/pull/9674) (@fasaxc)
- New Felix config param natOutgoingExclusions allows for configuring which type of destinations is excluded from being masqueraded. [calico 8961](https://github.com/projectcalico/calico/pull/8961) (@wayne-cheng)

##### OpenStack

- OpenStack: support IPv6 subnets using SLAAC [calico 11027](https://github.com/projectcalico/calico/pull/11027) (@nelljerram)
- OpenStack QoS handling has been improved to respond immediately to all kinds of QoS changes on the Neutron API.  In particular when rules are added, updated or deleted for a QoS policy that is already in use, and when a QoS policy is added, updated or deleted for a Neutron network that is already in use.  Calico's handling of these changes previously relied on a periodic resync, which could in practice take a long time; now those changes are handled immediately (within a few seconds). [calico 10931](https://github.com/projectcalico/calico/pull/10931) (@nelljerram)
- Calico for OpenStack's QoS support has been enhanced to cover packet rate burst size configuration.  There are new driver settings (cluster-wide, set in `neutron.conf`) for configuring max and min packet burst sizes in each direction. [calico 10521](https://github.com/projectcalico/calico/pull/10521) (@nelljerram)
- Calico for OpenStack's QoS support has been enhanced to cover peak rate configuration.  The "max_burst_kbps" field of bandwidth limit rules is honoured as the peak rate, and there are new driver settings (cluster-wide, set in `neutron.conf`) for configuring max and min burst sizes in each direction. [calico 10500](https://github.com/projectcalico/calico/pull/10500) (@nelljerram)
- Add Ubuntu 24.04 packages for OpenStack [calico 8685](https://github.com/projectcalico/calico/pull/8685) (@danudey)

##### eBPF

- ebpf: enable kube-proxy healthz server [calico 11055](https://github.com/projectcalico/calico/pull/11055) (@tomastigera)
- ebpf: BPFKubeProxyHealthzPort allows to change the kube-proxy healthz server port [calico 11152](https://github.com/projectcalico/calico/pull/11152) (@tomastigera) & [calico 11205](https://github.com/projectcalico/calico/pull/11205) (@caseydavenport)
- ebpf: calico-node -bpf policy dump prints the End of (Rule | Policy | Tier) in the default concise output [calico 11075](https://github.com/projectcalico/calico/pull/11075) (@tomastigera)
- Added a new manifest file, custom-resources-bpf.yaml, to streamline Calico installation with the eBPF dataplane. [calico 11003](https://github.com/projectcalico/calico/pull/11003) (@lucastigera)
- ebpf: Added a new Felix configuration option `CgroupV2Path` to set a custom cgroupV2 mount path, improving compatibility with immutable OSes like Talos Linux. [calico 10877](https://github.com/projectcalico/calico/pull/10877) (@lucastigera)
- ebpf: faster interaction with BPF maps from userspace due to batching update and delete operations. Should specifically help on larger and more churny clusters. [calico 10802](https://github.com/projectcalico/calico/pull/10802) (@tomastigera)
- Add support for packet rate QoS controls on the eBPF dataplane. [calico 10740](https://github.com/projectcalico/calico/pull/10740) (@coutinhop)
- ebpf: conntrack cleanup now uses a hybrid approach with a scan being done from user space (to avoid disturbing LRU state) and then deletions being done from BPF program. [calico 10736](https://github.com/projectcalico/calico/pull/10736) (@sridhartigera)
- The init container `mount-bpffs` is now named `ebpf-bootstrap` to reflect its broader responsibilities. No impact on functionality. [calico 10731](https://github.com/projectcalico/calico/pull/10731) (@lucastigera)
- ebpf: on ingress to node use pre-dnat IP for icmp response. Either it is an external IP or routable from the previous hop. The node can pose as having the VIP. [calico 10671](https://github.com/projectcalico/calico/pull/10671) (@tomastigera)
- Add support for bandwidth QoS controls on the eBPF databplane, when the BPF attach mode used is 'tcx'. [calico 10645](https://github.com/projectcalico/calico/pull/10645) (@coutinhop)
- ebpf: support for the new Felix config param natOutgoingExclusions, which allows for configuring which type of destinations are excluded from being masqueraded (SNAT). [calico 10614](https://github.com/projectcalico/calico/pull/10614) (@coutinhop)
- When installing Calico in BPF mode in a cluster using kube-proxy, the Operator now handles all required configuration automatically - no additional manual steps are required. [calico 10607](https://github.com/projectcalico/calico/pull/10607) (@lucastigera)
- ebpf: Add support for tcx which is available from 6.6 kernel. Introduced a new config option to set the attach type to tcx or tc. [calico 10573](https://github.com/projectcalico/calico/pull/10573) (@sridhartigera)
- ebpf: Changed the conntrack map type to LRU Hash to facilitate conntrack cleaning even when felix is not running [calico 10557](https://github.com/projectcalico/calico/pull/10557) (@sridhartigera)
- ebpf: Fixed attaching bpf programs by atomically replacing the old program rather than attaching new and detaching old. [calico 10445](https://github.com/projectcalico/calico/pull/10445) (@sridhartigera)
- ebpf: Fix forwarding of packets to kubevirt pods when in bridge mode. [calico 10308](https://github.com/projectcalico/calico/pull/10308) (@sridhartigera)
- Add new manifests to install Calico with the eBPF dataplane in an OpenShift cluster. [calico 10015](https://github.com/projectcalico/calico/pull/10015) (@lucastigera)
