// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Adjustment, Align, Buildable, Container, ListBoxRow, MovementStep, ResizeMode, SelectionMode,
    Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkListBox")]
    pub struct ListBox(Object<ffi::GtkListBox, ffi::GtkListBoxClass>) @extends Container, Widget, @implements Buildable;

    match fn {
        type_ => || ffi::gtk_list_box_get_type(),
    }
}

impl ListBox {
    pub const NONE: Option<&'static ListBox> = None;

    #[doc(alias = "gtk_list_box_new")]
    pub fn new() -> ListBox {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_list_box_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`ListBox`] objects.
    ///
    /// This method returns an instance of [`ListBoxBuilder`](crate::builders::ListBoxBuilder) which can be used to create [`ListBox`] objects.
    pub fn builder() -> ListBoxBuilder {
        ListBoxBuilder::new()
    }
}

impl Default for ListBox {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`ListBox`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ListBoxBuilder {
    builder: glib::object::ObjectBuilder<'static, ListBox>,
}

impl ListBoxBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn activate_on_single_click(self, activate_on_single_click: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("activate-on-single-click", activate_on_single_click),
        }
    }

    pub fn selection_mode(self, selection_mode: SelectionMode) -> Self {
        Self {
            builder: self.builder.property("selection-mode", selection_mode),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`ListBox`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> ListBox {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::ListBox>> Sealed for T {}
}

pub trait ListBoxExt: IsA<ListBox> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_list_box_bind_model")]
    fn bind_model<P: Fn(&glib::Object) -> Widget + 'static>(
        &self,
        model: Option<&impl IsA<gio::ListModel>>,
        create_widget_func: P,
    ) {
        let create_widget_func_data: Box_<P> = Box_::new(create_widget_func);
        unsafe extern "C" fn create_widget_func_func<P: Fn(&glib::Object) -> Widget + 'static>(
            item: *mut glib::gobject_ffi::GObject,
            user_data: glib::ffi::gpointer,
        ) -> *mut ffi::GtkWidget {
            let item = from_glib_borrow(item);
            let callback: &P = &*(user_data as *mut _);
            (*callback)(&item).to_glib_full()
        }
        let create_widget_func = Some(create_widget_func_func::<P> as _);
        unsafe extern "C" fn user_data_free_func_func<P: Fn(&glib::Object) -> Widget + 'static>(
            data: glib::ffi::gpointer,
        ) {
            let _callback: Box_<P> = Box_::from_raw(data as *mut _);
        }
        let destroy_call4 = Some(user_data_free_func_func::<P> as _);
        let super_callback0: Box_<P> = create_widget_func_data;
        unsafe {
            ffi::gtk_list_box_bind_model(
                self.as_ref().to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
                create_widget_func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call4,
            );
        }
    }

    #[doc(alias = "gtk_list_box_drag_highlight_row")]
    fn drag_highlight_row(&self, row: &impl IsA<ListBoxRow>) {
        unsafe {
            ffi::gtk_list_box_drag_highlight_row(
                self.as_ref().to_glib_none().0,
                row.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_list_box_drag_unhighlight_row")]
    fn drag_unhighlight_row(&self) {
        unsafe {
            ffi::gtk_list_box_drag_unhighlight_row(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_get_activate_on_single_click")]
    #[doc(alias = "get_activate_on_single_click")]
    fn activates_on_single_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_list_box_get_activate_on_single_click(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_list_box_get_adjustment")]
    #[doc(alias = "get_adjustment")]
    fn adjustment(&self) -> Option<Adjustment> {
        unsafe {
            from_glib_none(ffi::gtk_list_box_get_adjustment(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_list_box_get_row_at_index")]
    #[doc(alias = "get_row_at_index")]
    fn row_at_index(&self, index_: i32) -> Option<ListBoxRow> {
        unsafe {
            from_glib_none(ffi::gtk_list_box_get_row_at_index(
                self.as_ref().to_glib_none().0,
                index_,
            ))
        }
    }

    #[doc(alias = "gtk_list_box_get_row_at_y")]
    #[doc(alias = "get_row_at_y")]
    fn row_at_y(&self, y: i32) -> Option<ListBoxRow> {
        unsafe {
            from_glib_none(ffi::gtk_list_box_get_row_at_y(
                self.as_ref().to_glib_none().0,
                y,
            ))
        }
    }

    #[doc(alias = "gtk_list_box_get_selected_row")]
    #[doc(alias = "get_selected_row")]
    fn selected_row(&self) -> Option<ListBoxRow> {
        unsafe {
            from_glib_none(ffi::gtk_list_box_get_selected_row(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_list_box_get_selected_rows")]
    #[doc(alias = "get_selected_rows")]
    fn selected_rows(&self) -> Vec<ListBoxRow> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_list_box_get_selected_rows(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_list_box_get_selection_mode")]
    #[doc(alias = "get_selection_mode")]
    fn selection_mode(&self) -> SelectionMode {
        unsafe {
            from_glib(ffi::gtk_list_box_get_selection_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_list_box_insert")]
    fn insert(&self, child: &impl IsA<Widget>, position: i32) {
        unsafe {
            ffi::gtk_list_box_insert(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                position,
            );
        }
    }

    #[doc(alias = "gtk_list_box_invalidate_filter")]
    fn invalidate_filter(&self) {
        unsafe {
            ffi::gtk_list_box_invalidate_filter(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_invalidate_headers")]
    fn invalidate_headers(&self) {
        unsafe {
            ffi::gtk_list_box_invalidate_headers(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_invalidate_sort")]
    fn invalidate_sort(&self) {
        unsafe {
            ffi::gtk_list_box_invalidate_sort(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_prepend")]
    fn prepend(&self, child: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_list_box_prepend(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_list_box_select_all")]
    fn select_all(&self) {
        unsafe {
            ffi::gtk_list_box_select_all(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_select_row")]
    fn select_row(&self, row: Option<&impl IsA<ListBoxRow>>) {
        unsafe {
            ffi::gtk_list_box_select_row(
                self.as_ref().to_glib_none().0,
                row.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_list_box_selected_foreach")]
    fn selected_foreach<P: FnMut(&ListBox, &ListBoxRow)>(&self, func: P) {
        let func_data: P = func;
        unsafe extern "C" fn func_func<P: FnMut(&ListBox, &ListBoxRow)>(
            box_: *mut ffi::GtkListBox,
            row: *mut ffi::GtkListBoxRow,
            user_data: glib::ffi::gpointer,
        ) {
            let box_ = from_glib_borrow(box_);
            let row = from_glib_borrow(row);
            let callback: *mut P = user_data as *const _ as usize as *mut P;
            (*callback)(&box_, &row)
        }
        let func = Some(func_func::<P> as _);
        let super_callback0: &P = &func_data;
        unsafe {
            ffi::gtk_list_box_selected_foreach(
                self.as_ref().to_glib_none().0,
                func,
                super_callback0 as *const _ as usize as *mut _,
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_activate_on_single_click")]
    fn set_activate_on_single_click(&self, single: bool) {
        unsafe {
            ffi::gtk_list_box_set_activate_on_single_click(
                self.as_ref().to_glib_none().0,
                single.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_adjustment")]
    fn set_adjustment(&self, adjustment: Option<&impl IsA<Adjustment>>) {
        unsafe {
            ffi::gtk_list_box_set_adjustment(
                self.as_ref().to_glib_none().0,
                adjustment.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_filter_func")]
    fn set_filter_func(&self, filter_func: Option<Box_<dyn Fn(&ListBoxRow) -> bool + 'static>>) {
        let filter_func_data: Box_<Option<Box_<dyn Fn(&ListBoxRow) -> bool + 'static>>> =
            Box_::new(filter_func);
        unsafe extern "C" fn filter_func_func(
            row: *mut ffi::GtkListBoxRow,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let row = from_glib_borrow(row);
            let callback: &Option<Box_<dyn Fn(&ListBoxRow) -> bool + 'static>> =
                &*(user_data as *mut _);
            if let Some(ref callback) = *callback {
                callback(&row)
            } else {
                panic!("cannot get closure...")
            }
            .into_glib()
        }
        let filter_func = if filter_func_data.is_some() {
            Some(filter_func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<Option<Box_<dyn Fn(&ListBoxRow) -> bool + 'static>>> =
                Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(destroy_func as _);
        let super_callback0: Box_<Option<Box_<dyn Fn(&ListBoxRow) -> bool + 'static>>> =
            filter_func_data;
        unsafe {
            ffi::gtk_list_box_set_filter_func(
                self.as_ref().to_glib_none().0,
                filter_func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_header_func")]
    fn set_header_func(
        &self,
        update_header: Option<Box_<dyn Fn(&ListBoxRow, Option<&ListBoxRow>) + 'static>>,
    ) {
        let update_header_data: Box_<
            Option<Box_<dyn Fn(&ListBoxRow, Option<&ListBoxRow>) + 'static>>,
        > = Box_::new(update_header);
        unsafe extern "C" fn update_header_func(
            row: *mut ffi::GtkListBoxRow,
            before: *mut ffi::GtkListBoxRow,
            user_data: glib::ffi::gpointer,
        ) {
            let row = from_glib_borrow(row);
            let before: Borrowed<Option<ListBoxRow>> = from_glib_borrow(before);
            let callback: &Option<Box_<dyn Fn(&ListBoxRow, Option<&ListBoxRow>) + 'static>> =
                &*(user_data as *mut _);
            if let Some(ref callback) = *callback {
                callback(&row, before.as_ref().as_ref())
            } else {
                panic!("cannot get closure...")
            }
        }
        let update_header = if update_header_data.is_some() {
            Some(update_header_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<Option<Box_<dyn Fn(&ListBoxRow, Option<&ListBoxRow>) + 'static>>> =
                Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(destroy_func as _);
        let super_callback0: Box_<
            Option<Box_<dyn Fn(&ListBoxRow, Option<&ListBoxRow>) + 'static>>,
        > = update_header_data;
        unsafe {
            ffi::gtk_list_box_set_header_func(
                self.as_ref().to_glib_none().0,
                update_header,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_placeholder")]
    fn set_placeholder(&self, placeholder: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_list_box_set_placeholder(
                self.as_ref().to_glib_none().0,
                placeholder.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_selection_mode")]
    fn set_selection_mode(&self, mode: SelectionMode) {
        unsafe {
            ffi::gtk_list_box_set_selection_mode(self.as_ref().to_glib_none().0, mode.into_glib());
        }
    }

    #[doc(alias = "gtk_list_box_set_sort_func")]
    fn set_sort_func(
        &self,
        sort_func: Option<Box_<dyn Fn(&ListBoxRow, &ListBoxRow) -> i32 + 'static>>,
    ) {
        let sort_func_data: Box_<Option<Box_<dyn Fn(&ListBoxRow, &ListBoxRow) -> i32 + 'static>>> =
            Box_::new(sort_func);
        unsafe extern "C" fn sort_func_func(
            row1: *mut ffi::GtkListBoxRow,
            row2: *mut ffi::GtkListBoxRow,
            user_data: glib::ffi::gpointer,
        ) -> libc::c_int {
            let row1 = from_glib_borrow(row1);
            let row2 = from_glib_borrow(row2);
            let callback: &Option<Box_<dyn Fn(&ListBoxRow, &ListBoxRow) -> i32 + 'static>> =
                &*(user_data as *mut _);
            if let Some(ref callback) = *callback {
                callback(&row1, &row2)
            } else {
                panic!("cannot get closure...")
            }
        }
        let sort_func = if sort_func_data.is_some() {
            Some(sort_func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<Option<Box_<dyn Fn(&ListBoxRow, &ListBoxRow) -> i32 + 'static>>> =
                Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(destroy_func as _);
        let super_callback0: Box_<Option<Box_<dyn Fn(&ListBoxRow, &ListBoxRow) -> i32 + 'static>>> =
            sort_func_data;
        unsafe {
            ffi::gtk_list_box_set_sort_func(
                self.as_ref().to_glib_none().0,
                sort_func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gtk_list_box_unselect_all")]
    fn unselect_all(&self) {
        unsafe {
            ffi::gtk_list_box_unselect_all(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_unselect_row")]
    fn unselect_row(&self, row: &impl IsA<ListBoxRow>) {
        unsafe {
            ffi::gtk_list_box_unselect_row(
                self.as_ref().to_glib_none().0,
                row.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "activate-cursor-row")]
    fn connect_activate_cursor_row<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_cursor_row_trampoline<
            P: IsA<ListBox>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkListBox,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ListBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-cursor-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_cursor_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate_cursor_row(&self) {
        self.emit_by_name::<()>("activate-cursor-row", &[]);
    }

    #[doc(alias = "move-cursor")]
    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            P: IsA<ListBox>,
            F: Fn(&P, MovementStep, i32) + 'static,
        >(
            this: *mut ffi::GtkListBox,
            object: ffi::GtkMovementStep,
            p0: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                ListBox::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
                p0,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_cursor(&self, object: MovementStep, p0: i32) {
        self.emit_by_name::<()>("move-cursor", &[&object, &p0]);
    }

    #[doc(alias = "row-activated")]
    fn connect_row_activated<F: Fn(&Self, &ListBoxRow) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn row_activated_trampoline<
            P: IsA<ListBox>,
            F: Fn(&P, &ListBoxRow) + 'static,
        >(
            this: *mut ffi::GtkListBox,
            row: *mut ffi::GtkListBoxRow,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                ListBox::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(row),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-activated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    row_activated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "row-selected")]
    fn connect_row_selected<F: Fn(&Self, Option<&ListBoxRow>) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_selected_trampoline<
            P: IsA<ListBox>,
            F: Fn(&P, Option<&ListBoxRow>) + 'static,
        >(
            this: *mut ffi::GtkListBox,
            row: *mut ffi::GtkListBoxRow,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                ListBox::from_glib_borrow(this).unsafe_cast_ref(),
                Option::<ListBoxRow>::from_glib_borrow(row)
                    .as_ref()
                    .as_ref(),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-selected\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    row_selected_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "select-all")]
    fn connect_select_all<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_all_trampoline<P: IsA<ListBox>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkListBox,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ListBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_all(&self) {
        self.emit_by_name::<()>("select-all", &[]);
    }

    #[doc(alias = "selected-rows-changed")]
    fn connect_selected_rows_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn selected_rows_changed_trampoline<
            P: IsA<ListBox>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkListBox,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ListBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"selected-rows-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    selected_rows_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "toggle-cursor-row")]
    fn connect_toggle_cursor_row<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_cursor_row_trampoline<P: IsA<ListBox>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkListBox,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ListBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-cursor-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    toggle_cursor_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_cursor_row(&self) {
        self.emit_by_name::<()>("toggle-cursor-row", &[]);
    }

    #[doc(alias = "unselect-all")]
    fn connect_unselect_all<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unselect_all_trampoline<P: IsA<ListBox>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkListBox,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ListBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"unselect-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    unselect_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_unselect_all(&self) {
        self.emit_by_name::<()>("unselect-all", &[]);
    }

    #[doc(alias = "activate-on-single-click")]
    fn connect_activate_on_single_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_activate_on_single_click_trampoline<
            P: IsA<ListBox>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkListBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ListBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::activate-on-single-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_activate_on_single_click_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "selection-mode")]
    fn connect_selection_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selection_mode_trampoline<
            P: IsA<ListBox>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkListBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ListBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::selection-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_selection_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<ListBox>> ListBoxExt for O {}

impl fmt::Display for ListBox {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("ListBox")
    }
}
