"use strict";

var helpers = require("../../helpers/helpers");

exports["Asia/Beirut"] = {

	"guess:by:offset" : helpers.makeTestGuess("Asia/Beirut", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Asia/Beirut", { abbr: true }),

	"1879" : helpers.makeTestYear("Asia/Beirut", [
		["1879-12-31T21:38:00+00:00", "23:38:00", "EET", -120]
	]),

	"1920" : helpers.makeTestYear("Asia/Beirut", [
		["1920-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["1920-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1920-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1920-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1921" : helpers.makeTestYear("Asia/Beirut", [
		["1921-04-02T21:59:59+00:00", "23:59:59", "EET", -120],
		["1921-04-02T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1921-10-02T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1921-10-02T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1922" : helpers.makeTestYear("Asia/Beirut", [
		["1922-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["1922-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1922-10-07T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1922-10-07T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1923" : helpers.makeTestYear("Asia/Beirut", [
		["1923-04-21T21:59:59+00:00", "23:59:59", "EET", -120],
		["1923-04-21T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1923-09-15T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1923-09-15T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1957" : helpers.makeTestYear("Asia/Beirut", [
		["1957-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1957-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1957-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1957-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1958" : helpers.makeTestYear("Asia/Beirut", [
		["1958-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1958-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1958-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1958-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1959" : helpers.makeTestYear("Asia/Beirut", [
		["1959-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1959-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1959-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1959-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1960" : helpers.makeTestYear("Asia/Beirut", [
		["1960-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1960-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1960-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1960-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1961" : helpers.makeTestYear("Asia/Beirut", [
		["1961-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1961-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1961-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1961-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1972" : helpers.makeTestYear("Asia/Beirut", [
		["1972-06-21T21:59:59+00:00", "23:59:59", "EET", -120],
		["1972-06-21T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1972-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1972-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1973" : helpers.makeTestYear("Asia/Beirut", [
		["1973-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1973-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1973-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1973-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1974" : helpers.makeTestYear("Asia/Beirut", [
		["1974-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1974-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1974-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1974-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1975" : helpers.makeTestYear("Asia/Beirut", [
		["1975-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1975-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1975-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1975-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1976" : helpers.makeTestYear("Asia/Beirut", [
		["1976-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1976-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1976-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1976-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1977" : helpers.makeTestYear("Asia/Beirut", [
		["1977-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1977-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1977-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1977-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1978" : helpers.makeTestYear("Asia/Beirut", [
		["1978-04-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["1978-04-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1978-09-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1978-09-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1984" : helpers.makeTestYear("Asia/Beirut", [
		["1984-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1984-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1984-10-15T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1984-10-15T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1985" : helpers.makeTestYear("Asia/Beirut", [
		["1985-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1985-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1985-10-15T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1985-10-15T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1986" : helpers.makeTestYear("Asia/Beirut", [
		["1986-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1986-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1986-10-15T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1986-10-15T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1987" : helpers.makeTestYear("Asia/Beirut", [
		["1987-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1987-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1987-10-15T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1987-10-15T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1988" : helpers.makeTestYear("Asia/Beirut", [
		["1988-05-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["1988-05-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1988-10-15T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1988-10-15T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1989" : helpers.makeTestYear("Asia/Beirut", [
		["1989-05-09T21:59:59+00:00", "23:59:59", "EET", -120],
		["1989-05-09T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1989-10-15T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1989-10-15T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1990" : helpers.makeTestYear("Asia/Beirut", [
		["1990-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1990-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1990-10-15T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1990-10-15T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1991" : helpers.makeTestYear("Asia/Beirut", [
		["1991-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1991-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1991-10-15T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1991-10-15T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1992" : helpers.makeTestYear("Asia/Beirut", [
		["1992-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1992-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1992-10-03T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1992-10-03T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1993" : helpers.makeTestYear("Asia/Beirut", [
		["1993-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["1993-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1993-09-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1993-09-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1994" : helpers.makeTestYear("Asia/Beirut", [
		["1994-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["1994-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1994-09-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1994-09-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1995" : helpers.makeTestYear("Asia/Beirut", [
		["1995-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["1995-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1995-09-23T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1995-09-23T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1996" : helpers.makeTestYear("Asia/Beirut", [
		["1996-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1996-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1996-09-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1996-09-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1997" : helpers.makeTestYear("Asia/Beirut", [
		["1997-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["1997-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1997-09-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1997-09-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1998" : helpers.makeTestYear("Asia/Beirut", [
		["1998-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["1998-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1998-09-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1998-09-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1999" : helpers.makeTestYear("Asia/Beirut", [
		["1999-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["1999-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1999-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1999-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2000" : helpers.makeTestYear("Asia/Beirut", [
		["2000-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2000-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2000-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2000-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2001" : helpers.makeTestYear("Asia/Beirut", [
		["2001-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2001-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2001-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2001-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2002" : helpers.makeTestYear("Asia/Beirut", [
		["2002-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2002-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2002-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2002-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2003" : helpers.makeTestYear("Asia/Beirut", [
		["2003-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2003-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2003-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2003-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2004" : helpers.makeTestYear("Asia/Beirut", [
		["2004-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2004-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2004-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2004-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2005" : helpers.makeTestYear("Asia/Beirut", [
		["2005-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2005-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2005-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2005-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2006" : helpers.makeTestYear("Asia/Beirut", [
		["2006-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2006-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2006-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2006-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2007" : helpers.makeTestYear("Asia/Beirut", [
		["2007-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2007-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2007-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2007-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2008" : helpers.makeTestYear("Asia/Beirut", [
		["2008-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2008-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2008-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2008-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2009" : helpers.makeTestYear("Asia/Beirut", [
		["2009-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2009-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2009-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2009-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2010" : helpers.makeTestYear("Asia/Beirut", [
		["2010-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2010-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2010-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2010-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2011" : helpers.makeTestYear("Asia/Beirut", [
		["2011-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2011-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2011-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2011-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2012" : helpers.makeTestYear("Asia/Beirut", [
		["2012-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2012-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2012-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2012-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2013" : helpers.makeTestYear("Asia/Beirut", [
		["2013-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2013-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2013-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2013-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2014" : helpers.makeTestYear("Asia/Beirut", [
		["2014-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2014-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2014-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2014-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2015" : helpers.makeTestYear("Asia/Beirut", [
		["2015-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2015-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2015-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2015-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2016" : helpers.makeTestYear("Asia/Beirut", [
		["2016-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2016-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2016-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2016-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2017" : helpers.makeTestYear("Asia/Beirut", [
		["2017-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2017-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2017-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2017-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2018" : helpers.makeTestYear("Asia/Beirut", [
		["2018-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2018-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2018-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2018-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2019" : helpers.makeTestYear("Asia/Beirut", [
		["2019-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2019-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2019-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2019-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2020" : helpers.makeTestYear("Asia/Beirut", [
		["2020-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2020-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2020-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2020-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2021" : helpers.makeTestYear("Asia/Beirut", [
		["2021-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2021-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2021-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2021-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2022" : helpers.makeTestYear("Asia/Beirut", [
		["2022-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2022-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2022-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2022-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2023" : helpers.makeTestYear("Asia/Beirut", [
		["2023-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2023-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2023-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2023-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2024" : helpers.makeTestYear("Asia/Beirut", [
		["2024-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2024-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2024-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2024-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2025" : helpers.makeTestYear("Asia/Beirut", [
		["2025-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2025-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2025-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2025-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2026" : helpers.makeTestYear("Asia/Beirut", [
		["2026-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2026-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2026-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2026-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2027" : helpers.makeTestYear("Asia/Beirut", [
		["2027-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2027-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2027-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2027-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2028" : helpers.makeTestYear("Asia/Beirut", [
		["2028-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2028-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2028-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2028-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2029" : helpers.makeTestYear("Asia/Beirut", [
		["2029-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2029-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2029-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2029-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2030" : helpers.makeTestYear("Asia/Beirut", [
		["2030-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2030-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2030-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2030-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2031" : helpers.makeTestYear("Asia/Beirut", [
		["2031-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2031-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2031-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2031-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2032" : helpers.makeTestYear("Asia/Beirut", [
		["2032-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2032-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2032-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2032-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2033" : helpers.makeTestYear("Asia/Beirut", [
		["2033-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2033-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2033-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2033-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2034" : helpers.makeTestYear("Asia/Beirut", [
		["2034-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2034-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2034-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2034-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2035" : helpers.makeTestYear("Asia/Beirut", [
		["2035-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2035-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2035-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2035-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2036" : helpers.makeTestYear("Asia/Beirut", [
		["2036-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2036-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2036-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2036-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2037" : helpers.makeTestYear("Asia/Beirut", [
		["2037-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2037-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2037-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2037-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2038" : helpers.makeTestYear("Asia/Beirut", [
		["2038-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2038-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2038-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2038-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2039" : helpers.makeTestYear("Asia/Beirut", [
		["2039-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2039-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2039-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2039-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2040" : helpers.makeTestYear("Asia/Beirut", [
		["2040-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2040-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2040-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2040-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2041" : helpers.makeTestYear("Asia/Beirut", [
		["2041-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2041-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2041-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2041-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2042" : helpers.makeTestYear("Asia/Beirut", [
		["2042-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2042-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2042-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2042-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2043" : helpers.makeTestYear("Asia/Beirut", [
		["2043-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2043-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2043-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2043-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2044" : helpers.makeTestYear("Asia/Beirut", [
		["2044-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2044-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2044-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2044-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2045" : helpers.makeTestYear("Asia/Beirut", [
		["2045-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2045-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2045-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2045-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2046" : helpers.makeTestYear("Asia/Beirut", [
		["2046-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2046-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2046-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2046-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2047" : helpers.makeTestYear("Asia/Beirut", [
		["2047-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2047-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2047-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2047-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2048" : helpers.makeTestYear("Asia/Beirut", [
		["2048-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2048-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2048-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2048-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2049" : helpers.makeTestYear("Asia/Beirut", [
		["2049-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2049-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2049-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2049-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2050" : helpers.makeTestYear("Asia/Beirut", [
		["2050-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2050-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2050-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2050-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2051" : helpers.makeTestYear("Asia/Beirut", [
		["2051-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2051-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2051-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2051-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2052" : helpers.makeTestYear("Asia/Beirut", [
		["2052-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2052-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2052-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2052-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2053" : helpers.makeTestYear("Asia/Beirut", [
		["2053-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2053-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2053-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2053-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2054" : helpers.makeTestYear("Asia/Beirut", [
		["2054-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2054-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2054-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2054-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2055" : helpers.makeTestYear("Asia/Beirut", [
		["2055-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2055-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2055-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2055-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2056" : helpers.makeTestYear("Asia/Beirut", [
		["2056-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2056-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2056-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2056-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2057" : helpers.makeTestYear("Asia/Beirut", [
		["2057-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2057-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2057-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2057-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2058" : helpers.makeTestYear("Asia/Beirut", [
		["2058-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2058-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2058-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2058-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2059" : helpers.makeTestYear("Asia/Beirut", [
		["2059-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2059-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2059-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2059-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2060" : helpers.makeTestYear("Asia/Beirut", [
		["2060-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2060-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2060-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2060-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2061" : helpers.makeTestYear("Asia/Beirut", [
		["2061-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2061-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2061-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2061-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2062" : helpers.makeTestYear("Asia/Beirut", [
		["2062-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2062-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2062-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2062-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2063" : helpers.makeTestYear("Asia/Beirut", [
		["2063-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2063-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2063-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2063-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2064" : helpers.makeTestYear("Asia/Beirut", [
		["2064-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2064-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2064-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2064-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2065" : helpers.makeTestYear("Asia/Beirut", [
		["2065-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2065-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2065-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2065-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2066" : helpers.makeTestYear("Asia/Beirut", [
		["2066-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2066-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2066-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2066-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2067" : helpers.makeTestYear("Asia/Beirut", [
		["2067-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2067-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2067-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2067-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2068" : helpers.makeTestYear("Asia/Beirut", [
		["2068-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2068-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2068-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2068-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2069" : helpers.makeTestYear("Asia/Beirut", [
		["2069-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2069-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2069-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2069-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2070" : helpers.makeTestYear("Asia/Beirut", [
		["2070-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2070-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2070-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2070-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2071" : helpers.makeTestYear("Asia/Beirut", [
		["2071-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2071-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2071-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2071-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2072" : helpers.makeTestYear("Asia/Beirut", [
		["2072-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2072-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2072-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2072-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2073" : helpers.makeTestYear("Asia/Beirut", [
		["2073-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2073-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2073-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2073-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2074" : helpers.makeTestYear("Asia/Beirut", [
		["2074-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2074-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2074-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2074-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2075" : helpers.makeTestYear("Asia/Beirut", [
		["2075-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2075-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2075-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2075-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2076" : helpers.makeTestYear("Asia/Beirut", [
		["2076-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2076-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2076-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2076-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2077" : helpers.makeTestYear("Asia/Beirut", [
		["2077-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2077-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2077-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2077-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2078" : helpers.makeTestYear("Asia/Beirut", [
		["2078-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2078-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2078-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2078-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2079" : helpers.makeTestYear("Asia/Beirut", [
		["2079-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2079-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2079-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2079-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2080" : helpers.makeTestYear("Asia/Beirut", [
		["2080-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2080-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2080-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2080-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2081" : helpers.makeTestYear("Asia/Beirut", [
		["2081-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2081-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2081-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2081-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2082" : helpers.makeTestYear("Asia/Beirut", [
		["2082-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2082-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2082-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2082-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2083" : helpers.makeTestYear("Asia/Beirut", [
		["2083-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2083-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2083-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2083-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2084" : helpers.makeTestYear("Asia/Beirut", [
		["2084-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2084-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2084-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2084-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2085" : helpers.makeTestYear("Asia/Beirut", [
		["2085-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2085-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2085-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2085-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2086" : helpers.makeTestYear("Asia/Beirut", [
		["2086-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2086-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2086-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2086-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2087" : helpers.makeTestYear("Asia/Beirut", [
		["2087-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2087-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2087-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2087-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2088" : helpers.makeTestYear("Asia/Beirut", [
		["2088-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2088-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2088-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2088-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2089" : helpers.makeTestYear("Asia/Beirut", [
		["2089-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2089-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2089-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2089-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2090" : helpers.makeTestYear("Asia/Beirut", [
		["2090-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2090-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2090-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2090-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2091" : helpers.makeTestYear("Asia/Beirut", [
		["2091-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2091-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2091-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2091-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2092" : helpers.makeTestYear("Asia/Beirut", [
		["2092-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2092-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2092-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2092-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2093" : helpers.makeTestYear("Asia/Beirut", [
		["2093-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2093-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2093-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2093-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2094" : helpers.makeTestYear("Asia/Beirut", [
		["2094-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2094-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2094-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2094-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2095" : helpers.makeTestYear("Asia/Beirut", [
		["2095-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2095-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2095-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2095-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2096" : helpers.makeTestYear("Asia/Beirut", [
		["2096-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2096-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2096-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2096-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2097" : helpers.makeTestYear("Asia/Beirut", [
		["2097-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2097-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2097-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2097-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2098" : helpers.makeTestYear("Asia/Beirut", [
		["2098-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2098-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2098-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2098-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2099" : helpers.makeTestYear("Asia/Beirut", [
		["2099-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2099-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2099-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2099-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2100" : helpers.makeTestYear("Asia/Beirut", [
		["2100-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2100-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2100-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2100-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2101" : helpers.makeTestYear("Asia/Beirut", [
		["2101-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2101-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2101-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2101-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2102" : helpers.makeTestYear("Asia/Beirut", [
		["2102-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2102-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2102-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2102-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2103" : helpers.makeTestYear("Asia/Beirut", [
		["2103-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2103-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2103-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2103-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2104" : helpers.makeTestYear("Asia/Beirut", [
		["2104-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2104-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2104-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2104-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2105" : helpers.makeTestYear("Asia/Beirut", [
		["2105-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2105-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2105-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2105-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2106" : helpers.makeTestYear("Asia/Beirut", [
		["2106-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2106-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2106-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2106-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2107" : helpers.makeTestYear("Asia/Beirut", [
		["2107-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2107-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2107-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2107-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2108" : helpers.makeTestYear("Asia/Beirut", [
		["2108-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2108-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2108-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2108-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2109" : helpers.makeTestYear("Asia/Beirut", [
		["2109-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2109-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2109-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2109-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2110" : helpers.makeTestYear("Asia/Beirut", [
		["2110-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2110-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2110-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2110-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2111" : helpers.makeTestYear("Asia/Beirut", [
		["2111-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2111-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2111-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2111-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2112" : helpers.makeTestYear("Asia/Beirut", [
		["2112-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2112-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2112-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2112-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2113" : helpers.makeTestYear("Asia/Beirut", [
		["2113-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2113-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2113-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2113-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2114" : helpers.makeTestYear("Asia/Beirut", [
		["2114-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2114-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2114-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2114-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2115" : helpers.makeTestYear("Asia/Beirut", [
		["2115-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2115-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2115-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2115-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2116" : helpers.makeTestYear("Asia/Beirut", [
		["2116-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2116-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2116-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2116-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2117" : helpers.makeTestYear("Asia/Beirut", [
		["2117-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2117-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2117-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2117-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2118" : helpers.makeTestYear("Asia/Beirut", [
		["2118-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2118-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2118-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2118-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2119" : helpers.makeTestYear("Asia/Beirut", [
		["2119-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2119-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2119-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2119-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2120" : helpers.makeTestYear("Asia/Beirut", [
		["2120-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2120-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2120-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2120-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2121" : helpers.makeTestYear("Asia/Beirut", [
		["2121-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2121-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2121-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2121-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2122" : helpers.makeTestYear("Asia/Beirut", [
		["2122-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2122-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2122-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2122-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2123" : helpers.makeTestYear("Asia/Beirut", [
		["2123-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2123-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2123-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2123-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2124" : helpers.makeTestYear("Asia/Beirut", [
		["2124-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2124-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2124-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2124-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2125" : helpers.makeTestYear("Asia/Beirut", [
		["2125-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2125-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2125-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2125-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2126" : helpers.makeTestYear("Asia/Beirut", [
		["2126-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2126-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2126-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2126-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2127" : helpers.makeTestYear("Asia/Beirut", [
		["2127-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2127-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2127-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2127-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2128" : helpers.makeTestYear("Asia/Beirut", [
		["2128-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2128-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2128-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2128-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2129" : helpers.makeTestYear("Asia/Beirut", [
		["2129-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2129-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2129-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2129-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2130" : helpers.makeTestYear("Asia/Beirut", [
		["2130-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2130-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2130-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2130-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2131" : helpers.makeTestYear("Asia/Beirut", [
		["2131-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2131-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2131-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2131-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2132" : helpers.makeTestYear("Asia/Beirut", [
		["2132-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2132-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2132-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2132-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2133" : helpers.makeTestYear("Asia/Beirut", [
		["2133-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2133-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2133-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2133-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2134" : helpers.makeTestYear("Asia/Beirut", [
		["2134-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2134-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2134-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2134-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2135" : helpers.makeTestYear("Asia/Beirut", [
		["2135-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2135-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2135-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2135-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2136" : helpers.makeTestYear("Asia/Beirut", [
		["2136-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2136-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2136-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2136-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2137" : helpers.makeTestYear("Asia/Beirut", [
		["2137-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2137-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2137-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2137-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2138" : helpers.makeTestYear("Asia/Beirut", [
		["2138-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2138-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2138-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2138-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2139" : helpers.makeTestYear("Asia/Beirut", [
		["2139-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2139-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2139-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2139-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2140" : helpers.makeTestYear("Asia/Beirut", [
		["2140-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2140-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2140-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2140-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2141" : helpers.makeTestYear("Asia/Beirut", [
		["2141-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2141-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2141-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2141-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2142" : helpers.makeTestYear("Asia/Beirut", [
		["2142-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2142-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2142-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2142-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2143" : helpers.makeTestYear("Asia/Beirut", [
		["2143-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2143-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2143-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2143-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2144" : helpers.makeTestYear("Asia/Beirut", [
		["2144-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2144-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2144-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2144-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2145" : helpers.makeTestYear("Asia/Beirut", [
		["2145-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2145-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2145-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2145-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2146" : helpers.makeTestYear("Asia/Beirut", [
		["2146-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2146-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2146-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2146-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2147" : helpers.makeTestYear("Asia/Beirut", [
		["2147-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2147-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2147-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2147-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2148" : helpers.makeTestYear("Asia/Beirut", [
		["2148-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2148-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2148-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2148-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2149" : helpers.makeTestYear("Asia/Beirut", [
		["2149-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2149-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2149-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2149-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2150" : helpers.makeTestYear("Asia/Beirut", [
		["2150-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2150-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2150-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2150-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2151" : helpers.makeTestYear("Asia/Beirut", [
		["2151-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2151-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2151-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2151-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2152" : helpers.makeTestYear("Asia/Beirut", [
		["2152-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2152-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2152-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2152-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2153" : helpers.makeTestYear("Asia/Beirut", [
		["2153-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2153-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2153-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2153-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2154" : helpers.makeTestYear("Asia/Beirut", [
		["2154-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2154-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2154-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2154-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2155" : helpers.makeTestYear("Asia/Beirut", [
		["2155-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2155-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2155-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2155-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2156" : helpers.makeTestYear("Asia/Beirut", [
		["2156-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2156-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2156-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2156-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2157" : helpers.makeTestYear("Asia/Beirut", [
		["2157-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2157-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2157-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2157-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2158" : helpers.makeTestYear("Asia/Beirut", [
		["2158-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2158-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2158-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2158-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2159" : helpers.makeTestYear("Asia/Beirut", [
		["2159-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2159-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2159-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2159-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2160" : helpers.makeTestYear("Asia/Beirut", [
		["2160-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2160-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2160-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2160-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2161" : helpers.makeTestYear("Asia/Beirut", [
		["2161-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2161-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2161-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2161-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2162" : helpers.makeTestYear("Asia/Beirut", [
		["2162-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2162-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2162-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2162-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2163" : helpers.makeTestYear("Asia/Beirut", [
		["2163-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2163-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2163-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2163-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2164" : helpers.makeTestYear("Asia/Beirut", [
		["2164-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2164-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2164-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2164-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2165" : helpers.makeTestYear("Asia/Beirut", [
		["2165-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2165-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2165-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2165-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2166" : helpers.makeTestYear("Asia/Beirut", [
		["2166-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2166-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2166-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2166-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2167" : helpers.makeTestYear("Asia/Beirut", [
		["2167-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2167-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2167-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2167-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2168" : helpers.makeTestYear("Asia/Beirut", [
		["2168-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2168-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2168-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2168-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2169" : helpers.makeTestYear("Asia/Beirut", [
		["2169-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2169-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2169-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2169-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2170" : helpers.makeTestYear("Asia/Beirut", [
		["2170-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2170-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2170-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2170-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2171" : helpers.makeTestYear("Asia/Beirut", [
		["2171-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2171-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2171-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2171-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2172" : helpers.makeTestYear("Asia/Beirut", [
		["2172-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2172-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2172-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2172-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2173" : helpers.makeTestYear("Asia/Beirut", [
		["2173-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2173-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2173-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2173-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2174" : helpers.makeTestYear("Asia/Beirut", [
		["2174-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2174-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2174-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2174-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2175" : helpers.makeTestYear("Asia/Beirut", [
		["2175-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2175-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2175-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2175-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2176" : helpers.makeTestYear("Asia/Beirut", [
		["2176-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2176-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2176-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2176-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2177" : helpers.makeTestYear("Asia/Beirut", [
		["2177-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2177-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2177-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2177-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2178" : helpers.makeTestYear("Asia/Beirut", [
		["2178-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2178-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2178-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2178-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2179" : helpers.makeTestYear("Asia/Beirut", [
		["2179-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2179-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2179-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2179-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2180" : helpers.makeTestYear("Asia/Beirut", [
		["2180-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2180-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2180-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2180-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2181" : helpers.makeTestYear("Asia/Beirut", [
		["2181-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2181-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2181-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2181-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2182" : helpers.makeTestYear("Asia/Beirut", [
		["2182-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2182-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2182-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2182-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2183" : helpers.makeTestYear("Asia/Beirut", [
		["2183-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2183-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2183-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2183-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2184" : helpers.makeTestYear("Asia/Beirut", [
		["2184-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2184-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2184-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2184-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2185" : helpers.makeTestYear("Asia/Beirut", [
		["2185-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2185-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2185-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2185-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2186" : helpers.makeTestYear("Asia/Beirut", [
		["2186-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2186-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2186-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2186-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2187" : helpers.makeTestYear("Asia/Beirut", [
		["2187-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2187-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2187-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2187-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2188" : helpers.makeTestYear("Asia/Beirut", [
		["2188-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2188-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2188-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2188-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2189" : helpers.makeTestYear("Asia/Beirut", [
		["2189-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2189-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2189-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2189-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2190" : helpers.makeTestYear("Asia/Beirut", [
		["2190-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2190-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2190-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2190-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2191" : helpers.makeTestYear("Asia/Beirut", [
		["2191-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2191-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2191-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2191-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2192" : helpers.makeTestYear("Asia/Beirut", [
		["2192-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2192-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2192-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2192-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2193" : helpers.makeTestYear("Asia/Beirut", [
		["2193-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2193-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2193-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2193-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2194" : helpers.makeTestYear("Asia/Beirut", [
		["2194-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2194-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2194-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2194-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2195" : helpers.makeTestYear("Asia/Beirut", [
		["2195-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2195-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2195-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2195-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2196" : helpers.makeTestYear("Asia/Beirut", [
		["2196-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2196-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2196-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2196-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2197" : helpers.makeTestYear("Asia/Beirut", [
		["2197-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2197-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2197-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2197-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2198" : helpers.makeTestYear("Asia/Beirut", [
		["2198-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2198-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2198-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2198-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2199" : helpers.makeTestYear("Asia/Beirut", [
		["2199-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2199-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2199-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2199-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2200" : helpers.makeTestYear("Asia/Beirut", [
		["2200-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2200-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2200-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2200-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2201" : helpers.makeTestYear("Asia/Beirut", [
		["2201-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2201-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2201-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2201-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2202" : helpers.makeTestYear("Asia/Beirut", [
		["2202-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2202-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2202-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2202-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2203" : helpers.makeTestYear("Asia/Beirut", [
		["2203-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2203-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2203-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2203-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2204" : helpers.makeTestYear("Asia/Beirut", [
		["2204-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2204-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2204-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2204-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2205" : helpers.makeTestYear("Asia/Beirut", [
		["2205-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2205-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2205-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2205-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2206" : helpers.makeTestYear("Asia/Beirut", [
		["2206-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2206-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2206-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2206-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2207" : helpers.makeTestYear("Asia/Beirut", [
		["2207-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2207-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2207-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2207-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2208" : helpers.makeTestYear("Asia/Beirut", [
		["2208-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2208-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2208-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2208-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2209" : helpers.makeTestYear("Asia/Beirut", [
		["2209-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2209-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2209-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2209-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2210" : helpers.makeTestYear("Asia/Beirut", [
		["2210-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2210-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2210-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2210-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2211" : helpers.makeTestYear("Asia/Beirut", [
		["2211-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2211-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2211-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2211-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2212" : helpers.makeTestYear("Asia/Beirut", [
		["2212-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2212-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2212-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2212-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2213" : helpers.makeTestYear("Asia/Beirut", [
		["2213-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2213-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2213-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2213-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2214" : helpers.makeTestYear("Asia/Beirut", [
		["2214-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2214-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2214-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2214-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2215" : helpers.makeTestYear("Asia/Beirut", [
		["2215-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2215-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2215-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2215-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2216" : helpers.makeTestYear("Asia/Beirut", [
		["2216-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2216-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2216-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2216-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2217" : helpers.makeTestYear("Asia/Beirut", [
		["2217-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2217-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2217-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2217-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2218" : helpers.makeTestYear("Asia/Beirut", [
		["2218-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2218-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2218-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2218-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2219" : helpers.makeTestYear("Asia/Beirut", [
		["2219-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2219-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2219-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2219-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2220" : helpers.makeTestYear("Asia/Beirut", [
		["2220-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2220-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2220-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2220-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2221" : helpers.makeTestYear("Asia/Beirut", [
		["2221-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2221-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2221-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2221-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2222" : helpers.makeTestYear("Asia/Beirut", [
		["2222-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2222-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2222-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2222-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2223" : helpers.makeTestYear("Asia/Beirut", [
		["2223-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2223-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2223-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2223-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2224" : helpers.makeTestYear("Asia/Beirut", [
		["2224-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2224-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2224-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2224-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2225" : helpers.makeTestYear("Asia/Beirut", [
		["2225-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2225-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2225-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2225-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2226" : helpers.makeTestYear("Asia/Beirut", [
		["2226-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2226-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2226-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2226-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2227" : helpers.makeTestYear("Asia/Beirut", [
		["2227-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2227-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2227-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2227-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2228" : helpers.makeTestYear("Asia/Beirut", [
		["2228-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2228-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2228-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2228-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2229" : helpers.makeTestYear("Asia/Beirut", [
		["2229-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2229-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2229-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2229-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2230" : helpers.makeTestYear("Asia/Beirut", [
		["2230-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2230-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2230-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2230-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2231" : helpers.makeTestYear("Asia/Beirut", [
		["2231-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2231-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2231-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2231-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2232" : helpers.makeTestYear("Asia/Beirut", [
		["2232-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2232-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2232-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2232-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2233" : helpers.makeTestYear("Asia/Beirut", [
		["2233-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2233-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2233-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2233-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2234" : helpers.makeTestYear("Asia/Beirut", [
		["2234-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2234-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2234-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2234-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2235" : helpers.makeTestYear("Asia/Beirut", [
		["2235-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2235-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2235-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2235-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2236" : helpers.makeTestYear("Asia/Beirut", [
		["2236-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2236-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2236-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2236-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2237" : helpers.makeTestYear("Asia/Beirut", [
		["2237-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2237-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2237-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2237-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2238" : helpers.makeTestYear("Asia/Beirut", [
		["2238-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2238-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2238-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2238-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2239" : helpers.makeTestYear("Asia/Beirut", [
		["2239-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2239-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2239-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2239-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2240" : helpers.makeTestYear("Asia/Beirut", [
		["2240-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2240-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2240-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2240-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2241" : helpers.makeTestYear("Asia/Beirut", [
		["2241-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2241-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2241-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2241-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2242" : helpers.makeTestYear("Asia/Beirut", [
		["2242-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2242-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2242-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2242-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2243" : helpers.makeTestYear("Asia/Beirut", [
		["2243-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2243-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2243-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2243-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2244" : helpers.makeTestYear("Asia/Beirut", [
		["2244-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2244-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2244-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2244-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2245" : helpers.makeTestYear("Asia/Beirut", [
		["2245-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2245-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2245-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2245-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2246" : helpers.makeTestYear("Asia/Beirut", [
		["2246-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2246-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2246-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2246-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2247" : helpers.makeTestYear("Asia/Beirut", [
		["2247-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2247-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2247-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2247-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2248" : helpers.makeTestYear("Asia/Beirut", [
		["2248-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2248-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2248-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2248-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2249" : helpers.makeTestYear("Asia/Beirut", [
		["2249-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2249-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2249-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2249-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2250" : helpers.makeTestYear("Asia/Beirut", [
		["2250-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2250-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2250-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2250-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2251" : helpers.makeTestYear("Asia/Beirut", [
		["2251-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2251-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2251-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2251-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2252" : helpers.makeTestYear("Asia/Beirut", [
		["2252-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2252-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2252-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2252-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2253" : helpers.makeTestYear("Asia/Beirut", [
		["2253-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2253-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2253-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2253-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2254" : helpers.makeTestYear("Asia/Beirut", [
		["2254-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2254-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2254-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2254-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2255" : helpers.makeTestYear("Asia/Beirut", [
		["2255-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2255-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2255-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2255-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2256" : helpers.makeTestYear("Asia/Beirut", [
		["2256-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2256-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2256-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2256-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2257" : helpers.makeTestYear("Asia/Beirut", [
		["2257-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2257-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2257-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2257-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2258" : helpers.makeTestYear("Asia/Beirut", [
		["2258-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2258-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2258-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2258-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2259" : helpers.makeTestYear("Asia/Beirut", [
		["2259-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2259-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2259-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2259-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2260" : helpers.makeTestYear("Asia/Beirut", [
		["2260-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2260-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2260-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2260-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2261" : helpers.makeTestYear("Asia/Beirut", [
		["2261-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2261-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2261-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2261-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2262" : helpers.makeTestYear("Asia/Beirut", [
		["2262-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2262-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2262-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2262-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2263" : helpers.makeTestYear("Asia/Beirut", [
		["2263-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2263-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2263-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2263-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2264" : helpers.makeTestYear("Asia/Beirut", [
		["2264-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2264-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2264-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2264-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2265" : helpers.makeTestYear("Asia/Beirut", [
		["2265-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2265-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2265-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2265-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2266" : helpers.makeTestYear("Asia/Beirut", [
		["2266-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2266-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2266-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2266-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2267" : helpers.makeTestYear("Asia/Beirut", [
		["2267-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2267-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2267-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2267-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2268" : helpers.makeTestYear("Asia/Beirut", [
		["2268-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2268-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2268-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2268-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2269" : helpers.makeTestYear("Asia/Beirut", [
		["2269-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2269-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2269-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2269-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2270" : helpers.makeTestYear("Asia/Beirut", [
		["2270-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2270-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2270-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2270-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2271" : helpers.makeTestYear("Asia/Beirut", [
		["2271-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2271-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2271-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2271-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2272" : helpers.makeTestYear("Asia/Beirut", [
		["2272-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2272-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2272-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2272-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2273" : helpers.makeTestYear("Asia/Beirut", [
		["2273-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2273-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2273-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2273-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2274" : helpers.makeTestYear("Asia/Beirut", [
		["2274-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2274-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2274-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2274-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2275" : helpers.makeTestYear("Asia/Beirut", [
		["2275-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2275-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2275-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2275-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2276" : helpers.makeTestYear("Asia/Beirut", [
		["2276-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2276-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2276-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2276-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2277" : helpers.makeTestYear("Asia/Beirut", [
		["2277-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2277-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2277-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2277-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2278" : helpers.makeTestYear("Asia/Beirut", [
		["2278-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2278-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2278-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2278-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2279" : helpers.makeTestYear("Asia/Beirut", [
		["2279-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2279-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2279-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2279-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2280" : helpers.makeTestYear("Asia/Beirut", [
		["2280-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2280-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2280-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2280-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2281" : helpers.makeTestYear("Asia/Beirut", [
		["2281-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2281-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2281-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2281-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2282" : helpers.makeTestYear("Asia/Beirut", [
		["2282-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2282-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2282-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2282-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2283" : helpers.makeTestYear("Asia/Beirut", [
		["2283-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2283-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2283-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2283-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2284" : helpers.makeTestYear("Asia/Beirut", [
		["2284-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2284-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2284-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2284-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2285" : helpers.makeTestYear("Asia/Beirut", [
		["2285-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2285-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2285-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2285-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2286" : helpers.makeTestYear("Asia/Beirut", [
		["2286-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2286-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2286-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2286-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2287" : helpers.makeTestYear("Asia/Beirut", [
		["2287-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2287-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2287-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2287-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2288" : helpers.makeTestYear("Asia/Beirut", [
		["2288-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2288-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2288-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2288-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2289" : helpers.makeTestYear("Asia/Beirut", [
		["2289-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2289-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2289-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2289-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2290" : helpers.makeTestYear("Asia/Beirut", [
		["2290-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2290-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2290-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2290-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2291" : helpers.makeTestYear("Asia/Beirut", [
		["2291-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2291-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2291-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2291-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2292" : helpers.makeTestYear("Asia/Beirut", [
		["2292-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2292-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2292-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2292-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2293" : helpers.makeTestYear("Asia/Beirut", [
		["2293-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2293-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2293-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2293-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2294" : helpers.makeTestYear("Asia/Beirut", [
		["2294-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2294-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2294-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2294-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2295" : helpers.makeTestYear("Asia/Beirut", [
		["2295-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2295-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2295-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2295-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2296" : helpers.makeTestYear("Asia/Beirut", [
		["2296-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2296-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2296-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2296-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2297" : helpers.makeTestYear("Asia/Beirut", [
		["2297-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2297-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2297-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2297-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2298" : helpers.makeTestYear("Asia/Beirut", [
		["2298-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2298-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2298-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2298-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2299" : helpers.makeTestYear("Asia/Beirut", [
		["2299-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2299-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2299-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2299-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2300" : helpers.makeTestYear("Asia/Beirut", [
		["2300-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2300-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2300-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2300-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2301" : helpers.makeTestYear("Asia/Beirut", [
		["2301-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2301-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2301-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2301-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2302" : helpers.makeTestYear("Asia/Beirut", [
		["2302-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2302-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2302-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2302-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2303" : helpers.makeTestYear("Asia/Beirut", [
		["2303-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2303-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2303-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2303-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2304" : helpers.makeTestYear("Asia/Beirut", [
		["2304-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2304-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2304-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2304-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2305" : helpers.makeTestYear("Asia/Beirut", [
		["2305-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2305-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2305-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2305-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2306" : helpers.makeTestYear("Asia/Beirut", [
		["2306-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2306-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2306-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2306-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2307" : helpers.makeTestYear("Asia/Beirut", [
		["2307-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2307-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2307-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2307-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2308" : helpers.makeTestYear("Asia/Beirut", [
		["2308-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2308-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2308-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2308-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2309" : helpers.makeTestYear("Asia/Beirut", [
		["2309-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2309-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2309-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2309-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2310" : helpers.makeTestYear("Asia/Beirut", [
		["2310-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2310-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2310-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2310-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2311" : helpers.makeTestYear("Asia/Beirut", [
		["2311-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2311-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2311-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2311-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2312" : helpers.makeTestYear("Asia/Beirut", [
		["2312-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2312-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2312-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2312-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2313" : helpers.makeTestYear("Asia/Beirut", [
		["2313-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2313-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2313-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2313-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2314" : helpers.makeTestYear("Asia/Beirut", [
		["2314-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2314-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2314-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2314-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2315" : helpers.makeTestYear("Asia/Beirut", [
		["2315-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2315-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2315-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2315-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2316" : helpers.makeTestYear("Asia/Beirut", [
		["2316-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2316-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2316-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2316-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2317" : helpers.makeTestYear("Asia/Beirut", [
		["2317-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2317-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2317-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2317-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2318" : helpers.makeTestYear("Asia/Beirut", [
		["2318-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2318-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2318-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2318-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2319" : helpers.makeTestYear("Asia/Beirut", [
		["2319-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2319-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2319-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2319-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2320" : helpers.makeTestYear("Asia/Beirut", [
		["2320-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2320-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2320-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2320-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2321" : helpers.makeTestYear("Asia/Beirut", [
		["2321-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2321-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2321-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2321-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2322" : helpers.makeTestYear("Asia/Beirut", [
		["2322-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2322-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2322-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2322-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2323" : helpers.makeTestYear("Asia/Beirut", [
		["2323-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2323-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2323-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2323-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2324" : helpers.makeTestYear("Asia/Beirut", [
		["2324-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2324-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2324-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2324-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2325" : helpers.makeTestYear("Asia/Beirut", [
		["2325-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2325-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2325-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2325-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2326" : helpers.makeTestYear("Asia/Beirut", [
		["2326-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2326-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2326-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2326-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2327" : helpers.makeTestYear("Asia/Beirut", [
		["2327-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2327-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2327-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2327-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2328" : helpers.makeTestYear("Asia/Beirut", [
		["2328-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2328-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2328-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2328-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2329" : helpers.makeTestYear("Asia/Beirut", [
		["2329-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2329-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2329-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2329-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2330" : helpers.makeTestYear("Asia/Beirut", [
		["2330-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2330-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2330-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2330-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2331" : helpers.makeTestYear("Asia/Beirut", [
		["2331-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2331-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2331-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2331-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2332" : helpers.makeTestYear("Asia/Beirut", [
		["2332-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2332-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2332-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2332-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2333" : helpers.makeTestYear("Asia/Beirut", [
		["2333-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2333-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2333-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2333-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2334" : helpers.makeTestYear("Asia/Beirut", [
		["2334-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2334-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2334-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2334-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2335" : helpers.makeTestYear("Asia/Beirut", [
		["2335-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2335-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2335-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2335-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2336" : helpers.makeTestYear("Asia/Beirut", [
		["2336-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2336-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2336-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2336-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2337" : helpers.makeTestYear("Asia/Beirut", [
		["2337-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2337-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2337-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2337-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2338" : helpers.makeTestYear("Asia/Beirut", [
		["2338-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2338-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2338-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2338-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2339" : helpers.makeTestYear("Asia/Beirut", [
		["2339-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2339-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2339-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2339-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2340" : helpers.makeTestYear("Asia/Beirut", [
		["2340-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2340-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2340-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2340-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2341" : helpers.makeTestYear("Asia/Beirut", [
		["2341-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2341-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2341-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2341-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2342" : helpers.makeTestYear("Asia/Beirut", [
		["2342-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2342-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2342-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2342-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2343" : helpers.makeTestYear("Asia/Beirut", [
		["2343-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2343-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2343-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2343-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2344" : helpers.makeTestYear("Asia/Beirut", [
		["2344-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2344-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2344-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2344-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2345" : helpers.makeTestYear("Asia/Beirut", [
		["2345-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2345-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2345-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2345-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2346" : helpers.makeTestYear("Asia/Beirut", [
		["2346-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2346-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2346-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2346-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2347" : helpers.makeTestYear("Asia/Beirut", [
		["2347-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2347-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2347-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2347-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2348" : helpers.makeTestYear("Asia/Beirut", [
		["2348-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2348-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2348-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2348-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2349" : helpers.makeTestYear("Asia/Beirut", [
		["2349-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2349-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2349-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2349-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2350" : helpers.makeTestYear("Asia/Beirut", [
		["2350-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2350-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2350-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2350-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2351" : helpers.makeTestYear("Asia/Beirut", [
		["2351-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2351-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2351-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2351-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2352" : helpers.makeTestYear("Asia/Beirut", [
		["2352-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2352-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2352-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2352-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2353" : helpers.makeTestYear("Asia/Beirut", [
		["2353-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2353-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2353-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2353-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2354" : helpers.makeTestYear("Asia/Beirut", [
		["2354-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2354-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2354-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2354-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2355" : helpers.makeTestYear("Asia/Beirut", [
		["2355-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2355-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2355-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2355-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2356" : helpers.makeTestYear("Asia/Beirut", [
		["2356-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2356-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2356-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2356-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2357" : helpers.makeTestYear("Asia/Beirut", [
		["2357-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2357-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2357-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2357-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2358" : helpers.makeTestYear("Asia/Beirut", [
		["2358-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2358-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2358-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2358-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2359" : helpers.makeTestYear("Asia/Beirut", [
		["2359-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2359-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2359-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2359-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2360" : helpers.makeTestYear("Asia/Beirut", [
		["2360-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2360-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2360-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2360-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2361" : helpers.makeTestYear("Asia/Beirut", [
		["2361-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2361-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2361-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2361-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2362" : helpers.makeTestYear("Asia/Beirut", [
		["2362-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2362-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2362-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2362-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2363" : helpers.makeTestYear("Asia/Beirut", [
		["2363-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2363-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2363-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2363-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2364" : helpers.makeTestYear("Asia/Beirut", [
		["2364-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2364-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2364-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2364-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2365" : helpers.makeTestYear("Asia/Beirut", [
		["2365-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2365-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2365-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2365-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2366" : helpers.makeTestYear("Asia/Beirut", [
		["2366-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2366-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2366-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2366-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2367" : helpers.makeTestYear("Asia/Beirut", [
		["2367-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2367-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2367-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2367-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2368" : helpers.makeTestYear("Asia/Beirut", [
		["2368-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2368-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2368-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2368-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2369" : helpers.makeTestYear("Asia/Beirut", [
		["2369-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2369-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2369-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2369-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2370" : helpers.makeTestYear("Asia/Beirut", [
		["2370-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2370-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2370-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2370-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2371" : helpers.makeTestYear("Asia/Beirut", [
		["2371-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2371-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2371-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2371-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2372" : helpers.makeTestYear("Asia/Beirut", [
		["2372-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2372-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2372-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2372-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2373" : helpers.makeTestYear("Asia/Beirut", [
		["2373-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2373-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2373-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2373-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2374" : helpers.makeTestYear("Asia/Beirut", [
		["2374-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2374-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2374-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2374-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2375" : helpers.makeTestYear("Asia/Beirut", [
		["2375-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2375-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2375-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2375-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2376" : helpers.makeTestYear("Asia/Beirut", [
		["2376-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2376-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2376-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2376-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2377" : helpers.makeTestYear("Asia/Beirut", [
		["2377-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2377-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2377-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2377-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2378" : helpers.makeTestYear("Asia/Beirut", [
		["2378-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2378-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2378-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2378-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2379" : helpers.makeTestYear("Asia/Beirut", [
		["2379-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2379-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2379-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2379-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2380" : helpers.makeTestYear("Asia/Beirut", [
		["2380-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2380-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2380-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2380-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2381" : helpers.makeTestYear("Asia/Beirut", [
		["2381-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2381-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2381-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2381-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2382" : helpers.makeTestYear("Asia/Beirut", [
		["2382-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2382-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2382-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2382-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2383" : helpers.makeTestYear("Asia/Beirut", [
		["2383-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2383-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2383-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2383-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2384" : helpers.makeTestYear("Asia/Beirut", [
		["2384-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2384-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2384-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2384-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2385" : helpers.makeTestYear("Asia/Beirut", [
		["2385-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2385-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2385-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2385-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2386" : helpers.makeTestYear("Asia/Beirut", [
		["2386-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2386-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2386-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2386-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2387" : helpers.makeTestYear("Asia/Beirut", [
		["2387-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2387-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2387-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2387-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2388" : helpers.makeTestYear("Asia/Beirut", [
		["2388-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2388-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2388-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2388-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2389" : helpers.makeTestYear("Asia/Beirut", [
		["2389-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2389-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2389-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2389-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2390" : helpers.makeTestYear("Asia/Beirut", [
		["2390-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2390-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2390-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2390-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2391" : helpers.makeTestYear("Asia/Beirut", [
		["2391-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2391-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2391-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2391-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2392" : helpers.makeTestYear("Asia/Beirut", [
		["2392-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2392-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2392-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2392-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2393" : helpers.makeTestYear("Asia/Beirut", [
		["2393-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2393-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2393-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2393-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2394" : helpers.makeTestYear("Asia/Beirut", [
		["2394-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2394-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2394-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2394-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2395" : helpers.makeTestYear("Asia/Beirut", [
		["2395-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2395-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2395-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2395-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2396" : helpers.makeTestYear("Asia/Beirut", [
		["2396-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2396-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2396-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2396-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2397" : helpers.makeTestYear("Asia/Beirut", [
		["2397-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2397-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2397-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2397-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2398" : helpers.makeTestYear("Asia/Beirut", [
		["2398-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2398-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2398-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2398-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2399" : helpers.makeTestYear("Asia/Beirut", [
		["2399-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2399-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2399-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2399-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2400" : helpers.makeTestYear("Asia/Beirut", [
		["2400-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2400-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2400-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2400-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2401" : helpers.makeTestYear("Asia/Beirut", [
		["2401-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2401-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2401-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2401-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2402" : helpers.makeTestYear("Asia/Beirut", [
		["2402-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2402-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2402-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2402-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2403" : helpers.makeTestYear("Asia/Beirut", [
		["2403-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2403-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2403-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2403-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2404" : helpers.makeTestYear("Asia/Beirut", [
		["2404-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2404-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2404-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2404-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2405" : helpers.makeTestYear("Asia/Beirut", [
		["2405-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2405-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2405-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2405-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2406" : helpers.makeTestYear("Asia/Beirut", [
		["2406-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2406-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2406-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2406-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2407" : helpers.makeTestYear("Asia/Beirut", [
		["2407-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2407-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2407-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2407-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2408" : helpers.makeTestYear("Asia/Beirut", [
		["2408-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2408-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2408-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2408-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2409" : helpers.makeTestYear("Asia/Beirut", [
		["2409-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2409-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2409-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2409-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2410" : helpers.makeTestYear("Asia/Beirut", [
		["2410-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2410-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2410-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2410-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2411" : helpers.makeTestYear("Asia/Beirut", [
		["2411-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2411-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2411-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2411-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2412" : helpers.makeTestYear("Asia/Beirut", [
		["2412-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2412-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2412-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2412-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2413" : helpers.makeTestYear("Asia/Beirut", [
		["2413-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2413-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2413-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2413-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2414" : helpers.makeTestYear("Asia/Beirut", [
		["2414-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2414-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2414-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2414-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2415" : helpers.makeTestYear("Asia/Beirut", [
		["2415-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2415-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2415-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2415-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2416" : helpers.makeTestYear("Asia/Beirut", [
		["2416-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2416-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2416-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2416-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2417" : helpers.makeTestYear("Asia/Beirut", [
		["2417-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2417-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2417-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2417-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2418" : helpers.makeTestYear("Asia/Beirut", [
		["2418-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2418-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2418-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2418-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2419" : helpers.makeTestYear("Asia/Beirut", [
		["2419-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2419-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2419-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2419-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2420" : helpers.makeTestYear("Asia/Beirut", [
		["2420-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2420-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2420-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2420-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2421" : helpers.makeTestYear("Asia/Beirut", [
		["2421-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2421-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2421-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2421-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2422" : helpers.makeTestYear("Asia/Beirut", [
		["2422-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2422-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2422-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2422-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2423" : helpers.makeTestYear("Asia/Beirut", [
		["2423-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2423-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2423-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2423-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2424" : helpers.makeTestYear("Asia/Beirut", [
		["2424-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2424-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2424-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2424-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2425" : helpers.makeTestYear("Asia/Beirut", [
		["2425-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2425-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2425-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2425-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2426" : helpers.makeTestYear("Asia/Beirut", [
		["2426-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2426-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2426-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2426-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2427" : helpers.makeTestYear("Asia/Beirut", [
		["2427-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2427-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2427-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2427-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2428" : helpers.makeTestYear("Asia/Beirut", [
		["2428-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2428-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2428-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2428-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2429" : helpers.makeTestYear("Asia/Beirut", [
		["2429-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2429-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2429-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2429-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2430" : helpers.makeTestYear("Asia/Beirut", [
		["2430-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2430-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2430-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2430-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2431" : helpers.makeTestYear("Asia/Beirut", [
		["2431-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2431-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2431-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2431-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2432" : helpers.makeTestYear("Asia/Beirut", [
		["2432-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2432-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2432-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2432-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2433" : helpers.makeTestYear("Asia/Beirut", [
		["2433-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2433-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2433-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2433-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2434" : helpers.makeTestYear("Asia/Beirut", [
		["2434-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2434-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2434-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2434-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2435" : helpers.makeTestYear("Asia/Beirut", [
		["2435-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2435-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2435-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2435-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2436" : helpers.makeTestYear("Asia/Beirut", [
		["2436-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2436-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2436-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2436-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2437" : helpers.makeTestYear("Asia/Beirut", [
		["2437-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2437-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2437-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2437-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2438" : helpers.makeTestYear("Asia/Beirut", [
		["2438-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2438-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2438-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2438-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2439" : helpers.makeTestYear("Asia/Beirut", [
		["2439-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2439-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2439-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2439-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2440" : helpers.makeTestYear("Asia/Beirut", [
		["2440-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2440-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2440-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2440-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2441" : helpers.makeTestYear("Asia/Beirut", [
		["2441-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2441-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2441-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2441-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2442" : helpers.makeTestYear("Asia/Beirut", [
		["2442-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2442-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2442-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2442-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2443" : helpers.makeTestYear("Asia/Beirut", [
		["2443-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2443-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2443-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2443-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2444" : helpers.makeTestYear("Asia/Beirut", [
		["2444-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2444-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2444-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2444-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2445" : helpers.makeTestYear("Asia/Beirut", [
		["2445-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2445-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2445-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2445-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2446" : helpers.makeTestYear("Asia/Beirut", [
		["2446-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2446-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2446-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2446-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2447" : helpers.makeTestYear("Asia/Beirut", [
		["2447-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2447-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2447-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2447-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2448" : helpers.makeTestYear("Asia/Beirut", [
		["2448-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2448-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2448-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2448-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2449" : helpers.makeTestYear("Asia/Beirut", [
		["2449-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2449-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2449-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2449-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2450" : helpers.makeTestYear("Asia/Beirut", [
		["2450-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2450-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2450-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2450-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2451" : helpers.makeTestYear("Asia/Beirut", [
		["2451-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2451-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2451-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2451-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2452" : helpers.makeTestYear("Asia/Beirut", [
		["2452-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2452-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2452-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2452-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2453" : helpers.makeTestYear("Asia/Beirut", [
		["2453-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2453-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2453-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2453-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2454" : helpers.makeTestYear("Asia/Beirut", [
		["2454-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2454-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2454-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2454-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2455" : helpers.makeTestYear("Asia/Beirut", [
		["2455-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2455-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2455-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2455-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2456" : helpers.makeTestYear("Asia/Beirut", [
		["2456-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2456-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2456-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2456-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2457" : helpers.makeTestYear("Asia/Beirut", [
		["2457-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2457-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2457-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2457-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2458" : helpers.makeTestYear("Asia/Beirut", [
		["2458-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2458-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2458-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2458-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2459" : helpers.makeTestYear("Asia/Beirut", [
		["2459-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2459-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2459-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2459-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2460" : helpers.makeTestYear("Asia/Beirut", [
		["2460-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2460-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2460-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2460-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2461" : helpers.makeTestYear("Asia/Beirut", [
		["2461-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2461-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2461-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2461-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2462" : helpers.makeTestYear("Asia/Beirut", [
		["2462-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2462-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2462-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2462-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2463" : helpers.makeTestYear("Asia/Beirut", [
		["2463-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2463-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2463-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2463-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2464" : helpers.makeTestYear("Asia/Beirut", [
		["2464-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2464-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2464-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2464-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2465" : helpers.makeTestYear("Asia/Beirut", [
		["2465-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2465-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2465-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2465-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2466" : helpers.makeTestYear("Asia/Beirut", [
		["2466-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2466-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2466-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2466-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2467" : helpers.makeTestYear("Asia/Beirut", [
		["2467-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2467-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2467-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2467-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2468" : helpers.makeTestYear("Asia/Beirut", [
		["2468-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2468-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2468-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2468-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2469" : helpers.makeTestYear("Asia/Beirut", [
		["2469-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2469-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2469-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2469-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2470" : helpers.makeTestYear("Asia/Beirut", [
		["2470-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2470-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2470-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2470-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2471" : helpers.makeTestYear("Asia/Beirut", [
		["2471-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2471-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2471-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2471-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2472" : helpers.makeTestYear("Asia/Beirut", [
		["2472-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2472-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2472-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2472-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2473" : helpers.makeTestYear("Asia/Beirut", [
		["2473-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2473-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2473-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2473-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2474" : helpers.makeTestYear("Asia/Beirut", [
		["2474-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2474-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2474-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2474-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2475" : helpers.makeTestYear("Asia/Beirut", [
		["2475-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2475-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2475-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2475-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2476" : helpers.makeTestYear("Asia/Beirut", [
		["2476-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2476-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2476-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2476-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2477" : helpers.makeTestYear("Asia/Beirut", [
		["2477-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2477-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2477-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2477-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2478" : helpers.makeTestYear("Asia/Beirut", [
		["2478-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2478-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2478-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2478-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2479" : helpers.makeTestYear("Asia/Beirut", [
		["2479-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2479-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2479-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2479-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2480" : helpers.makeTestYear("Asia/Beirut", [
		["2480-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2480-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2480-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2480-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2481" : helpers.makeTestYear("Asia/Beirut", [
		["2481-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2481-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2481-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2481-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2482" : helpers.makeTestYear("Asia/Beirut", [
		["2482-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2482-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2482-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2482-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2483" : helpers.makeTestYear("Asia/Beirut", [
		["2483-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2483-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2483-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2483-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2484" : helpers.makeTestYear("Asia/Beirut", [
		["2484-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2484-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2484-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2484-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2485" : helpers.makeTestYear("Asia/Beirut", [
		["2485-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2485-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2485-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2485-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2486" : helpers.makeTestYear("Asia/Beirut", [
		["2486-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2486-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2486-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2486-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2487" : helpers.makeTestYear("Asia/Beirut", [
		["2487-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2487-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2487-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2487-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2488" : helpers.makeTestYear("Asia/Beirut", [
		["2488-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2488-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2488-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2488-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2489" : helpers.makeTestYear("Asia/Beirut", [
		["2489-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2489-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2489-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2489-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2490" : helpers.makeTestYear("Asia/Beirut", [
		["2490-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2490-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2490-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2490-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2491" : helpers.makeTestYear("Asia/Beirut", [
		["2491-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2491-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2491-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2491-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2492" : helpers.makeTestYear("Asia/Beirut", [
		["2492-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2492-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2492-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2492-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2493" : helpers.makeTestYear("Asia/Beirut", [
		["2493-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2493-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2493-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2493-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2494" : helpers.makeTestYear("Asia/Beirut", [
		["2494-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2494-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2494-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2494-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2495" : helpers.makeTestYear("Asia/Beirut", [
		["2495-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2495-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2495-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2495-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2496" : helpers.makeTestYear("Asia/Beirut", [
		["2496-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2496-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2496-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2496-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2497" : helpers.makeTestYear("Asia/Beirut", [
		["2497-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2497-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2497-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2497-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2498" : helpers.makeTestYear("Asia/Beirut", [
		["2498-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2498-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2498-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2498-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2499" : helpers.makeTestYear("Asia/Beirut", [
		["2499-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2499-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2499-10-24T20:59:59+00:00", "23:59:59", "EEST", -180]
	])
};