/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  Canvas
//
// .AUTHOR:
//  Gilberto Camara, Baudouin Raoult and Fernando Ii
//
// .SUMMARY:
//  A  base class for access to drawing areas
//
// .CLIENTS:
//  Presentable, SuperPage, Page, Subpage, DataObject
//
//
// .RESPONSABILITIES:
//  Provides an interface, which, in combination
//  with multiple inheritance of its derived classes, is able
//  to support both X-Window and Postscript drawing areas
//
//
// .COLLABORATORS:
//  Graphics Engine, Device
//
//
// .BASE CLASS:
//
//
// .DERIVED CLASSES:
//  XCanvas, PSCanvas
//
// .REFERENCES:
//
//
#ifndef Canvas_H
#define Canvas_H

#include <Rectangle.h>

#include "PaperSize.h"
#include "Location.h"
#include "Device.h"

class SubPage;

enum
{
    RMALL,
    RMMATCH,
    RMNONE
};

class Canvas
{
public:
    // Contructors
    Canvas(Device& device, const Rectangle& rect, const PaperSize& size, int presentableId);

    // Destructor
    virtual ~Canvas();  // base class

    // Drawing Methods
#if 0
	// Start a new drawing
	virtual void StartDrawing () {}

	// End the drawing (and perform appropriate actions)
        virtual void EndDrawing() {}

	// Draw a given line/area
	virtual void Draw (Location&) {}

	// Set the effective drawing area
	virtual void SetDrawingArea ( const Location& drawingAreaCoord  );

	// Check if drawing area has been updated
	virtual bool HasDrawingAreaBeenSet ();

	virtual void StartPicture() {}
	virtual void EndPicture() {}
	virtual void EndAllPicture() {}

	virtual void Clear() {}

	// Dealing with zoom
	virtual void UndoSelection() {}
	virtual void RedoSelection() {}
	virtual void ResetSelection() {}
	
	// Dealing with visualization window
	virtual void SetWaitState( bool ) {}
	virtual void DisplayCoords( bool ) {}
	virtual void OnLeave () {}
	virtual void ExposeProc() {}
	virtual void SetWorldCoordinates ( Location& ) {}

//	virtual void LatLonCursor ( Location&, Location& ) {}

	// Dealing with segments
	virtual void SelectSegment ( int, const string & ) {}
        virtual void SelectShared  ( const string & ) {}
#endif

    virtual bool HasSegment(int, const string&)
    {
        return false;
    }
#if 0
        virtual bool HasShared (const string &)
		{ return false; }

	virtual void ClearSegment ( int, const string & ) {}
        virtual void ClearShared  ( const string & ) {}
        virtual void UpdateShared ( ) {}

	virtual void RemoveAllSegments ( int, bool = 0 ) {}
 	virtual void RemoveAll  () {}
#endif

    virtual bool RemoveForAll(int, const string&)
    {
        return false;
    }

    // Dealing with drawing requests
    //	virtual void InitTitleDraw ( int, Presentable* ) {}
    //	virtual void EndDraw ( Presentable* ) {}

    //	double AspectRatio()
    //		{ return aspectRatio_; }

    double GetWidth()
    {
        return size_.GetWidth();
    }

    double GetHeight()
    {
        return size_.GetHeight();
    }

    virtual void PresentableId(int presentableId)
    {
        presentableId_ = presentableId;
    }

    int PresentableId()
    {
        return presentableId_;
    }

    virtual void RemovePresentableId(int, int = RMMATCH) {}

    //        virtual void MovePresentable(SubPage*,int ) {}

    virtual void ShowPresentableId(int) {}
    virtual int ShowPresentableId()
    {
        return -1;
    }

    const Device& GetDevice() const
    {
        return myDevice_;
    }  // pointer to the device

#if 0
	virtual Point Origin ()
		{ return Point ( 0, 0 ); }

	virtual PaperSize FullPaper ()
		{ return PaperSize ( 0, 0 ); }

	virtual Cached OutFileName ()
		{ return Cached ( "" ); }

	virtual Cached OutTmpFileName ()
		{ return Cached ( "" ); }

	virtual Cached CanvasType ();

#endif

    virtual MvRequest PrinterRequest();

#if 0
        virtual string PresentableString(int ) { return string(""); }

        virtual string SharedString( ) { return string(""); }

	virtual void SetRubberBand(int,int,int,int,bool) { };

        // Move MagicsEngine file to different name
        virtual void CreateTmpFile(MvRequest &) {}

        // Put together all generated files if needed  
        virtual void CreateFile(int) {}

        // Utility for file handling
        bool MoveToFile ( const char* inFileName, const char* outFileName,
			  bool appendMode );

	virtual Widget MainWidget() const { };
#endif

protected:
    // Members
    Device& myDevice_;  // pointer to the device

    //D	auto_ptr <DeviceDriver>  canvasDeviceDriver_; //  Pointer to the deviceDriver

    double aspectRatio_;  // aspectRatio must be preserved

    Rectangle rect_;  // size of the canvas

    PaperSize size_;

    Location drawingAreaCoord_;  // coordinates on paper of
                                 // effective drawing area

    int presentableId_;  // id of the presentable associated to the canvas

private:
    // No copy allowed
    Canvas(const Canvas&);
    Canvas& operator=(const Canvas&) { return *this; }
};

#endif
