/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef GribExaminer_H
#define GribExaminer_H

#include <QStringList>

#include "MvQAbstractMessageExaminer.h"

class QButtonGroup;
class QComboBox;
class QLabel;
class QLineEdit;
class QSpinBox;
class QSplitter;
class QStackedWidget;
class QTabWidget;
class QTextBrowser;

class MvQGribMvDumpModel;
class MvQGribWmoDumpModel;
class MvQGribStdDumpModel;
class MvQGribValueDumpModel;
class MvQTextEditSearchLine;
class MvQTreeExpandState;
class MvQTreeView;
class MvQTreeViewSearchLine;
class GribMetaData;
class PlainTextWidget;

class MvQGribDumpPanel : public QWidget
{
    Q_OBJECT
public:
    MvQGribDumpPanel(QWidget* parent = 0);
    ~MvQGribDumpPanel();

    void init(GribMetaData* data);
    void loadDumps(int msgCnt);

    void readSettings(QSettings& settings);
    void writeSettings(QSettings& settings);

protected slots:
    void slotCurrentDumpChanged(int);
    void slotSetGribNameSpace(const QString&);
    void slotValueRowSpinChanged(int);
    void slotSelectValueRow(const QModelIndex&);
    void slotMvDumpFilter(QString txt);

private:
    void loadMvDump();
    void loadWmoDump();
    void loadStdDump();
    void loadValueDump();

    void clearDumps();
    void clearMvDump();
    void clearWmoDump();
    void clearStdDump();
    void clearValueDump();

    enum DumpTabIndex
    {
        DataTabIndex  = 0,
        TableTabIndex = 1,
        DebugTabIndex = 2
    };

    int currentMsg_;  //starts at 0

    GribMetaData* data_;
    bool messageCanBeDecoded_ {true};

    QTabWidget* dumpTab_;

    QComboBox* nsCombo_;
    QStringList gribNameSpace_;

    QLineEdit* mvDumpFilter_;
    MvQTreeView* mvDumpTree_;
    MvQGribMvDumpModel* mvDumpModel_;
    QSortFilterProxyModel* mvDumpSortModel_;
    bool mvDumpLoaded_ {false};

    QStackedWidget* stdDumpStacked_;
    QButtonGroup* stdGroup_;
    MvQTreeView* stdDumpTree_;
    MvQGribStdDumpModel* stdDumpModel_;
    PlainTextWidget* stdDumpBrowser_;
    bool stdDumpLoaded_ {false};
    MvQTreeExpandState* stdExpand_;

    QStackedWidget* wmoDumpStacked_;
    QButtonGroup* wmoGroup_;
    MvQTreeView* wmoDumpTree_;
    MvQGribWmoDumpModel* wmoDumpModel_;
    PlainTextWidget* wmoDumpBrowser_;
    bool wmoDumpLoaded_ {false};
    MvQTreeExpandState* wmoExpand_;

    QSpinBox* valueRowSpin_;
    QLabel* valueDumpLabel_;
    MvQTreeView* valueDumpTree_;
    MvQGribValueDumpModel* valueDumpModel_;
    QSortFilterProxyModel* valueDumpSortModel_;
    bool valueDumpLoaded_ {false};

    bool ignoreValueRowSpinChangeSignal_ {false};
    bool fileInfoLabelNeedsUpdating_ {true};
};

class MvQGribMainPanel : public QWidget
{
    Q_OBJECT
public:
    MvQGribMainPanel(QWidget* parent);
    void init(GribMetaData*);
    void clear();
    MvKeyProfile* keyProfile() const;
    void loadKeyProfile(MvKeyProfile* prof);
    void reloadData();

    void readSettings(QSettings& settings);
    void writeSettings(QSettings& settings);

protected slots:
    void messageSelected(int);
    void messageChangedInGoto(int value);

signals:
    void newMessageSelected();
    void keyProfileChanged();
    void messageNumDetermined();

private:
    GribMetaData* data_;
    MvQMessagePanel* messagePanel_;
    MvQGribDumpPanel* dumpPanel_;
    MessageControlPanel* gotoPanel_;
    QSplitter* dataSplitter_;
};

class GribExaminer : public MvQAbstractMessageExaminer
{
    Q_OBJECT

public:
    GribExaminer(QWidget* parent = 0);
    ~GribExaminer();

protected slots:
    void slotShowAboutBox();
    void slotLoadFile(QString);
    void updateFileInfoLabel();

protected:
    MvKeyProfile* loadedKeyProfile() const;

private:
    void initMain(MvMessageMetaData* data);
    void initDumps();
    void initAllKeys();

    void loadKeyProfile(MvKeyProfile*);

    void settatusMessage(QString);

    void writeSettings();
    void readSettings();

    QString lastKeyProfileName_;

    MvQGribMainPanel* mainPanel_;


    bool fileInfoLabelNeedsUpdating_;

    string tmpfilename_;
};

#endif
