#include <rumba/exception.h>


RUMBA::Exception
::~Exception(){}
RUMBA::Exception
::Exception () : error_message("") {
	#ifdef DEBUG
	cerr << "Calling RUMBA::Exception ( ) " << endl;
	#endif

}
RUMBA::Exception
::Exception ( std::string err ) : error_message ( err ) {
	#ifdef DEBUG
	cerr << "Calling RUMBA::Exception (string ) " << endl;
	#endif
}

std::string
RUMBA::Exception::
error() { return error_message; }

RUMBA::DivByZero
::DivByZero (){};

RUMBA::DivByZero
::DivByZero(std::string err) 
: RUMBA::Exception(err){};

RUMBA::BadConvert
::BadConvert () {}

RUMBA::BadConvert
::BadConvert (std::string err ) 
: RUMBA::Exception(err) {}

RUMBA::BadFile
::BadFile () {};

RUMBA::BadFile
::BadFile (std::string err ) 
: RUMBA::Exception ( err ) 
{
	#ifdef DEBUG
	cerr << "Calling RUMBA::BadFile ( string ) " << endl;
	#endif
}

RUMBA::BadArgument
::BadArgument () {};

RUMBA::BadArgument
::BadArgument (std::string err ) 
: RUMBA::Exception ( err ) {}

