// -*-objc-*-

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

@interface RSSReaderToolbarDelegate : NSObject
{
  NSToolbarItem*    update;
  NSToolbarItem*    addFeed;
  NSToolbarItem*    remFeed;
  NSToolbarItem*    jumpto;
}

-init;

// returns a ToolbarItem of the kind identified by the
// itemIdentifier.

- (NSToolbarItem *) toolbar:(NSToolbar *) toolbar
      itemForItemIdentifier:(NSString *)itemIdentifier
  willBeInsertedIntoToolbar:(BOOL)flag;


// Returns an array of ToolbarItem identifiers. (Strings)

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar;


// Returns an array of default ToolbarItem identifiers.

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar;


- (NSToolbarItem *) getToolbarItemForIdentifier: (NSString*) itemIdentifier;


// callbacks
- update: (NSNotification*) not;
- remFeed: (NSNotification*) not;
- addFeed: (NSNotification*) not;

@end
