/*
 * mirrors.h : manage a list of distributions mirrors
 *
 * See Copyright for the status of this software.
 *
 * $Id: mirrorfind.h,v 1.2 1998/09/11 05:25:04 daniel Exp $
 */

#ifndef __MIRRORS_H__
#define __MIRRORS_H__

/*
 * Constants.
 */
#define MIRRORS_NAME	"mirrors"
#define MIRRORS_VER    	"0.10"
#define MIRRORS_URL	"http://rufus.w3.org/linux/rpm2html/mirrors.html"
#define MIRRORS_MAINT	"Daniel Veillard"
#define MIRRORS_MAIL 	"veillard@w3.org"

#define MAX_MIRRORS	200
#define MAX_SERVERS	50
#define MAX_DISTRIBS	100

/*
 * Types
 */

/*
 * An info for an origin location for a distribution, picked up from
 * the original rpm2html config file.
 */
typedef struct originDistrib {
    char *directory;		/* local directory */
    char *name;			/* distribution description */
    char *dir;
    char *url;
    char *ftp;			/* The origin ftp server ! */
    char *subdir;		/* for rpm2html metadata structure */
    char *ftpsrc;		/* URL for the source RPM */
    char *color;
    char *trust;
    int   html;
    int   build_tree;
    int   nbMirrors;		/* Number of mirrors */
    char *mirrors[MAX_MIRRORS]; /* the mirrors list to build */
} originDistrib, *originDistribPtr;

/*
 * An info for an mirror holding a set of distributions and with a
 * set of mirrors worldwide.
 */
typedef struct originServer {
    char *ftp;			/* The origin ftp server ! */
    int   nbMirrors;		/* Number of mirrors */
    char *mirrors[MAX_MIRRORS]; /* the mirrors list to test */
} originServer, *originServerPtr;

/*
 * Shared variables
 */
extern char *downloadDir;
extern char *myHttpProxy;
extern char *myFtpProxy;
extern int   mirrorsVerbose;

originServer originServerList[MAX_SERVERS];
int originServerNb;
originDistrib originDistribList[MAX_DISTRIBS];
int originDistribNb;

/*
 * Functions.
 */

/* rpm2html config files parsing */
void addOriginDistrib(char *ftp);

/* mirrors config file parsing */
void addOriginServerMirror(char *ftp, char *mirror);

extern void mirrorsReadConfigFiles(char *rpm2htmlConfig);
extern void mirrorsWriteConfigFile(char *rpm2htmlConfig);
extern int getOriginServer(char *ftp);
extern void addOriginServerMirror(char *ftp, char *mirror);
extern int getOriginDistrib(char *ftp);
extern void addOriginDistribMirror(int index, char *mirror);

#endif /* __MIRRORS_H__ */
