\name{reposToolsLibPaths}
\alias{reposToolsLibPaths}
\title{A function to handle temporary libPaths}
\description{
  The reposTools package needs to maintain state information about
  packages that are installed, and normally does this by writing to a
  file 'liblisting.rda' in each library directory.  At times, a library
  directory is not writeable so reposTools stores this state in another
  directory.  This function keeps track of those directories and will
  join them with the normal .libPaths.
}
\usage{
reposToolsLibPaths(baseLib = .libPaths(), tmpLibPath = file.path(tempdir(), "tempLibs"))
}
\arguments{
  \item{baseLib}{The base set of library directories}
  \item{tmpLibPath}{The temporary directory used to maintain state}
}
\value{
  A vector of library directories
}
\author{Jeff Gentry}
\examples{
  z <- reposToolsLibPaths()
}
\keyword{utilities}
