\name{load.locLib}
\alias{load.locLib}
\title{A function to load a local library listing}
\description{
  If one exists, will load a local library listing (liblisting.Rda) from
  the specified library directory, creating an object in the user's
  session named 'locLibList'.
}
\usage{
load.locLib(lib=reposToolsLibPaths()[1])
}
\arguments{
  \item{lib}{ The R library directory to use }
}
\details{
  Will take the library directory to look at (default is
  .libPaths()[1]), and will load a liblisting.Rda file if one exists in
  that directory.  This will result in an object existing in the
  user's session with the name 'locLibList'.
}
\value{
  TRUE if successful, FALSE otherwise.
  There is also the side effect that an object named 'locLibList' is
  loaded in the user's session if TRUE.
}
\author{Jeff Gentry}
\seealso{\code{\link{closeLocLib}},\code{\link{save.locLib}},\code{\link{syncLocalLibList}},
\code{\link{reposToolsLibPaths}}}
\examples{
   lib <- paste(.find.package("reposTools"),"data/",sep="/")
   load.locLib(lib)
}
\keyword{utilities}
