\name{ReposEntry-class}
\docType{class}
\alias{ReposEntry-class}
\alias{ReposEntry}
\alias{repdataframe}
\alias{repObjects}
\alias{repPkgInfos}
\alias{repName}
\alias{repType}
\alias{repURL}
\alias{is.ReposEntry}
\alias{depends}
\alias{suggests}
\alias{imports}
\alias{keywords}
\alias{numSubReps}
\alias{getSubRep}
\alias{getSubRepList}
\alias{hasFiles}
\alias{pkgRVersion}
\alias{downloadFile}
\alias{repReleaseLevel}
\alias{reposThemes}
\alias{repReleaseLevel,ReposEntry-method}
\alias{reposThemes,ReposEntry-method}
\alias{depends,ReposEntry-method}
\alias{downloadFile,ReposEntry-method}
\alias{getSubRep,ReposEntry-method}
\alias{getSubRepList,ReposEntry-method}
\alias{hasFiles,ReposEntry-method}
\alias{keywords,ReposEntry-method}
\alias{numSubReps,ReposEntry-method}
\alias{pkgRVersion,ReposEntry-method}
\alias{repName,ReposEntry-method}
\alias{repObjects,ReposEntry-method}
\alias{repPkgInfos,ReposEntry-method}
\alias{repPkgs,ReposEntry-method}
\alias{repType,ReposEntry-method}
\alias{repURL,ReposEntry-method}
\alias{repdatadesc,ReposEntry-method}
\alias{repdataframe,ReposEntry-method}
\alias{replisting,ReposEntry-method}
\alias{show,ReposEntry-method}
\alias{suggests,ReposEntry-method}
\alias{summary,ReposEntry-method}
\alias{imports,ReposEntry-method}
\title{A class to represent a repository}
\description{This class models all key information for a server side
  repository, which can then be passed on to clients.  It provides
  access to both the basic administrative information as well as the
  dataframe itself.}
\section{Objects from the Class}{
  The helper function \code{\link{buildReposEntry}} should be used to
  create objects of this class.
}
\section{Slots}{
  \describe{
    \item{\code{replisting}:}{Object of class \code{"replisting"} The
      administrative information for the repository}
    \item{\code{repdatadesc}:}{Object of class \code{"repdatadesc"} The
      representative dataframe for this repository }
    \item{\code{reopsThemes}:}{Object of class \code{"list"} The list of
      themes for this repository.}
  }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "ReposEntry")}: A verbose
      output of the repository}
    \item{summary}{\code{signature(object = "ReposEntry")}: A brief
      output of the repository}
    \item{repdatadesc}{\code{signature(object = "ReposEntry")}: Returns
      the repdatadesc object }
    \item{repdataframe}{\code{signature(object = "ReposEntry")}: Returns
    the raw dataframe stored in repdatadesc}
    \item{replisting}{\code{signature(object = "ReposEntry")}: Returns
      the replisting object}
    \item{reposThemes}{\code{signature(object = "ReposEntry")}: Returns
      the reposThemes slot}
    \item{repName}{\code{signature(object = "ReposEntry")}: Returns the name of the repository}
    \item{repReleaseLevel}{\code{signature(object = "ReposEntry")}:
      Returns the release level of this repository.}
    \item{repObjects}{\code{signature(object = "ReposEntry")}: Returns a
    listing of all distributable objects contained in the repository}
    \item{repPkgInfos}{\code{signature(object = "ReposEntry")}: Returns
      a list of PkgInfo objects for packages stored in the repository }
    \item{repType}{\code{signature(object = "ReposEntry")}: Returns a
      string representing the type of data stored in the repository }
    \item{repURL}{\code{signature(object = "ReposEntry")}: Returns the
      URL of the repository }
    \item{depends}{\code{signature(object = "ReposEntry")}: Returns the
      dependencies for a given package}
    \item{suggests}{\code{signature(object = "ReposEntry")}: Returns the
      \code{suggests} field for a given package}
    \item{imports}{\code{signature(object = "ReposEntry")}: Returns the
      \code{imports} field for a given package}
    \item{keywords}{\code{signature(object = "ReposEntry")}: Returns the
      \code{keywords} field for a given package}
    \item{numSubReps}{\code{signature(object = "ReposEntry")}: Returns
      the number of available subrepositories}
    \item{getSubRep}{\code{signature(object = "ReposEntry")}: Returns a
      \code{ReposEntry} object for a given subrepository}
    \item{getSubRepList}{\code{signature(object = "ReposEntry")}:
      Returns a \code{ReposList} object for all subrepositories}
    \item{hasFiles}{\code{signature(object = "ReposEntry")}: Whether or
      not this repository has any downloadable files}
    \item{pkgRVersion}{\code{signature(object = "ReposEntry")}: Returns
      the version of R that a package was built under}
    \item{downloadFile}{\code{signature(object = "ReposEntry")}: Will
      download a requested file and return the new filename}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{repdatadesc-class}},\code{\link{replisting-class}},
  \code{\link{buildReposEntry}}, \code{\link{ReposList}}}
\examples{
   ## TBD
}
\keyword{classes}
