.buildReposToolsOpts <- function(OST) {
    if (is.null(getOption("BioC"))) {
        BioC <- list()
        class(BioC) <- "BioCOptions"
        options("BioC"=BioC)
    }
    ReposEntry <- list()
    class(ReposEntry) <- "BioCPkg"

    ## Set the default download type
    if (OST == "windows")
        ReposEntry$type <- "Win32"
    else
        ReposEntry$type <- "Source"

    BioC <- getOption("BioC")
    BioC$reposEntry <- ReposEntry
    options("BioC"=BioC)

    ## Set up the repositories2 option
    if (!("CRAN" %in% names(getOption("repositories2")))) {
        bioCOpt <- "http://www.bioconductor.org/CRANrepository"
        names(bioCOpt) <- "CRAN"
        options("repositories2"=c(getOption("repositories2"),bioCOpt))
    }

    if (!("BIOCRel1.5" %in% names(getOption("repositories2")))) {
        bioROpt <- "http://www.bioconductor.org/repository/release1.5/package"
        names(bioROpt) <- "BIOCRel1.5"
        options("repositories2"=c(getOption("repositories2"),bioROpt))
    }

    if (!("BIOCDevel" %in% names(getOption("repositories2")))) {
        bioDOpt <- "http://www.bioconductor.org/repository/devel/package"
        names(bioDOpt) <- "BIOCDevel"
        options("repositories2"=c(getOption("repositories2"),bioDOpt))
    }

    if (!("BIOCData" %in% names(getOption("repositories2")))) {
        bioDaDopt <- "http://www.bioconductor.org/data/metaData"
        names(bioDaDopt) <- "BIOCData"
        options("repositories2"=c(getOption("repositories2"),
        bioDaDopt))
    }
    if (!("BIOCDevData" %in% names(getOption("repositories2")))) {
        bioDaDopt <- "http://www.bioconductor.org/data/metaData-devel"
        names(bioDaDopt) <- "BIOCDevData"
        options("repositories2"=c(getOption("repositories2"),
        bioDaDopt))
    }


    if (!("BIOCExdata" %in% names(getOption("repositories2")))) {
        bioCexpr <- "http://www.bioconductor.org/data/experimental/repos"
        names(bioCexpr) <- "BIOCExdata"
        options("repositories2"=c(getOption("repositories2"),
                bioCexpr))
    }
    if (!("BIOCCourses" %in% names(getOption("repositories2")))) {
        bioCCourse <- "http://www.bioconductor.org/repository/Courses"
        names(bioCCourse) <- "BIOCCourses"
        options("repositories2"=c(getOption("repositories2"),
                bioCCourse))
    }
    if (!("BIOCcdf" %in% names(getOption("repositories2")))) {
        bioCcdf <- "http://www.bioconductor.org/data/cdfenvs/repos"
        names(bioCcdf) <- "BIOCcdf"
        options("repositories2"=c(getOption("repositories2"),
                bioCcdf))
    }
    if (!("BIOCprobes" %in% names(getOption("repositories2")))) {
        bioCProbe <- "http://www.bioconductor.org/data/probes/Packages"
        names(bioCProbe) <- "BIOCprobes"
        options("repositories2"=c(getOption("repositories2"),
                bioCProbe))
    }
    if (!("BIOCOmegahat" %in% names(getOption("repositories2")))) {
        bioCOmegahat <-
            "http://www.bioconductor.org/repository/Omegahat"
        names(bioCOmegahat) <- "BIOCOmegahat"
        options("repositories2"=c(getOption("repositories2"),
                bioCOmegahat))
    }

    if (!("BIOCLinds" %in% names(getOption("repositories2")))) {
        bioClindsey <-
            "http://www.bioconductor.org/repository/lindsey"
        names(bioClindsey) <- "BIOCLinds"
        options("repositories2"=c(getOption("repositories2"),
                bioClindsey))
    }

}

.First.lib <- function(libname, pkgname, where) {

    ## Bump up the internet.info - the current model for internet
    ## connections is extremely chatty.  Ugh.
    ##options("internet.info"=3)

    if (missing(where)) {
        where <- match(paste("package:", pkgname, sep=""), search())
        if(is.na(where)) {
            warning(paste("Not a package name: ",pkgname))
            return()
        }
        where <- pos.to.env(where)
    }

    .initComparisonMethods(where)
    OST <- .Platform$OS.type
    .buildReposToolsOpts(OST)

    autoSync <- getOption("reposTools")$autosync
    if (is.null(autoSync))
        autoSync <- TRUE

    if( interactive() && autoSync )
        syncLocalLibList()
}

