setClass("reposTheme", representation(repThemeName="character",
                                      repThemeDesc="character",
                                      repThemeRepos="character",
                                      repThemePkgs="list"))

if (is.null(getGeneric("repThemeName")))
    setGeneric("repThemeName", function(object)
               standardGeneric("repThemeName"))
setMethod("repThemeName", "reposTheme", function(object)
          object@repThemeName)

if (is.null(getGeneric("repThemePkgs")))
    setGeneric("repThemePkgs", function(object)
               standardGeneric("repThemePkgs"))
setMethod("repThemePkgs", "reposTheme", function(object)
          object@repThemePkgs)

if (is.null(getGeneric("repThemeDesc")))
    setGeneric("repThemeDesc", function(object)
               standardGeneric("repThemeDesc"))
setMethod("repThemeDesc", "reposTheme", function(object)
          object@repThemeDesc)

if (is.null(getGeneric("repThemeRepos")))
    setGeneric("repThemeRepos", function(object)
               standardGeneric("repThemeRepos"))
setMethod("repThemeRepos", "reposTheme", function(object)
          object@repThemeRepos)

setMethod("show", "reposTheme", function(object) {
    cat("Theme '", repThemeName(object), "':\n",
        repThemeDesc(object), "\nTheme Contents:\n", sep="")
    pkgs <- repThemePkgs(object)

    if (length(pkgs) == 0)
        cat("\tNo packages\n")

    for (i in seq(along = pkgs))
        cat("\tPackage ", pkgName(pkgs[[i]]), ", version ",
            as.character(pkgVersion(pkgs[[i]])),"\n", sep="")

    return(NULL)
})

repThemeNames <- function(repEntry) {
    ## Given a repository, returns a vector with all theme names
    unlist(lapply(reposThemes(repEntry), repThemeName))
}

getReposThemePkgs <- function(themeName, repEntry) {
    ## Given a name of a theme, will return the list
    ## of pkgInfos for that repository, or NULL if the
    ## theme does not exist (an empty list means that
    ## the theme has no packages, which while not making
    ## much sense, is different then it not existing)

    pos <- match(themeName, repThemeNames(repEntry))
    if (is.na(pos))
        NULL
    else
        repThemePkgs(reposThemes(repEntry)[[pos]])
}

loadRepThemes <- function(repURL, repT="repThemes.rda") {
    fileURL <- paste(repURL, repT, sep="/")

    curSEM <- getOption("show.error.messages")
    options(show.error.messages = FALSE)
    curWarn <- getOption("warn")
    options(warn=-1)
    on.exit(options(warn=curWarn), add=TRUE)
    on.exit(options(show.error.messages=curSEM), add=TRUE)
    repCon <- try(loadURL(fileURL, quiet=TRUE, mode="wb"))
    if (is(repCon,"try-error") == TRUE) {
        return(list())
    }

    repThemes
}

writeThemesXML <- function(themeList, repTXML="repThemes.xml") {
    out <- "<?xml version=\"1.0\"?>\n"
    out <- paste(out,
                 "<repositoryThemes xmlns:bt=\"http://www.bioconductor.org/THEME\">")
    outThemes <- mapply(function(x, y) {
        curOut <- "\t<theme>\n\t\t<themeName>"
        curOut <- paste(curOut, y,
                        "</themeName>\n\t\t<themeDesc>",
                        x$Description, "</themeDesc>\n\t\t",
                        "<themeRepos>", x$Repository,
                        "</themeRepos>\n\t\t<themePackages>\n", sep="")
        pkgOut <- sapply(x$Packages, function(z) {
            if (is(z, "pkgInfo")) {
                pkgName <- pkgName(z)
                pkgVersion <- pkgVersion(z)
            }
            else {
                pkgName <- z
                pkgVersion <- character()
            }

            curPkg <- paste("\t\t\t<package>\n\t\t\t\t<packageName>",
                            pkgName, "</packageName>", sep="")
            if (length(as.character(pkgVersion)) > 0)
                curPkg <- paste(curPkg, "\n\t\t\t\t<packageVersion>",
                                as.character(pkgVersion),
                                "</packageVersion>", sep="")
            curPkg <- paste(curPkg, "\t\t\t</package>", sep="\n")
            curPkg
        })
        curOut <- paste(curOut, paste(pkgOut, collapse="\n"),
                        "\t\t</themePackages>\n\t</theme>",
                        sep="\n")
        curOut
    }, themeList, names(themeList))
    out <- paste(out, paste(outThemes, collapse="\n\n"),
                 "</repositoryThemes>", sep="\n")

    cat(out, file=repTXML)
}

parseThemesXML <- function(repTXML="repThemes.xml",
                           repTrda="repThemes.rda",
                           repDrda="repdatadesc.rda") {
    require("XML") || stop("This function requires XML package")

    if (file.exists(repTXML)) {
        load(repDrda)

        xml <- xmlTreeParse(repTXML)$doc$children$repositoryThemes

        ## lapply() seems to think this is longer then it is,
        ## i suppose it is due to how XML works.  using for
        ## loop instead
        repThemes <- vector(mode="list", length=length(xml))
        for (j in seq(along=xml)) {
            themeName <- as.character(xmlChildren(xmlChildren(xml[[j]])$themeName)$text)[6]
            themeDesc <- as.character(xmlChildren(xmlChildren(xml[[j]])$themeDesc)$text)[6]
            themeRepos <- as.character(xmlChildren(xmlChildren(xml[[j]])$themeRepos)$text)[6]
            pkgs <- xmlChildren(xml[[j]])$themePackages
            pkgList <- vector(mode="list", length=length(pkgs))
            for (i in seq(along=pkgs)) {
                curPkg <- xmlChildren(pkgs[[i]])
                pkgName <- as.character(xmlChildren(curPkg$packageName)$text)[6]
                if ("packageVersion" %in% names(curPkg))
                    pkgVersion <- buildVersionNumber(as.character(xmlChildren(curPkg$packageVersion)$text)[6])
                else {
                    dfRows <- which(reposDF[,"Package"] == pkgName)
                    if (length(dfRows) == 0)
                        pkgVersion <- new("VersionNumber")
                    else {
                        maxRow <- getMaxElement(reposDF[dfRows, "Version"])
                        pkgVersion <- reposDF[dfRows[maxRow], "Version"][[1]]
                    }
                }
                pkgList[[i]] <- new("pkgInfo",
                                    pkgName= pkgName,
                                    pkgVersion=pkgVersion)
            }
            repThemes[[j]] <- new("reposTheme", repThemeName=themeName,
                                  repThemeDesc=themeDesc,
                                  repThemeRepos=themeRepos, repThemePkgs=pkgList)
        }
    }
    else
        repThemes <- list()

    save(repThemes, file=repTrda)
}

