getPkgStatusListInfos <- function(pSL) {
    ## Given a pkgStatusList, returns a set of pkgInfo objects

    pkgs <- packages(pSL)
    versions <- pkgVersions(pSL)

    out <- list()

    if (length(pkgs) > 0) {
        for (i in 1:length(pkgs))
            out[[i]] <- buildPkgInfo(pkgs[i], versions[i][[1]])
    }

    out
}


setClass("pkgStatusList", representation(statusList="list",
                                         matchesList="list"))

setMethod("show", "pkgStatusList", function(object) {
    if (length(statusList(object)) == 0) {
        cat("Unable to locate the requested package(s) in any",
                "known repository\n")
    }
    else {
        found <- found(object)
        out <- NULL
            if (length(found) > 0) {
                urls <- urls(object)
                pkgs <- packages(object)
                vers <- pkgVersions(object)
                updated <- updated(object)
                foundUrls <- urls[found]

                for (rep in unique(foundUrls)) {
                    eles <- which(urls==rep)
                    ## Now see which of these were actually updated
                    upPos <- eles[match(updated,eles)]
                    upPos <- upPos[!is.na(upPos)]
                    if ((length(upPos) > 0) && !(is.na(upPos))) {
                        versStrs <- unlist(lapply(vers,stringRep))[upPos]
                        pkgOuts <- paste(pkgs[upPos],versStrs,
                                         sep=" version ", collapse="\n\t")
                        out <- paste(out,"From URL:  ",rep,
                                     "\n\t",pkgOuts,"\n\n",sep="")
                    }
                }
            }
        ## Fill out the not found info
        nfPkgs <- pkgs[notFound(object)]
        if (length(nfPkgs) > 0) {
            out <- paste(out,"Packages that were not found:\n\t",
                         paste(nfPkgs,collapse="\n\t"),"\n\n",sep="")
        }
        ## Fill out the not updated info
        nuPkgs <- pkgs[notUpdated(object)]
        if (length(nuPkgs) > 0) {
            out <- paste(out,"Packages that were not updated:\n\t",
                         paste(nuPkgs,collapse="\n\t"),"\n\n",sep="")
        }
        cat(out)
    }
})

if (is.null(getGeneric("statusList")))
    setGeneric("statusList", function(object)
               standardGeneric("statusList"))
setMethod("statusList","pkgStatusList", function(object)
          object@statusList)
if (is.null(getGeneric("statusList<-")))
    setGeneric("statusList<-", function(object, value)
               standardGeneric("statusList<-"))
setMethod("statusList<-", "pkgStatusList", function(object,value)
      {
          if (is(value,"pkgStatusList")) {
              newList <- statusList(value)
              object@statusList <- c(object@statusList, newList)
          }
          else if (is(value,"pkgStatus")) {
              object@statusList[[length(object@statusList)+1]] <-
                  value
          }
          else if (is.list(value)) {
              object@statusList <- c(object@statusList,value)
          }
          object
      })

if (is.null(getGeneric("matchesList")))
    setGeneric("matchesList", function(object)
               standardGeneric("matchesList"))
setMethod("matchesList", "pkgStatusList", function(object)
          object@matchesList)

if (is.null(getGeneric("matchesList<-")))
    setGeneric("matchesList<-", function(object, value)
               standardGeneric("matchesList<-"))
setMethod("matchesList<-", "pkgStatusList", function(object,value)
      {
          if (is(value,"pkgStatusList")) {
              newList <- matchesList(value)
              object@matchesList <- c(object@matchesList, newList)
          }
          else if (is(value,"pkgStatus")) {
              object@matchesList[[length(object@matchesList)+1]] <-
                  value
          }
          else if (is.list(value)) {
              object@matchesList <- c(object@matchesList,value)
          }
          object
      })


if (is.null(getGeneric("packages")))
    setGeneric("packages", function(object)
               standardGeneric("packages"))
setMethod("packages", "pkgStatusList", function(object) {
    z <- unlist(lapply(statusList(object),package))
    z
})

if (is.null(getGeneric("found")))
    setGeneric("found", function(object)
               standardGeneric("found"))
setMethod("found", "pkgStatusList", function(object) {
    z <- unlist(lapply(statusList(object),found))
    if (length(z) > 0)
        which(z)
    else
        z
})

if (is.null(getGeneric("notFound")))
    setGeneric("notFound", function(object)
               standardGeneric("notFound"))
setMethod("notFound", "pkgStatusList", function(object) {
    z <- unlist(lapply(statusList(object),found))
    z <- which(!z)
    z
})

if (is.null(getGeneric("updated")))
    setGeneric("updated", function(object)
               standardGeneric("updated"))
setMethod("updated", "pkgStatusList", function(object) {
    z <- unlist(lapply(statusList(object),updated))
    if (!(is.null(z)))
        z <- which(z)
    z
})

if (is.null(getGeneric("notUpdated")))
    setGeneric("notUpdated", function(object)
               standardGeneric("notUpdated"))
setMethod("notUpdated", "pkgStatusList", function(object) {
    z <- unlist(lapply(statusList(object),updated))
    z <- which(!z)
    z
})

if (is.null(getGeneric("urls")))
    setGeneric("urls", function(object)
               standardGeneric("urls"))
setMethod("urls", "pkgStatusList", function(object) {
    z <- unlist(lapply(statusList(object),URL))
        z
})

if (is.null(getGeneric("pkgVersions")))
    setGeneric("pkgVersions", function(object)
               standardGeneric("pkgVersions"))
setMethod("pkgVersions", "pkgStatusList", function(object) {
    z <- lapply(statusList(object),pkgVersion)
    z
})



if (is.null(getGeneric("foundPkgs")))
    setGeneric("foundPkgs", function(object)
               standardGeneric("foundPkgs"))
setMethod("foundPkgs", "pkgStatusList", function(object) {
    z <- found(object)
    pkgs <- packages(object)[z]
    pkgs
})

if (is.null(getGeneric("notFoundPkgs")))
    setGeneric("notFoundPkgs", function(object)
               standardGeneric("notFoundPkgs"))
setMethod("notFoundPkgs", "pkgStatusList", function(object) {
    z <- notFound(object)
    pkgs <- packages(object)[z]
    pkgs
})

if (is.null(getGeneric("updatedPkgs")))
    setGeneric("updatedPkgs", function(object)
               standardGeneric("updatedPkgs"))
setMethod("updatedPkgs", "pkgStatusList", function(object) {
    z <- updated(object)
    if (!(is.null(z)))
        pkgs <- packages(object)[z]
    else
        pkgs <- NULL
    pkgs
})

if (is.null(getGeneric("getPackage")))
    setGeneric("getPackage", function(object,pos)
               standardGeneric("getPackage"))
setMethod("getPackage","pkgStatusList",function(object,pos)
          package(object@statusList[[pos]]))
if (is.null(getGeneric("getFound")))
    setGeneric("getFound", function(object,pos)
               standardGeneric("getFound"))
setMethod("getFound","pkgStatusList",function(object,pos)
          found(object@statusList[[pos]]))
if (is.null(getGeneric("getUpdated")))
    setGeneric("getUpdated", function(object,pos)
               standardGeneric("getUpdated"))
setMethod("getUpdated","pkgStatusList",function(object,pos)
          updated(object@statusList[[pos]]))
if (is.null(getGeneric("getUrl")))
    setGeneric("getUrl", function(object,pos)
               standardGeneric("getUrl"))
setMethod("getUrl","pkgStatusList",function(object,pos)
          URL(object@statusList[[pos]]))
if (is.null(getGeneric("getPkgVersion")))
    setGeneric("getPkgVersion", function(object,pos)
               standardGeneric("getPkgVersion"))
setMethod("getPkgVersion","pkgStatusList",function(object,pos)
          pkgVersion(object@statusList[[pos]]))



setClass("pkgStatus", representation(package="character",
                                     found="logical",
                                     updated="logical",
                                     url="character",
                                     pkgVersion="VersionNumber"))
if (is.null(getGeneric("package")))
    setGeneric("package", function(object)
               standardGeneric("package"))
setMethod("package","pkgStatus",function(object)
          object@package)
if (is.null(getGeneric("found")))
    setGeneric("found", function(object)
               standardGeneric("found"))
setMethod("found","pkgStatus",function(object)
          object@found)
if (is.null(getGeneric("updated")))
    setGeneric("updated", function(object)
               standardGeneric("updated"))
setMethod("updated","pkgStatus",function(object)
          object@updated)
if (is.null(getGeneric("URL")))
    setGeneric("URL", function(object)
               standardGeneric("URL"))
setMethod("URL","pkgStatus",function(object)
          object@url)
if (is.null(getGeneric("pkgVersion")))
    setGeneric("pkgVersion", function(object)
               standardGeneric("pkgVersion"))
setMethod("pkgVersion","pkgStatus",function(object)
          object@pkgVersion)

setMethod("show","pkgStatus",function(object) {
    out <- paste("Package ",package(object))
    if (found(object) == TRUE) {
        out <- paste(out,"version",pkgVersion(object),"was found at",
                     URL(object), "and")
        if (updated(object) == FALSE)
            out <- paste(out,"not")
        out <- paste(out,"updated.")
    }
    else
        out <- paste(out,"was not found.")
    print(out)
})

