/*

RenAttach 1.1.1 - GNU email virus/trojan attachment filter
Copyright(C) 2000-2001 Jem E. Berkes
Release date: October 18, 2001

Author's e-mail: jberkes at pc-tools dot net
Distribution site:
http://www.pc-tools.net/

Write to -stdout and modified file rename technique contributed by:
Colin McKinnon <colinmckinnon at technologist dot com>

Before compiling and executing this software you must read and agree to
the terms in LICENSE.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program (see LICENSE); if not, write to the Free
    Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA

*/


#include "defs.h"
#include <ctype.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>

const char VERSION[]="RenAttach 1.1.1 (www.pc-tools.net)";
int cursize = DEF_BUFSIZE; /* sets buffer sizes; changes on the fly */
char *scratch, *good_list, *bad_list, *gl_scratch, *bl_scratch;
FILE *mailer;
int mode, use_stdout=0;
/* these buffers have fixed size */
char messageid[DEF_BUFSIZE];
char generic[DEF_BUFSIZE];
char mime_buf[MAX_MIMEHEAD];

void free_lists()
{
free(good_list);
free(bad_list);
free(gl_scratch);
free(bl_scratch);
}


void log_it(char* filename)
/* Log a renamed filename and message ID to syslog */
{
#ifdef USE_SYSLOG
openlog("renattach", LOG_PID, LOG_MAIL);
syslog(LOG_WARNING, "renamed \"%s\" in %s", filename, messageid);
closelog();
#endif
}

char *startof_fn(char *line)
/*
Looks inside line, and returns a pointer to the start of a found
filename, or NULL if no filename is located.
*/
{
char *filename1, *filename2, *line_copy, *mime_fn, *loc;
int line_length, i;

filename1 = (char*)malloc(cursize);
filename2 = (char*)malloc(cursize);
line_copy = (char*)malloc(cursize);
if (filename1 == NULL)
	return NULL;
if (filename2 == NULL)
	{
	free(filename1);
	return NULL;
	}
if (line_copy == NULL)
	{
	free(filename1);
	free(filename2);
	return NULL;
	}
line_length = strlen(line)+1;
for (i=0; i<line_length; i++)
	line_copy[i] = tolower(line[i]);
if ((mime_fn=strstr(line_copy, "name")) == NULL)
	{
	if ( (mime_fn=strstr(line_copy, "content-description:")) == NULL)
		{
		free(filename1);
		free(filename2);
		free(line_copy);
		return NULL;
		}
	else
		{
		mime_fn = mime_fn-line_copy+line+20;
		free(filename2);
		free(line_copy);
		if (sscanf(mime_fn, "%s", filename1) == 1)
			{
			loc = strstr(mime_fn, filename1);
			free(filename1);
			return loc;
			}
		else
			{
			free(filename1);
			return NULL;
			}
		}
	}
mime_fn += 4;
mime_fn = mime_fn-line_copy+line;
free(line_copy);
switch (sscanf(mime_fn, "%s%s", filename1, filename2))
	{
	case 1:
		{
		if (strcmp(filename1, "=") == 0)
			break;
		else if (*filename1 == '=')
			{
			char *loc = strstr(mime_fn, filename1+1);
			free(filename1);
			free(filename2);
			return loc;
			}
		break;
		}
	case 2:
		{
		if (strcmp(filename1, "=") == 0)
			{
			char *loc = strstr(mime_fn, filename2);
			free(filename1);
			free(filename2);
			return loc;
			}
		else if (*filename1 == '=')
			{
			char *loc = strstr(mime_fn, filename1+1);
			free(filename1);
			free(filename2);
			return loc;
			}
		break;
		}
	}
free(filename1);
free(filename2);
return NULL;
}


int is_kosher(char *address)
/*
Catches bad "forward to" addresses. Tells whether address is good.
NB will reject prog mailers "|" and "`...`" [CM]
Return: 0 means address is bad, 1 means good
*/
{
int i;
char ch;

for (i=0; i < (int)strlen(address); i++)
	{
	ch = address[i];
	if (ch == '.' || ch == '_' || ch == '-' || ch == '@')
		continue;
	else if (ch >= 'a' && ch <= 'z')
		continue;
	else if (ch >= 'A' && ch <= 'Z')
		continue;
	else if (ch >= '0' && ch <= '9')
		continue;
	return 0;
	}
return 1;
}


int syntax(char *exec)
/*  Generic syntax error */
{
fprintf(stderr, "\n%s\nCopyright(C) 2000-2001 Jem E. Berkes\n\n", VERSION);
fprintf(stderr, "\tRenAttach comes with ABSOLUTELY NO WARRANTY. This is\n"
		"\tfree software, and you are welcome to redistribute it\n"
		"\tunder certain conditions. See LICENSE for details.\n\n");
fprintf(stderr, "Usage: %s [-v] -b|-g|-f [-s|-t address]\n\n", exec);
fprintf(stderr, "-bad or -partial (old) will rename only dangerous extensions\n");
fprintf(stderr, "-good will rename everything except known safe extensions\n");
fprintf(stderr, "-full will rename all attachments\n");
fprintf(stderr, "-to will forward the filtered mail to some address\n");
fprintf(stderr, "-stdout writes the filtered output to stdout\n");
fprintf(stderr, "-verbose will dump internal settings (including lists)\n\n");
fprintf(stderr, "Examples: (insert into .forward, with quotes)\n");
fprintf(stderr, "\"|/path/renattach -g\"\n");
fprintf(stderr, "\"|/path/renattach -b -t address@domain.tld\"\n\n");
return -1;
}


int is_match(char *filename, int good)
/*
Compares filename's extension to either the good (1) or bad (0) list
Return: 0 is not match, 1 is match
*/
{
char *extcopy, *ext, *lastdot, *token;

strcpy(gl_scratch, good_list);
strcpy(bl_scratch, bad_list);

if (good==1)
	extcopy = gl_scratch;
else
	extcopy = bl_scratch;
ext = NULL;
lastdot = strrchr(filename, '.');
if (lastdot == NULL)
	return 0;
ext = lastdot+1;
token = strtok(extcopy, CONF_TOKS);
while (token != NULL)
	{
	if (strcasecmp(token, ext) == 0)
		return 1;
	token = strtok(NULL, CONF_TOKS);
	}
return 0;
}


int make_safe(char *orig_line, char *name, int in_mime)
/*
Processes lines which contain filenames. Returns 1 if it renames
a filename. If in_mime, then output is appended to mime_buf instead
of output immediately. Note: orig_line and name must point into the
same buffer.
*/
{
char *fnbuf, *filename, *txtend, *lastdot;
int i, n;
int renamed = 0;

/* prepare this generic filename in case it is needed */
strncpy(generic, GENERIC_FN, DEF_BUFSIZE);
generic[DEF_BUFSIZE-1] = 0;

if (*name=='\n' || *name==0)
	return 0;
fnbuf = (char*)malloc(cursize);
if (fnbuf == NULL)
	return 0;
filename = fnbuf;
if ((sscanf(name, "%[^\"]", filename)==1) ||
	(sscanf(name, "\"%[^\"]", filename)==1) ||
	(sscanf(name, "%[^\n]", filename)==1))
	{
	if (filename[strlen(filename)-1] == '\n')
		filename[strlen(filename)-1] = 0;
	}
else
	{
	free(fnbuf);
	return 0;
	}
n = (strstr(name, filename)-orig_line);
strncpy(scratch, orig_line, n);
scratch[n] = 0;
txtend = strstr(name, filename) + strlen(filename);
for (i=strlen(filename)-1; (filename[i]=='.' || filename[i]==' ')
				&& i>0 ; i--)
	filename[i] = 0;
#ifdef CATCH_CODED
if (strstr(filename, "=?")!=NULL)
	{
	renamed = 1;
	log_it(filename);
	filename = generic;
	}
#endif
switch (mode)
	{
	case MODE_BADLIST:
		if (is_match(filename, 0)==1)
			{
			renamed = 1;
			log_it(filename);
			*strrchr(filename, '.') = '_';
			if (strlen(filename)+strlen(NEW_EXTN)+1 < cursize)
				strcat(filename, NEW_EXTN);
			else
				filename = generic;
			}
		break;

	case MODE_GOODLIST:
		if (is_match(filename, 1)==1)
			break;
		/* deliberate run into following case */

	case MODE_FULL:
		/* simply appending a string doesn't fix Eudora light where the
		extension _may_ be truncated back to its original value */
		renamed = 1;
		log_it(filename);
		lastdot = strrchr(filename, '.');
		if (lastdot != NULL)
			*lastdot = '_';
		if (strlen(filename)+strlen(NEW_EXTN)+1 < cursize)
			strcat(filename, NEW_EXTN);
		else
			filename = generic;
		break;
	}
strcat(scratch, filename);
strcat(scratch, txtend);
if (in_mime == 1)
	{
	if (strlen(mime_buf)+strlen(scratch)+1 < MAX_MIMEHEAD)
		strcat(mime_buf, scratch);
	}
else
	fputs(scratch, mailer);
free(fnbuf);
return renamed;
}


int main (int argc, char *argv[])
{
char *line, *fname, *bigger_line, *bigger_scratch, *token, *after_mt;
int inheader=1, mime_type=0, change_mime=0, i;
int badlist=0, goodlist=0, full=0, address=0, verbose=0;

*messageid = 0;
if (argc == 1)
	return syntax(argv[0]);
	
for (i = 1; i < argc; i++)
	{
	if (*argv[i] != '-')
		return syntax(argv[0]);
	switch (argv[i][1])
		{
		case 'v': case 'V':
			verbose = 1;
			break;
			
		case 'f': case 'F':
			full = 1;
			break;

		case 'g': case 'G':
			goodlist = 1;
			break;

		case 'b': case 'B':
		case 'p': case 'P':
			badlist = 1;
			break;

		case 's': case 'S':
			use_stdout = 1;
			break;

		case 't': case 'T':
			if (argc-1 > i)
				{
				i++;
				address = i;
				}
			else
				return syntax(argv[0]);
			break;

		default:
			return syntax(argv[0]);
		}
	}
if (use_stdout==0)
	{
	if (access(LOCAL_MAILER, X_OK) == -1)
		{
		fprintf(stderr, "Can not find/execute local mailer: %s\n", LOCAL_MAILER);
		return -1;
		}
	if (access(MTA_COMMAND, X_OK) == -1)
		{
		fprintf(stderr, "Can not find/execute MTA: %s\n", MTA_COMMAND);
		return -1;
		}
	}

if (read_lists(&good_list, &bad_list, &gl_scratch, &bl_scratch) != 0)
        return -1;
        
if (verbose == 1)
	{
	printf("Version string: %s\n", VERSION);
	printf("Configuration file is %s\n", CONF_FILE);
	printf("Mail transport agent is %s\n", MTA_COMMAND);
	printf("Local mailer is %s\n", LOCAL_MAILER);
	printf("\nReading lists from configuration file...\n");
	printf("-- begin goodlist --\n");
	strcpy(gl_scratch, good_list);
	tokenize_list(gl_scratch, 1);
	printf("\n-- begin badlist --\n");
	strcpy(bl_scratch, bad_list);
	tokenize_list(bl_scratch, 1);
	printf("\n-- end --\n\n");
	return 0;
	}

if ( (badlist==0 && goodlist==0 && full==0) ||
	(badlist==1 && goodlist==1) || (badlist==1 && full==1) || (goodlist==1 && full==1) )
	{
	fprintf(stderr, "Specify -badlist, -goodlist or -full filtering (only one)\n");
	free_lists();
	return -1;
	}
if ((address>0) && use_stdout==1)
	{
	fprintf(stderr, "Specify -stdout or -to address, but not both\n");
	free_lists();
	return -1;
	}
if (badlist==1)
	mode = MODE_BADLIST;
else if (goodlist==1)
	mode = MODE_GOODLIST;
else
	mode = MODE_FULL;
scratch = (char*)malloc(cursize);
if (scratch == NULL)
	{
	free_lists();
	return mem_error();
	}
if (address > 0)
	{
	if (is_kosher(argv[address])==0)
		{
		fprintf(stderr, "\"%s\" is not a valid e-mail address\n", argv[address]);
		free_lists();
		free(scratch);
		return -1;
		}
	else if (cursize < (int)(3+sizeof(MTA_COMMAND)+sizeof(MTA_TAIL)+strlen(argv[address])))
		{
		fprintf(stderr, "Address is too long\n");
		free_lists();
		free(scratch);
		return -1;
		}
	else sprintf(scratch, "%s %s %s", MTA_COMMAND, MTA_TAIL, argv[address]);
	}
else
	{
	strncpy(scratch, LOCAL_MAILER, cursize);
	scratch[cursize-1] = 0;
	}
line = (char*)malloc(cursize);
if (line == NULL)
	{
	free_lists();
	free(scratch);
	return mem_error();
	}
if (use_stdout==1)
	mailer=stdout;
else
	mailer = popen(scratch, "w");	/* init MDA */
if (mailer == NULL)
	{
	free_lists();
	free(scratch);
	free(line);
	return -1;
	}
while (fgets(line, cursize, stdin) != NULL)
	{
	while ( ((int)strlen(line)==cursize-1) && (line[strlen(line)-1]!='\n') )
		{
		if (cursize >= BUF_LIMIT)
			bigger_line = NULL;
		else
			{
			cursize *= 2;
			bigger_line = (char*)malloc(cursize);
			}
		if (bigger_line == NULL)
			{
			free_lists();
			free(scratch);
			free(line);
			return mem_error();
			}
		strcpy(bigger_line, line);
		free(line);
		line = bigger_line;
		free(scratch);
		bigger_scratch = (char*)malloc(cursize);
		if (bigger_scratch == NULL)
			{
			free_lists();
			free(line);
			return mem_error();
			}
		scratch = bigger_scratch;
		fgets(line+(cursize/2)-1, (cursize/2)+1, stdin);
		}
	if (inheader==1)
		{
		if (strncasecmp(line, "Message-ID:", 11)==0)
			{
			strncpy(messageid, line, DEF_BUFSIZE);
			messageid[DEF_BUFSIZE-1] = 0;
			}
		else if (*line=='\n')
			{
			/*
			Should have reached end of headers - add additional before body [CM]
			*/
			inheader = 0;
			fprintf(mailer, "X-Filtered-With: %s - ", VERSION);
				if (mode == MODE_BADLIST)
					fprintf(mailer, "badlist filter\n\n");
				else if (mode == MODE_GOODLIST)
					fprintf(mailer, "goodlist filter\n\n");
				else
					fprintf(mailer, "full filter\n\n");
			continue;
			}
		}
	else
		{
		if (mime_type==0 && (strncasecmp(line, "Content-type:", 13)==0))
			{
			mime_type = 1;
			change_mime = 0;
			*mime_buf = 0;
			}
		else
			{
			if	( (strncmp(line, "begin", 5)==0) &&
					(sscanf(line, "begin %*d %[^\n]", scratch)==1) )
				{
				if (make_safe(line, strstr(line+5, scratch), 0)==1)
					continue;
				}
			}

		if (mime_type==1)
			{
			if (*line=='\n')
				{
				mime_type = 0;
				if (change_mime == 1)
					{
					/* Change content-type */
					token = strtok(mime_buf, "\r\n");
					while (token != NULL)
						{
						if (strncasecmp(token, "Content-type:", 13)==0)
							{
							after_mt = strchr(token, ';');
							if (after_mt == NULL)
								after_mt = "";
							fprintf(mailer, "Content-Type: %s%s\n", NEW_MIMETYPE, after_mt);
							}
						else
							fprintf(mailer, "%s\n", token);
						token = strtok(NULL, "\r\n");
						}
					}
				else
					fputs(mime_buf, mailer);
				fprintf(mailer, "\n");
				}
			else
				{
				if ((fname=startof_fn(line)) != NULL)
					{
					if (make_safe(line, fname, 1)==1)
						change_mime = 1;
					}
				else
					{
					if (strlen(mime_buf)+strlen(line)+1 < MAX_MIMEHEAD)
						strcat(mime_buf, line);
					}
				}
			continue;	/* no output, yet */
			}
		}

	fputs(line, mailer);
	}
pclose(mailer);
free_lists();
free(scratch);
free(line);
return 0;
}
