/* variables.c - Variable management for interactive qmv.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils).
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif
/* C89 */
#include <string.h>
#include <stdio.h>
/* POSIX/gnulib */
#include <stdbool.h>
/* Gettext */
#include <gettext.h> /* will include <libintl.h> if ENABLE_NLS */
#define _(String) gettext(String)
/* common */
#include "common/string-utils.h"
#include "common/memory.h"
/* qmv */
#include "qmv.h"

static inline bool
parse_boolean(const char *value, bool *bool_value)
{
	if (strcmp(value, "0") == 0
			|| strcasecmp(value, "false") == 0
			|| strcasecmp(value, "no") == 0
			|| strcasecmp(value, "off") == 0) {
		*bool_value = false;
		return true;
	}
	if (strcmp(value, "1") == 0
			|| strcasecmp(value, "true") == 0
			|| strcasecmp(value, "yes") == 0
			|| strcasecmp(value, "on") == 0) {
		*bool_value = true;
		return true;
	}

	printf(_("invalid boolean value `%s' - should be either `yes' or `no'\n"), value);
	return false;
}

void
set_command(char **args)
{
	if (args[1] == NULL) {
		show_command(args);
		return;
	}
	if (args[2] == NULL) {
		printf(_("missing value argument\n"));
		return;
	}

	/*if (strcmp(args[1], "show-control-chars") == 0) {
		bool value;
		if (parse_boolean(args[2], &value))
			set_show_control_chars(value);
		
	}
	else*/ if (strcmp(args[1], "dummy") == 0) {
		bool value;
		if (parse_boolean(args[2], &value))
			dummy = value;
	}
	else if (strcmp(args[1], "editor") == 0) {
		editor_program = xstrdup(args[2]);
	}
	else if (strcmp(args[1], "format") == 0) {
		EditFormat *new_format = find_edit_format_by_name(args[2]);
		if (new_format == NULL)
			printf(_("no such edit format `%s'\n"), args[2]);
		else
			format = new_format;
	}
	else if (strcmp(args[1], "tempfile") == 0) {
		printf(_("tempfile variable is read-only\n"));
	}
	else if (strcmp(args[1], "options") == 0) {
		format->parse_options(args[2]);
	}
}

static void
show_variable(char *name)
{
	/*if (strcmp(name, "show-control-chars") == 0) {
		printf("%s=%s\n", name, show_control_chars ? "true" : "false");
	}
	else*/ if (strcmp(name, "dummy") == 0) {
		printf("%s=%s\n", name, dummy ? "true" : "false");
	}
	else if (strcmp(name, "editor") == 0) {
		printf("%s=%s\n", name, editor_program);
	}
	else if (strcmp(name, "tempfile") == 0) {
		printf("%s=%s\n", name, edit_filename);
	}
	else if (strcmp(name, "options") == 0) {
		printf(_("Write-only variable\n"));
	}
}

void
show_command(char **args)
{
	if (args[1] == NULL) {
		/*show_variable("show-control-chars");*/
		show_variable("dummy");
		show_variable("editor");
		show_variable("tempfile");
	} else {
		show_variable(args[1]);
	}
}

char *
qmv_variable_generator(const char *text, int state)
{
	static int c;
	static char *variables[] = {
		/*"show-control-chars",*/
		"dummy",
		"editor",
		"format",
		"tempfile",
		"options"
	};

	if (state == 0)
		c = 0;

	while (c < sizeof(variables)/sizeof(*variables)) {
		char *name = variables[c];
		c++;
		if (starts_with(name, text))
			return xstrdup(name);
	}

	return NULL;
}
