/* memory.c - Wrapper functions to catch memory allocation errors.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif
/* C89 */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
/* gnulib */
#include <vasprintf.h>
/* common */
#include "memory.h"
#include "error.h"

char *
xasprintf(const char *format, ...)
{
    va_list args;
	char *out;

    va_start(args, format);
    if (vasprintf(&out, format, args) < 0)
		die_memory();
    va_end(args);

	return out;
}

/*void *
xmalloc(size_t size)
{
	return check_memory(malloc(size));
}

void *
xrealloc(void *mem, size_t size)
{
	return check_memory(realloc(mem, size));
}

char *
xstrdup(const char *str)
{
	return check_memory(strdup(str));
}*/

inline void *
xmalloc_clear(size_t size)
{
	void *memory = xmalloc(size);
	memclear(memory, size);
	return memory;
}
