/***************************************************************************
 *                             RasMol 2.7.4.2                              *
 *                                                                         *
 *                                 RasMol                                  *
 *                 Molecular Graphics Visualisation Tool                   *
 *                            19 November 2007                             *
 *                          (rev. 21 March 2008)                           *
 *                                                                         *
 *                   Based on RasMol 2.6 by Roger Sayle                    *
 * Biomolecular Structures Group, Glaxo Wellcome Research & Development,   *
 *                      Stevenage, Hertfordshire, UK                       *
 *         Version 2.6, August 1995, Version 2.6.4, December 1998          *
 *                   Copyright (C) Roger Sayle 1992-1999                   *
 *                                                                         *
 *                          and Based on Mods by                           *
 *Author             Version, Date             Copyright                   *
 *Arne Mueller       RasMol 2.6x1   May 98     (C) Arne Mueller 1998       *
 *Gary Grossman and  RasMol 2.5-ucb Nov 95     (C) UC Regents/ModularCHEM  *
 *Marco Molinaro     RasMol 2.6-ucb Nov 96         Consortium 1995, 1996   *
 *                                                                         *
 *Philippe Valadon   RasTop 1.3     Aug 00     (C) Philippe Valadon 2000   *
 *                                                                         *
 *Herbert J.         RasMol 2.7.0   Mar 99     (C) Herbert J. Bernstein    * 
 *Bernstein          RasMol 2.7.1   Jun 99         1998-2008               *
 *                   RasMol 2.7.1.1 Jan 01                                 *
 *                   RasMol 2.7.2   Aug 00                                 *
 *                   RasMol 2.7.2.1 Apr 01                                 *
 *                   RasMol 2.7.2.1.1 Jan 04                               *
 *                   RasMol 2.7.3   Feb 05                                 *
 *                   RasMol 2.7.3.1 Apr 06                                 *
 *                   RasMol 2.7.4   Nov 07                                 *
 *                   RasMol 2.7.4.1 Jan 08                                 *
 *                   RasMol 2.7.4.2 Mar 08                                 *
 *                                                                         *
 * RasMol 2.7.3 incorporates changes by Clarice Chigbo, Ricky Chachra,     *
 * and Mamoru Yamanishi.  Work on RasMol 2.7.3 supported in part by        *
 * grants DBI-0203064, DBI-0315281 and EF-0312612 from the U.S. National   *
 * Science Foundation and grant DE-FG02-03ER63601 from the U.S. Department *
 * of Energy.  RasMol 2.7.4 incorporates changes by G. Todorov, Nan Jia,   *
 * N. Darakev, P. Kamburov, G. McQuillan, J. Jemilawon.  Work on RasMol    *
 * 2.7.4 supported in part by grant 1R15GM078077-01 from the National      *
 * Institute of General Medical Sciences (NIGMS). The content is solely    *
 * the responsibility of the authors and does not necessarily represent    * 
 * the official views of the funding organizations.                        *
 *                                                                         *
 * The code for use of RasMol under GTK in RasMol 2.7.4.2 was written by   *
 * Teemu  Ikonen.                                                          *
 *                                                                         *
 *                    and Incorporating Translations by                    *
 *  Author                               Item                     Language *
 *  Isabel Servan Martinez,                                                *
 *  Jose Miguel Fernandez Fernandez      2.6   Manual             Spanish  *
 *  Jose Miguel Fernandez Fernandez      2.7.1 Manual             Spanish  *
 *  Fernando Gabriel Ranea               2.7.1 menus and messages Spanish  *
 *  Jean-Pierre Demailly                 2.7.1 menus and messages French   *
 *  Giuseppe Martini, Giovanni Paolella, 2.7.1 menus and messages          *
 *  A. Davassi, M. Masullo, C. Liotto    2.7.1 help file          Italian  *
 *  G. Pozhvanov                         2.7.3 menus and messages Russian  *
 *  G. Todorov                           2.7.3 menus and messages Bulgarian*
 *  Nan Jia, G. Todorov                  2.7.3 menus and messages Chinese  *
 *  Mamoru Yamanishi, Katajima Hajime    2.7.3 menus and messages Japanese *
 *                                                                         *
 *                             This Release by                             *
 * Herbert J. Bernstein, Bernstein + Sons, 5 Brewster Ln, Bellport, NY, USA*
 *                       yaya@bernstein-plus-sons.com                      *
 *               Copyright(C) Herbert J. Bernstein 1998-2008               *
 *                                                                         *
 *                READ THE FILE NOTICE FOR RASMOL LICENSES                 *
 *Please read the file NOTICE for important notices which apply to this    *
 *package and for license terms (GPL or RASLIC).                           *
 ***************************************************************************/
 
/* langsel.c
 */

/***************************************************************************
 *                                                                         *
 * The Spanish translations in langsel.c were provided in late 2000 and    *
 * early 2001 by Fernando Gabriel Ranea <davinci@dinamica.com.ar>, who     *
 * created a version of RasMol with Spanish messages.  Those translations  *
 * were adapted by Herbert J. Bernstein to create a general multilingual   *
 * structure for RasMol.  In order to add another languages, define that   *
 * language in langsel.h, define a token for that language in tokens.h,    *
 * add code to recognize that token to tokens.c and command.c, and add     *
 * parallel lines with translations to the new language to langsel.c.      *
 * When entering menu items, you must identify a character in the item     *
 * to be underlined as a menu bar accelerator character.  The position of  *
 * that character (starting from 0 for the left-most character) should be  *
 * the last field of the line.  In addition, all menu items need to be     *
 * repeated for the Windows version with an ampersand ("&") before the     *
 * menu bar accelerator character.                                         *
 *                                                                         *
 * To date the following translations have been provided:                  *
 *                                                                         *
 * Spanish  Fernando Gabriel Ranea <davinci@dinamica.com.ar>               *
 *          January 2001                                                   *
 * French   Jean-Pierre Demailly <Jean-Pierre.Demailly@ujf-grenoble.fr>    *
 *          February 2001                                                  *
 * Italian  Giuseppe Martini <martini@iigb.na.cnr.it> and                  *
 *          Giovanni Paolella <paolella@dbbm.unina.it>                     *
 *          with contributions by: A. Davassi, M. Masullo, C. Liotto,      *
 *          G. Paolella, G. Martini of the joint bioinformatics            *
 *          groups of DBBM-UNINA and IIGB-CNR in Naples, Italy.            *
 *          March 2001                                                     *
 * Russian  Gregory A. Pozhvanov <pozhvanov@gmail.com>                     *    
 *          February 2006                                                  *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>

#define LANGSEL
#include "rasmol.h"
#include "graphics.h"
#include "langsel.h"
#include "command.h"
#include "cmndline.h"


extern int Interactive;

static char * langnames[NUMLANGS] = {
  "English",
  "French",
  "German",
  "Italian",
  "Spanish",
  "Russian",
  "Chinese",
  "Japanese",
  "Bulgarian"
};


#ifdef MSWIN
langfont langfonts[NUMLANGS] = {
  { "RASMOL_ENGLISH_MENU_FONT", 
    ANSI_CHARSET,
    "ANSI_CHARSET",
    English },
  { "RASMOL_FRENCH_MENU_FONT", 
    ANSI_CHARSET,
    "ANSI_CHARSET", 
    French },
  { "RASMOL_GERMAN_MENU_FONT", 
    ANSI_CHARSET,
    "ANSI_CHARSET", 
    German },
  { "RASMOL_ITALIAN_MENU_FONT", 
    ANSI_CHARSET,
    "ANSI_CHARSET", 
    Italian },
  { "RASMOL_SPANISH_MENU_FONT", 
    ANSI_CHARSET,
    "ANSI_CHARSET", 
    Spanish },
  { "RASMOL_RUSSIAN_MENU_FONT", 
    RUSSIAN_CHARSET,
    "RUSSIAN_CHARSET", 
    Russian },
  { "RASMOL_CHINESE_MENU_FONT", 
    GB2312_CHARSET,
    "GB2312_CHARSET",
    Chinese },
  { "RASMOL_JAPANESE_MENU_FONT", 
    SHIFTJIS_CHARSET,
    "SHIFTJIS_CHARSET", 
    Japanese },
  { "RASMOL_BULGARIAN_MENU_FONT", 
    RUSSIAN_CHARSET,
    "RUSSIAN_CHARSET", 
    Bulgarian }
};
#else
#ifdef APPLEMAC
langfont langfonts[NUMLANGS] = {
  { "RASMOL_ENGLISH_MENU_FONT", 
    "Monaco", 
    English },
  { "RASMOL_FRENCH_MENU_FONT", 
    "Monaco", 
    French },
  { "RASMOL_GERMAN_MENU_FONT", 
    "Monaco", 
    German },
  { "RASMOL_ITALIAN_MENU_FONT", 
    "Monaco", 
    Italian },
  { "RASMOL_SPANISH_MENU_FONT", 
    "Monaco", 
    Spanish },
  { "RASMOL_RUSSIAN_MENU_FONT", 
    "ER Kurier Macintosh", 
    Russian },
  { "RASMOL_CHINESE_MENU_FONT", 
    "Beijing", 
    Chinese },
  { "RASMOL_JAPANESE_MENU_FONT", 
    "Osaka", 
    Japanese },
  { "RASMOL_BULGARIAN_MENU_FONT", 
    "ER Kurier Macintosh", 
    Bulgarian }
};
#else
langfont langfonts[NUMLANGS] = {
  { "RASMOL_ENGLISH_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-serf-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-*-bold-o-normal-*-14-*-iso8859-1", 
    English },
  { "RASMOL_FRENCH_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-serf-bold-o-normal-*-14-*-iso8859-1"  ":"
    "-*-*-bold-o-normal-*-14-*-iso8859-1", 
    French },
  { "RASMOL_GERMAN_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-serf-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-*-bold-o-normal-*-14-*-iso8859-1", 
    German },
  { "RASMOL_ITALIAN_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-serf-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-*-bold-o-normal-*-14-*-iso8859-1", 
    Italian },
  { "RASMOL_SPANISH_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-serf-bold-o-normal-*-14-*-iso8859-1" ":"
    "-*-*-bold-o-normal-*-14-*-iso8859-1", 
    Spanish },
  { "RASMOL_RUSSIAN_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*1251" ":"
    "-*-serf-bold-o-normal-*-14-*-*1251" ":"
    "-*-*-bold-o-normal-*-14-*-*1251", 
    Russian },
  { "RASMOL_CHINESE_MENU_FONT", 
    "*-16-*-gb2312.1980-0", 
    Chinese },
  { "RASMOL_JAPANESE_MENU_FONT", 
    "*-r-*-14-*-jisx0208.1983-0", 
    Japanese },
  { "RASMOL_BULGARIAN_MENU_FONT", 
    "-*-helvetica-bold-o-normal-*-14-*1251" ":"
    "-*-serf-bold-o-normal-*-14-*-*1251" ":"
    "-*-*-bold-o-normal-*-14-*-*1251", 
    Bulgarian }
};
#endif
#endif
	

static langstr langstrs[] = {
  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, English,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  English,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, English,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  English,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, English,0},

  { "Invalid command syntax!\n",                       ErrSyntax,   English,0},
  { "Parameter value too large!\n",                    ErrBigNum,   English,0},
  { "Invalid parameter setting!\n",                    ErrBadOpt,   English,0},
  { "Invalid parameter name!\n",                       ErrParam,    English,0},
  { "Filename string expected!\n",                     ErrFilNam,   English,0},
  { "Molecule database loaded!\n",                     ErrBadLoad,  English,0},
  { "Integer value expected!\n",                       ErrNotNum,   English,0},
  { "Comma separator missing!\n",                      ErrNotSep,   English,0},
  { "Close bracket ']' expected!\n",                   ErrNotBrac,  English,0},
  { "No colour specified!\n",                          ErrNoCol,    English,0},
  { "Unknown or incorrect colour!\n",                  ErrColour,   English,0},
  { "Invalid command argument!\n",                     ErrBadArg,   English,0},
  { "Syntax error in expression!\n",                   ErrBadExpr,  English,0},
  { "Close parenthesis ')' expected!\n",               ErrParen,    English,0},
  { "Script command stack too deep!\n",                ErrScript,   English,0},
  { "Open parenthesis '(' expected!\n",                ErrFunc,     English,0}, 
  { "Invalid or missing atom set name!\n",             ErrSetName,  English,0},
  { "Not enough memory to define set!\n",              ErrBadSet,   English,0},
  { "Command disabled in script file!\n",              ErrInScrpt,  English,0},
  { "Command invalid (valid only within a script)!\n", ErrOutScrpt, English,0},
  { "Molecule database not loaded!\n",                 ErrBadMolDB, English,0},
  { "Bond for rotation not picked!\n",                 ErrNoBond,   English,0},
  { "Error: File '",                                   StrErrFile,  English,0},
  { "' not found!\n\n",                                StrNotFnd,   English,0},
  { "Error: Unrecognised compression format!\n\n",     StrCFmt,     English,0},
  { "Error: Unable to decompress file!\n\n",           StrDcmp,     English,0},
  { "Script command line too long!\n",                 StrSLong,    English,0},
  { "Command Error: Insufficient memory!\n",           StrSMem,     English,0},
  { "Unable to find RasMol help file!\n",              StrHFil,     English,0},
  { "Ambiguous help topic requested!\n",               StrHTop,     English,0},
  { "No available help on requested topic!\n",         StrHNone,    English,0},
  { "Command Error: Unable to reopen help file!\n",    StrHROpn,    English,0},
  { "String constant unterminated!\n",                 StrCTerm,    English,0},
  { "String constant too long!\n",                     StrCLong,    English,0},
  { "Invalid floating point number!\n",                StrFNum,     English,0},
  { "No Atoms to Centre!\n",                           StrCent,     English,0},
  { "Unable to copy to clipboard!\n",                  StrCClip,    English,0},
  { "Cannot open dots file '",                         StrDFile,    English,0},
  { "Warning: No suitable printer!\n",                 StrNPrint,   English,0},
  { "Unit Cell",                                       StrUCell,    English,0},
  { "Space Group",                                     StrSGroup,   English,0},
  { "No crystal symmetry data!\n",                     StrSymm,     English,0},
  { "Unrecognised command!\n",                         StrUnrec,    English,0},
  { "Warning: Ignoring rest of command!\n",            StrIgnore,   English,0},
  { "Warning: Remote command too long!\n",             StrRCLong,   English,0},
  { "Cannot open script file '",                       StrSFile,    English,0},
  { "Identifier too long!\n",                          StrILong,    English,0},
  { "Molecule name ......... ",                        StrMolNam,   English,0},
  { "Classification ........ ",                        StrClass,    English,0},
  { "Secondary Structure ... ",                        StrSecSt,    English,0},
  { "No Assignment\n",                                 StrNoAsmt,   English,0},
  { "PDB Data Records\n",                              StrPDBRec,   English,0},
  { "Calculated\n",                                    StrCalc,     English,0},
  { "Database Code ......... ",                        StrDBCode,   English,0},
  { "Experiment Technique .. ",                        StrExpTec,   English,0},
  { "Number of Chains ...... ",                        StrNumChn,   English,0},
  { "Number of Groups ...... ",                        StrNumGrp,   English,0},
  { "Number of Atoms ....... ",                        StrNumAtm,   English,0},
  { "Number of Bonds ....... ",                        StrNumBnd,   English,0},
  { "Number of Bridges ..... ",                        StrNumBrg,   English,0},
  { "Number of H-Bonds ..... ",                        StrNumHbd,   English,0},
  { "Number of Helices ..... ",                        StrNumHel,   English,0},
  { "Number of Strands ..... ",                        StrNumStrnd, English,0},
  { "Number of Turns ....... ",                        StrNumTrn,   English,0},
  { "Memory allocation failed",                        StrMalloc,   English,0},
  { "Too many new residues",                           StrXSRes,    English,0},
  { "Too many new atom types",                         StrXSAtyp,   English,0},
#ifndef MSWIN
  { "Open...",                                         StrMOpen,    English,0},
  { "Save As...",                                      StrMSaveAs,  English,0},
  { "Close",                                           StrMClose,   English,0},
  { "",                                                StrMEmpty,   English,0},
#ifdef APPLEMAC 
  { "Page Setup",                                      StrMPSetup,  English,0},
  { "Print",                                           StrMPrint,   English,0},
  { "Quit",                                            StrMExit,    English,0},
#else
  { "Exit",                                            StrMExit,    English,0},
#endif
  { "Wireframe",                                       StrMWirefr,  English,0},
  { "Backbone",                                        StrMBackbn,  English,0},
  { "Sticks",                                          StrMSticks,  English,1},
  { "Spacefill",                                       StrMSpacefl, English,0},
  { "Ball & Stick",                                    StrMBallStk, English,0},
  { "Ribbons",                                         StrMRibbons, English,0},
  { "Strands",                                         StrMStrands, English,3},
  { "Cartoons",                                        StrMCartoon, English,0},
  { "Molecular Surface",                               StrMMolSurf, English,0},
  { "Monochrome",                                      StrMMonochr, English,0},
  { "CPK",                                             StrMCPK,     English,0},
  { "Shapely",                                         StrMShapely, English,0},
  { "Group",                                           StrMGroup,   English,0},
  { "Chain",                                           StrMChain,   English,1},
  { "Temperature",                                     StrMTemp,    English,0},
  { "Structure",                                       StrMStruct,  English,2},
  { "User",                                            StrMUser,    English,0},
  { "Model",                                           StrMModel,   English,2},
  { "Alt",                                             StrMAlt,     English,0},
  { "Slab Mode",                                       StrMSlab,    English,0},
  { "Hydrogens",                                       StrMHydr,    English,1},
  { "Hetero Atoms",                                    StrMHet,     English,2},
  { "Specular",                                        StrMSpec,    English,1},
  { "Shadows",                                         StrMShad,    English,1},
  { "Stereo",                                          StrMStereo,  English,5},
  { "Labels",                                          StrMLabel,   English,0},
  { "Pick Off",                                        StrMPOff,    English,5},
  { "Pick Ident",                                      StrMPIdent,  English,5},
  { "Pick Distance",                                   StrMPDist,   English,5},
  { "Pick Monitor",                                    StrMPMon,    English,0},
  { "Pick Angle",                                      StrMPAng,    English,5},
  { "Pick Torsion",                                    StrMPTrsn,   English,5},
  { "Pick Label",                                      StrMPLabl,   English,5}, 
  { "Pick Centre",                                     StrMPCent,   English,5},
  { "Pick Coord",                                      StrMPCoord,  English,6},
  { "Pick Bond",                                       StrMPBond,   English,5},
  { "Rotate Bond",                                     StrMRBond,   English,0},
  { "Rotate Mol",                                      StrMRMol,    English,7},
  { "Rotate All",                                      StrMRAll,    English,7},
  { "BMP ...",                                         StrMBMP,     English,0},  
  { "GIF ...",                                         StrMGIF,     English,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    English,5},  
  { "PPM ...",                                         StrMPPM,     English,2},  
  { "Sun Raster...",                                   StrMSRast,   English,0},  
  { "PostScript...",                                   StrMPostscr, English,0},  
  { "PICT...",                                         StrMPICT,    English,1},  
  { "Vector PS ...",                                   StrMVECPS,   English,0},  
  { "Molscript ...",                                   StrMMSCR,    English,1},  
  { "Kinemage ...",                                    StrMKine,    English,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  English,2}, 
  { "VRML ...",                                        StrMVRML,    English,3},  
  { "Ramachandran ...",                                StrMRPP,     English,3},  
  { "Raster3D ...",                                    StrMR3D,     English,6},  
  { "RasMol Script ...",                               StrMSCR,     English,8},  
  { "About RasMol...",                                 StrMAbout,   English,0},
  { "User Manual...",                                  StrMUserM,   English,0},
  { "Undo",                                            StrMUndo,    English,0},
  { "Cut",                                             StrMCut,     English,1},
  { "Copy",                                            StrMCopy,    English,1},
  { "Paste",                                           StrMPaste,   English,0},
#ifdef APPLEMAC
  { "Clear",                                           StrMClear,   English,1},
#else
  { "Delete",                                          StrMDelete,  English,0},
#endif
  { "Select all",                                      StrMSelAll,  English,0},
  { "File",                                            StrMFile,    English,0},
  { "Edit",                                            StrMEdit,    English,0},
  { "Display",                                         StrMDisplay, English,0},
  { "Colours",                                         StrMColour,  English,0},
  { "Options",                                         StrMOpt,     English,0},
  { "Settings",                                        StrMSettings,English,0},
  { "Export",                                          StrMExport,  English,1},
#ifdef APPLEMAC
  { "Window",                                          StrMWindow,  English,0},
#endif
  { "Help",                                            StrMHelp,    English,0},
#ifdef APPLEMAC
  { "Main Window",                                     StrMMainWin,  English,0},
  { "Command Line",                                    StrMCmndLin,  English,0},
#endif
#else
  { "&Open ...",                                       StrMOpen,    English,0},
  { "&Information",                                    StrMInfo,    English,0},
  { "&Close",                                          StrMClose,   English,0},
  { "&Print",                                          StrMPrint,   English,0},
  { "P&rint Setup",                                    StrMPSetup,  English,0},
  { "&Exit",                                           StrMExit,    English,0},
  { "&Wireframe",                                      StrMWirefr,  English,0},
  { "&Backbone",                                       StrMBackbn,  English,0},
  { "S&ticks",                                         StrMSticks,  English,1},
  { "&Spacefill",                                      StrMSpacefl, English,0},
  { "&Ball && Stick",                                  StrMBallStk, English,0},
  { "&Ribbons",                                        StrMRibbons, English,0},
  { "Str&ands",                                        StrMStrands, English,3},
  { "&Cartoons",                                       StrMCartoon, English,0},
  { "&Molecular Surface",                              StrMMolSurf, English,0},
  { "&Monochrome",                                     StrMMonochr, English,0},
  { "&CPK",                                            StrMCPK,     English,0},
  { "&Shapely",                                        StrMShapely, English,0},
  { "&Group",                                          StrMGroup,   English,0},
  { "C&hain",                                          StrMChain,   English,1},
  { "&Temperature",                                    StrMTemp,    English,0},
  { "St&ructure",                                      StrMStruct,  English,2},
  { "&User",                                           StrMUser,    English,0},
  { "Mo&del",                                          StrMModel,   English,2},
  { "&Alt",                                            StrMAlt,     English,0},
  { "&Slab Mode",                                      StrMSlab,    English,0},
  { "H&ydrogens",                                      StrMHydr,    English,1},
  { "He&tero Atoms",                                   StrMHet,     English,2},
  { "S&pecular",                                       StrMSpec,    English,1},
  { "S&hadows",                                        StrMShad,    English,1},
  { "Stere&o",                                         StrMStereo,  English,5},
  { "&Labels",                                         StrMLabel,   English,0},
  { "Pick &Off",                                       StrMPOff,    English,5},
  { "Pick &Ident",                                     StrMPIdent,  English,5},
  { "Pick &Distance",                                  StrMPDist,   English,5},
  { "&Pick Monitor",                                   StrMPMon,    English,0},
  { "Pick &Angle",                                     StrMPAng,    English,5},
  { "Pick &Torsion",                                   StrMPTrsn,   English,5},
  { "Pick &Label",                                     StrMPLabl,   English,5}, 
  { "Pick &Centre",                                    StrMPCent,   English,5},
  { "Pick C&oord",                                     StrMPCoord,  English,6},
  { "Pick &Bond",                                      StrMPBond,   English,5},
  { "&Rotate Bond",                                    StrMRBond,   English,0},
  { "Rotate &Mol",                                     StrMRMol,    English,7},
  { "Rotate &All",                                     StrMRAll,    English,7},
  { "&BMP ...",                                        StrMBMP,     English,0},  
  { "&GIF ...",                                        StrMGIF,     English,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    English,5}, 
  { "PP&M ...",                                        StrMPPM,     English,2},  
  { "&Sun Raster...",                                  StrMSRast,   English,0},  
  { "&PostScript...",                                  StrMPostscr, English,0},  
  { "P&ICT...",                                        StrMPICT,    English,1},  
  { "&Vector PS ...",                                  StrMVECPS,   English,0},  
  { "M&olscript ...",                                  StrMMSCR,    English,1},  
  { "&Kinemage ...",                                   StrMKine,    English,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  English,2},  
  { "VRM&L ...",                                       StrMVRML,    English,3},  
  { "Ram&achandran ...",                               StrMRPP,     English,3},  
  { "Raster&3D ...",                                   StrMR3D,     English,6},  
  { "RasMol S&cript ...",                              StrMSCR,     English,8},  
  { "&About RasMol...",                                StrMAbout,   English,0},
  { "&User Manual...",                                 StrMUserM,   English,0},
  { "&Undo",                                           StrMUndo,    English,0},
  { "C&ut",                                            StrMCut,     English,1},
  { "C&opy",                                           StrMCopy,    English,1},
  { "&Paste",                                          StrMPaste,   English,0},
  { "&Delete",                                         StrMDelete,  English,0},
  { "&Select all",                                     StrMSelAll,  English,0},
  { "&File",                                           StrMFile,    English,0},
  { "&Edit",                                           StrMEdit,    English,0},
  { "&Display",                                        StrMDisplay, English,0},
  { "&Colours",                                        StrMColour,  English,0},
  { "&Options",                                        StrMOpt,     English,0},
  { "&Settings",                                       StrMSettings,English,0},
  { "E&xport",                                         StrMExport,  English,1},
  { "&Help",                                           StrMHelp,    English,0},
#endif
  { "PDB file name:",                                  StrPrmtPDB,  English,0},
  { "Image file name:",                                StrPrmtImg,  English,0},
  { "Molecule file name:",                             StrPrmtMol,  English,0},
  { "Warning: ",                                       StrWarn,     English,0},
  { "Chain",                                           StrChain,    English,0},
  { "Register",                                        StrRegister, English,0},
  { "Donate",                                          StrDonate,   English,0},
  { "Do not show this dialog at startup",              StrNoShow,   English,0},
  { "No Warranty, Open Source, GPL, Donations Appreciated", StrWarranty, English,0},


  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Spanish,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Spanish,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Spanish,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Spanish,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Spanish,0},

  { "¡Sintaxis de comando inválida!\n",                ErrSyntax,   Spanish,0},
  { "¡Valor de parámetro demasiado larga!\n",          ErrBigNum,   Spanish,0},
  { "¡Valor de parámetro inválido!\n",                 ErrBadOpt,   Spanish,0},
  { "¡Nombre de parámetro inválido!\n",                ErrParam,    Spanish,0},
  { "¡Se esperaba un nombre de archivo!\n",            ErrFilNam,   Spanish,0},
  { "¡Base de datos de moléculas cargada!\n",          ErrBadLoad,  Spanish,0},
  { "¡Se esperaba un valor entero!\n",                 ErrNotNum,   Spanish,0},
  { "¡Separador coma perdido!\n",                      ErrNotSep,   Spanish,0},
  { "¡Se esperaba cerrar corchete ']'!\n",             ErrNotBrac,  Spanish,0},
  { "¡No se ha especificado un color!\n",              ErrNoCol,    Spanish,0},
  { "¡Color incorrecto o desconocido!\n",              ErrColour,   Spanish,0},
  { "¡Argumento de comando inválido!\n",               ErrBadArg,   Spanish,0},
  { "¡Error de sintaxis en la expresión!\n",           ErrBadExpr,  Spanish,0},
  { "¡Se esperaba cerrar paréntesis ')'!\n",           ErrParen,    Spanish,0},
  { "¡Pila del comando de script demasiado grande!\n", ErrScript,   Spanish,0},
  { "¡Se esperaba abrir parentesis '('!\n",            ErrFunc,     Spanish,0},
  { "¡Nombre de átomo inválido o erróneo!\n",          ErrSetName,  Spanish,0},
  { "¡No hay suficiente memoria para definir!\n",      ErrBadSet,   Spanish,0},
  { "¡Comando deshabilitado en el archivo de script!\n", ErrInScrpt,  Spanish,0},
  { "¡Comando inválido (comando válido sólo dentro un script)!\n", ErrOutScrpt, Spanish,0},
  { "¡Base de datos de moléculas no cargada!\n",       ErrBadMolDB, Spanish,0},
  { "¡Enlace para el giro no elegido!\n",              ErrNoBond,   Spanish,0},
  { "¡Error: Archivo '",                               StrErrFile,  Spanish,0},
  { "' no encontrado!\n\n",                            StrNotFnd,   Spanish,0},
  { "¡Error: Formato de compresión no reconocido!\n\n", StrCFmt,     Spanish,0},
  { "¡Error: Incapaz de descomprimir el archivo!\n\n", StrDcmp,     Spanish,0},
  { "¡Script de línea de comando demasiado largo!\n",  StrSLong,    Spanish,0},
  { "¡Error de comando: Memoria insuficiente!",        StrSMem,     Spanish,0},
  { "¡Incapaz de encontrar el archivo de ayuda del RasMol!\n", StrHFil,     Spanish,0},
  { "¡Tópico de ayuda requerido ambiguo!\n",           StrHTop,     Spanish,0},
  { "¡No hay ayuda disponible para el tópico requerido!\n", StrHNone,    Spanish,0},
  { "¡Error de comando: Incapaz de reabrir el archivo de ayuda!\n", StrHROpn,    Spanish,0},
  { "¡Constante de cadena indeterminada!\n",           StrCTerm,    Spanish,0},
  { "¡Constante de cadena muy larga !\n",              StrCLong,    Spanish,0},
  { "¡Número de punto flotante inválido!\n",           StrFNum,     Spanish,0},
  { "¡No hay átomos para centrar!\n",                  StrCent,     Spanish,0},
  { "¡Incapaz de copiar al portapapeles!\n",           StrCClip,    Spanish,0},
  { "¡No se puede abrir el archivo de puntos '",       StrDFile,    Spanish,0},
  { "¡Cuidado: No hay impresora disponible!\n",        StrNPrint,   Spanish,0},
  { "Célula Unidad",                                   StrUCell,    Spanish,0},
  { "Grupo Espacial",                                  StrSGroup,   Spanish,0},
  { "¡No hay datos de simetría del cristal\n",         StrSymm,     Spanish,0},
  { "¡Comando no reconocido!\n",                       StrUnrec,    Spanish,0},
  { "¡Cuidado: se ignora el resto del comando!\n",     StrIgnore,   Spanish,0},
  { "¡Cuidado: comando remoto demasiado largo!\n",     StrRCLong,   Spanish,0},
  { "¡No se puede abrir el archivo de script '",       StrSFile,    Spanish,0},
  { "¡Identificador demasiado largo!\n",               StrILong,    Spanish,0},
  { "Nombre de la Molécula . ",                        StrMolNam,   Spanish,0},
  { "Clasificación ......... ",                        StrClass,    Spanish,0},
  { "Estructura Secundaria . ",                        StrSecSt,    Spanish,0},
  { "No Asignada\n",                                   StrNoAsmt,   Spanish,0},
  { "Registro PDB\n",                                  StrPDBRec,   Spanish,0},
  { "Calculado\n",                                     StrCalc,     Spanish,0},
  { "Código de Base de Datos ",                        StrDBCode,   Spanish,0},
  { "Técnica de Experimento  ",                        StrExpTec,   Spanish,0},
  { "Número de Cadenas ..... ",                        StrNumChn,   Spanish,0},
  { "Número de Grupos ...... ",                        StrNumGrp,   Spanish,0},
  { "Número de Atomos ...... ",                        StrNumAtm,   Spanish,0},
  { "Número de Enlaces ..... ",                        StrNumBnd,   Spanish,0},
  { "Número de Puentes ..... ",                        StrNumBrg,   Spanish,0},
  { "Número de Uniones-H ... ",                        StrNumHbd,   Spanish,0},
  { "Número de Hélices ..... ",                        StrNumHel,   Spanish,0},
  { "Número de Hebras ...... ",                        StrNumStrnd, Spanish,0},
  { "Número de Giros ....... ",                        StrNumTrn,   Spanish,0},
  { "Falla en la asignación de memoria",               StrMalloc,   Spanish,0},
  { "Demasiados residuos nuevos",                      StrXSRes,    Spanish,0},
  { "Demasiados tipos de átomos nuevos",               StrXSAtyp,   Spanish,0},
#ifndef MSWIN
  { "Abrir...",                                        StrMOpen,    Spanish,0},
  { "Guardar como...",                                 StrMSaveAs,  Spanish,0},
  { "Cerrar",                                          StrMClose,   Spanish,0},
  { "",                                                StrMEmpty,   Spanish,0},
#ifdef APPLEMAC
  { "Configurar página",                               StrMPSetup,  Spanish,3},
  { "Imprimir",                                        StrMPrint,   Spanish,0},
  { "Quitar",                                          StrMExit,    Spanish,0},
#else
  { "Salir",                                           StrMExit,    Spanish,0},
#endif
  { "Alambre",                                         StrMWirefr,  Spanish,0},
  { "Esqueleto",                                       StrMBackbn,  Spanish,0},
  { "Bastones",                                        StrMSticks,  Spanish,3},
  { "Espacio Completo",                                StrMSpacefl, Spanish,2},
  { "Bolas & Bastones",                                StrMBallStk, Spanish,0},
  { "Cintas",                                          StrMRibbons, Spanish,0},
  { "Hebras",                                          StrMStrands, Spanish,0},
  { "Dibujo",                                          StrMCartoon, Spanish,0},
  { "Superficie Molecular",                            StrMMolSurf, Spanish,11},
  { "Monocromo",                                       StrMMonochr, Spanish,0},
  { "CPK",                                             StrMCPK,     Spanish,0},
  { "Forma",                                           StrMShapely, Spanish,0},
  { "Grupo",                                           StrMGroup,   Spanish,0},
  { "Cadena",                                          StrMChain,   Spanish,2},
  { "Temperatura",                                     StrMTemp,    Spanish,0},
  { "Estructura",                                      StrMStruct,  Spanish,3},
  { "Usuario",                                         StrMUser,    Spanish,0},
  { "Modelo",                                          StrMModel,   Spanish,2},
  { "Alt",                                             StrMAlt,     Spanish,0},
  { "Modo Aserrado",                                   StrMSlab,    Spanish,6},
  { "Hidrógenos",                                      StrMHydr,    Spanish,1},
  { "Heteroátomos",                                    StrMHet,     Spanish,2},
  { "Especular",                                       StrMSpec,    Spanish,2},
  { "Sombras",                                         StrMShad,    Spanish,2},
  { "Estereo",                                         StrMStereo,  Spanish,6},
  { "Etiquetas",                                       StrMLabel,   Spanish,3},
  { "Desactivar elección",                             StrMPOff,    Spanish,0},
  { "Elegir identificación",                           StrMPIdent,  Spanish,7},
  { "Elegir distancia",                                StrMPDist,   Spanish,9},
  { "Elegir monitor",                                  StrMPMon,    Spanish,13},
  { "Elegir ángulo",                                   StrMPAng,    Spanish,8},
  { "Elegir torsiones",                                StrMPTrsn,   Spanish,7},
  { "Elegir etiqueta",                                 StrMPLabl,   Spanish,10}, 
  { "Elegir centro",                                   StrMPCent,   Spanish,7},
  { "Elegir coordenadas",                              StrMPCoord,  Spanish,8},
  { "Elegir enlace",                                   StrMPBond,   Spanish,7},
  { "Girar enlace",                                    StrMRBond,   Spanish,0},
  { "Girar molécula",                                  StrMRMol,    Spanish,6},
  { "Girar todo",                                      StrMRAll,    Spanish,6},
  { "BMP ...",                                         StrMBMP,     Spanish,0},  
  { "GIF ...",                                         StrMGIF,     Spanish,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Spanish,5},  
  { "PPM ...",                                         StrMPPM,     Spanish,2},  
  { "Sun Raster...",                                   StrMSRast,   Spanish,0},  
  { "PostScript...",                                   StrMPostscr, Spanish,0},  
  { "PICT...",                                         StrMPICT,    Spanish,1},  
  { "Vector PS ...",                                   StrMVECPS,   Spanish,0},  
  { "Molscript ...",                                   StrMMSCR,    Spanish,1},  
  { "Kinemage ...",                                    StrMKine,    Spanish,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  Spanish,2},  
  { "VRML ...",                                        StrMVRML,    Spanish,3},  
  { "Ramachandran ...",                                StrMRPP,     Spanish,3},  
  { "Raster3D ...",                                    StrMR3D,     Spanish,6},  
  { "RasMol Script ...",                               StrMSCR,     Spanish,8},  
  { "Acerca del RasMol...",                            StrMAbout,   Spanish,0},
  { "Manual del Usuario...",                           StrMUserM,   Spanish,0},
  { "Deshacer",                                        StrMUndo,    Spanish,0},
  { "Cortar",                                          StrMCut,     Spanish,2},
  { "Copiar",                                          StrMCopy,    Spanish,1},
  { "Pegar",                                           StrMPaste,   Spanish,0},
#ifdef APPLEMAC
  { "Borrar",                                          StrMClear,   Spanish,0},
#else
  { "Borrar",                                          StrMDelete,  Spanish,0},
#endif
  { "Seleccionar todo",                                StrMSelAll,  Spanish,0},
  { "Archivo",                                         StrMFile,    Spanish,0},
  { "Editar",                                          StrMEdit,    Spanish,0},
  { "Mostrar",                                         StrMDisplay ,Spanish,0},
  { "Colores",                                         StrMColour,  Spanish,0},
  { "Opciones",                                        StrMOpt,     Spanish,0},
  { "Configuraciones",                                 StrMSettings,Spanish,3},
  { "Exportar",                                        StrMExport,  Spanish,1},
#ifdef APPLEMAC
  { "Ventana",                                         StrMWindow,  Spanish,0},
#endif
  { "Ayuda",                                           StrMHelp,    Spanish,1},
#ifdef APPLEMAC
  { "Ventana principal",                               StrMMainWin,  Spanish,0},
  { "Línea de comando",                                StrMCmndLin,  Spanish,0},
#endif
#else
  { "&Abrir ...",                                      StrMOpen,    Spanish,0},
  { "&Información",                                    StrMInfo,    Spanish,0},
  { "&Cerrar",                                         StrMClose,   Spanish,0},
  { "Im&primir",                                       StrMPrint,   Spanish,0},
  { "Con&figurar impresora",                           StrMPSetup,  Spanish,3},
  { "&Salir",                                          StrMExit,    Spanish,0},
  { "&Alambre",                                        StrMWirefr,  Spanish,0},
  { "&Esqueleto",                                      StrMBackbn,  Spanish,0},
  { "Bas&tones",                                       StrMSticks,  Spanish,3},
  { "Es&pacio Completo",                               StrMSpacefl, Spanish,2},
  { "&Bolas && Bastones",                              StrMBallStk, Spanish,0},
  { "&Cintas",                                         StrMRibbons, Spanish,0},
  { "&Hebras",                                         StrMStrands, Spanish,0},
  { "&Dibujo",                                         StrMCartoon, Spanish,0},
  { "Superficie &Molecular",                           StrMMolSurf, Spanish,11},
  { "&Monocromo",                                      StrMMonochr, Spanish,0},
  { "&CPK",                                            StrMCPK,     Spanish,0},
  { "&Forma",                                          StrMShapely, Spanish,0},
  { "&Grupo",                                          StrMGroup,   Spanish,0},
  { "Ca&dena",                                         StrMChain,   Spanish,2},
  { "&Temperatura",                                    StrMTemp,    Spanish,0},
  { "Est&ructura",                                     StrMStruct,  Spanish,3},
  { "&Usuario",                                        StrMUser,    Spanish,0},
  { "Mo&delo",                                         StrMModel,   Spanish,2},
  { "&Alt",                                            StrMAlt,     Spanish,0},
  { "Modo A&serrado",                                  StrMSlab,    Spanish,6},
  { "H&idrógenos",                                     StrMHydr,    Spanish,1},
  { "He&teroátomos",                                   StrMHet,     Spanish,2},
  { "Es&pecular",                                      StrMSpec,    Spanish,2},
  { "So&mbras",                                        StrMShad,    Spanish,2},
  { "Estere&o",                                        StrMStereo,  Spanish,6},
  { "Eti&quetas",                                      StrMLabel,   Spanish,3},
  { "&Desactivar elección",                            StrMPOff,    Spanish,0},
  { "Elegir &identificación",                          StrMPIdent,  Spanish,7},
  { "Elegir di&stancia",                               StrMPDist,   Spanish,9},
  { "Elegir monito&r",                                 StrMPMon,    Spanish,13},
  { "Elegir á&ngulo",                                  StrMPAng,    Spanish,8},
  { "Elegir &torsiones",                               StrMPTrsn,   Spanish,7},
  { "Elegir eti&queta",                                StrMPLabl,   Spanish,10}, 
  { "Elegir &centro",                                  StrMPCent,   Spanish,7},
  { "Elegir c&oordenadas",                             StrMPCoord,  Spanish,8},
  { "Elegir &enlace",                                  StrMPBond,   Spanish,7},
  { "&Girar enlace",                                   StrMRBond,   Spanish,0},
  { "Girar &molécula",                                 StrMRMol,    Spanish,6},
  { "Girar &todo",                                     StrMRAll,    Spanish,6},
  { "&BMP ...",                                        StrMBMP,     Spanish,0},  
  { "&GIF ...",                                        StrMGIF,     Spanish,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Spanish,5},  
  { "PP&M ...",                                        StrMPPM,     Spanish,2},  
  { "&Sun Raster...",                                  StrMSRast,   Spanish,0},  
  { "&PostScript...",                                  StrMPostscr, Spanish,0},  
  { "P&ICT...",                                        StrMPICT,    Spanish,1},  
  { "&Vector PS ...",                                  StrMVECPS,   Spanish,0},  
  { "M&olscript ...",                                  StrMMSCR,    Spanish,1},  
  { "&Kinemage ...",                                   StrMKine,    Spanish,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  Spanish,2},  
  { "VRM&L ...",                                       StrMVRML,    Spanish,3},  
  { "Ram&achandran ...",                               StrMRPP,     Spanish,3},  
  { "Raster&3D ...",                                   StrMR3D,     Spanish,6},  
  { "RasMol S&cript ...",                              StrMSCR,     Spanish,8},  
  { "&Acerca del RasMol...",                           StrMAbout,   Spanish,0},
  { "&Manual del Usuario...",                          StrMUserM,   Spanish,0},
  { "&Deshacer",                                       StrMUndo,    Spanish,0},
  { "Co&rtar",                                         StrMCut,     Spanish,2},
  { "C&opiar",                                         StrMCopy,    Spanish,1},
  { "&Pegar",                                          StrMPaste,   Spanish,0},
  { "&Borrar",                                         StrMDelete,  Spanish,0},
  { "&Seleccionar todo",                               StrMSelAll,  Spanish,0},
  { "&Archivo",                                        StrMFile,    Spanish,0},
  { "&Editar",                                         StrMEdit,    Spanish,0},
  { "&Mostrar",                                        StrMDisplay ,Spanish,0},
  { "&Colores",                                        StrMColour,  Spanish,0},
  { "&Opciones",                                       StrMOpt,     Spanish,0},
  { "Con&figuraciones",                                StrMSettings,Spanish,3},
  { "E&xportar",                                       StrMExport,  Spanish,1},
  { "A&yuda",                                          StrMHelp,    Spanish,1},
#endif
  { "Nombre del archivo PDB:",                         StrPrmtPDB,  Spanish,0},
  { "Nombre del archivo de imagen:",                   StrPrmtImg,  Spanish,0},
  { "Nombre del archivo de molécula:",                 StrPrmtMol,  Spanish,0},
  { "Cuidado: ",                                       StrWarn,     Spanish,0},
  { "Cadena",                                          StrChain,    Spanish,0},
  { "Para registrarse",                                StrRegister, Spanish,0}, 
  { "Para donar",                                      StrDonate,   Spanish,0}, 
  { "No muestran este diálogo al comienzo",            StrNoShow,   Spanish,0}, 
  { "Ninguna garantía, Open Source, GPL, donaciones apreciadas", StrWarranty, Spanish, 0},


  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Italian,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Italian,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Italian,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Italian,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Italian,0},

  { "Sintassi del comando errata!\n",                  ErrSyntax,   Italian,0},
  { "Valore del parametro troppo grande!\n",           ErrBigNum,   Italian,0},
  { "Parametro di impostazione non valido!\n",         ErrBadOpt,   Italian,0},
  { "Nome del parametro non valido!\n",                ErrParam,    Italian,0},
  { "Stringa col nome del documento richiesta!\n",     ErrFilNam,   Italian,0},
  { "Archivio della molecola caricato!\n",             ErrBadLoad,  Italian,0},
  { "Valore intero richiesto!\n",                      ErrNotNum,   Italian,0},
  { "Virgola di separazione richiesta!\n",             ErrNotSep,   Italian,0},
  { "Parentesi chiusa ']' richiesta!\n",               ErrNotBrac,  Italian,0},
  { "Colore non specificato!\n",                       ErrNoCol,    Italian,0},
  { "Colore non corretto o non specificato!\n",        ErrColour,   Italian,0},
  { "Argomento del comando non corretto!\n",           ErrBadArg,   Italian,0},
  { "Errore di sintassi nell'espressione!\n",          ErrBadExpr,  Italian,0},
  { "Parentesi chiusa ')' richiesta!\n",               ErrParen,    Italian,0},
  { "La pila dei comandi  troppo profonda!\n",        ErrScript,   Italian,0},
  { "Parentesi aperta '(' richiesta!\n",               ErrFunc,     Italian,0},
  { "Nome set atomo non valido o assente!\n",          ErrSetName,  Italian,0},
  { "Memoria insufficiente per definire set!\n",       ErrBadSet,   Italian,0},
  { "Comando disabilitato nel documento di script!\n", ErrInScrpt,  Italian,0},
  { "Comando non valido (valido solo dentro uno script)!\n", ErrOutScrpt, Italian,0},
  { "Archivio della molecola non caricato!\n",         ErrBadMolDB, Italian,0},
  { "Legame per rotazione non selezionato\n",          ErrNoBond,   Italian,0},
  { "Errore: Documento '",                             StrErrFile,  Italian,0},
  { "' non trovato!\n\n",                              StrNotFnd,   Italian,0},
  { "Errore: Formato di compressione non riconosciuto!\n\n", StrCFmt,     Italian,0},
  { "Errore: Incapace di decomprimere il documento!\n\n", StrDcmp,     Italian,0},
  { "Script di linea di comando troppo lungo!\n",      StrSLong,    Italian,0},
  { "Errore di comando: Memoria insufficiente!",       StrSMem,     Italian,0},
  { "Incapace di trovare il documento dell'aiuto di RasMol!\n", StrHFil,     Italian,0},
  { "Richiesta di argomento di aiuto ambiguo!\n",      StrHTop,     Italian,0},
  { "Argomento di aiuto non disponibile!\n",           StrHNone,    Italian,0},
  { "Errore di comando: Incapace di riaprire documento di aiuto!\n", StrHROpn,    Italian,0},
  { "Costante di stringa non terminata!\n",            StrCTerm,    Italian,0},
  { "Costante di stringa troppo lunga!\n",             StrCLong,    Italian,0},
  { "Numero in virgola mobile non valido!\n",          StrFNum,     Italian,0},
  { "Non ci sono atomi da centrare!\n",                StrCent,     Italian,0},
  { "Incapace di copiare nel blocco appunti!\n",       StrCClip,    Italian,0},
  { "Non si pu aprire un file di punti '",            StrDFile,    Italian,0},
  { "Attenzione: Stampante non disponibile!\n",        StrNPrint,   Italian,0},
  { "Cella Unitaria",                                  StrUCell,    Italian,0},
  { "Gruppo Spaziale",                                 StrSGroup,   Italian,0},
  { "Assenza dati simmetria del cristallo\n",          StrSymm,     Italian,0},
  { "Comando non riconosciuto!\n",                     StrUnrec,    Italian,0},
  { "Attenzione: si ignora la restante parte del comando!\n",StrIgnore,   Italian,0},
  { "Attenzione: comando remoto troppo lungo!\n",      StrRCLong,   Italian,0},
  { "Impossibile aprire documento di script '",        StrSFile,    Italian,0},
  { "Identificatore troppo lungo!\n",                  StrILong,    Italian,0},
  { "Nome della Molecola ... ",                        StrMolNam,   Italian,0},
  { "Classificazione ....... ",                        StrClass,    Italian,0},
  { "Struttura Secondaria .. ",                        StrSecSt,    Italian,0},
  { "Nessuna assegnazione\n",                          StrNoAsmt,   Italian,0},
  { "Registro PDB\n",                                  StrPDBRec,   Italian,0},
  { "Calcolato\n",                                     StrCalc,     Italian,0},
  { "Codice di database .... ",                        StrDBCode,   Italian,0},
  { "Tecnica sperimentale .. ",                        StrExpTec,   Italian,0},
  { "Numero di Catene ...... ",                        StrNumChn,   Italian,0},
  { "Numero di Gruppi ...... ",                        StrNumGrp,   Italian,0},
  { "Numero di Atomi ....... ",                        StrNumAtm,   Italian,0},
  { "Numero di Legami ...... ",                        StrNumBnd,   Italian,0},
  { "Numero di Ponti S-S ... ",                        StrNumBrg,   Italian,0},
  { "Numero di Legami-H .... ",                        StrNumHbd,   Italian,0},
  { "Numero di Eliche ...... ",                        StrNumHel,   Italian,0},
  { "Numero di Foglietti ... ",                        StrNumStrnd, Italian,0},
  { "Numero di Turns ....... ",                        StrNumTrn,   Italian,0},
  { "Assegnazione di memoria fallita",                 StrMalloc,   Italian,0},
  { "Troppi residui nuovi",                            StrXSRes,    Italian,0},
  { "Troppi tipi di atomi nuovi",                      StrXSAtyp,   Italian,0},
#ifndef MSWIN
  { "Apri...",                                         StrMOpen,    Italian,0},
  { "Salva col nome...",                               StrMSaveAs,  Italian,0},
  { "Chiudi",                                          StrMClose,   Italian,0},
  { "",                                                StrMEmpty,   Italian,0},
#ifdef APPLEMAC
  { "Imposta pagina",                                  StrMPSetup,  Italian,0},
  { "Stampa",                                          StrMPrint,   Italian,0},
  { "Esci",                                            StrMExit,    Italian,0},
#else
  { "Esci",                                            StrMExit,    Italian,0},
#endif
  { "Fildiferro",                                      StrMWirefr,  Italian,0},
  { "Scheletro",                                       StrMBackbn,  Italian,0},
  { "Bastoncini",                                      StrMSticks,  Italian,3},
  { "Riempimento spaziale",                            StrMSpacefl, Italian,2},
  { "Palle e Bastoncini",                              StrMBallStk, Italian,0},
  { "Nastri",                                          StrMRibbons, Italian,0},
  { "Fili",                                            StrMStrands, Italian,0},
  { "Vignetta",                                        StrMCartoon, Italian,0},
  { "Superficie Molecolare",                           StrMMolSurf, Italian,11},
  { "Monocromatico",                                   StrMMonochr, Italian,0},
  { "CPK",                                             StrMCPK,     Italian,0},
  { "Forma",                                           StrMShapely, Italian,0},
  { "Gruppo",                                          StrMGroup,   Italian,0},
  { "Catena",                                          StrMChain,   Italian,2},
  { "Temperatura",                                     StrMTemp,    Italian,0},
  { "Struttura",                                       StrMStruct,  Italian,3},
  { "Utente",                                          StrMUser,    Italian,0},
  { "Modello",                                         StrMModel,   Italian,2},
  { "Alt",                                             StrMAlt,     Italian,0},
  { "Appiattito",                                      StrMSlab,    Italian,6},
  { "Idrogeni",                                        StrMHydr,    Italian,1},
  { "Eteroatomi",                                      StrMHet,     Italian,2},
  { "Speculare",                                       StrMSpec,    Italian,2},
  { "Ombre",                                           StrMShad,    Italian,2},
  { "Stereo",                                          StrMStereo,  Italian,5},
  { "Etichette",                                       StrMLabel,   Italian,3},
  { "Elimina selezione",                               StrMPOff,    Italian,14},
  { "Identifica",                                      StrMPIdent,  Italian,0},
  { "Seleziona distanza",                              StrMPDist,   Italian,10},
  { "Seleziona monitor",                               StrMPMon,    Italian,0},
  { "Seleziona angolo",                                StrMPAng,    Italian,11},
  { "Seleziona torsione",                              StrMPTrsn,   Italian,10},
  { "Seleziona etichetta",                             StrMPLabl,   Italian,14}, 
  { "Seleziona centro",                                StrMPCent,   Italian,10},
  { "Seleziona coordinate",                            StrMPCoord,  Italian,11},
  { "Seleziona legame",                                StrMPBond,   Italian,10},
  { "Ruota legame",                                    StrMRBond,   Italian,0},
  { "Ruota molecola",                                  StrMRMol,    Italian,6},
  { "Ruota tutto",                                     StrMRAll,    Italian,6},
  { "BMP ...",                                         StrMBMP,     Italian,0},  
  { "GIF ...",                                         StrMGIF,     Italian,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Italian,5},  
  { "PPM ...",                                         StrMPPM,     Italian,2},  
  { "Sun Raster...",                                   StrMSRast,   Italian,0},  
  { "PostScript...",                                   StrMPostscr, Italian,0},  
  { "PICT...",                                         StrMPICT,    Italian,1},  
  { "Vector PS ...",                                   StrMVECPS,   Italian,0},  
  { "Molscript ...",                                   StrMMSCR,    Italian,1},  
  { "Kinemage ...",                                    StrMKine,    Italian,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  Italian,2},  
  { "VRML ...",                                        StrMVRML,    Italian,3},  
  { "Ramachandran ...",                                StrMRPP,     Italian,3},  
  { "Raster3D ...",                                    StrMR3D,     Italian,6},  
  { "RasMol Script ...",                               StrMSCR,     Italian,8},  
  { "Informazioni su RasMol...",                       StrMAbout,   Italian,0},
  { "Manuale utente...",                               StrMUserM,   Italian,0},
  { "Annulla",                                         StrMUndo,    Italian,0},
  { "Taglia",                                          StrMCut,     Italian,2},
  { "Copia",                                           StrMCopy,    Italian,1},
  { "Incolla",                                         StrMPaste,   Italian,0},
#ifdef APPLEMAC
  { "Cancella",                                        StrMClear,   Italian,0},
#else
  { "Elimina",                                         StrMDelete,  Italian,0},
#endif
  { "Seleziona tutto",                                 StrMSelAll,  Italian,0},
  { "Archivio",                                        StrMFile,    Italian,0},
  { "Modifica",                                        StrMEdit,    Italian,0},
  { "Mostra",                                          StrMDisplay ,Italian,0},
  { "Colori",                                          StrMColour,  Italian,0},
  { "Opzioni",                                         StrMOpt,     Italian,0},
  { "Impostazioni",                                    StrMSettings,Italian,3},
  { "Esporta",                                         StrMExport,  Italian,1},
#ifdef APPLEMAC
  { "Finestra",                                        StrMWindow,  Italian,0},
#endif
  { "Aiuto",                                           StrMHelp,    Italian,1},
#ifdef APPLEMAC
  { "Finestra Principale",                             StrMMainWin,  Italian,0},
  { "Linea di Comando",                                StrMCmndLin,  Italian,0},
#endif
#else
  { "&Apri ...",                                       StrMOpen,    Italian,0},
  { "&Informazione",                                   StrMInfo,    Italian,0},
  { "&Chiudi",                                         StrMClose,   Italian,0},
  { "St&ampa",                                         StrMPrint,   Italian,0},
  { "Imp&osta pagina",                                 StrMPSetup,  Italian,3},
  { "&Esci",                                           StrMExit,    Italian,0},
  { "&Fildiferro",                                     StrMWirefr,  Italian,0},
  { "&Scheletro",                                      StrMBackbn,  Italian,0},
  { "Bas&toncini",                                     StrMSticks,  Italian,3},
  { "Ri&empimento spaziale",                           StrMSpacefl, Italian,2},
  { "&Palle e Bastoncini",                             StrMBallStk, Italian,0},
  { "&Nastri",                                         StrMRibbons, Italian,0},
  { "&Fili",                                           StrMStrands, Italian,0},
  { "&Vignetta",                                       StrMCartoon, Italian,0},
  { "Superficie &Molecolare",                          StrMMolSurf, Italian,11},
  { "&Monocromatico",                                  StrMMonochr, Italian,0},
  { "&CPK",                                            StrMCPK,     Italian,0},
  { "&Forma",                                          StrMShapely, Italian,0},
  { "&Gruppo",                                         StrMGroup,   Italian,0},
  { "Ca&tena",                                         StrMChain,   Italian,2},
  { "&Temperatura",                                    StrMTemp,    Italian,0},
  { "Str&uttura",                                      StrMStruct,  Italian,3},
  { "&Utente",                                         StrMUser,    Italian,0},
  { "Mo&dello",                                        StrMModel,   Italian,2},
  { "&Alt",                                            StrMAlt,     Italian,0},
  { "Appiat&tito",                                     StrMSlab,    Italian,6},
  { "I&drogeni",                                       StrMHydr,    Italian,1},
  { "Et&eroatomi",                                     StrMHet,     Italian,2},
  { "&Speculare",                                      StrMSpec,    Italian,0},
  { "Om&bre",                                          StrMShad,    Italian,2},
  { "Stere&o",                                         StrMStereo,  Italian,5},
  { "Eti&chette",                                      StrMLabel,   Italian,3},
  { "Disattiva sele&zione",                            StrMPOff,    Italian,14},
  { "&Identifica",                                     StrMPIdent,  Italian,0},
  { "Seleziona &distanza",                             StrMPDist,   Italian,10},
  { "&Seleziona monitor",                              StrMPMon,    Italian,0},
  { "Seleziona a&ngolo",                               StrMPAng,    Italian,11},
  { "Seleziona &torsione",                             StrMPTrsn,   Italian,10},
  { "Seleziona etic&hetta",                            StrMPLabl,   Italian,14}, 
  { "Seleziona &centro",                               StrMPCent,   Italian,10},
  { "Seleziona c&oordinate",                           StrMPCoord,  Italian,11},
  { "Seleziona &legame",                               StrMPBond,   Italian,10},
  { "&Ruota legame",                                   StrMRBond,   Italian,0},
  { "Ruota &molecola",                                 StrMRMol,    Italian,6},
  { "Ruota &tutto",                                    StrMRAll,    Italian,6},
  { "&BMP ...",                                        StrMBMP,     Italian,0},  
  { "&GIF ...",                                        StrMGIF,     Italian,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Italian,5},  
  { "PP&M ...",                                        StrMPPM,     Italian,2},  
  { "&Sun Raster...",                                  StrMSRast,   Italian,0},  
  { "&PostScript...",                                  StrMPostscr, Italian,0},  
  { "P&ICT...",                                        StrMPICT,    Italian,1},  
  { "&Vector PS ...",                                  StrMVECPS,   Italian,0},  
  { "M&olscript ...",                                  StrMMSCR,    Italian,1},  
  { "&Kinemage ...",                                   StrMKine,    Italian,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  Italian,2},  
  { "VRM&L ...",                                       StrMVRML,    Italian,3},  
  { "Ram&achandran ...",                               StrMRPP,     Italian,3},  
  { "Raster&3D ...",                                   StrMR3D,     Italian,6},  
  { "RasMol S&cript ...",                              StrMSCR,     Italian,8},  
  { "&Informazioni su RasMol...",                      StrMAbout,   Italian,0},
  { "&Manuale utente...",                              StrMUserM,   Italian,0},
  { "&Annulla",                                        StrMUndo,    Italian,0},
  { "Ta&glia",                                         StrMCut,     Italian,2},
  { "C&opia",                                          StrMCopy,    Italian,1},
  { "&Incolla",                                        StrMPaste,   Italian,0},
  { "&Cancella",                                       StrMDelete,  Italian,0},
  { "&Seleziona tutto",                                StrMSelAll,  Italian,0},
  { "&Archivio",                                       StrMFile,    Italian,0},
  { "&Modifica",                                       StrMEdit,    Italian,0},
  { "&Mostra",                                         StrMDisplay ,Italian,0},
  { "&Colori",                                         StrMColour,  Italian,0},
  { "&Opzioni",                                        StrMOpt,     Italian,0},
  { "Con&figurazione",                                 StrMSettings,Italian,3},
  { "E&sporta",                                        StrMExport,  Italian,1},
  { "A&iuto",                                          StrMHelp,    Italian,1},
#endif
  { "Nome documento PDB:",                             StrPrmtPDB,  Italian,0},
  { "Nome documento immagine:",                        StrPrmtImg,  Italian,0},
  { "Nome documento molecola:",                        StrPrmtMol,  Italian,0},
  { "Attenzione: ",                                    StrWarn,     Italian,0},
  { "Catena",                                          StrChain,    Italian,0},
  { "Per registrarsi",                                 StrRegister, Italian, 0},
  { "Per donare",                                      StrDonate,   Italian, 0}, 
  { "Non mostrare questo dialogo all'avviamento",      StrNoShow,   Italian, 0}, 
  { "Nessuna garanzia, Open Source, GPL, donazioni apprezzate", StrWarranty, Italian, 0},


  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, French,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  French,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, French,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  French,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, French,0},

  { "Syntaxe de commande incorrecte!\n",               ErrSyntax,   French ,0},
  { "Valeur du paramètre trop grande!\n",              ErrBigNum,   French ,0},
  { "Valeur du paramètre incorrecte!\n",               ErrBadOpt,   French ,0},
  { "Nom du paramètre incorrect!\n",                   ErrParam,    French ,0},
  { "Un nom de fichier est attendu!\n",                ErrFilNam,   French ,0},
  { "Base de données de molécules chargée!\n",         ErrBadLoad,  French ,0},
  { "Une valeur entière est attendue!\n",              ErrNotNum,   French ,0},
  { "Manque une virgule de séparation!\n",             ErrNotSep,   French ,0},
  { "Manque un crochet fermant ']'!\n",                ErrNotBrac,  French ,0},
  { "Aucune couleur n'a été spécifiée!\n",             ErrNoCol,    French ,0},
  { "Couleur incorrecte ou inconnue!\n",               ErrColour,   French ,0},
  { "Argument de commande invalide!\n",                ErrBadArg,   French ,0},
  { "Erreur de syntaxe dans l'expression!\n",          ErrBadExpr,  French ,0},
  { "Une parenthèse fermante ')' est attendue!\n",     ErrParen,    French ,0},
  { "La pile de commande est trop profonde!\n",        ErrScript,   French ,0},
  { "Une parenthèse ouvrante '(' est attendue!\n",     ErrFunc,     French ,0},
  { "Nom d'atome invalide ou erroné!\n",               ErrSetName,  French ,0},
  { "Mémoire insuffisante pour définir l'ensemble!\n", ErrBadSet,   French ,0},
  { "Commande désactivée dans le fichier de script!\n", ErrInScrpt,  French ,0},
  { "Commande invalide (le serait seulement dans un script)!\n", ErrOutScrpt, French ,0},
  { "Base de données de molécules non chargée!\n",     ErrBadMolDB, French ,0},
  { "Liaison de tourner non choisi!\n",                ErrNoBond,   French ,0},
  { "Erreur: Fichier '",                               StrErrFile,  French ,0},
  { "' non trouvé!\n\n",                               StrNotFnd,   French ,0},
  { "Erreur: Format de compression non reconnu!\n\n",  StrCFmt,     French ,0},
  { "Erreur: Impossible de décompresser le fichier!\n\n", StrDcmp,     French ,0},
  { "Ligne de command de script trop longue!\n",       StrSLong,    French ,0},
  { "Erreur de commande: Mémoire inuffisante!\n",      StrSMem,     French ,0},
  { "Impossible de trouver le fichier d'aide sur RasMol!\n",  StrHFil,     French ,0},
  { "Requête d'aide thématique ambigüe!\n",            StrHTop,     French ,0},
  { "Pas d'aide disponible sur le thème requis!\n",    StrHNone,    French ,0},
  { "Erreur de commande: Impossible de réouvrir le fichier d'aide!\n",   StrHROpn,    French ,0},
  { "Chaîne de caractères non terminée!\n",            StrCTerm,    French ,0},
  { "Chaîne de caractères trop longue!\n",             StrCLong,    French ,0},
  { "Nombre à virgule flottante invalide!\n",          StrFNum,     French ,0},
  { "Aucun atome à recentrer!\n",                      StrCent,     French ,0},
  { "Impossible de copier le porte-papiers!\n",        StrCClip,    French ,0},
  { "Impossible d'ouvrir le fichier de points '",      StrDFile,    French ,0},
  { "Avertissement: Aucune imprimante disponible!\n",  StrNPrint,   French ,0},
  { "Cellule Unité",                                   StrUCell,    French ,0},
  { "Groupe Spatial",                                  StrSGroup,   French ,0},
  { "Pas de données de symétrie du cristal!\n",        StrSymm,     French ,0},
  { "Commande non reconnue!\n",                        StrUnrec,    French ,0},
  { "Avertissement: Reste de la commande ignorée!\n",  StrIgnore,   French ,0},
  { "Avertissement: Command indirecte trop longue!\n", StrRCLong,   French ,0},
  { "Impossible d'ouvrir le fichier de script file '", StrSFile,    French ,0},
  { "Identificateur trop long!\n",                     StrILong,    French ,0},
  { "Nom de la molécule .... ",                        StrMolNam,   French ,0},
  { "Classification ........ ",                        StrClass,    French ,0},
  { "Structure Secondaire... ",                        StrSecSt,    French ,0},
  { "Non assigné\n",                                   StrNoAsmt,   French ,0},
  { "Registre PDB\n",                                  StrPDBRec,   French ,0},
  { "Calculé\n",                                       StrCalc,     French ,0},
  { "Code de Base de Données ",                        StrDBCode,   French ,0},
  { "Technique expérim.  ... ",                        StrExpTec,   French ,0},
  { "Nombre de Chaînes ..... ",                        StrNumChn,   French ,0},
  { "Nombre de Groupes ..... ",                        StrNumGrp,   French ,0},
  { "Nombre d'Atomes ....... ",                        StrNumAtm,   French ,0},
  { "Nombre de Liaisons .... ",                        StrNumBnd,   French ,0},
  { "Nombre de Ponts ....... ",                        StrNumBrg,   French ,0},
  { "Nombre de Liaisons-H .. ",                        StrNumHbd,   French ,0},
  { "Nombre d'Hélices ...... ",                        StrNumHel,   French ,0},
  { "Nombre de Tresses ..... ",                        StrNumStrnd, French ,0},
  { "Nombre de Tours ....... ",                        StrNumTrn,   French ,0},
  { "Allocation mémoire défaillante",                  StrMalloc,   French ,0},
  { "Nouveaux résidus trop nombreux",                  StrXSRes,    French ,0},
  { "Nouveaux type d'atomes trop nombreux",            StrXSAtyp,   French ,0},
#ifndef MSWIN
  { "Ouvrir...",                                       StrMOpen,    French ,0},
  { "Sauver sous...",                                  StrMSaveAs,  French ,0},
  { "Fermer",                                          StrMClose,   French ,0},
  { "",                                                StrMEmpty,   French ,0},
#ifdef APPLEMAC
  { "Configuration des Pages",                         StrMPSetup,  French ,0},
  { "Imprimer",                                        StrMPrint,   French ,0},
  { "Quitter",                                         StrMExit,    French ,0},
#else
  { "Terminer",                                        StrMExit,    French ,0},
#endif
  { "Fil",                                             StrMWirefr,  French ,0},
  { "Squelette",                                       StrMBackbn,  French ,0},
  { "Bâtons",                                          StrMSticks,  French ,0},
  { "Espace réél occupé",                              StrMSpacefl, French ,0},
  { "Boules et Bâtons",                                StrMBallStk, French ,1},
  { "Rubans",                                          StrMRibbons, French ,0},
  { "Tresses",                                         StrMStrands, French ,0},
  { "Ebauches",                                        StrMCartoon, French ,5},
  { "Surface Molécular",                               StrMMolSurf, French ,8},
  { "Monochrome",                                      StrMMonochr, French ,0},
  { "CPK",                                             StrMCPK,     French ,0},
  { "Forme",                                           StrMShapely, French ,0},
  { "Groupe",                                          StrMGroup,   French ,0},
  { "Chaîne",                                          StrMChain,   French ,1},
  { "Température",                                     StrMTemp,    French ,0},
  { "Structure",                                       StrMStruct,  French ,0},
  { "Utilisateur",                                     StrMUser,    French ,0},
  { "Modèle",                                          StrMModel,   French ,2},
  { "Alt",                                             StrMAlt,     French ,0},
  { "Vision en Coupe",                                 StrMSlab,    French ,10},
  { "Hydrogènes",                                      StrMHydr,    French ,1},
  { "Hétéroatomes",                                    StrMHet,     French ,0},
  { "Reflets",                                         StrMSpec,    French ,0},
  { "Ombres",                                          StrMShad,    French ,0},
  { "Stéréo",                                          StrMStereo,  French ,0},
  { "Labels",                                          StrMLabel,   French ,0},
  { "Désactiver Choix",                                StrMPOff,    French ,0},
  { "Activer Identification",                          StrMPIdent,  French ,8},
  { "Activer Distance",                                StrMPDist,   French ,8},
  { "Activer Moniteur",                                StrMPMon,    French ,8},
  { "Activer Angle",                                   StrMPAng,    French ,8},
  { "Activer Torsion",                                 StrMPTrsn,   French ,8},
  { "Activer Label",                                   StrMPLabl,   French ,8}, 
  { "Activer Centre",                                  StrMPCent,   French ,8},
  { "Activer Coord",                                   StrMPCoord,  French ,8},
  { "Activer Liaison",                                 StrMPBond,   French ,9},
  { "Tourner Liaison",                                 StrMRBond,   French ,10},
  { "Tourner Molécule",                                StrMRMol,    French ,9},
  { "Tourner Globalement",                             StrMRAll,    French ,8},
  { "BMP ...",                                         StrMBMP,     French ,0},  
  { "GIF ...",                                         StrMGIF,     French ,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    French ,5}, 
  { "PPM ...",                                         StrMPPM,     French ,2},  
  { "Sun Raster...",                                   StrMSRast,   French ,0},  
  { "PostScript...",                                   StrMPostscr, French ,0},  
  { "PICT...",                                         StrMPICT,    French ,1},  
  { "Vector PS ...",                                   StrMVECPS,   French ,0},  
  { "Molscript ...",                                   StrMMSCR,    French ,1},  
  { "Kinemage ...",                                    StrMKine,    French ,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  French ,2},  
  { "VRML ...",                                        StrMVRML,    French ,3},  
  { "Ramachandran ...",                                StrMRPP,     French ,3},  
  { "Raster3D ...",                                    StrMR3D,     French ,6},  
  { "RasMol Script ...",                               StrMSCR,     French ,8},  
  { "A propos de RasMol...",                           StrMAbout,   French ,0},
  { "Manual utilisateur...",                           StrMUserM,   French ,0},
  { "Annuler",                                         StrMUndo,    French ,0},
  { "Couper",                                          StrMCut,     French ,0},
  { "Copier",                                          StrMCopy,    French ,1},
  { "Coller",                                          StrMPaste,   French ,2},
#ifdef APPLEMAC
  { "Effacer",                                         StrMClear,   French ,0},
#else
  { "Détruire",                                        StrMDelete,  French ,0},
#endif
  { "Sélectionner tout",                               StrMSelAll,  French ,0},
  { "Fichier",                                         StrMFile,    French ,0},
  { "Editer",                                          StrMEdit,    French ,0},
  { "Montrer",                                         StrMDisplay, French ,0},
  { "Couleurs",                                        StrMColour,  French ,0},
  { "Options",                                         StrMOpt,     French ,0},
  { "Configuration",                                   StrMSettings,French ,3},
  { "Exporter",                                        StrMExport,  French ,1},
#ifdef APPLEMAC
  { "Fenêtre",                                         StrMWindow,  French ,0},
#endif
  { "Aide",                                            StrMHelp,    French ,0},
#ifdef APPLEMAC
  { "Fenêtre Principale",                              StrMMainWin,  French ,0},
  { "Ligne de Commande",                               StrMCmndLin,  French ,0},
#endif
#else
  { "&Ouvrir ...",                                     StrMOpen,    French ,0},
  { "&Information",                                    StrMInfo,    French ,0},
  { "&Fermer",                                         StrMClose,   French ,0},
  { "Im&primer",                                       StrMPrint,   French ,2},
  { "&Configuration des Pages",                        StrMPSetup,  French ,0},
  { "&Terminer",                                       StrMExit,    French ,0},
  { "&Fil",                                            StrMWirefr,  French ,0},
  { "&Squelette",                                      StrMBackbn,  French ,0},
  { "&Bâtons",                                         StrMSticks,  French ,0},
  { "&Espace réel occupé",                             StrMSpacefl, French ,0},
  { "B&oules et Bâtons",                               StrMBallStk, French ,1},
  { "&Ribbons",                                        StrMRibbons, French ,0},
  { "&Tresses",                                        StrMStrands, French ,0},
  { "Ebauc&hes",                                       StrMCartoon, French ,5},
  { "Surface &Molécular",                              StrMMolSurf, French ,8},
  { "&Monochrome",                                     StrMMonochr, French ,0},
  { "&CPK",                                            StrMCPK,     French ,0},
  { "&Forme",                                          StrMShapely, French ,0},
  { "&Groupe",                                         StrMGroup,   French ,0},
  { "C&haîne",                                         StrMChain,   French ,1},
  { "&Température",                                    StrMTemp,    French ,0},
  { "&Structure",                                      StrMStruct,  French ,0},
  { "&Utilisateur",                                    StrMUser,    French ,0},
  { "Mo&dèle",                                         StrMModel,   French ,2},
  { "&Alt",                                            StrMAlt,     French ,0},
  { "Vision en &Coupe",                                StrMSlab,    French ,10},
  { "H&ydrogènes",                                     StrMHydr,    French ,1},
  { "&Hétéroatomes",                                   StrMHet,     French ,0},
  { "&Reflets",                                        StrMSpec,    French ,0},
  { "&Ombres",                                         StrMShad,    French ,0},
  { "&Stéréo",                                         StrMStereo,  French ,0},
  { "&Labels",                                         StrMLabel,   French ,0},
  { "&Désactiver Choix",                               StrMPOff,    French ,0},
  { "Activer &Identification",                         StrMPIdent,  French ,8},
  { "Activer &Distance",                               StrMPDist,   French ,8},
  { "Activer &Moniteur",                               StrMPMon,    French ,8},
  { "Activer &Angle",                                  StrMPAng,    French ,8},
  { "Activer &Torsion",                                StrMPTrsn,   French ,8},
  { "Activer &Label",                                  StrMPLabl,   French ,8}, 
  { "Activer &Centre",                                 StrMPCent,   French ,8},
  { "Activer &Coord",                                  StrMPCoord,  French ,8},
  { "Activer L&iaison",                                StrMPBond,   French ,9},
  { "Tourner Li&aison",                                StrMRBond,   French ,10},
  { "Tourner M&olécule",                               StrMRMol,    French ,9},
  { "Tourner &Globalement",                            StrMRAll,    French ,8},
  { "&BMP ...",                                        StrMBMP,     French ,0},  
  { "&GIF ...",                                        StrMGIF,     French ,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    French ,5},  
  { "PP&M ...",                                        StrMPPM,     French ,2},  
  { "&Sun Raster...",                                  StrMSRast,   French ,0},  
  { "&PostScript...",                                  StrMPostscr, French ,0},  
  { "P&ICT...",                                        StrMPICT,    French ,1},  
  { "&Vector PS ...",                                  StrMVECPS,   French ,0},  
  { "M&olscript ...",                                  StrMMSCR,    French ,1},  
  { "&Kinemage ...",                                   StrMKine,    French ,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  French ,2},  
  { "VRM&L ...",                                       StrMVRML,    French ,3},  
  { "Ram&achandran ...",                               StrMRPP,     French ,3},  
  { "Raster&3D ...",                                   StrMR3D,     French ,6},  
  { "RasMol S&cript ...",                              StrMSCR,     French ,8},  
  { "&A propos de RasMol...",                          StrMAbout,   French ,0},
  { "&Manual utilisateur...",                          StrMUserM,   French ,0},
  { "&Annuler",                                        StrMUndo,    French ,0},
  { "&Couper",                                         StrMCut,     French ,0},
  { "C&opier",                                         StrMCopy,    French ,1},
  { "Co&ller",                                         StrMPaste,   French ,2},
  { "&Détruire",                                       StrMDelete,  French ,0},
  { "&Sélectionner tout",                              StrMSelAll,  French ,0},
  { "&Fichier",                                        StrMFile,    French ,0},
  { "&Editer",                                         StrMEdit,    French ,0},
  { "&Montrer",                                        StrMDisplay, French ,0},
  { "&Couleurs",                                       StrMColour,  French ,0},
  { "&Options",                                        StrMOpt,     French ,0},
  { "Con&figuration",                                  StrMSettings,French ,3},
  { "E&xporter",                                       StrMExport,  French ,1},
  { "&Aide",                                           StrMHelp,    French ,0},
#endif
  { "Nom du fichier PDB:",                             StrPrmtPDB,  French ,0},
  { "Nom du fichier Image:",                           StrPrmtImg,  French ,0},
  { "Nom du fichier de Molécule:",                     StrPrmtMol,  French ,0},
  { "Avertissement: ",                                 StrWarn,     French ,0},
  { "Chaîne",                                          StrChain,    French ,0},
  { "S'enregistrer",                                   StrRegister, French, 0}, 
  { "Donner",                                          StrDonate,   French, 0},
  { "Ne montrez pas ce dialogue au démarrage",         StrNoShow,   French, 0}, 
  { "Aucunes garantie, Open Source, GPL, donations appréciées", StrWarranty, French, 0},


  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Russian,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Russian,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Russian,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Russian,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Russian,0},

  { "Неверный синтаксис команды!\n",                   ErrSyntax,   Russian,0},
  { "Значение параметра слишком длинное!\n",           ErrBigNum,   Russian,0},
  { "Неверная установка параметра!\n",                 ErrBadOpt,   Russian,0},
  { "Неверное имя параметра!\n",                       ErrParam,    Russian,0},
  { "Ожидается строка имени файла!\n",                 ErrFilNam,   Russian,0},
  { "База данных о молекуле загружена!\n",             ErrBadLoad,  Russian,0},
  { "Ожидается целочисленное значение!\n",             ErrNotNum,   Russian,0},
  { "Пропущена разделительная запятая!\n",             ErrNotSep,   Russian,0},
  { "Ожидается закрытая скобка ']'!\n",                ErrNotBrac,  Russian,0},
  { "Не указано значение цвета!\n",                    ErrNoCol,    Russian,0},
  { "Неизвестное или неверно введённое значение цвета!\n", ErrColour,   Russian,0},
  { "Неверный аргумент команды!\n",                    ErrBadArg,   Russian,0},
  { "Синтаксическая ошибка в выражении!\n",            ErrBadExpr,  Russian,0},
  { "Ожидается закрытая скобка ')'!\n",                ErrParen,    Russian,0},
  { "Глубина команды слишком велика!\n",               ErrScript,   Russian,0},
  { "Ожидается открытая скобка '('!\n",                ErrFunc,     Russian,0},
  { "Неверное или пропущенное имя набора атомов!\n",   ErrSetName,  Russian,0},
  { "Недостаточно памяти для определения набора!\n",   ErrBadSet,   Russian,0},
  { "Команда в файле скрипта отключена!\n",            ErrInScrpt,  Russian,0},
  { "Команда неверна (действует только в скрипте)!\n", ErrOutScrpt, Russian,0},
  { "Не загружена база данных о молекуле!\n",          ErrBadMolDB, Russian,0},
  { "Связь для вращения не выделена!\n",               ErrNoBond,   Russian,0},
  { "Ошибка: файл '",                                  StrErrFile,  Russian,0},
  { "' не найден!\n\n",                                StrNotFnd,   Russian,0},
  { "Ошибка: неизвестный формат сжатия!\n\n",          StrCFmt,     Russian,0},
  { "Ошибка: невозможно распаковать файл!\n\n",        StrDcmp,     Russian,0},
  { "Командная строка скрипта слишком длинная!\n",     StrSLong,    Russian,0},
  { "Ошибка: недостаточно памяти!\n",                  StrSMem,     Russian,0},
  { "Файл справки RasMol не найден!\n",                StrHFil,     Russian,0},
  { "Неоднозначный запрос темы справки!\n",            StrHTop,     Russian,0},
  { "По запрошенной теме справка не найдена!\n",       StrHNone,    Russian,0},
  { "Командная ошибка: невозможно переоткрыть файл справки!\n", StrHROpn,    Russian,0},
  { "Незавершённая строковая константа!\n",            StrCTerm,    Russian,0},
  { "Слишком длинная строковая константа!\n",          StrCLong,    Russian,0},
  { "Неверное число с плавающей запятой!\n",           StrFNum,     Russian,0},
  { "Нет атомов для центрирования!\n",                 StrCent,     Russian,0},
  { "Невозможно копировать в буфер обмена!\n",         StrCClip,    Russian,0},
  { "Невозможно открыть файл точек '",                 StrDFile,    Russian,0},
  { "Предупреждение: подходящий принтер отсутствует!\n", StrNPrint,   Russian,0},
  { "Элементарная ячейка ",                             StrUCell,    Russian,0},
  { "Пространственная группа",                         StrSGroup,   Russian,0},
  { "Нет данных о симметрии кристалла!\n",             StrSymm,     Russian,0},
  { "Нераспознанная команда!\n",                       StrUnrec,    Russian,0},
  { "Предупреждение: конец команды игнорирован!\n",    StrIgnore,   Russian,0},
  { "Предупреждение: удалённая команда слишком длинная!\n",  StrRCLong,   Russian,0},
  { "Невозможно открыть файл скрипта '",               StrSFile,    Russian,0},
  { "Идентификатор слишком длинный!\n",                StrILong,    Russian,0},
  { "Название .............. ",                        StrMolNam,   Russian,0},
  { "Классификация ......... ",                        StrClass,    Russian,0},
  { "Вторичная структура ... ",                        StrSecSt,    Russian,0},
  { "Не присвоена\n",                                  StrNoAsmt,   Russian,0},
  { "Записи данных PDB\n",                             StrPDBRec,   Russian,0},
  { "Вычислено\n",                                     StrCalc,     Russian,0},
  { "Код базы данных ....... ",                        StrDBCode,   Russian,0},
  { "Экспериментальная методика .. ",                  StrExpTec,   Russian,0},
  { "Количество цепей ...... ",                        StrNumChn,   Russian,0},
  { "Количество групп ...... ",                        StrNumGrp,   Russian,0},
  { "Количество атомов ..... ",                        StrNumAtm,   Russian,0},
  { "Количество связей ..... ",                        StrNumBnd,   Russian,0},
  { "Количество S-S мостиков ",                        StrNumBrg,   Russian,0},
  { "Количество водородных связей  ",                  StrNumHbd,   Russian,0},
  { "Количество альфа-спиралей ... ",                  StrNumHel,   Russian,0},
  { "Количество бета-складок ..... ",                  StrNumStrnd, Russian,0},
  { "Количество бета-поворотов ... ",                  StrNumTrn,   Russian,0},
  { "Сбой определения места памяти",                   StrMalloc,   Russian,0},
  { "Слишком много остатков",                          StrXSRes,    Russian,0},
  { "Слишком много новых типов атомов",                StrXSAtyp,   Russian,0},
#ifndef MSWIN

  { "Открыть...",                                      StrMOpen,    Russian,0},
  { "Сохранить как...",                                StrMSaveAs,  Russian,0},
  { "Закрыть",                                         StrMClose,   Russian,0},
  { "",                                                StrMEmpty,   Russian,0},
#ifdef APPLEMAC

  { "Настройка печати",                                StrMPSetup,  Russian,0},
  { "Печать",                                          StrMPrint,   Russian,0},
  { "Выход",                                           StrMExit,    Russian,0},
#else

  { "Выход" ,                                           StrMExit,    Russian,0},
#endif

  { "Каркас",                                          StrMWirefr,  Russian,2},
  { "Скелет",                                          StrMBackbn,  Russian,0},
  { "Связи",                                           StrMSticks,  Russian,0},
  { "Ван-дер-Ваальсов радиус",                         StrMSpacefl, Russian,0},
  { "Атомы и связи",                                   StrMBallStk, Russian,0},
  { "Ленты",                                           StrMRibbons, Russian,0},
  { "Нити",                                            StrMStrands, Russian,0},
  { "Картон",                                          StrMCartoon, Russian,0},
  { "Молек. поверхность",                              StrMMolSurf, Russian,0},
  { "Чёрно-белый",                                     StrMMonochr, Russian,0},
  { "Хим. элемент",                                    StrMCPK,     Russian,0},
  { "Радикал",                                         StrMShapely, Russian,0},
  { "Индекс",                                          StrMGroup,   Russian,0},
  { "Цепь",                                            StrMChain,   Russian,2},
  { "Температура",                                     StrMTemp,    Russian,0},
  { "Структура",                                       StrMStruct,  Russian,0},
  { "Пользовательский",                                StrMUser,    Russian,4},
  { "Модель",                                          StrMModel,   Russian,2},
  { "Альтернативный",                                  StrMAlt,     Russian,1},
  { "Сечение",                                         StrMSlab,    Russian,0},
  { "Атомы H",                                         StrMHydr,    Russian,0},
  { "Гетероатомы",                                     StrMHet,     Russian,0},
  { "Зеркальная поверхность",                          StrMSpec,    Russian,0},
  { "Тени",                                            StrMShad,    Russian,0},
  { "Стерео",                                          StrMStereo,  Russian,3},
  { "Подписи",                                         StrMLabel,   Russian,0},
  { "Отключить выбор",                                 StrMPOff,    Russian,0},
  { "Название",                                        StrMPIdent,  Russian,0},
  { "Расстояние",                                      StrMPDist,   Russian,0},
  { "Монитор",                                         StrMPMon,    Russian,1},
  { "Угол",                                            StrMPAng,    Russian,0},
  { "Торсионный угол",                                 StrMPTrsn,   Russian,0},
  { "Метка",                                           StrMPLabl,   Russian,0}, 
  { "Выбор центра",                                    StrMPCent,   Russian,6},
  { "Координаты",                                      StrMPCoord,  Russian,0},
  { "Связь",                                           StrMPBond,   Russian,0},
  { "Вращать связь",                                   StrMRBond,   Russian,2},
  { "Вращать молекулу",                                StrMRMol,    Russian,10},
  { "Вращать всё",                                     StrMRAll,    Russian,8},
  { "BMP ...",                                         StrMBMP,     Russian,0},  
  { "GIF ...",                                         StrMGIF,     Russian,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Russian,5},  
  { "PPM ...",                                         StrMPPM,     Russian,2},  
  { "Sun Raster...",                                   StrMSRast,   Russian,0},  
  { "PostScript...",                                   StrMPostscr, Russian,0},  
  { "PICT...",                                         StrMPICT,    Russian,1},  
  { "Vector PS ...",                                   StrMVECPS,   Russian,0},  
  { "Molscript ...",                                   StrMMSCR,    Russian,1},  
  { "Kinemage ...",                                    StrMKine,    Russian,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  Russian,2},  
  { "VRML ...",                                        StrMVRML,    Russian,3},  
  { "Ramachandran ...",                                StrMRPP,     Russian,3},  
  { "Raster3D ...",                                    StrMR3D,     Russian,6},  
  { "RasMol Script ...",                               StrMSCR,     Russian,8},  
  { "О программе RasMol...",                           StrMAbout,   Russian,0},
  { "Руководство пользователя...",                     StrMUserM,   Russian,0},
  { "Отмена",                                          StrMUndo,    Russian,0},
  { "Вырезать",                                        StrMCut,     Russian,2},
  { "Копировать",                                      StrMCopy,    Russian,0},
  { "Вставить",                                        StrMPaste,   Russian,1},
#ifdef APPLEMAC
  { "Очистить",                                        StrMClear,   Russian,1},
#else
  { "Удалить",                                         StrMDelete,  Russian,1},
#endif  
  
  { "Выделить всё",                                    StrMSelAll,  Russian,9},
  { "Файл",                                            StrMFile,    Russian,0},
  { "Правка",                                          StrMEdit,    Russian,0},
  { "Вид",                                             StrMDisplay, Russian,0},
  { "Цвет",                                            StrMColour,  Russian,0},
  { "Опции",                                           StrMOpt,     Russian,0},
  { "Установка",                                       StrMSettings,Russian,0},
  { "Экспорт",                                         StrMExport,  Russian,0},
#ifdef APPLEMAC
  { "Окно",                                            StrMWindow,  Russian,0},
#endif
  { "Справка",                                         StrMHelp,    Russian,5},
#ifdef APPLEMAC
  { "Главное окно",                                    StrMMainWin,  Russian,0},
  { "Командная строка",                                StrMCmndLin,  Russian,0},
#endif
#else
  { "&Открыть ...",                                    StrMOpen,    Russian,0},
  { "&Информация",                                     StrMInfo,    Russian,0},
  { "&Закрыть",                                        StrMClose,   Russian,0},
  { "&Печать",                                         StrMPrint,   Russian,0},
  { "&Настройка печати",                               StrMPSetup,  Russian,0},
  { "Вы&ход",                                          StrMExit,    Russian,2},
  { "Ка&ркас",                                         StrMWirefr,  Russian,2},
  { "&Скелет",                                         StrMBackbn,  Russian,0},
  { "&Связи",                                          StrMSticks,  Russian,0},
  { "&Ван-дер-Ваальсов радиус",                        StrMSpacefl, Russian,0},
  { "&Атомы и связи",                                  StrMBallStk, Russian,0},
  { "&Ленты",                                          StrMRibbons, Russian,0},
  { "&Нити",                                           StrMStrands, Russian,0},
  { "&Картон",                                         StrMCartoon, Russian,0},
  { "&Молек. поверхность",                             StrMMolSurf, Russian,0},
  { "&Чёрно-белый",                                    StrMMonochr, Russian,0},
  { "&Хим. элемент",                                   StrMCPK,     Russian,0},
  { "&Радикал",                                        StrMShapely, Russian,0},
  { "&Индекс",                                         StrMGroup,   Russian,0},
  { "&Цепь",                                           StrMChain,   Russian,0},
  { "&Температура",                                    StrMTemp,    Russian,0},
  { "&Структура",                                      StrMStruct,  Russian,0},
  { "&Пользовательский",                               StrMUser,    Russian,4},
  { "&Модель",                                         StrMModel,   Russian,0},
  { "А&льтернативный",                                 StrMAlt,     Russian,1},
  { "&Сечение",                                        StrMSlab,    Russian,0},
  { "&Атомы H",                                        StrMHydr,    Russian,0},
  { "&Гетероатомы",                                    StrMHet,     Russian,0},
  { "&Зеркальная поверхность",                         StrMSpec,    Russian,0},
  { "&Тени",                                           StrMShad,    Russian,0},
  { "Сте&рео",                                         StrMStereo,  Russian,3},
  { "&Подписи",                                        StrMLabel,   Russian,0},
  { "&Отключить выбор",                                StrMPOff,    Russian,0},
  { "&Название",                                       StrMPIdent,  Russian,0},
  { "&Растояние",                                      StrMPDist,   Russian,0},
  { "М&онитор",                                        StrMPMon,    Russian,1},
  { "&Угол",                                           StrMPAng,    Russian,0},
  { "&Торсионный угол",                                StrMPTrsn,   Russian,0},
  { "&Метка",                                          StrMPLabl,   Russian,0}, 
  { "Выбор &центра",                                   StrMPCent,   Russian,6},
  { "&Координаты",                                     StrMPCoord,  Russian,0},
  { "&Связь",                                          StrMPBond,   Russian,0},
  { "Вр&ащать связь",                                  StrMRBond,   Russian,2},
  { "Вращать мо&лекулу",                               StrMRMol,    Russian,10},
  { "Вращать &всё",                                    StrMRAll,    Russian,8},
  { "&BMP ...",                                        StrMBMP,     Russian,0},  
  { "&GIF ...",                                        StrMGIF,     Russian,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Russian,5},  
  { "PP&M ...",                                        StrMPPM,     Russian,2},  
  { "&Sun Raster...",                                  StrMSRast,   Russian,0},  
  { "&PostScript...",                                  StrMPostscr, Russian,0},  
  { "P&ICT...",                                        StrMPICT,    Russian,1},  
  { "&Vector PS ...",                                  StrMVECPS,   Russian,0},  
  { "M&olscript ...",                                  StrMMSCR,    Russian,1},  
  { "&Kinemage ...",                                   StrMKine,    Russian,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  Russian,2},  
  { "VRM&L ...",                                       StrMVRML,    Russian,3},  
  { "Ram&achandran ...",                               StrMRPP,     Russian,3},  
  { "Raster&3D ...",                                   StrMR3D,     Russian,6},  
  { "RasMol S&cript ...",                              StrMSCR,     Russian,8},  
  { "&О программе RasMol...",                          StrMAbout,   Russian,0},
  { "&Руководство пользователя...",                    StrMUserM,   Russian,0},
  { "&Отмена",                                         StrMUndo,    Russian,0},
  { "Вы&резать",                                       StrMCut,     Russian,2},
  { "&Копировать",                                     StrMCopy,    Russian,0},
  { "В&ставить",                                       StrMPaste,   Russian,1},
  { "У&далить",                                        StrMDelete,  Russian,1},
  { "Выделить &всё",                                   StrMSelAll,  Russian,0},
  { "&Файл",                                           StrMFile,    Russian,0},
  { "&Правка",                                         StrMEdit,    Russian,0},
  { "&Вид",                                            StrMDisplay, Russian,0},
  { "&Цвет",                                           StrMColour,  Russian,0},
  { "&Опции",                                          StrMOpt,     Russian,0},
  { "&Установки",                                      StrMSettings,Russian,0},
  { "&Экспорт",                                        StrMExport,  Russian,0},
  { "Справ&ка",                                        StrMHelp,    Russian,5},
#endif
  { "Имя файла PDB:",                                  StrPrmtPDB,  Russian,0},
  { "Имя файла рисунка:",                              StrPrmtImg,  Russian,0},
  { "Имя файла молекулы:",                             StrPrmtMol,  Russian,0},
  { "Предупреждение: ",                                StrWarn,     Russian,0},
  { "Цепь",                                            StrChain,    Russian,0},
  { "Регистрация",                                     StrRegister, Russian, 0},
  { "Пожертвование",                                   StrDonate,   Russian, 0},
  { "Не показывать это окно при запуске",              StrNoShow,   Russian, 0},
  { "Без гарантий, Open Source, GPL, пожертвования приветствуются", StrWarranty, Russian, 0},



  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Bulgarian,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Bulgarian,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Bulgarian,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Bulgarian,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Bulgarian,0},

  { "Невалиден команден синтаксис!\n",		       ErrSyntax,   Bulgarian,0},
  { "Твърде голяма стойност на параметъра\n!",	       ErrBigNum,   Bulgarian,0},
  { "Невалина настройка на параметъра!\n",	       ErrBadOpt,   Bulgarian,0},
  { "Невалидно име на параметъра!\n",		       ErrParam,    Bulgarian,0},
  { "Очаква се име на файл!\n",			       ErrFilNam,   Bulgarian,0},
  { "База данни на молекулата заредена!\n",	       ErrBadLoad,  Bulgarian,0},
  { "Очаква се цяло число!\n",			       ErrNotNum,   Bulgarian,0},
  { "Липсваща разделителна запетая!\n",		       ErrNotSep,   Bulgarian,0},
  { "Очаква се затваряща скоба ']'!\n", 	       ErrNotBrac,  Bulgarian,0},
  { "Не е зададен сцят!\n",			       ErrNoCol,    Bulgarian, 0},
  { "Неизвестен или невалиден цвят!\n",		       ErrColour,   Bulgarian,0},
  { "Невалиден команден аргумент!\n",		       ErrBadArg,   Bulgarian,0},
  { "Синтактична грешка във фразата!\n",	       ErrBadExpr,  Bulgarian,0},
  { "Очаква се затваряща скоба ')'!\n", 	       ErrParen,    Bulgarian,0},
  { "Дълбочината на командата е твърде голяма!\n",     ErrScript,   Bulgarian,0},
  { "Очаква се отваряща скоба '('!\n",                 ErrFunc,     Bulgarian,0},
  { "Невалидно или липсващо име на атомния сет!\n",    ErrSetName,  Bulgarian, 0},
  { "Няна дистатъчно памет за дефиниране на сета!\n",  ErrBadSet,   Bulgarian,0},
  { "Командата е изключена в скриптовия файл!\n",      ErrInScrpt,  Bulgarian,0},
  { "Командата е невалидна (валидна е само в скрипт)!\n", ErrOutScrpt, Bulgarian,0},
  { "База данни на молекулата не е заредена!\n",       ErrBadMolDB, Bulgarian,0},
  { "Не е избрана връзка за въртене!\n",	       ErrNoBond,   Bulgarian,0},
  { "Грешка: файлът '",				       StrErrFile,  Bulgarian,0},
  { ", не е намерен!\n\n",			       StrNotFnd,   Bulgarian,0},
  { "Грешка: Непознат формат за компресия!\n\n",       StrCFmt,     Bulgarian,0},
  { "Грешка: невъзможно разархивиране на файла!\n\n",  StrDcmp,     Bulgarian,0},
  { "Командният ред в скрипта е твърде дълъг!\n",      StrSLong,    Bulgarian,0},
  { "Грешка: Недостатъчно памет!\n\n",		       StrSMem,     Bulgarian,0},
  { "Помощният файл на РасМол не e намерен!\n\n",      StrHFil,     Bulgarian,0},
  { "Двусмислена тема за помощ!\n",		       StrHTop,     Bulgarian,0},
  { "Няма намерена помощ по темата!\n",		       StrHNone,    Bulgarian,0},
  { "Грешка в командата: невъзможно преотваряне на помощният файл!\n", StrHROpn,    Bulgarian,0},
  { "Незавършена стринг константа!\n",		       StrCTerm,    Bulgarian,0},
  { "Стринг константата е твърде дълга!\n",	       StrCLong,    Bulgarian,0},
  { "Невалидно число с плаваща запетая!\n",	       StrFNum,     Bulgarian,0},
  { "Няма атоми за центриране!\n",		       StrCent,     Bulgarian,0},
  { "Невъзможно е копирането в клиборд!\n",	       StrCClip,    Bulgarian,0},
  { "Невъзможно отварянето на файл точки '",	       StrDFile,    Bulgarian,0},
  { "Внимание: няма подходящ принтер!\n",	       StrNPrint,   Bulgarian,0},
  { "Единица клетка",    			       StrUCell,    Bulgarian,0},
  { "Пространствена група",			       StrSGroup,   Bulgarian,0},
  { "Няма данни за кристална симетрия!\n",	       StrSymm,     Bulgarian,0},
  { "Неразпозната команда!\n",			       StrUnrec,    Bulgarian,0},
  { "Внимание: Игнориране на остатъкът от командата!\n",StrIgnore,   Bulgarian,0},
  { "Внимание: Отдалечената команда е твърде дълга!\n",StrRCLong,   Bulgarian,0},
  { "Невъзможно отварянето на скриптовя файл '",       StrSFile,    Bulgarian,0},
  { "идентификаторът е твърде дълъг!\n",	       StrILong,    Bulgarian,0},
  { "Име на молекулата ..... ",			       StrMolNam,   Bulgarian,0},
  { "Класификация .......... ",			       StrClass,    Bulgarian,0},
  { "Вторична структура .... ",			       StrSecSt,    Bulgarian,0},
  { "Не назначена\n",				       StrNoAsmt,   Bulgarian,0},
  { "База данни PDB\n",				       StrPDBRec,   Bulgarian,0},
  { "Изчислено\n",				       StrCalc,     Bulgarian,0},
  { "Код на база данни ..... ",			       StrDBCode,   Bulgarian,0},
  { "Експериментална техника ... ",		       StrExpTec,   Bulgarian,0},
  { "Количество вериги ..... ",			       StrNumChn,   Bulgarian,0},
  { "Количество групи ...... ",			       StrNumGrp,   Bulgarian,0},
  { "Количество атоми ...... ",			       StrNumAtm,   Bulgarian,0},
  { "Количество връзки ..... ",			       StrNumBnd,   Bulgarian,0},
  { "Количество мостове .... ",			       StrNumBrg,   Bulgarian,0},
  { "Количество водородни връзки . ",		       StrNumHbd,   Bulgarian,0},
  { "Количество хеликси .... ",			       StrNumHel,   Bulgarian,0},
  { "Количество нишки ...... ",			       StrNumStrnd, Bulgarian,0},
  { "Количество завои ...... ",			       StrNumTrn,   Bulgarian,0},
  { "Неуспешно заделяне на памет!\n",		       StrMalloc,   Bulgarian,0},
  { "Твърде много остатъци!\n",			       StrXSRes,    Bulgarian,0},
  { "Твърде много нови видове атоми!\n",	       StrXSAtyp,   Bulgarian,0},
#ifndef MSWIN
  { "Отвори ...",                                      StrMOpen,    Bulgarian,0},
  { "Запази като ...",                                 StrMSaveAs,  Bulgarian,0},
  { "Затвори",                                         StrMClose,   Bulgarian,0},
  { "",                                                StrMEmpty,   Bulgarian,0},
#ifdef APPLEMAC
  { "Настройки на печата",                             StrMPSetup,  Bulgarian,0},
  { "Печат",                                           StrMPrint,   Bulgarian,0},
  { "Изход",                                           StrMExit,    Bulgarian,0},
#else
  { "Изход",                                           StrMExit,    Bulgarian,0},
#endif
  { "Скелет",                                          StrMWirefr,  Bulgarian,0},
  { "Гръбнак",                                         StrMBackbn,  Bulgarian,0},
  { "Пръчки",                                          StrMSticks,  Bulgarian,1},
  { "Ван-дер-Ваалсов радиус",                          StrMSpacefl, Bulgarian,0},
  { "Свери и Пръчки",                                  StrMBallStk, Bulgarian,0},
  { "Ленти",                                           StrMRibbons, Bulgarian,0},
  { "Нишки",                                           StrMStrands, Bulgarian,3},
  { "Анимации",                                        StrMCartoon, Bulgarian,0},
  { "Молек. повърхност",                               StrMMolSurf, Bulgarian,0},
  { "Черно-бяло",                                      StrMMonochr, Bulgarian,0},
  { "Хим. елементи",                                   StrMCPK,     Bulgarian,0},
  { "Форма",                                           StrMShapely, Bulgarian,0},
  { "Група",                                           StrMGroup,   Bulgarian,0},
  { "Верига",                                          StrMChain,   Bulgarian,1},
  { "Температура",                                     StrMTemp,    Bulgarian,0},
  { "Структура",                                       StrMStruct,  Bulgarian,2},
  { "Потребителски",                                   StrMUser,    Bulgarian,0},
  { "Модел",                                           StrMModel,   Bulgarian,2},
  { "Алтернативен",                                    StrMAlt,     Bulgarian,0},
  { "Сечение",                                         StrMSlab,    Bulgarian,0},
  { "Водородни",                                       StrMHydr,    Bulgarian,0},
  { "Хетеро атоми",                                    StrMHet,     Bulgarian,0},
  { "Огледален",                                       StrMSpec,    Bulgarian,0},
  { "Сенки",                                           StrMShad,    Bulgarian,0},
  { "Стерео",                                          StrMStereo,  Bulgarian,3},
  { "Надписи",                                         StrMLabel,   Bulgarian,0},
  { "Изключи избор",                                   StrMPOff,    Bulgarian,0},
  { "Име",                                             StrMPIdent,  Bulgarian,0},
  { "Дистанция",                                       StrMPDist,   Bulgarian,0},
  { "Монитор",                                         StrMPMon,    Bulgarian,0},
  { "Ъгъл",                                            StrMPAng,    Bulgarian,0},
  { "Извиване",                                        StrMPTrsn,   Bulgarian,0},
  { "Надпис",                                          StrMPLabl,   Bulgarian,0}, 
  { "Избор на Център",                                 StrMPCent,   Bulgarian,0},
  { "Координати",                                      StrMPCoord,  Bulgarian,0},
  { "Връзка",                                          StrMPBond,   Bulgarian,0},
  { "Завърти връзка",                                  StrMRBond,   Bulgarian,0},
  { "Завърти молекула",                                StrMRMol,    Bulgarian,10},
  { "Завърти всичко",                                  StrMRAll,    Bulgarian,12},
  { "BMP ...",                                         StrMBMP,     Bulgarian,0},  
  { "GIF ...",                                         StrMGIF,     Bulgarian,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Bulgarian,5},  
  { "PPM ...",                                         StrMPPM,     Bulgarian,2},  
  { "Sun Raster...",                                   StrMSRast,   Bulgarian,0},  
  { "PostScript...",                                   StrMPostscr, Bulgarian,0},  
  { "PICT...",                                         StrMPICT,    Bulgarian,1},  
  { "Vector PS ...",                                   StrMVECPS,   Bulgarian,0},  
  { "Molscript ...",                                   StrMMSCR,    Bulgarian,1},  
  { "Kinemage ...",                                    StrMKine,    Bulgarian,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  Bulgarian,2},  
  { "VRML ...",                                        StrMVRML,    Bulgarian,3},  
  { "Ramachandran ...",                                StrMRPP,     Bulgarian,3},  
  { "Raster3D ...",                                    StrMR3D,     Bulgarian,6},  
  { "RasMol Script ...",                               StrMSCR,     Bulgarian,8},
  { "За РасМол...",                                    StrMAbout,   Bulgarian,0},
  { "Ръководство на потребителя...",                   StrMUserM,   Bulgarian,0},
  { "Назад",                                           StrMUndo,    Bulgarian,0},
  { "Изрежи",                                          StrMCut,     Bulgarian,1},
  { "Копрай",                                          StrMCopy,    Bulgarian,1},
  { "Постави",                                         StrMPaste,   Bulgarian,0},
#ifdef APPLEMAC
  { "Изчисти",                                         StrMClear,   Bulgarian,1},
#else
  { "Изтрий",                                          StrMDelete,  Bulgarian,0},
#endif
  { "Избери всичко",                                   StrMSelAll,  Bulgarian,0},
  { "Файл",                                            StrMFile,    Bulgarian,0},
  { "Редакция",                                        StrMEdit,    Bulgarian,0},
  { "Изглед",                                          StrMDisplay, Bulgarian,0},
  { "Цветове",                                         StrMColour,  Bulgarian,0},
  { "Опции",                                           StrMOpt,     Bulgarian,0},
  { "Настройки",                                       StrMSettings,Bulgarian,0},
  { "Експорт",                                         StrMExport,  Bulgarian,1},
#ifdef APPLEMAC
  { "Прозорец",                                        StrMWindow,  Bulgarian,0},
#endif
  { "Помощ",                                           StrMHelp,    Bulgarian,0},
#ifdef APPLEMAC
  { "Основен прозорец",                                StrMMainWin,  Bulgarian,0},
  { "Команден ред",                                    StrMCmndLin,  Bulgarian,0},
#endif
#else
  { "&Отвори ...",                                     StrMOpen,    Bulgarian,0},
  { "&Информация",                                     StrMInfo,    Bulgarian,0},
  { "&Затвори",                                        StrMClose,   Bulgarian,0},
  { "&Печат",                                          StrMPrint,   Bulgarian,0},
  { "Н&астройки на печата",                            StrMPSetup,  Bulgarian,0},
  { "Из&ход",                                          StrMExit,    Bulgarian,2},
  { "&Скелет",                                         StrMWirefr,  Bulgarian,0},
  { "&Гръбнак",                                        StrMBackbn,  Bulgarian,0},
  { "П&ръчки",                                         StrMSticks,  Bulgarian,1},
  { "&Ван-дер-Ваалсов радиус",                         StrMSpacefl, Bulgarian,0},
  { "Св&ери и Пръчки",                                 StrMBallStk, Bulgarian,2},
  { "&Ленти",                                          StrMRibbons, Bulgarian,0},
  { "&Нишки",                                          StrMStrands, Bulgarian,0},
  { "&Анимации",                                       StrMCartoon, Bulgarian,0},
  { "&Молек. повърхност",                              StrMMolSurf, Bulgarian,0},
  { "&Черно-бяло",                                     StrMMonochr, Bulgarian,0},
  { "&Хим. елементи",                                  StrMCPK,     Bulgarian,0},
  { "&Форма",                                          StrMShapely, Bulgarian,0},
  { "&Група",                                          StrMGroup,   Bulgarian,0},
  { "В&ерига",                                         StrMChain,   Bulgarian,1},
  { "&Температура",                                    StrMTemp,    Bulgarian,0},
  { "Ст&руктура",                                      StrMStruct,  Bulgarian,2},
  { "&Потребителски",                                  StrMUser,    Bulgarian,0},
  { "Мо&дел",                                          StrMModel,   Bulgarian,2},
  { "&Алтернативен",                                   StrMAlt,     Bulgarian,0},
  { "&Сечение",                                        StrMSlab,    Bulgarian,0},
  { "&Водородни",                                      StrMHydr,    Bulgarian,0},
  { "&Хетеро атоми",                                   StrMHet,     Bulgarian,0},
  { "&Огледален",                                      StrMSpec,    Bulgarian,0},
  { "С&енки",                                          StrMShad,    Bulgarian,1},
  { "С&терео",                                         StrMStereo,  Bulgarian,1},
  { "&Надписи",                                        StrMLabel,   Bulgarian,0},
  { "&Изключи избор",                                  StrMPOff,    Bulgarian,0},
  { "И&ме",                                            StrMPIdent,  Bulgarian,1},
  { "&Дистанция",                                      StrMPDist,   Bulgarian,0},
  { "М&онитор",                                        StrMPMon,    Bulgarian,1},
  { "&Ъгъл",                                           StrMPAng,    Bulgarian,0},
  { "И&звиване",                                       StrMPTrsn,   Bulgarian,1},
  { "&Надпис",                                         StrMPLabl,   Bulgarian,0}, 
  { "Из&бор на Център",                                StrMPCent,   Bulgarian,2},
  { "&Координати",                                     StrMPCoord,  Bulgarian,0},
  { "&Връзка",                                         StrMPBond,   Bulgarian,0},
  { "&Завърти връзка",                                 StrMRBond,   Bulgarian,0},
  { "Завърти м&олекула",                               StrMRMol,    Bulgarian,10},
  { "Завърти вси&чко",                                 StrMRAll,    Bulgarian,12},
  { "&BMP ...",                                        StrMBMP,     Bulgarian,0},  
  { "&GIF ...",                                        StrMGIF,     Bulgarian,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Bulgarian,5}, 
  { "PP&M ...",                                        StrMPPM,     Bulgarian,2},  
  { "&Sun Raster...",                                  StrMSRast,   Bulgarian,0},  
  { "&PostScript...",                                  StrMPostscr, Bulgarian,0},  
  { "P&ICT...",                                        StrMPICT,    Bulgarian,1},  
  { "&Vector PS ...",                                  StrMVECPS,   Bulgarian,0},  
  { "M&olscript ...",                                  StrMMSCR,    Bulgarian,1},  
  { "&Kinemage ...",                                   StrMKine,    Bulgarian,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  Bulgarian,2},  
  { "VRM&L ...",                                       StrMVRML,    Bulgarian,3},  
  { "Ram&achandran ...",                               StrMRPP,     Bulgarian,3},  
  { "Raster&3D ...",                                   StrMR3D,     Bulgarian,6},  
  { "RasMol S&cript ...",                              StrMSCR,     Bulgarian,8},  
  { "&За РасМол...",                                   StrMAbout,   Bulgarian,0},
  { "&Ръководство на потребителя...",                  StrMUserM,   Bulgarian,0},
  { "&Назад",                                          StrMUndo,    Bulgarian,0},
  { "И&зрежи",                                         StrMCut,     Bulgarian,1},
  { "&Копирай",                                        StrMCopy,    Bulgarian,0},
  { "П&остави",                                        StrMPaste,   Bulgarian,1},
  { "И&зтрий",                                         StrMDelete,  Bulgarian,1},
  { "&Избери всичко",                                  StrMSelAll,  Bulgarian,0},
  { "&Файл",                                           StrMFile,    Bulgarian,0},
  { "&Редакция",                                       StrMEdit,    Bulgarian,0},
  { "&Изглед",                                         StrMDisplay, Bulgarian,0},
  { "&Цветове",                                        StrMColour,  Bulgarian,0},
  { "&Опции",                                          StrMOpt,     Bulgarian,0},
  { "&Настройки",                                      StrMSettings,Bulgarian,0},
  { "&Експорт",                                        StrMExport,  Bulgarian,1},
  { "&Помощ",                                          StrMHelp,    Bulgarian,0},
#endif
  { "Име на PDB файл:",                                StrPrmtPDB,  Bulgarian,0},
  { "Име на файла на изображението:",                  StrPrmtImg,  Bulgarian,0},
  { "Име на файла на молекулата:",                     StrPrmtMol,  Bulgarian,0},
  { "Внимание: ",                                      StrWarn,     Bulgarian,0},
  { "Верига",                                          StrChain,    Bulgarian,0},
  { "Регистрация",                                     StrRegister, Bulgarian, 0},
  { "Даряване",                                        StrDonate,   Bulgarian, 0},
  { "Не показвай този прозорец при стартиране",              StrNoShow,   Bulgarian, 0},
  { "Без гаранция, Open Source, GPL, дарения са добре дошли", StrWarranty, Bulgarian, 0},


  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Chinese,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Chinese,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Chinese,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Chinese,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Chinese,0},

  { "指挥无效语法!\n",                                 ErrSyntax,   Chinese,0},
  { "参数值太大!\n",                                     ErrBigNum,  Chinese,0},
  { "无效参数设定!\n",                                   ErrBadOpt,   Chinese,0},
  { "无效参数名称!\n",                                   ErrParam,    Chinese,0},
  { "文件名称系列期望!\n",                                ErrFilNam,   Chinese,0},
  { "装载分子数据库!\n",                                 ErrBadLoad,  Chinese,0},
  { "整数预期值!\n",                                     ErrNotNum,   Chinese,0},
  { "逗号分离丢失!\n",                                   ErrNotSep,   Chinese,0},
  { "关闭括弧']'期望!\n",                                ErrNotBrac,  Chinese,0},
  { "没有指定颜色!\n",                                   ErrNoCol,    Chinese,0},
  { "不详或不正确的颜色!\n",                              ErrColour,   Chinese,0},
  { "指挥无效说法!\n",                                 ErrBadArg,   Chinese,0},
  { "语法错误表达!\n",                                 ErrBadExpr,  Chinese,0},
  { "关闭括弧')'期望!\n",                                ErrParen,    Chinese,0},
  { "脚本指挥栈太深!\n",                                  ErrScript,   Chinese,0},
  { "开括号'('期望!\n",                                  ErrFunc,     Chinese,0},
  { "无效或丢失的原子命名!\n",                             ErrSetName,  Chinese,0},
  { "内存不够明确规定!\n",                                ErrBadSet,   Chinese,0},
  { "在脚本文件中丧失命令能力!\n",                         ErrInScrpt,  Chinese,0},
  { "指挥无效(仅在一个脚本中有效)!\n",                      ErrOutScrpt, Chinese,0},
  { "未装分子数据库！\n",                                 ErrBadMolDB, Chinese,0},
  { "旋转循环的化学键没有被选择!\n",                        ErrNoBond,   Chinese,0},
  { "错误:文件 '",                                       StrErrFile,  Chinese,0},
  { "' 没有找到!!\n\n",                                  StrNotFnd,   Chinese,0},
  { "错误:未经压缩格式!\n\n",                             StrCFmt,     Chinese,0},
  { "错误:无法解压缩档案!\n\n",                           StrDcmp,   Chinese,0},
  { "脚本指挥线太长!\n",                                  StrSLong,    Chinese,0},
  { "指挥错误:内存不足!\n",                               StrSMem,     Chinese,0},
  { "找不到RasMol帮助文件！\n",                           StrHFil,     Chinese,0},
  { "不明话题请求帮助！\n",                               StrHTop,     Chinese,0},
  { "在请求中没有可行的帮助！\n",                          StrHNone,    Chinese,0},
  { "指挥错误:无法打开帮助文件!\n",                        StrHROpn,    Chinese,0},
  { "常数串无法终止！\n",                                 StrCTerm,   Chinese,0},
  { "常数串太长！\n",                                    StrCLong,    Chinese,0},
  { "无效浮点数字!\n",                                   StrFNum,     Chinese,0},
  { "没有到中心的原子！\n",                               StrCent,     Chinese,0},
  { "无法拷贝到剪贴板!\n",                                StrCClip,    Chinese,0},
  { "不能打开圆点文件'",                                  StrDFile,    Chinese,0},
  { "注意:没有适合的打印机！\n",                           StrNPrint,   Chinese,0},
  { "单元细胞",                                         StrUCell,    Chinese,0},
  { "空间群",                                           StrSGroup,   Chinese,0},
  { "没有晶体对称性数据！\n",                              StrSymm,     Chinese,0},
  { "未经指挥!\n",                                      StrUnrec,    Chinese,0},
  { "注意:忽略剩余指挥！\n",                              StrIgnore,   Chinese,0},
  { "注意:远程指挥太久!\n",                               StrRCLong,   Chinese,0},
  { "不能打开文字档案 '",                                 StrSFile,    Chinese,0},
  { "标识符过长!\n",                                     StrILong,    Chinese,0},
  { "分子名称 ......... ",                               StrMolNam,   Chinese,0},
  { "分类 ........ ",                                   StrClass,    Chinese,0},
  { "二级结构 ... ",                                    StrSecSt,    Chinese,0},
  { "不转让 \n",                                        StrNoAsmt,   Chinese,0},
  { "PDB数据记录\n",                                    StrPDBRec,   Chinese,0},
  { "计算\n",                                           StrCalc,     Chinese,0},
  { "数据库代码 ......... ",                             StrDBCode,   Chinese,0},
  { "实验技术 .. ",                                     StrExpTec,   Chinese,0},
  { "链的数量...... ",                                  StrNumChn,   Chinese,0},
  { "群的数量...... ",                                  StrNumGrp,   Chinese,0},
  { "原子的数量....... ",                                StrNumAtm,   Chinese,0},
  { "化学键的数量 ....... ",                             StrNumBnd,  Chinese,0},
  { "桥键的数量..... ",                                  StrNumBrg,   Chinese,0},
  { "H化学键的数量 ..... ",                              StrNumHbd,   Chinese,0},
  { "螺旋的数量 ..... ",                                 StrNumHel,   Chinese,0},
  { "纤维体的数量 ..... ",                               StrNumStrnd, Chinese,0},
  { "轮流转变的数量 ....... ",                            StrNumTrn,   Chinese,0},
  { "内存分配失败",                                      StrMalloc,   Chinese,0},
  { "太多新的残余",                                      StrXSRes,    Chinese,0},
  { "太多新的原子类型",                                   StrXSAtyp,   Chinese,0},
#ifndef MSWIN
  { "打开...",                                         StrMOpen,    Chinese,0},
  { "保存到...",                                       StrMSaveAs,  Chinese,0},
  { "关闭",                                            StrMClose,   Chinese,0},
  { "",                                                StrMEmpty,   Chinese,0},
#ifdef APPLEMAC
  { "页面设置",                                        StrMPSetup,  Chinese,0},
  { "打印",                                            StrMPrint,   Chinese,0},
  { "退出",                                            StrMExit,    Chinese,0},
#else
  { "退出",                                            StrMExit,    Chinese,0},
#endif
  { "线框",                                            StrMWirefr,  Chinese,0},
  { "脊梁",                                            StrMBackbn,  Chinese,0},
  { "枝条",                                            StrMSticks,  Chinese,1},
  { "空间填充",                                        StrMSpacefl, Chinese,0},
  { "球形和枝状",                                      StrMBallStk, Chinese,0},
  { "系带",                                            StrMRibbons, Chinese,0},
  { "纤维",                                            StrMStrands, Chinese,3},
  { "草图",                                            StrMCartoon, Chinese,0},
  { "分子表面",                                        StrMMolSurf, Chinese,0},
  { "单色",                                            StrMMonochr, Chinese,0},
  { "CPK",                                             StrMCPK,     Chinese,0},
  { "曲线",                                         StrMShapely, Chinese,0},
  { "群",                                              StrMGroup,   Chinese,0},
  { "链",                                              StrMChain,   Chinese,1},
  { "温度",                                            StrMTemp,    Chinese,0},
  { "结构",                                            StrMStruct,  Chinese,2},
  { "用户",                                            StrMUser,    Chinese,0},
  { "模型",                                            StrMModel,   Chinese,2},
  { "Alt",                                            StrMAlt,     Chinese,0},
  { "平板模式",                                        StrMSlab,    Chinese,0},
  { "氢",                                              StrMHydr,    Chinese,1},
  { "异种原子",                                        StrMHet,     Chinese,2},
  { "镜面",                                            StrMSpec,    Chinese,1},
  { "影子",                                            StrMShad,    Chinese,1},
  { "立体声",                                          StrMStereo,  Chinese,5},
  { "标签",                                            StrMLabel,   Chinese,0},
  { "选择",                                            StrMPOff,    Chinese,5},
  { "鉴别",                                            StrMPIdent,  Chinese,5},
  { "选择距离",                                        StrMPDist,   Chinese,5},
  { "选择监视器",                                      StrMPMon,    Chinese,0},
  { "选择角度",                                        StrMPAng,    Chinese,5},
  { "选择转矩",                                        StrMPTrsn,   Chinese,5},
  { "选择标签",                                        StrMPLabl,   Chinese,5}, 
  { "选择中心",                                        StrMPCent,   Chinese,5},
  { "选择坐标",                                        StrMPCoord,  Chinese,6},
  { "选择化学键",                                      StrMPBond,   Chinese,5},
  { "化学键轮换",                                      StrMRBond,   Chinese,0},
  { "摩尔轮换",                                        StrMRMol,    Chinese,7},
  { "全部轮换",                                        StrMRAll,    Chinese,7},
  { "BMP ...",                                         StrMBMP,     Chinese,0},  
  { "GIF ...",                                         StrMGIF,     Chinese,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Chinese,5},  
  { "PPM ...",                                         StrMPPM,     Chinese,2},  
  { "太阳光域...",                                      StrMSRast,   Chinese,0},  
  { "后记...",                                         StrMPostscr, Chinese,0},  
  { "PICT...",                                         StrMPICT,    Chinese,1},  
  { "矢量 PS ...",                                     StrMVECPS,   Chinese,0},  
  { "Molscript ...",                                   StrMMSCR,    Chinese,1},  
  { "Kinemage ...",                                    StrMKine,    Chinese,0},  
  { "POV射线 3 ...",                                   StrMPOVRAY,  Chinese,2},  
  { "虚拟现实模型语言 ...",                              StrMVRML,    Chinese,3},  
  { "Ramachandran ...",                                StrMRPP,     Chinese,3},  
  { "3D光域 ...",                                      StrMR3D,     Chinese,6},  
  { "RasMol 字母 ...",                                 StrMSCR,     Chinese,8},  
  { "关于 RasMol...",                                  StrMAbout,   Chinese,0},
  { "用户手册...",                                      StrMUserM,   Chinese,0},
  { "撤消",                                            StrMUndo,    Chinese,0},
  { "剪切",                                            StrMCut,     Chinese,1},
  { "复制",                                            StrMCopy,    Chinese,1},
  { "粘贴",                                            StrMPaste,   Chinese,0},
#ifdef APPLEMAC
  { "清除",                                            StrMClear,   Chinese,1},
#else
  { "删除",                                            StrMDelete,  Chinese,0},
#endif
  { "全选",                                            StrMSelAll,  Chinese,0},
  { "文件",                                            StrMFile,    Chinese,0},
  { "编辑",                                            StrMEdit,    Chinese,0},
  { "展示",                                            StrMDisplay, Chinese,0},
  { "颜色",                                            StrMColour,  Chinese,0},
  { "附件",                                            StrMOpt,     Chinese,0},
  { "设置",                                            StrMSettings,Chinese,0},
  { "输出",                                            StrMExport,  Chinese,1},
#ifdef APPLEMAC
  { "窗口",                                            StrMWindow,  Chinese,0},
#endif
  { "帮助",                                            StrMHelp,    Chinese,0},
#ifdef APPLEMAC
  { "主窗口",                                          StrMMainWin,  Chinese,0},
  { "控制线",                                          StrMCmndLin,  Chinese,0},
#endif
#else
  { "打开 (&O)",                                       StrMOpen,    Chinese,0},
  { "信息 (&I)",                                       StrMInfo,    Chinese,0},
  { "关闭 (&C)",                                       StrMClose,   Chinese,0},
  { "打印 (&P)",                                       StrMPrint,   Chinese,0},
  { "打印设置 (&R)",                                    StrMPSetup,  Chinese,0},
  { "退出 (&E)",                                       StrMExit,    Chinese,0},
  { "线框 (&W)",                                       StrMWirefr,  Chinese,0},
  { "脊梁(&M)",                                        StrMBackbn,  Chinese,0},
  { "枝条 (&B)",                                       StrMSticks,  Chinese,1},
  { "空间填充 (&S)",                                   StrMSpacefl, Chinese,0},
  { "球形和枝状 (&H)",                                 StrMBallStk, Chinese,0},
  { "系带 (&R)",                                       StrMRibbons, Chinese,0},
  { "纤维 (&T)",                                       StrMStrands, Chinese,3},
  { "草图 (&C)",                                       StrMCartoon, Chinese,0},
  { "分子表面 (&M)",                                   StrMMolSurf, Chinese,0},
  { "单色 (&M)",                                       StrMMonochr, Chinese,0},
  { "&CPK",                                            StrMCPK,     Chinese,0},
  { "曲线 (&H)",                                       StrMShapely, Chinese,0},
  { "群 (&G)",                                         StrMGroup,   Chinese,0},
  { "链 (&C)",                                         StrMChain,   Chinese,1},
  { "温度 (&T)",                                       StrMTemp,    Chinese,0},
  { "结构 (&S)",                                       StrMStruct,  Chinese,2},
  { "用户 (&U)",                                       StrMUser,    Chinese,0},
  { "模型 (&D)",                                       StrMModel,   Chinese,2},
  { "选择 (&A)",                                       StrMAlt,     Chinese,0},
  { "平板模式 (&P)",                                   StrMSlab,    Chinese,0},
  { "氢 (&H)",                                         StrMHydr,    Chinese,1},
  { "异种原子 (&N)",                                   StrMHet,     Chinese,2},
  { "镜面 (&T)",                                       StrMSpec,    Chinese,1},
  { "影子 (&D)",                                       StrMShad,    Chinese,1},
  { "立体声 (&S)",                                     StrMStereo,  Chinese,5},
  { "标签 (&L)",                                       StrMLabel,   Chinese,0},
  { "选择 (&O)",                                       StrMPOff,    Chinese,5},
  { "鉴别 (&I)",                                       StrMPIdent,  Chinese,5},
  { "选择距离 (&D)",                                   StrMPDist,   Chinese,5},
  { "选择监视器 (&S)",                                 StrMPMon,    Chinese,0},
  { "选择角度 (&A)",                                   StrMPAng,    Chinese,5},
  { "选择转矩 (&T)",                                   StrMPTrsn,   Chinese,5},
  { "选择标签 (&L)",                                   StrMPLabl,   Chinese,5}, 
  { "选择中心 (&C)",                                   StrMPCent,   Chinese,5},
  { "选择坐标 (&X)",                                   StrMPCoord,  Chinese,6},
  { "选择化学键 (&B)",                                 StrMPBond,   Chinese,5},
  { "化学键轮换 (&R)",                                 StrMRBond,   Chinese,0},
  { "摩尔轮换 (&M)",                                   StrMRMol,    Chinese,7},
  { "全部轮换 (&H)",                                   StrMRAll,    Chinese,7},
  { "&BMP ...",                                        StrMBMP,     Chinese,0},  
  { "&GIF ...",                                        StrMGIF,     Chinese,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Chinese,5},  
  { "PP&M ...",                                        StrMPPM,     Chinese,2},  
  { "太阳光域(&S)...",                                  StrMSRast,   Chinese,0},  
  { "后记 (&P)...",                                    StrMPostscr, Chinese,0},  
  { "P&ICT...",                                        StrMPICT,    Chinese,1},  
  { "矢量PS (&V)...",                                  StrMVECPS,   Chinese,0},  
  { "M&olscript ...",                                  StrMMSCR,    Chinese,1},  
  { "&Kinemage ...",                                   StrMKine,    Chinese,0},  
  { "POV射线3(&V)...",                                 StrMPOVRAY,  Chinese,2},  
  { "虚拟现实模型语言 (&L)",                              StrMVRML,    Chinese,3},  
  { "Ram&achandran ...",                               StrMRPP,     Chinese,3},  
  { "3D光域(&3) ...",                                  StrMR3D,     Chinese,6},  
  { "RasMol字母 (&c) ...",                             StrMSCR,     Chinese,8},  
  { "关于RasMol (&A)...",                               StrMAbout,   Chinese,0},
  { "用户手册  (&M)...",                                 StrMUserM,   Chinese,0},
  { "撤消 (&Z)",                                       StrMUndo,    Chinese,0},
  { "剪切 (&X)",                                       StrMCut,     Chinese,1},
  { "复制 (&C)",                                       StrMCopy,    Chinese,1},
  { "粘贴 (&V)",                                       StrMPaste,   Chinese,0},
  { "删除 (&D)",                                       StrMDelete,  Chinese,0},
  { "全选 (&S)",                                       StrMSelAll,  Chinese,0},
  { "文件 (&F)",                                       StrMFile,    Chinese,0},
  { "编辑 (&E)",                                       StrMEdit,    Chinese,0},
  { "展示 (&D)",                                       StrMDisplay, Chinese,0},
  { "颜色 (&C)",                                       StrMColour,  Chinese,0},
  { "附件 (&O)",                                       StrMOpt,     Chinese,0},
  { "设置 (&S",                                        StrMSettings,Chinese,0},
  { "输出 (&X)",                                       StrMExport,  Chinese,1},
  { "帮助 (&H)",                                       StrMHelp,    Chinese,0},
#endif
  { "PDB文件名称:",                                      StrPrmtPDB,  Chinese,0},
  { "图像文件名称：",                                     StrPrmtImg,  Chinese,0},
  { "分子文件名称：",                                     StrPrmtMol,  Chinese,0},
  { "注意: ",                                           StrWarn,     Chinese,0},
  { "链式结构",                                         StrChain,    Chinese,0},
  { "注册",                                            StrRegister, Chinese,0},
  { "赠送",                                            StrDonate,   Chinese,0},
  { "不要把这个对话放在启动中",                        StrNoShow,   Chinese,0},
  { "无保修，开放源码，通用公共许可证，捐赠物鉴别",    StrWarranty, Chinese,0},
  { "Error: NoToggle mode enabled; "
    "type 'set notoggle off' to disabled.\n",          ErrNoToggle, Japanese,0},
  { "2.7.3 Color compatibility mode enabled.\n",       StrCCompOn,  Japanese,0},
  { "2.7.3 Color compatibility mode disabled.\n",      StrCCompOff, Japanese,0},
  { "NoToggle mode: enabled.\n",                       StrNoTogOn,  Japanese,0},
  { "NoToggle mode: disabled.\n",                      StrNoTogOff, Japanese,0},

  { "コマンドの文法が不適切です!\n",                   ErrSyntax,   Japanese,0},
  { "パラメーターが大きすぎます!\n",                        ErrBigNum,   Japanese,0},
  { "パラメーターの設定が不適切です!\n",                    ErrBadOpt,   Japanese,0},
  { "パラメーター名が不適切です!\n",                        ErrParam,    Japanese,0},
  { "ファイル名を示す文字列がありません!\n",                 ErrFilNam,  Japanese,0},
  { "分子構造データーベースを読みました!\n",                 ErrBadLoad,  Japanese,0},
  { "整数値を指定する必要があります!\n",                     ErrNotNum,   Japanese,0},
  { "区切り（コンマ）がありません! \n",                     ErrNotSep,   Japanese,0},
  { "右カッコ ']' がありませありません!\n",                 ErrNotBrac,  Japanese,0},
  { "色が指定されていません!\n",                           ErrNoCol,    Japanese,0},
  { "色の指定が不適切です!\n",                             ErrColour,   Japanese,0},
  { "コマンドの引数が不適切です!\n",                   ErrBadArg,   Japanese,0},
  { "表現に誤りがあります!\n",                         ErrBadExpr,  Japanese,0},
  { "右カッコ ')' がありません!\n",                       ErrParen,    Japanese,0},
  { "スクリプトが複雑すぎます!\n",                         ErrScript,   Japanese,0},
  { "左カッコ '(' がありません!\n",                        ErrFunc,     Japanese,0}, 
  { "原子団の名前が不適切です!\n",                         ErrSetName,  Japanese,0},
  { "原子団を定義するために必要なメモリーが確保できません!\n",  ErrBadSet,   Japanese,0},
  { "スクリプトファイルでは使えないコマンドがあります!\n",     ErrInScrpt,  Japanese,0},
  { "スクリプトファイルでしか使えないコマンドです!\n",         ErrOutScrpt, Japanese,0},
  { "分子構造データーベースを読み込めません!\n",              ErrBadMolDB, Japanese,0},
  { "回転のための結合が指定されていません!\n",                ErrNoBond,   Japanese,0},
  { "エラー: ファイル '",                                 StrErrFile,  Japanese,0},
  { "'が見つかりません!\n\n",                             StrNotFnd,   Japanese,0},
  { "エラー: ファイルの圧縮形式が不明です!\n\n",             StrCFmt,     Japanese,0},
  { "エラー: 圧縮されたファイルを展開できません!\n\n",        StrDcmp,     Japanese,0},
  { "スクリプトの１行が長すぎます!\n",                      StrSLong,    Japanese,0},
  { "コマンドエラー: メモリーが足りません!\n",               StrSMem,     Japanese,0},
  { "RasMolのヘルプファイルが見つかりません!\n",             StrHFil,     Japanese,0},
  { "ヘルプファイルにない不明のトピックスを指定しました!\n",    StrHTop,     Japanese,0},
  { "指定されたトピックスにはオンラインヘルプがありません!\n",  StrHNone,    Japanese,0},
  { "コマンドエラー: ヘルプファイルを開くことができません!\n",  StrHROpn,    Japanese,0},
  { "文字定数が閉じられていません\n",                       StrCTerm,    Japanese,0},
  { "文字定数が長すぎます!\n",                             StrCLong,    Japanese,0},
  { "数値（小数点）の表記が不適切です!\n",                   StrFNum,     Japanese,0},
  { "中心に置く原子がありません!\n",                        StrCent,     Japanese,0},
  { "クリップボードにコピーできません!\n",                   StrCClip,    Japanese,0},
  { "設定（ドット）ファイルを開くことができません: '",         StrDFile,    Japanese,0},
  { "注意: プリンターが指定されていません!\n",               StrNPrint,   Japanese,0},
  { "単位格子",                                         StrUCell,    Japanese,0},
  { "空間群",                                           StrSGroup,   Japanese,0},
  { "結晶の対称性が不明です!\n",                           StrSymm,     Japanese,0},
  { "コマンドが意味不明です!\n",                           StrUnrec,    Japanese,0},
  { "注意: 残りのコマンドを無視します!\n",                  StrIgnore,   Japanese,0},
  { "注意: リモートコマンドが長すぎます!\n",                 StrRCLong,   Japanese,0},
  { "スクリプトファイルを開くことができません:'",             StrSFile,    Japanese,0},
  { "識別子が長すぎます!\n",                               StrILong,    Japanese,0},
  { "分子名 ............ ",                                StrMolNam,   Japanese,0},
  { "分類 .............. ",                                  StrClass,    Japanese,0},
  { "二次構造... ",                                     StrSecSt,    Japanese,0},
  { "アサインされていません\n",                            StrNoAsmt,   Japanese,0},
  { "PDBデータのレコードによる\n",                         StrPDBRec,   Japanese,0},
  { "計算による\n",                                      StrCalc,     Japanese,0},
  { "コード番号 ........ ",                             StrDBCode,   Japanese,0},
  { "実験方法 .......... ",                                     StrExpTec,   Japanese,0},
  { "主鎖の数 .......... ",                                StrNumChn,   Japanese,0},
  { "グループの数 ...... ",                               StrNumGrp,   Japanese,0},
  { "原子の数 .......... ",                                StrNumAtm,   Japanese,0},
  { "結合の数 .......... ",                                StrNumBnd,   Japanese,0},
  { "S-S結合の数 ....... ",                               StrNumBrg,   Japanese,0},
  { "水素結合の数 ...... ",                             StrNumHbd,   Japanese,0},
  { "ヘリックスの数 .... ",                             StrNumHel,   Japanese,0},
  { "ストランドの数 .... ",                             StrNumStrnd, Japanese,0},
  { "ターンの数 ........ ",                               StrNumTrn,   Japanese,0},
  { "メモリーの確保に失敗しました",                         StrMalloc,   Japanese,0},
  { "残基の種類が多すぎます",                              StrXSRes,    Japanese,0},
  { "原子の種類が多すぎます",                              StrXSAtyp,   Japanese,0},
#ifndef MSWIN
  { "開く...",                                         StrMOpen,    Japanese,0},
  { "別名で保存...",                                      StrMSaveAs,  Japanese,0},
  { "閉じる",                                           StrMClose,   Japanese,0},
  { "",                                                StrMEmpty,   Japanese,0},
#ifdef APPLEMAC
  { "ページ設定",                                      StrMPSetup,  Japanese,0},
  { "印刷",                                           StrMPrint,   Japanese,0},
  { "終了",                                            StrMExit,    Japanese,0},
#else
  { "終了",                                            StrMExit,    Japanese,0},
#endif
  { "ワイヤーフレーム",                                    StrMWirefr,  Japanese,0},
  { "主鎖",                                              StrMBackbn,  Japanese,0},
  { "スティック",                                         StrMSticks,  Japanese,1},
  { "空間充填モデル",                                      StrMSpacefl, Japanese,0},
  { "棒玉",                                              StrMBallStk, Japanese,0},
  { "リボン",                                            StrMRibbons, Japanese,0},
  { "ストランド",                                         StrMStrands, Japanese,3},
  { "カートゥーン",                                        StrMCartoon, Japanese,0},
  { "分子表面",                                           StrMMolSurf, Japanese,0},
  { "白黒",                                            StrMMonochr, Japanese,0},
  { "CPK（カラー）",                                             StrMCPK,     Japanese,0},
  { "形",                                              StrMShapely, Japanese,0},
  { "グループ",                                         StrMGroup,   Japanese,0},
  { "鎖",                                              StrMChain,   Japanese,1},
  { "温度",                                            StrMTemp,    Japanese,0},
  { "構造",                                            StrMStruct,  Japanese,2},
  { "ユーザー",                                         StrMUser,    Japanese,0},
  { "モデル",                                           StrMModel,   Japanese,2},
  { "可換構造",                                             StrMAlt,     Japanese,0},
  { "スラブモード",                                     StrMSlab,    Japanese,0},
  { "水素原子",                                         StrMHydr,    Japanese,1},
  { "ヘテロ原子",                                       StrMHet,     Japanese,2},
  { "輝き",                                            StrMSpec,    Japanese,1},
  { "影",                                              StrMShad,    Japanese,1},
  { "ステレオ",                                         StrMStereo,  Japanese,5},
  { "ラベル",                                          StrMLabel,   Japanese,0},
  { "オフ",                                          StrMPOff,    Japanese,5},
  { "選択されたものを表示",                             StrMPIdent,  Japanese,5},
  { "距離を測る",                                     StrMPDist,   Japanese,5},
  { "距離を表示",                                     StrMPMon,    Japanese,0},
  { "角度を測る",                                     StrMPAng,    Japanese,5},
  { "２面角をはかる",                                  StrMPTrsn,   Japanese,5},
  { "ラベルを付ける",                                  StrMPLabl,   Japanese,5}, 
  { "中心を設定",                                     StrMPCent,   Japanese,5},
  { "座標を表示",                                     StrMPCoord,  Japanese,6},
  { "結合を指定",                                     StrMPBond,   Japanese,5},
  { "結合を回転",                                     StrMRBond,   Japanese,0},
  { "分子を回転",                                     StrMRMol,    Japanese,7},
  { "すべてを回転",                                   StrMRAll,    Japanese,7},
  { "BMP ...",                                         StrMBMP,     Japanese,0},  
  { "GIF ...",                                         StrMGIF,     Japanese,0},  
  { "IRIS RGB ...",                                    StrMIRGB,    Japanese,5},  
  { "PPM ...",                                         StrMPPM,     Japanese,2},  
  { "Sun Raster...",                                   StrMSRast,   Japanese,0},  
  { "PostScript...",                                   StrMPostscr, Japanese,0},  
  { "PICT...",                                         StrMPICT,    Japanese,1},  
  { "Vector PS ...",                                   StrMVECPS,   Japanese,0},  
  { "Molscript ...",                                   StrMMSCR,    Japanese,1},  
  { "Kinemage ...",                                    StrMKine,    Japanese,0},  
  { "POVRay 3 ...",                                    StrMPOVRAY,  Japanese,2},  
  { "VRML ...",                                        StrMVRML,    Japanese,3},  
  { "Ramachandran ...",                                StrMRPP,     Japanese,3},  
  { "Raster3D ...",                                    StrMR3D,     Japanese,6},  
  { "RasMolスクリプト...",                           StrMSCR,     Japanese,8},  
  { "RasMolについて...",                                StrMAbout,   Japanese,0},
  { "マニュアル...",                                     StrMUserM,   Japanese,0},
  { "元に戻す",                                         StrMUndo,    Japanese,0},
  { "カット",                                           StrMCut,     Japanese,1},
  { "コピー",                                           StrMCopy,    Japanese,1},
  { "ペースト",                                         StrMPaste,   Japanese,0},
#ifdef APPLEMAC
  { "消去",                                             StrMClear,   Japanese,1},
#else
  { "削除",                                             StrMDelete,  Japanese,0},
#endif
  { "すべてを選択",                                       StrMSelAll,  Japanese,0},
  { "ファイル",                                            StrMFile,    Japanese,0},
  { "編集",                                            StrMEdit,    Japanese,0},
  { "表示方法",                                         StrMDisplay, Japanese,0},
  { "色",                                         StrMColour,  Japanese,0},
  { "オプション",                                         StrMOpt,     Japanese,0},
  { "設定",                                        StrMSettings,Japanese,0},
  { "画像出力",                                          StrMExport,  Japanese,1},
#ifdef APPLEMAC
  { "ウインドウ",                                          StrMWindow,  Japanese,0},
#endif
  { "ヘルプ",                                            StrMHelp,    Japanese,0},
#ifdef APPLEMAC
  { "メインウインドウ",                                     StrMMainWin,  Japanese,0},
  { "コマンドライン",                                    StrMCmndLin,  Japanese,0},
#endif
#else
  { "開く(&O) ...",                                       StrMOpen,    Japanese,0},
  { "情報(&I)",                                    StrMInfo,    Japanese,0},
  { "閉じる(&C)",                                          StrMClose,   Japanese,0},
  { "印刷(&P)",                                          StrMPrint,   Japanese,0},
  { "ページ設定(&R)",                                    StrMPSetup,  Japanese,0},
  { "終了(&E)",                                           StrMExit,    Japanese,0},
  { "ワイヤーフレーム(&W)",                                      StrMWirefr,  Japanese,0},
  { "主鎖(&M)",                                       StrMBackbn,  Japanese,0},
  { "スティック(&B)",                                         StrMSticks,  Japanese,1},
  { "空間充填モデル(&S)",                                      StrMSpacefl, Japanese,0},
  { "棒玉(&H)",                                  StrMBallStk, Japanese,0},
  { "リボン(&R)",                                        StrMRibbons, Japanese,0},
  { "ストランド(&T)",                                        StrMStrands, Japanese,3},
  { "カートゥーン(&C)",                                       StrMCartoon, Japanese,0},
  { "分子表面(&M)",                              StrMMolSurf, Japanese,0},
  { "白黒(&M)",                                     StrMMonochr, Japanese,0},
  { "&CPK（カラー）",                                            StrMCPK,     Japanese,0},
  { "形(&H)",                                        StrMShapely, Japanese,0},
  { "グループ(&G)",                                          StrMGroup,   Japanese,0},
  { "鎖(&C)",                                          StrMChain,   Japanese,1},
  { "温度(&T)",                                    StrMTemp,    Japanese,0},
  { "構造(&S)",                                      StrMStruct,  Japanese,2},
  { "ユーザー(&U)",                                           StrMUser,    Japanese,0},
  { "モデル(&D)",                                          StrMModel,   Japanese,2},
  { "可換構造(&A)",                                            StrMAlt,     Japanese,0},
  { "スラブモード(&P)",                                      StrMSlab,    Japanese,0},
  { "水素原子(&H)",                                      StrMHydr,    Japanese,1},
  { "ヘテロ原子(&N)",                                   StrMHet,     Japanese,2},
  { "輝き(&T)",                                       StrMSpec,    Japanese,1},
  { "影(&D)",                                        StrMShad,    Japanese,1},
  { "ステレオ(&S)",                                         StrMStereo,  Japanese,5},
  { "ラベル(&L)",                                         StrMLabel,   Japanese,0},
  { "オフ(&O)",                                       StrMPOff,    Japanese,5},
  { "選択されたものを表示(&I)",                                     StrMPIdent,  Japanese,5},
  { "距離を測る(&D)",                                  StrMPDist,   Japanese,5},
  { "距離を表示(&S)",                                   StrMPMon,    Japanese,0},
  { "角度を測る(&A)",                                     StrMPAng,    Japanese,5},
  { "２面角をはかる(&T)",                                   StrMPTrsn,   Japanese,5},
  { "ラベルを付ける(&L)",                                     StrMPLabl,   Japanese,5}, 
  { "中心を設定(&C)",                                    StrMPCent,   Japanese,5},
  { "座標を表示(&X)",                                     StrMPCoord,  Japanese,6},
  { "結合を指定(&B)",                                      StrMPBond,   Japanese,5},
  { "結合を回転(&R)",                                    StrMRBond,   Japanese,0},
  { "分子を回転(&M)",                                     StrMRMol,    Japanese,7},
  { "すべてを回転(&H)",                                     StrMRAll,    Japanese,7},
  { "&BMP ...",                                        StrMBMP,     Japanese,0},  
  { "&GIF ...",                                        StrMGIF,     Japanese,0},  
  { "IRIS &RGB ...",                                   StrMIRGB,    Japanese,5},  
  { "PP&M ...",                                        StrMPPM,     Japanese,2},  
  { "&Sun Raster...",                                  StrMSRast,   Japanese,0},  
  { "&PostScript...",                                  StrMPostscr, Japanese,0},  
  { "PICT... &26",                                        StrMPICT,    Japanese,1},  
  { "&Vector PS ...",                                  StrMVECPS,   Japanese,0},  
  { "M&olscript ...",                                  StrMMSCR,    Japanese,1},  
  { "Kinemage ...  (&29)",                                   StrMKine,    Japanese,0},  
  { "PO&VRay 3 ...",                                   StrMPOVRAY,  Japanese,2},  
  { "VRM&L ...",                                       StrMVRML,    Japanese,3},  
  { "Ram&achandran ...",                               StrMRPP,     Japanese,3},  
  { "Raster&3D ...",                                   StrMR3D,     Japanese,6},  
  { "RasMolスクリプト(&C)...",                              StrMSCR,     Japanese,8},  
  { "RasMolについて(&A)...",                                StrMAbout,   Japanese,0},
  { "マニュアル(&M)...",                                 StrMUserM,   Japanese,0},
  { "元に戻す(&Z)",                                           StrMUndo,    Japanese,0},
  { "カット(&X)",                                            StrMCut,     Japanese,1},
  { "コピー(&C)",                                           StrMCopy,    Japanese,1},
  { "ペースト(&V)",                                          StrMPaste,   Japanese,0},
  { "削除(&D)",                                         StrMDelete,  Japanese,0},
  { "すべてを選択(&S)",                                     StrMSelAll,  Japanese,0},
  { "ファイル(&F)",                                           StrMFile,    Japanese,0},
  { "編集(&E)",                                           StrMEdit,    Japanese,0},
  { "表示方法(&D)",                                        StrMDisplay, Japanese,0},
  { "色(&C)",                                        StrMColour,  Japanese,0},
  { "オプション(&O)",                                        StrMOpt,     Japanese,0},
  { "設定(&S)",                                       StrMSettings,    Japanese,0},
  { "画像出力(&X)",                                         StrMExport,  Japanese,1},
  { "ヘルプ(&H)",                                           StrMHelp,    Japanese,0},
#endif
  { "PDBファイル名:",                                  StrPrmtPDB,  Japanese,0},
  { "画像ファイル名:",                                StrPrmtImg,  Japanese,0},
  { "分子構造ファイル名:",                             StrPrmtMol,  Japanese,0},
  { "警告: ",                                           StrWarn,     Japanese,0},
  { "鎖",                                              StrChain,    Japanese,0},
  { "ユーザー登録",                                        StrRegister, Japanese,0},
  { "寄付について",                                          StrDonate,   Japanese,0},
  { "起動時にこのダイアログを表示しない",              StrNoShow,   Japanese,0},
  { "GPLによる保証無しのオープンソース。寄付をお願いします。", StrWarranty, Japanese,0}





};

 
 
void SwitchLang( language lang ) {

  int ii;
  int kmsg;

  kmsg = sizeof(langstrs)/sizeof(langstr);
  for (ii = 0; ii < MaxStrFlag; ii++) {
     MsgStrs[ii] = (char *)0;
     MsgLens[ii] = 0;
     MsgAuxl[ii] = 0;
  }
  for (ii = 0; ii < kmsg; ii++) {
    if (langstrs[ii].lang == lang) {
      MsgStrs[langstrs[ii].msgno] = langstrs[ii].msg;
      MsgLens[langstrs[ii].msgno] = strlen(langstrs[ii].msg);
      MsgAuxl[langstrs[ii].msgno] = langstrs[ii].aux;
    }
  }
  for (ii = 0; ii < kmsg; ii++) {
    if (langstrs[ii].lang == English && !(MsgStrs[langstrs[ii].msgno])) {
      WriteString("\nError: Translation missing for ...\n");
      WriteString(langstrs[ii].msg);
      MsgStrs[langstrs[ii].msgno] = langstrs[ii].msg;
      MsgLens[langstrs[ii].msgno] = strlen(langstrs[ii].msg);
      MsgAuxl[langstrs[ii].msgno] = langstrs[ii].aux;
    }
  }
  Language = lang;
  UpdateLanguage();
  if (Interactive)
    ReDrawWindow();
    if (Language != lang) {
      for (ii = 0; ii < kmsg; ii++) {
        if (langstrs[ii].lang == Language) {
          MsgStrs[langstrs[ii].msgno] = langstrs[ii].msg;
          MsgLens[langstrs[ii].msgno] = strlen(langstrs[ii].msg);
          MsgAuxl[langstrs[ii].msgno] = langstrs[ii].aux;
        }
      }
    ReDrawWindow();
    UpdateLanguage();
    InvalidateCmndLine();
    WriteString("Error: Unable to find font for ");
    WriteString((char *)lang2str(lang));
    WriteString("\n");
    for (ii = 0; ii < NUMLANGS; ii++) {
      if (langfonts[ii].lang == lang) {
        WriteString(langfonts[ii].menufontlist);
        WriteString("\n");
      	
      }
    	
    }
  }

}

language str2lang ( const char * langstr) {

  int ilang;

  for (ilang = 0; ilang < NUMLANGS; ilang++) {
  
    if (!strcasecmp(langstr,langnames[ilang])) {
      return (language) ilang;	
    }
    
  }

  return English;
  	
	
	
}

const char * lang2str ( language lang) {
	
	if ((int)lang >= 0 && (int)lang < NUMLANGS) return langnames[(int)lang];
	else return langnames[0];
}
