#!/usr/bin/python
#
#  Copyright (c) 1998-2001 Sean Reifschneider, tummy.com, ltd.  
#	All Rights Reserved.
#
#  Module which generates text-format reports.  Is called by the
#  generator.py module *ONLY*.  Requires only being imported by the
#  "stdreport" program, it automatically registers with the generator to
#  generate reports.
#
#  http://www.tummy.com/radiusContext/
#  ftp://ftp.tummy.com/pub/tummy/radiusContext/

import time
import generator
from radiussupp import *
import os, sys

headLine = "Login Date              Time This    Total   BW In/Out     Reason\n"
seppLine = "=============================================" + \
		"===============================\n"

class gentext:
	genname = "text"

	def __init__(self):
		self.out = None
		self.outIndex = None
		self.reportDirName = "."
		self.reportIndexName = "index"
		self.reportSuffix = ""
		self.splitNum = None

	def setSplit(self, split = None):
		self.splitNum = split

	def reportDir(self, name):
		self.reportDirName = name

	def reportIndex(self, name):
		self.reportIndexName = name

	def Start(self, sesData):
		dir = self.reportDirName + '/'
		if self.splitNum > 0:
			dir = '%s%s/' % ( dir, sesData['userName'][:self.splitNum] )

		try: os.mkdir(dir)
		except os.error: pass
		outputName = dir + sesData["userName"] + self.reportSuffix
		try:
			self.out = open(outputName, "w")
		except IOError:
			sys.stdout.write('Error writing file "%s"' % outputName)
			sys.stdout.write('Make sure it\'s directory exists and is writable.\n')
			sys.exit(1)

		self.out.write("Session report for: %s\n" % ( sesData["userName"] ))
		self.out.write(headLine)
		self.out.write(seppLine)

	def Stop(self, sesData):
		if self.out != None:
			self.out.write(seppLine)
			self.out.write("Total Online Time: %s   Days on: %d\n"
					% ( secsToStr(sesData["timeOn"]), sesData["numDays"] ))
			self.out.write("Average Online Times:  %s per day,  %s per session\n"
					% ( secsToStr(sesData["timeOn"] / sesData["numDays"]),
					secsToStr(sesData["timeOn"] / sesData["sessionCount"]) ))

			self.out.write(
					"Total Data Transferred In/Out:  %s/%s  Rate In/Out: %s/%s\n"
					% ( bytesToStr(sesData["bytesIn"]),
					bytesToStr(sesData["bytesOut"]),
					sesData["bwIn"], sesData["bwOut"] ))
			self.out.write("\nGenerated by radiusContext "+
					"(http://www.tummy.com/radiusContext/)\n")
			self.out.close()
			self.out = None

	def Item(self, userData, sesData):
		termReason = sesData.get("Acct-Terminate-Cause", "")
		if termReason == "User-Request":
			termReason = ""
		if not termReason:
			termReason = sesData.get("Ascend-Disconnect-Cause", "")

		self.out.write("%-23s  %8s %8s  %6s/%-6s  %s\n" % ( sesData["reportDate"],
				secsToStr(sesData["currentTime"], 2),
				secsToStr(userData["timeOn"], 2),
				sesData["bwIn"],
				sesData["bwOut"],
				termReason ))

	def IndexStart(self):
		self.outIndex = open(self.reportDirName + "/" + self.reportIndexName
				+ self.reportSuffix, "w")
		self.outIndex.write("Overall Dial-In Report generated %s\n\n" %
				( time.strftime("%A, %B %d, %Y", time.localtime(time.time())) ))
		self.outIndex.write("                                  Times Online\n")
		self.outIndex.write(
			"User Name            SesNum   Total  Per Day  Per Ses   BW In/Out\n")
		self.outIndex.write(seppLine)

	def IndexStop(self, indexData):
		if self.outIndex != None:
			self.outIndex.write(seppLine)

			self.outIndex.write(
					"Average Online Time: %s per user, %s per session\n" %
					( secsToStr(indexData["timePerUser"]),
					secsToStr(indexData["timePerSes"]) ))
			self.outIndex.write("Average Sessions: %d per user\n" % (
					indexData["sesPerUser"] ))
			self.outIndex.write(
					"Data In/Out: %s/%s total, %s/%s per user, %s/%s per session\n" %
					( bytesToStr(indexData["bytesIn"]),
					bytesToStr(indexData["bytesOut"]),
					bytesToStr(indexData["dataInPerUser"]),
					bytesToStr(indexData["dataOutPerUser"]),
					bytesToStr(indexData["dataInPerSes"]),
					bytesToStr(indexData["dataOutPerSes"]) ))

			self.outIndex.write(
					"Throughput In/Out: %s/%s total, %s/%s per user\n" %
					( bytesToStr(indexData["bwIn"]), bytesToStr(indexData["bwOut"]),
					bytesToStr(indexData["bwInUser"]),
					bytesToStr(indexData["bwOutUser"]) ))
			self.outIndex.write("\nGenerated by radiusContext "+
					"(http://www.tummy.com/radiusContext/)\n")
			self.outIndex.close()
			self.outIndex = None

	def IndexItem(self, indexData, userData):
		self.outIndex.write("%-20s  %4d  %7s  %7s  %7s  %6s/%-6s\n" %
				( userData["userName"], userData["sessionCount"],
				secsToStr(userData["timeOn"], 2),
				secsToStr(userData["timeOn"] / userData["numDays"], 2),
				secsToStr(userData["timeOn"] / userData["sessionCount"], 2),
				bytesToStr(userData["bytesIn"]),
				bytesToStr(userData["bytesOut"]) ))
		self.outIndex.flush()

generator.append(gentext())
