#!/usr/bin/python
#
#  Copyright (c) 1998-2001 Sean Reifschneider, tummy.com, ltd.  
#	All Rights Reserved.
#
#  Module which generates HTML-format reports.  Is called by the generator.py
#  module *ONLY*.  Requires only being imported by the "stdreport" program,
#  it automatically registers with the generator to generate reports.
#
#  http://www.tummy.com/radiusContext/
#  ftp://ftp.tummy.com/pub/tummy/radiusContext/

import time
import generator
import os
from radiussupp import *

#  Ascend Termination Reasons
ascendTermReason = {
		0 : "No Reason",
		1 : "Non Hangup",
		2 : "Unknown",
		3 : "Call Disconnected",
		4 : "CLID Auth Fail",
		10 : "No DCD",
		11 : "DCD->Inactive",
		45 : "User Request",
		151 : "Killed",
		185 : "User Hangup",
		12 : 'The result codes could not be parsed.',
		20 : 'The user exited normally from the terminal server.',
		21 : 'The user exited from the terminal server because the idle timer '
				'expired.',
		22 : 'The user exited normally from a Telnet session.',
		23 : 'The user could not switch to SLIP or PPP because the remote host'
				' had no IP address or because the dynamic pool could not '
				'assign one.',
		24 : 'The user exited normally from a raw TCP session.',
		25 : 'The login process ended because the user failed to enter a correct'
				' password after three attempts.',
		26 : 'The raw TCP option is not enabled.',
		27 : 'The login process ended because the user typed Ctrl-C.',
		28 : 'The terminal server session has ended.',
		29 : 'The user closed the virtual connection',
		30 : 'The virtual connection has ended.',
		31 : 'The user exited normally from an Rlogin session',
		32 : 'The user selected an invalid Rlogin option.',
		33 : 'The has insufficient resources for the terminal server session.',
		40 : 'PPP LCP negotiation timed out while waiting for a response from a'
				' peer.',
		41 : 'There was a failure to converge on PPP LCP negotiations.',
		42 : 'PPP PAP authentication failed.',
		43 : 'PPP CHAP authentication failed.',
		44 : 'Authentication failed from the remote server.',
		46 : 'LCP got a close request from the upper layer while LCP was in'
				' an open state.',
		47 : 'LCP closed because no NCPs were open.',
		48 : 'LCP closed because it could not determine to which MP bundle '
				'it should add the user.',
		49 : 'LCP closed because the could not add any more channels to an '
				'MP session.',
		50 : 'The Raw TCP or Telnet internal session tables are full.',
		51 : 'Internal resources are full.',
		52 : 'The IP address for the Telnet host is invalid.',
		53 : 'The could not resolve the hostname.',
		54 : 'The detected a bad or missing port number.',
		60 : 'The host reset the TCP connection.',
		61 : 'The host refused the TCP connection.',
		62 : 'The TCP connection timed out.',
		63 : 'A foreign host closed the TCP connection.',
		64 : 'The TCP network was unreachable.',
		65 : 'The TCP host was unreachable.',
		66 : 'The TCP network was administratively unreachable.',
		67 : 'The TCP host was administratively unreachable.',
		68 : 'The TCP port was unreachable.',
		100 : 'The session timed out because there was no activity on a '
				'PPP link.',
		101 : 'The session failed for security reasons.',
		102 : 'The session ended for callback.',
		120 : 'One end refused the call because the protocol was disabled or'
				' unsupported.',
		150 : 'RADIUS requested the disconnect.',
		160 : 'The allowed retries for V.110 synchronization have been exceeded.',
		170 : 'PPP authentication has timed out.',
		180 : 'Local hangup',
		190 : 'The call disconnected because the T1 line that carried it was'
				' quiesced.',
		195 : 'The call disconnected because the call duration exceeded the'
				' maximum amount of time allowed by the Max Call Mins or Max DS0'
				' Mins parameter on the .'
		}

class genhtml:
	genname = "HTML-Ascend"

	def __init__(self):
		self.out = None
		self.outIndex = None
		self.outMainIndex = None
		self.reportDirName = "."
		self.reportIndexName = "index"
		self.reportSuffix = ".html"
		self.splitNum = None
		self.lastIndexDir = None

	def setSplit(self, split = None):
		self.splitNum = split

	def reportDir(self, name):
		self.reportDirName = name

	def reportIndex(self, name):
		self.reportIndexName = name

	def Start(self, sesData):
		dir = self.reportDirName + '/'
		if self.splitNum > 0:
			dir = '%s%s/' % ( dir, sesData['userName'][:self.splitNum] )

		try: os.mkdir(dir)
		except os.error: pass
		self.out = open(dir + sesData["userName"] + self.reportSuffix, "w")

		title = "Session report for: %s\n" % ( sesData["userName"] )
		self.out.write("<HTML>\n<HEAD>\n<TITLE>" + title + "</TITLE>\n</HEAD>\n")
		self.out.write("<BODY><H1>" + title + "</H1>\n")
		self.out.write("<TABLE BORDER=1>\n")
		self.out.write("<TR><TH>Login Date</TH><TH>Time<BR>This</TH>")
		self.out.write("<TH>Time<BR>Total</TH>")
		self.out.write("<TH>BW<BR>In/Out</TH><TH>Data<BR>I/O</TH>"
				"<TH>IP</TH><TH>CallerID</TH><TH>Down/Up Rate</TH>"
				"<TH>Disconnect<BR>Reason</TH></TR>\n")

	def Stop(self, sesData):
		if self.out != None:
			self.out.write("</TABLE>\n")
			self.out.write("<TABLE BORDER=1>\n")
			self.out.write("<TR><TD>Total Online Time:</TD><TD>%s</TD></TR>" %
					( secsToStr(sesData["timeOn"]) ))
			self.out.write("<TR><TD>Days on:</TD><TD>%d</TD></TR>\n"
					% ( sesData["numDays"] ))
			self.out.write("<TR><TD>Average Online Times:</TD><TD>%s per day"
					% ( secsToStr(sesData["timeOn"] / sesData["numDays"]) ))
			self.out.write("</TD><TD>%s per session</TD></TR>\n" %
					(secsToStr(sesData["timeOn"] / sesData["sessionCount"]) ))

			self.out.write("<TR><TD>Total Data Transferred In/Out:</TD>")
			self.out.write("<TD>%s/%s</TD></TR>\n" %
					( bytesToStr(sesData["bytesIn"]),
					bytesToStr(sesData["bytesOut"]) ))
			self.out.write("<TR><TD>Rate In/Out:</TD><TD>%s/%s</TD>\n" %
					( sesData["bwIn"], sesData["bwOut"] ))
			self.out.write("</TABLE>\n")
			self.out.write("\n<P>Generated by <A HREF=\"http://www.tummy.com/" +
					"radiusContext/\">radiusContext</A>\n")
			self.out.write("</BODY></HTML>\n")
			self.out.close()
			self.out = None

	def Item(self, userData, sesData):
		try:
			termReason = ascendTermReason[int(
					sesData.get("Ascend-Disconnect-Cause", 0))]
		except KeyError:
			termReason = sesData.get("Acct-Terminate-Cause", "")

		sessIP = sesData.get("Framed-Address", "")
		sessCallerID = sesData.get("Caller-Id", "")
		sessINd = bytesToStr(sesData.get("Acct-Input-Octets", 0))
		sessOUTd = bytesToStr(sesData.get("Acct-Output-Octets", 0))
		sessXmit = sesData.get("Ascend-Xmit-Rate", "")
		sessRmit = sesData.get("Ascend-Data-Rate", "")

		if not termReason: termReason = "Unknown"
		if termReason == "User-Request": termReason = ""

		self.out.write("<TR><TD>%-23s</TD><TD>%8s</TD><TD>%8s</TD>" %
				( sesData["Session-Start-Date"],
				secsToStr(sesData["currentTime"], 2),
				secsToStr(userData["timeOn"], 2) ))
		self.out.write("<TD>%6s/%-6s</TD><TD>%s/%s</TD><TD>%s</TD>"
				"<TD>%s</TD><TD>%s/%s</TD><TD>%s</TD></TR>\n" % ( sesData["bwIn"],
				sesData["bwOut"], sessINd, sessOUTd, sessIP,
				sessCallerID, sessXmit, sessRmit, termReason ))

	def IndexStart(self):
		self.outMainIndex = open(self.reportDirName + "/" + self.reportIndexName
				+ self.reportSuffix, "w")
		title = "Overall Dial-In Report generated %s" % (
				time.strftime("%A, %B %d, %Y", time.localtime(time.time())) )
		self.IndexWriteUserHeader(self.outMainIndex, title)

	def IndexStop(self, indexData):
		if self.outIndex != None:
			self.outIndex.write("</TABLE>\n")
			self.outIndex.close()
			self.outIndex = None

		if self.outMainIndex != None:
			self.outMainIndex.write("</TABLE>\n")
			self.outMainIndex.write("<TABLE BORDER=1>\n")

			self.outMainIndex.write(
					"<TR><TD>Average Online Time:</TD><TD></TD><TD>%s per user" %
					( secsToStr(indexData["timePerUser"]) ))
			self.outMainIndex.write("</TD><TD>%s per session</TD></TR>\n" %
					( secsToStr(indexData["timePerSes"]) ))
			self.outMainIndex.write("<TR><TD>Average Sessions:</TD><TD></TD>")
			self.outMainIndex.write("<TD>%d per user</TD></TR>\n" %
					( indexData["sesPerUser"] ))
			self.outMainIndex.write("<TR><TD>Data In/Out:</TD><TD>%s/%s total</TD>"
					% ( bytesToStr(indexData["bytesIn"]),
					bytesToStr(indexData["bytesOut"]) ))
			self.outMainIndex.write("<TD>%s/%s per user</TD>" %
					( bytesToStr(indexData["dataInPerUser"]),
					bytesToStr(indexData["dataOutPerUser"]) ))
			self.outMainIndex.write("<TD>%s/%s per session</TD></TR>\n" %
					( bytesToStr(indexData["dataInPerSes"]),
					bytesToStr(indexData["dataOutPerSes"]) ))

			self.outMainIndex.write("<TR><TD>Throughput In/Out:</TD>")
			self.outMainIndex.write("<TD>%s/%s total</TD>" %
					( bytesToStr(indexData["bwIn"]),
					bytesToStr(indexData["bwOut"]) ))
			self.outMainIndex.write("<TD>%s/%s per user</TD></TR>\n" %
					( bytesToStr(indexData["bwInUser"]),
					bytesToStr(indexData["bwOutUser"]) ))
			self.outMainIndex.write("</TABLE>\n")
			self.outMainIndex.write("\n<P>Generated by " +
					"<A HREF=\"http://www.tummy.com/radiusContext/\">" +
					"radiusContext</A>\n")
			self.outMainIndex.write("</BODY></HTML>\n")
			self.outMainIndex.close()
			self.outMainIndex = None


	####################################
	#  write the user header information

	def IndexWriteUserHeader(self, fp, title):
		fp.write("<HTML>\n<HEAD>\n<TITLE>" + title
				+ "</TITLE>\n</HEAD>\n")
		fp.write("<BODY><H1>" + title + "</H1>\n")
		fp.write("<TABLE BORDER=1>\n")
		fp.write("<TR><TH>User Name</TH><TH>Session<BR>Count</TH><TH>")
		fp.write("Time<BR>Total</TH><TH>Time<BR>Per Day</TH><TH>")
		fp.write("Time<BR>Per Ses</TH><TH>BW<BR>In/Out</TH></TR>\n")


	def IndexItem(self, indexData, userData):
		dir = ''
		if self.splitNum > 0:
			dir = userData['userName'][:self.splitNum]

		out = self.outMainIndex
		if self.splitNum > 0:
			#  re-open split index
			if dir != self.lastIndexDir and self.outIndex != None:
				self.outIndex.write("</TABLE>\n</BODY>\n</HTML>\n")
				self.outIndex.close()
				self.outIndex = None
			if self.outIndex == None:
				self.outIndex = open(self.reportDirName + '/' + dir
						+ '/' + self.reportIndexName + self.reportSuffix, 'w')
				title = "Dial-In Report ``%s'' generated %s" % ( dir,
						time.strftime("%A, %B %d, %Y", time.localtime(time.time())) )
				self.IndexWriteUserHeader(self.outIndex, title)

				if self.splitNum > 0:
					self.outMainIndex.write('<TR><TD><A HREF="%s/%s%s">%s</A><BR>'
							'</TD></TR>\n' %
							( dir, self.reportIndexName, self.reportSuffix, dir ))

		#  remember the last index dir name
		self.lastIndexDir = dir

		#  set output file handle (code above may re-open self.outIndex)
		out = self.outIndex

		out.write("<TR><TD><A HREF=\"" + userData["userName"]
				+ self.reportSuffix + "\">%s</TD><TD>%d</TD><TD>%s</TD><TD>" %
				( userData["userName"], userData["sessionCount"],
				secsToStr(userData["timeOn"], 2) ))
		out.write("%s</TD><TD>%s</TD><TD>%s/%s</TD><TD></TR>\n" %
				( secsToStr(userData["timeOn"] / userData["numDays"], 2),
				secsToStr(userData["timeOn"] / userData["sessionCount"], 2),
				bytesToStr(userData["bytesIn"]),
				bytesToStr(userData["bytesOut"]) ))
		out.flush()

generator.append(genhtml())
