#!/usr/bin/python
#
#  Copyright (c) 1998-2001 Sean Reifschneider, tummy.com, ltd.  
#	All Rights Reserved.
#
#  Module which generates HTML-format reports.  Is called by the generator.py
#  module *ONLY*.  Requires only being imported by the "stdreport" program,
#  it automatically registers with the generator to generate reports.
#
#  http://www.tummy.com/radiusContext/
#  ftp://ftp.tummy.com/pub/tummy/radiusContext/

import time
import generator
import os
from radiussupp import *

class genhtml:
	genname = "HTML"

	def __init__(self):
		self.out = None
		self.outIndex = None
		self.outMainIndex = None
		self.reportDirName = "."
		self.reportIndexName = "index"
		self.reportSuffix = ".html"
		self.splitNum = None
		self.lastIndexDir = None

	def setSplit(self, split = None):
		self.splitNum = split

	def reportDir(self, name):
		self.reportDirName = name

	def reportIndex(self, name):
		self.reportIndexName = name

	def Start(self, sesData):
		dir = self.reportDirName + '/'
		if self.splitNum > 0:
			dir = '%s%s/' % ( dir, sesData['userName'][:self.splitNum] )

		try: os.mkdir(dir)
		except os.error: pass
		outputName = dir + sesData["userName"] + self.reportSuffix
		try:
			self.out = open(outputName, "w")
		except IOError:
			sys.stdout.write('Error writing file "%s"' % outputName)
			sys.stdout.write('Make sure it\'s directory exists and is writable.\n')
			sys.exit(1)

		title = "Session report for: %s\n" % ( sesData["userName"] )
		self.out.write("<HTML>\n<HEAD>\n<TITLE>" + title + "</TITLE>\n</HEAD>\n")
		self.out.write("<BODY><H1>" + title + "</H1>\n")
		self.out.write("<TABLE BORDER=1>\n")
		self.out.write("<TR><TH>Login Date</TH><TH>Time<BR>This</TH>")
		self.out.write("<TH>Time<BR>Total</TH>")
		self.out.write("<TH>BW<BR>In/Out</TH><TH>Caller ID</TH>")
		self.out.write("<TH>IP Address</TH><TH>Reason</TH></TR>\n")

	def Stop(self, sesData):
		if self.out != None:
			self.out.write("</TABLE>\n")
			self.out.write("<TABLE BORDER=1>\n")
			self.out.write("<TR><TD>Total Online Time:</TD><TD>%s</TD></TR>" %
					( secsToStr(sesData["timeOn"]) ))
			self.out.write("<TR><TD>Days on:</TD><TD>%d</TD></TR>\n"
					% ( sesData["numDays"] ))
			self.out.write("<TR><TD>Average Online Times:</TD><TD>%s per day"
					% ( secsToStr(sesData["timeOn"] / sesData["numDays"]) ))
			self.out.write("</TD><TD>%s per session</TD></TR>\n" %
					(secsToStr(sesData["timeOn"] / sesData["sessionCount"]) ))

			self.out.write("<TR><TD>Total Data Transferred In/Out:</TD>")
			self.out.write("<TD>%s/%s</TD></TR>\n" %
					( bytesToStr(sesData["bytesIn"]),
					bytesToStr(sesData["bytesOut"]) ))
			self.out.write("<TR><TD>Rate In/Out:</TD><TD>%s/%s</TD>\n" %
					( sesData["bwIn"], sesData["bwOut"] ))
			self.out.write("</TABLE>\n")
			self.out.write("\n<P>Generated by <A HREF=\"http://www.tummy.com/" +
					"radiusContext/\">radiusContext</A>\n")
			self.out.write("</BODY></HTML>\n")
			self.out.close()
			self.out = None

	def Item(self, userData, sesData):
		termReason = sesData.get("Acct-Terminate-Cause", "")
		if termReason == "User-Request":
			termReason = ""
		if not termReason:
			termReason = sesData.get("Ascend-Disconnect-Cause", "")

		#  get caller-id information
		callerId = ''
		if sesData.has_key('Calling-Station-Id'):
			callerId = sesData['Calling-Station-Id']
		if sesData.has_key("Caller-Id"):
			sessCallerID = sesData['Caller-Id']

		#  get IP address information
		ipAddr = ''
		if sesData.has_key('Framed-IP-Address'):
			ipAddr = sesData['Framed-IP-Address']

		#  write out record
		self.out.write("<TR><TD>%-23s</TD><TD>%8s</TD><TD>%8s</TD>" %
				( sesData["Session-Start-Date"],
				secsToStr(sesData["currentTime"], 2),
				secsToStr(userData["timeOn"], 2) ))
		self.out.write("<TD>%6s/%-6s</TD><TD>%s</TD><TD>%s</TD>"
				"<TD>%s</TD></TR>\n" % ( sesData["bwIn"], sesData["bwOut"],
				callerId, ipAddr, termReason ))

	def IndexStart(self):
		self.outMainIndex = open(self.reportDirName + "/" + self.reportIndexName
				+ self.reportSuffix, "w")
		title = "Overall Dial-In Report generated %s" % (
				time.strftime("%A, %B %d, %Y", time.localtime(time.time())) )
		self.IndexWriteUserHeader(self.outMainIndex, title)

	def IndexStop(self, indexData):
		if self.outIndex != None:
			self.outIndex.write("</TABLE>\n")
			self.outIndex.close()
			self.outIndex = None

		if self.outMainIndex != None:
			self.outMainIndex.write("</TABLE>\n")
			self.outMainIndex.write("<TABLE BORDER=1>\n")

			self.outMainIndex.write(
					"<TR><TD>Average Online Time:</TD><TD></TD><TD>%s per user" %
					( secsToStr(indexData["timePerUser"]) ))
			self.outMainIndex.write("</TD><TD>%s per session</TD></TR>\n" %
					( secsToStr(indexData["timePerSes"]) ))
			self.outMainIndex.write("<TR><TD>Average Sessions:</TD><TD></TD>")
			self.outMainIndex.write("<TD>%d per user</TD></TR>\n" %
					( indexData["sesPerUser"] ))
			self.outMainIndex.write("<TR><TD>Data In/Out:</TD><TD>%s/%s total</TD>"
					% ( bytesToStr(indexData["bytesIn"]),
					bytesToStr(indexData["bytesOut"]) ))
			self.outMainIndex.write("<TD>%s/%s per user</TD>" %
					( bytesToStr(indexData["dataInPerUser"]),
					bytesToStr(indexData["dataOutPerUser"]) ))
			self.outMainIndex.write("<TD>%s/%s per session</TD></TR>\n" %
					( bytesToStr(indexData["dataInPerSes"]),
					bytesToStr(indexData["dataOutPerSes"]) ))

			self.outMainIndex.write("<TR><TD>Throughput In/Out:</TD>")
			self.outMainIndex.write("<TD>%s/%s total</TD>" %
					( bytesToStr(indexData["bwIn"]),
					bytesToStr(indexData["bwOut"]) ))
			self.outMainIndex.write("<TD>%s/%s per user</TD></TR>\n" %
					( bytesToStr(indexData["bwInUser"]),
					bytesToStr(indexData["bwOutUser"]) ))
			self.outMainIndex.write("</TABLE>\n")
			self.outMainIndex.write("\n<P>Generated by " +
					"<A HREF=\"http://www.tummy.com/radiusContext/\">" +
					"radiusContext</A>\n")
			self.outMainIndex.write("</BODY></HTML>\n")
			self.outMainIndex.close()
			self.outMainIndex = None


	####################################
	#  write the user header information

	def IndexWriteUserHeader(self, fp, title):
		fp.write("<HTML>\n<HEAD>\n<TITLE>" + title
				+ "</TITLE>\n</HEAD>\n")
		fp.write("<BODY><H1>" + title + "</H1>\n")
		fp.write("<TABLE BORDER=1>\n")
		fp.write("<TR><TH>User Name</TH><TH>Session<BR>Count</TH><TH>")
		fp.write("Time<BR>Total</TH><TH>Time<BR>Per Day</TH><TH>")
		fp.write("Time<BR>Per Ses</TH><TH>BW<BR>In/Out</TH></TR>\n")


	def IndexItem(self, indexData, userData):
		dir = ''
		if self.splitNum > 0:
			dir = userData['userName'][:self.splitNum]
		else:
			dir = '.'

		#  re-open split index
		out = self.outMainIndex
		if self.splitNum > 0:
			if dir != self.lastIndexDir and self.outIndex != None:
				self.outIndex.write("</TABLE>\n</BODY>\n</HTML>\n")
				self.outIndex.close()
				self.outIndex = None

			if self.outIndex == None:
				self.outIndex = open(self.reportDirName + '/' + dir
						+ '/' + self.reportIndexName + self.reportSuffix, 'w')
				title = "Dial-In Report ``%s'' generated %s" % ( dir,
						time.strftime("%A, %B %d, %Y", time.localtime(time.time())) )
				self.IndexWriteUserHeader(self.outIndex, title)

				self.outMainIndex.write('<TR><TD><A HREF="%s/%s%s">%s</A><BR>'
						'</TD></TR>\n' %
						( dir, self.reportIndexName, self.reportSuffix, dir ))
			out = self.outIndex

		#  remember the last index dir name
		self.lastIndexDir = dir

		#  write index
		out.write("<TR><TD><A HREF=\"" + userData["userName"]
				+ self.reportSuffix + "\">%s</TD><TD>%d</TD><TD>%s</TD><TD>" %
				( userData["userName"], userData["sessionCount"],
				secsToStr(userData["timeOn"], 2) ))
		out.write("%s</TD><TD>%s</TD><TD>%s/%s</TD><TD></TR>\n" %
				( secsToStr(userData["timeOn"] / userData["numDays"], 2),
				secsToStr(userData["timeOn"] / userData["sessionCount"], 2),
				bytesToStr(userData["bytesIn"]),
				bytesToStr(userData["bytesOut"]) ))
		out.flush()

generator.append(genhtml())
